/*
 * Decompiled with CFR 0.152.
 */
package de.cimt.talendcomp.dbtools.parser;

import java.io.Serializable;

public class URLElement
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String value;
    private boolean valid = true;
    public static final String PASSWORD_NAME = "PASSWORD";
    public static final String USER_NAME = "USER";
    public static final String COMMENT = "COMMENT";
    public static final String PROPERTIES = "PROPERTIES";
    public static final String INIT_SQL = "INIT_SQL";
    public static final String FETCHSIZE = "FETCHSIZE";
    public static final String PRODUCTIVE = "PRODUCTIVE";
    public static final String URL = "URL";
    public static final String DRIVER_CLASS = "DRIVER_CLASS";

    public URLElement() {
    }

    public URLElement(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public URLElement(URLElement element) {
        this.name = element.getName();
        this.value = element.getValue();
    }

    public URLElement(String param) {
        this.parseParamStr(param);
    }

    public String getParamStr() {
        if (this.value == null) {
            return this.name + "=";
        }
        return this.name + "=" + this.value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name_loc) {
        this.name = name_loc;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value_loc) {
        this.value = value_loc;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isUserNameElement() {
        return USER_NAME.equalsIgnoreCase(this.name);
    }

    private void parseParamStr(String param) {
        int pos = param.indexOf(61);
        if (pos != -1) {
            this.name = param.substring(0, pos).trim();
            this.value = param.substring(pos + 1, param.length()).trim();
        } else {
            this.valid = false;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof URLElement) {
            return this.name.equals(((URLElement)o).getName());
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "URLElement: name=" + this.name + ", value=" + this.value;
    }
}

