/*
 * Decompiled with CFR 0.152.
 */
package de.cimt.talendcomp.dbtools.parser;

import de.cimt.talendcomp.dbtools.parser.SQLPSParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;

public class SQLStatement
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int OTHER = 0;
    public static final int QUERY = 1;
    public static final int UPDATE = 2;
    public static final int START = 3;
    public static final int EXPLAIN = 4;
    static int lastIndex = -1;
    private int index;
    protected String sql;
    protected String sql_temp;
    private long executedAt = 0L;
    private long durationExec = 0L;
    private long durationGet = 0L;
    private boolean successful = false;
    private int type;
    private int startPos;
    private int endPos;
    private String message = "";
    protected boolean hidden = false;
    public static final String START_SEQUENCE_FOR_SUMMARY = "-[";
    public static final String SQL_PARAM_DELIMITER = "\u0000";
    public static final String PARAM_PARAM_DELIMITER = "\u0001";
    private List<SQLPSParam> paramList = new Vector<SQLPSParam>();
    private boolean isPrepared = false;
    private boolean hasNamedParams = false;
    private boolean sqlCodeValid = true;
    private String currentFile = null;
    private boolean isExecuting = false;
    private boolean isGettingData = false;
    private String currentUrl;
    private String currentUser;

    public SQLStatement(String sql) {
        this.sql = sql.replace('\r', ' ');
        this.type = this.checkType();
        this.index = ++lastIndex;
    }

    public SQLStatement() {
    }

    public String getSQL() {
        return this.sql;
    }

    public void setSQL(String sql_loc) {
        this.sql = sql_loc.replace('\r', ' ');
        this.type = this.checkType();
    }

    public void setStartTime() {
        this.isExecuting = true;
        this.executedAt = System.currentTimeMillis();
    }

    public void setExecStopTime() {
        this.isExecuting = false;
        if (this.type == 1) {
            this.isGettingData = true;
        }
        this.durationExec = System.currentTimeMillis() - this.executedAt;
    }

    public void setGetStopTime() {
        this.isGettingData = false;
        this.durationGet = System.currentTimeMillis() - this.executedAt + this.durationExec;
    }

    public long getDurationExec() {
        return this.durationExec;
    }

    public long getDurationGet() {
        return this.durationGet;
    }

    public Date getExecutionDate() {
        return new Date(this.executedAt);
    }

    public boolean isStarted() {
        return this.executedAt != 0L;
    }

    public boolean isRunning() {
        return this.isExecuting || this.isGettingData;
    }

    public void setTextRange(int startPos_loc, int endPos_loc) {
        this.startPos = startPos_loc;
        this.endPos = endPos_loc;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int getIndex() {
        return this.index;
    }

    public static void resetIndex() {
        lastIndex = -1;
    }

    public void setSuccessful(boolean successful_loc) {
        this.isGettingData = false;
        this.isExecuting = false;
        this.successful = successful_loc;
    }

    public boolean isSuccessful() {
        return this.successful;
    }

    public void setMessage(String message_loc) {
        this.message = message_loc;
    }

    public String getMessage() {
        return this.message;
    }

    public String getSummary() {
        String startTime = this.executedAt > 0L ? this.getExecutionDate().toString() : "nicht ausgef\u00fchrt";
        String textDurationExec = null;
        textDurationExec = this.getDurationExec() > 1000L ? this.getDurationExec() + "ms = " + (float)this.getDurationExec() / 1000.0f + "s = " + (float)this.getDurationExec() / 1000.0f / 60.0f + "min" : this.getDurationExec() + "ms = " + (float)this.getDurationExec() / 1000.0f + "s";
        String textDurationGet = null;
        textDurationGet = this.getDurationExec() > 1000L ? this.getDurationGet() + "ms = " + (float)this.getDurationGet() / 1000.0f + "s = " + (float)this.getDurationGet() / 1000.0f / 60.0f + "min" : this.getDurationGet() + "ms = " + (float)this.getDurationGet() / 1000.0f + "s";
        StringBuilder sb = new StringBuilder();
        sb.append("URL = ");
        sb.append(this.getCurrentUrl());
        sb.append("\nUser = ");
        sb.append(this.getCurrentUser());
        sb.append("\nSuccesfull = ");
        sb.append(this.successful);
        sb.append("\nStart time = ");
        sb.append(startTime);
        sb.append("\nDuration exec = ");
        sb.append(textDurationExec);
        sb.append("\nDuration fetch = ");
        sb.append(textDurationGet);
        sb.append("\n");
        sb.append(this.message);
        sb.append("\n");
        sb.append(this.getParameterSummary());
        return sb.toString();
    }

    private String getParameterSummary() {
        StringBuffer text = new StringBuffer(64);
        if (this.paramList.size() > 0) {
            SQLPSParam param = null;
            text.append("used parameters:");
            for (int i = 0; i < this.paramList.size(); ++i) {
                param = this.paramList.get(i);
                text.append('\n');
                if (!param.isOutParam()) {
                    text.append("in ");
                } else {
                    text.append("out ");
                }
                text.append("index=");
                text.append(param.getIndex());
                if (param.getName() != null) {
                    text.append(" (");
                    text.append(param.getName());
                    text.append(") ");
                }
                text.append(" value=");
                text.append(param.getValue());
            }
        } else {
            text.append("none prepared parameters used");
        }
        return text.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof SQLStatement) {
            SQLStatement sqlStat = (SQLStatement)o;
            return this.getSQL().trim().toLowerCase().equals(sqlStat.getSQL().trim().toLowerCase());
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    private int checkType() {
        this.sql_temp = this.sql.trim().toLowerCase();
        int sqlType = this.sql_temp.startsWith("insert") || this.sql_temp.startsWith("update") || this.sql_temp.startsWith("delete") ? 2 : (this.sql_temp.startsWith("select") ? 1 : (this.sql_temp.startsWith("start") || this.sql_temp.startsWith("@") ? 3 : 0));
        return sqlType;
    }

    public void setHidden(boolean hidden_loc) {
        this.hidden = hidden_loc;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getSummaryStr() {
        return START_SEQUENCE_FOR_SUMMARY + String.valueOf(this.index) + "|" + String.valueOf(this.successful) + "|" + String.valueOf(this.executedAt) + "|" + String.valueOf(this.durationExec) + "|" + String.valueOf(this.durationGet) + "]";
    }

    public void parseSummaryStr(String param) {
        int i1 = param.indexOf(124);
        this.index = Integer.parseInt(param.substring(0, i1));
        int i2 = param.indexOf(124, i1 + 2);
        this.successful = param.substring(i1 + 1, i2).trim().equals("true");
        int i3 = param.indexOf(124, i2 + 1);
        this.executedAt = Long.parseLong(param.substring(i2 + 1, i3));
        int i4 = param.indexOf(124, i3 + 1);
        this.durationExec = Long.parseLong(param.substring(i3 + 1, i4));
        int i5 = param.indexOf(124, i4 + 1);
        if (i5 != -1) {
            this.durationGet = Long.parseLong(param.substring(i4 + 1, i5));
            this.currentFile = param.substring(i5 + 1, param.length());
        } else {
            this.durationGet = Long.parseLong(param.substring(i4 + 1, param.length()));
        }
    }

    public void addParam(SQLPSParam param) {
        this.paramList.add(param);
    }

    public SQLPSParam getParam(String name) {
        SQLPSParam psParam = null;
        for (int i = 0; i < this.paramList.size() && !(psParam = this.paramList.get(i)).getName().equalsIgnoreCase(name); ++i) {
            psParam = null;
        }
        return psParam;
    }

    public SQLPSParam getParam(int paramIndex) {
        SQLPSParam psParam = null;
        for (int i = 0; i < this.paramList.size() && (psParam = this.paramList.get(i)).getIndex() != paramIndex; ++i) {
            psParam = null;
        }
        return psParam;
    }

    public boolean hasOutputParams() {
        for (SQLPSParam psParam : this.paramList) {
            if (!psParam.isOutParam()) continue;
            return true;
        }
        return false;
    }

    public boolean hasNamedParams() {
        for (SQLPSParam psParam : this.paramList) {
            if (!psParam.isNamedParam()) continue;
            return true;
        }
        return false;
    }

    public List<SQLPSParam> getOutputParams() {
        ArrayList<SQLPSParam> list = new ArrayList<SQLPSParam>();
        for (SQLPSParam psParam : this.paramList) {
            if (!psParam.isOutParam()) continue;
            list.add(psParam);
        }
        return list;
    }

    public List<SQLPSParam> getParams() {
        return this.paramList;
    }

    public void setParams(List<SQLPSParam> params) {
        this.paramList = params;
    }

    public boolean isValid() {
        SQLPSParam param = null;
        boolean isValid = true;
        if (this.sql.length() < 3) {
            isValid = false;
        }
        for (int i = 0; i < this.paramList.size(); ++i) {
            param = this.paramList.get(i);
            if (param.isValid()) continue;
            isValid = false;
            break;
        }
        return isValid;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(String.valueOf(this.index) + ": " + this.getSQL());
        for (int i = 0; i < this.paramList.size(); ++i) {
            if (i == 0) {
                sb.append(" [");
            }
            sb.append('\n');
            sb.append(this.paramList.get(i).toString());
            if (i == this.paramList.size() - 1) {
                sb.append("]");
                continue;
            }
            sb.append(",");
        }
        return sb.toString();
    }

    public String getPSParamStr() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.paramList.size(); ++i) {
            sb.append(PARAM_PARAM_DELIMITER);
            sb.append(this.paramList.get(i).toString());
        }
        return sb.toString();
    }

    public boolean isPrepared() {
        return this.isPrepared;
    }

    public void setPrepared(boolean isPrepared_loc) {
        this.isPrepared = isPrepared_loc;
    }

    public int hashCode() {
        return this.sql.hashCode();
    }

    public boolean isSqlCodeValid() {
        return this.sqlCodeValid;
    }

    public void setSqlCodeValid(boolean sqlCodeWrong) {
        this.sqlCodeValid = sqlCodeWrong;
    }

    public boolean isHasNamedParams() {
        return this.hasNamedParams;
    }

    public void setHasNamedParams(boolean hasNamedParams) {
        this.hasNamedParams = hasNamedParams;
    }

    public void setFile(String file) {
        this.currentFile = file;
    }

    public String getFile() {
        return this.currentFile;
    }

    public boolean isStartStatement() {
        return this.type == 3;
    }

    public String getCurrentUrl() {
        return this.currentUrl;
    }

    public void setCurrentUrl(String currentUrl) {
        this.currentUrl = currentUrl;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public void setCurrentUser(String currentUser) {
        this.currentUser = currentUser;
    }

    public void setIsExplainStatement() {
        this.type = 4;
    }

    public boolean isExplainStatement() {
        return this.type == 4;
    }
}

