/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json.streaming;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class JsonStreamParser {
    private static Logger logger = Logger.getLogger(JsonStreamParser.class);
    private JsonFactory factory = new JsonFactory();
    private JsonParser parser = null;
    private Stack<String> stack = new Stack();
    private int currentLoopIndex = 0;
    private String loopPath = null;
    private Map<String, String> columnExpectedPathMap = new HashMap<String, String>();
    private Set<String> expectedPathSet = new TreeSet<String>();
    private TreeMap<String, StringBuilder> currentPathContentMap = new TreeMap();
    private Map<String, Integer> expectedPathOccurence = new HashMap<String, Integer>();
    private List<String> keysToDel = new ArrayList<String>();
    private boolean streamEnded = false;
    private ObjectMapper objectMapper = new ObjectMapper();
    private boolean firstToken = true;
    private int jsonLevel = 0;
    private int currLoopPathLevel = -1;
    private static String loopPathDummyName = "#LOOP";

    public static void enableTraceLogging(boolean on) {
        if (on) {
            logger.setLevel(Level.TRACE);
        } else {
            logger.setLevel(Level.INFO);
        }
    }

    public void addColumnAttrPath(String name, String attrPath) {
        if (this.loopPath == null) {
            throw new IllegalStateException("Loop path must be set before!");
        }
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        if (attrPath == null || attrPath.trim().isEmpty()) {
            throw new IllegalArgumentException("attrPath must not be null or empty");
        }
        if (!attrPath.startsWith("$")) {
            attrPath = this.loopPath + "." + attrPath;
        }
        this.columnExpectedPathMap.put(name, attrPath);
        this.expectedPathSet.add(attrPath);
    }

    public void setInputFile(String filePath) throws Exception {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new IllegalArgumentException("filePath must be null or empty!");
        }
        File f = new File(filePath);
        if (!f.exists()) {
            throw new Exception("Input file: " + filePath + " does not exists!");
        }
        this.reset();
        this.parser = this.factory.createParser(f);
    }

    private void reset() {
        this.currentPathContentMap.clear();
        this.expectedPathOccurence.clear();
        this.currentLoopIndex = 0;
    }

    public void setInputStream(InputStream in) throws Exception {
        if (in == null) {
            throw new IllegalArgumentException("InputStream cannot be null!");
        }
        this.reset();
        this.parser = this.factory.createParser(in);
    }

    public void setInputResource(String inputResourceName) throws Exception {
        InputStream in;
        if (inputResourceName == null || inputResourceName.trim().isEmpty()) {
            throw new IllegalArgumentException("Input resource name cannot be null or empty!");
        }
        this.reset();
        if (!inputResourceName.startsWith("/")) {
            inputResourceName = "/" + inputResourceName;
        }
        if ((in = this.getClass().getResourceAsStream(inputResourceName.trim())) == null) {
            throw new Exception("There is no input resource with the name: " + inputResourceName);
        }
        this.parser = this.factory.createParser(in);
    }

    public static int getKeyLevel(String key) {
        int level = 0;
        int c = 176;
        int n = key.length();
        for (int i = 0; i < n; ++i) {
            c = key.charAt(i);
            if (c == 36) {
                ++level;
                continue;
            }
            if (c == 91) {
                ++level;
                continue;
            }
            if (c != 46) continue;
            ++level;
        }
        if (c != 93 && level > 1) {
            --level;
        }
        return level;
    }

    private void clearPathContentMap() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"clearPathContentMap:----------------------------");
        }
        for (String key : this.keysToDel) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("clearPathContentMap: key=" + key + " -> remove"));
            }
            this.currentPathContentMap.remove(key);
        }
        this.keysToDel.clear();
    }

    private void collectKeysToDelete() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)"collectKeysToDelete:----------------------------");
        }
        for (String key : this.currentPathContentMap.keySet()) {
            int keyLevel = JsonStreamParser.getKeyLevel(key);
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("collectKeysToDelete: key=" + key + ", keyLevel=" + keyLevel + ", jsonLevel=" + this.jsonLevel));
            }
            if (keyLevel <= this.jsonLevel) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("collectKeysToDelete: key=" + key + " -> mark"));
            }
            if (this.keysToDel.contains(key)) continue;
            this.keysToDel.add(key);
        }
    }

    private void incrementJsonLevel() {
        ++this.jsonLevel;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("incrementJsonLevel: jsonLevel=" + this.jsonLevel));
        }
    }

    private void decrementJsonLevel() {
        --this.jsonLevel;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("decrementJsonLevel: jsonLevel=" + this.jsonLevel));
        }
        this.collectKeysToDelete();
    }

    public boolean parseStream() throws Exception {
        if (this.parser == null) {
            throw new IllegalArgumentException("Parser not initialized.");
        }
        if (this.loopPath == null) {
            throw new IllegalArgumentException("Loop-path not set.");
        }
        if (this.columnExpectedPathMap.isEmpty()) {
            throw new IllegalArgumentException("Expected path to column mapping is empty!");
        }
        if (this.expectedPathSet.isEmpty()) {
            throw new IllegalArgumentException("Expected path set is empty!");
        }
        this.clearPathContentMap();
        boolean endReached = false;
        JsonToken token = null;
        String name = null;
        while ((token = this.parser.nextToken()) != null) {
            String path;
            name = this.parser.getCurrentName();
            if (token == JsonToken.START_OBJECT) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"START_OBJECT");
                }
                if (this.firstToken) {
                    this.firstToken = false;
                    this.push("$");
                }
                if (name == null) {
                    name = "";
                }
                path = this.push(name);
                this.incrementJsonLevel();
                this.appendObject(path, "{");
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("START_OBJECT: path: " + path + ", level: " + this.jsonLevel));
                continue;
            }
            if (token == JsonToken.START_ARRAY) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"START_ARRAY");
                }
                if (this.firstToken) {
                    this.firstToken = false;
                    this.push("$");
                }
                if (name == null) {
                    name = "";
                }
                this.incrementJsonLevel();
                this.appendContent(this.getCurrentStackPath(), "[");
                this.push(name + "[*]");
                if (!logger.isTraceEnabled()) continue;
                logger.trace((Object)("START_ARRAY: path: " + this.getCurrentStackPath() + ", level: " + this.jsonLevel));
                continue;
            }
            if (token == JsonToken.FIELD_NAME) {
                this.appendName(this.getCurrentStackPath(), "\"" + this.parser.getText() + "\":");
                continue;
            }
            if (token == JsonToken.VALUE_TRUE || token == JsonToken.VALUE_FALSE) {
                this.appendValue(this.getCurrentStackPath() + "." + this.parser.getCurrentName(), this.parser.getText());
                continue;
            }
            if (token == JsonToken.VALUE_NULL) {
                this.appendValue(this.getCurrentStackPath() + "." + this.parser.getCurrentName(), "null");
                continue;
            }
            if (token == JsonToken.VALUE_NUMBER_FLOAT) {
                this.appendValue(this.getCurrentStackPath() + "." + this.parser.getCurrentName(), this.parser.getText());
                continue;
            }
            if (token == JsonToken.VALUE_NUMBER_INT) {
                this.appendValue(this.getCurrentStackPath() + "." + this.parser.getCurrentName(), this.parser.getText());
                continue;
            }
            if (token == JsonToken.VALUE_STRING) {
                this.appendValue(this.getCurrentStackPath() + "." + this.parser.getCurrentName(), this.getJsonStringValue(this.parser.getText()));
                continue;
            }
            if (token == JsonToken.END_OBJECT) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)"END_OBJECT");
                }
                path = this.pop();
                this.appendContent(path, "}");
                this.decrementJsonLevel();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("END_OBJECT: path: " + path + ", level: " + this.jsonLevel));
                }
                if (!this.loopPath.equals(path)) continue;
                if (this.currLoopPathLevel == -1) {
                    this.currLoopPathLevel = this.jsonLevel;
                    ++this.currentLoopIndex;
                    endReached = true;
                    break;
                }
                if (this.currLoopPathLevel != this.jsonLevel) continue;
                ++this.currentLoopIndex;
                endReached = true;
                break;
            }
            if (token != JsonToken.END_ARRAY) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)"END_ARRAY");
            }
            path = this.pop();
            this.appendContent(this.getCurrentStackPath(), "]");
            this.decrementJsonLevel();
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("END_ARRAY: path: " + path + ", level: " + this.jsonLevel));
            }
            if (!this.loopPath.equals(path)) continue;
            if (this.currLoopPathLevel == -1) {
                this.currLoopPathLevel = this.jsonLevel;
                ++this.currentLoopIndex;
                endReached = true;
                break;
            }
            if (this.currLoopPathLevel != this.jsonLevel) continue;
            ++this.currentLoopIndex;
            endReached = true;
            break;
        }
        if (token == null) {
            this.streamEnded = true;
        }
        return endReached;
    }

    private String getJsonStringValue(String rawText) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)TextNode.valueOf((String)rawText));
    }

    private void appendContent(String path, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendContent: path: " + path + " level: " + this.jsonLevel + " value: " + value));
        }
        for (String ep : this.expectedPathSet) {
            StringBuilder sb;
            if (!JsonStreamParser.isMatchingSubpath(path, ep)) continue;
            if (this.keysToDel.contains(ep)) {
                this.currentPathContentMap.remove(ep);
                this.keysToDel.remove(ep);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("\tremove and set ep: " + ep));
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("\tappend to ep: " + ep));
            }
            if ((sb = this.currentPathContentMap.get(ep)) == null) {
                sb = new StringBuilder(value);
                this.currentPathContentMap.put(ep, sb);
                continue;
            }
            sb.append(value);
        }
    }

    public static boolean isMatchingSubpath(String path, String expectedPath) {
        if (path.equals(expectedPath)) {
            return true;
        }
        int pos = -1;
        String ep = "";
        while ((pos = path.indexOf(".", pos + 1)) != -1) {
            ep = path.substring(0, pos);
            if (!expectedPath.equals(ep)) continue;
            return true;
        }
        return false;
    }

    private void appendName(String path, String name) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendName: path: " + path + " level: " + this.jsonLevel + " name: " + name));
        }
        for (String ep : this.expectedPathSet) {
            StringBuilder sb;
            if (!JsonStreamParser.isMatchingSubpath(path, ep)) continue;
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("\tapply to ep: " + ep));
            }
            if ((sb = this.currentPathContentMap.get(ep)) == null) {
                sb = new StringBuilder(name);
                this.currentPathContentMap.put(ep, sb);
                continue;
            }
            if (!sb.toString().endsWith("{")) {
                sb.append(",");
            }
            sb.append(name);
        }
    }

    private void appendObject(String path, String object) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendObject: path: " + path + " level: " + this.jsonLevel + " object: " + object));
        }
        for (String ep : this.expectedPathSet) {
            StringBuilder sb;
            if (!JsonStreamParser.isMatchingSubpath(path, ep)) continue;
            if (this.keysToDel.contains(ep)) {
                this.currentPathContentMap.remove(ep);
                this.keysToDel.remove(ep);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("\tremove and set ep: " + ep));
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("\tappend to ep: " + ep));
            }
            if ((sb = this.currentPathContentMap.get(ep)) == null) {
                sb = new StringBuilder(object);
                this.currentPathContentMap.put(ep, sb);
                Integer counter = this.expectedPathOccurence.get(ep);
                counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
                this.expectedPathOccurence.put(ep, counter);
                continue;
            }
            if (sb.toString().endsWith("}")) {
                sb.append(",");
            }
            sb.append(object);
        }
    }

    private void appendValue(String path, String value) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("appendValue: path: " + path + " level: " + this.jsonLevel + " value: " + value));
        }
        for (String ep : this.expectedPathSet) {
            StringBuilder sb;
            if (!JsonStreamParser.isMatchingSubpath(path, ep)) continue;
            if (this.keysToDel.contains(ep)) {
                this.currentPathContentMap.remove(ep);
                this.keysToDel.remove(ep);
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("\tremove and set ep: " + ep));
                }
            } else if (logger.isTraceEnabled()) {
                logger.trace((Object)("\tappend to ep: " + ep));
            }
            if ((sb = this.currentPathContentMap.get(ep)) == null) {
                sb = new StringBuilder(value);
                this.currentPathContentMap.put(ep, sb);
                Integer counter = this.expectedPathOccurence.get(ep);
                counter = counter == null ? Integer.valueOf(1) : Integer.valueOf(counter + 1);
                this.expectedPathOccurence.put(ep, counter);
                continue;
            }
            if (!sb.toString().endsWith(":") && !sb.toString().endsWith("[")) {
                sb.append(",");
            }
            sb.append(value);
        }
    }

    private String push(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("PUSH " + name));
        }
        this.stack.push(name);
        return this.getCurrentStackPath();
    }

    private String pop() {
        String path = this.getCurrentStackPath();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("POP current level=" + this.jsonLevel + " current path=" + path));
        }
        this.stack.pop();
        return path;
    }

    public boolean next() throws Exception {
        boolean found = this.parseStream();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("next: found: " + found + " stream ended: " + this.streamEnded));
        }
        if (this.streamEnded) {
            return false;
        }
        return found;
    }

    private String getCurrentStackPath() {
        int size = this.stack.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            String name = (String)this.stack.get(i);
            if (name.isEmpty()) continue;
            if (i > 0 && !name.startsWith("[")) {
                sb.append(".");
            }
            sb.append(name);
        }
        return sb.toString();
    }

    public int getCurrentLoopIndex() {
        return this.currentLoopIndex;
    }

    public void setLoopPath(String loopPath) {
        if (loopPath == null || loopPath.trim().isEmpty()) {
            throw new IllegalArgumentException("loop path must not be null or empty!");
        }
        this.loopPath = loopPath;
        this.addColumnAttrPath(loopPathDummyName, loopPath);
    }

    public String getValue(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        String path = this.columnExpectedPathMap.get(name);
        if (path == null) {
            throw new IllegalArgumentException("name does not exist in configuration");
        }
        StringBuilder sb = this.currentPathContentMap.get(path);
        if (sb != null) {
            String value = sb.toString();
            if ("null".equals(value)) {
                return null;
            }
            if (value.startsWith("\"") && value.endsWith("\"")) {
                value = value.substring(1, value.length() - 1);
            }
            return value;
        }
        return null;
    }

    public int getCountOccurence(String name) {
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        String path = this.columnExpectedPathMap.get(name);
        if (path == null) {
            throw new IllegalArgumentException("name does not exist in configuration");
        }
        Integer counter = this.expectedPathOccurence.get(path);
        if (counter == null) {
            return 0;
        }
        return counter;
    }

    public String getLoopJsonString() {
        return this.getValue(loopPathDummyName);
    }

    public JsonNode getLoopJsonNode() throws Exception {
        String jsonString = this.getValue(loopPathDummyName);
        if (jsonString != null) {
            return this.objectMapper.readTree(jsonString);
        }
        return null;
    }
}

