/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.jlo.talendcomp.json.ops.JSONValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Traverse {
    private Set<String> excludeFieldSet = new HashSet<String>();
    private String[] pathArray = new String[0];
    private JSONValue dummy = new JSONValue();
    private int maxLevel = 0;

    public void addExcludeFields(String commaDelimitedFieldNames) {
        String[] fields;
        for (String field : fields = commaDelimitedFieldNames.split(",")) {
            this.excludeFieldSet.add(field);
        }
    }

    public void setStartPath(String parentPath) {
        this.pathArray = parentPath != null && !parentPath.isEmpty() ? parentPath.split("\\.") : new String[0];
    }

    public List<JSONValue> traverse(JsonNode node) {
        for (String parent : this.pathArray) {
            Object child = null;
            child = parent.equals("$") ? node : node.get(parent);
            if (!(child instanceof ObjectNode)) break;
            node = (ObjectNode)((Object)child);
        }
        return this.traverse((JsonNode)node, null, null);
    }

    private List<JSONValue> traverse(JsonNode node, List<JSONValue> valueList, List<String> keyPath) {
        if (keyPath == null) {
            keyPath = new ArrayList<String>();
            keyPath.add("$");
        }
        if (valueList == null) {
            valueList = new ArrayList<JSONValue>();
        }
        if (this.maxLevel == 0 || keyPath.size() - 1 < this.maxLevel + 1) {
            if (node instanceof ObjectNode) {
                Iterator keys = node.fieldNames();
                while (keys.hasNext()) {
                    List<String> childPath = Traverse.clone(keyPath);
                    String key = (String)keys.next();
                    if (this.excludeFieldSet.contains(key)) continue;
                    JsonNode child = node.get(key);
                    childPath.add(key);
                    this.traverse(child, valueList, childPath);
                }
            } else if (node instanceof ArrayNode) {
                ArrayNode arrayNode = (ArrayNode)node;
                int count = arrayNode.size();
                for (int i = 0; i < count; ++i) {
                    JsonNode child = arrayNode.get(i);
                    List<String> childPath = Traverse.clone(keyPath);
                    childPath.add("[" + i + "]");
                    this.traverse(child, valueList, childPath);
                }
            } else if (node instanceof ValueNode) {
                JSONValue value = new JSONValue();
                value.setValue(node);
                value.setKeyPath(keyPath);
                valueList.add(value);
            }
        }
        return valueList;
    }

    public static List<String> clone(List<String> list) {
        ArrayList<String> clone = new ArrayList<String>();
        for (String s : list) {
            clone.add(s);
        }
        return clone;
    }

    public JSONValue getDummyValue() {
        return this.dummy;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(Integer maxLevel) {
        this.maxLevel = maxLevel != null ? maxLevel : 0;
    }
}

