/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.jlo.talendcomp.json.JsonDocument;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Merge {
    private Logger logger = null;
    private String sourceLoopPath = null;
    private String sourceIdentifier = null;
    private String targetLoopPath = null;
    private String targetIdentifier = null;
    private JsonNode sourceRootNode = null;
    private JsonNode targetRootNode = null;
    private JsonDocument sourceDoc = null;
    private JsonDocument targetDoc = null;
    private String targetMountAttribute = null;
    private boolean targetMountNodeIsArray = true;
    private boolean cloneSourceNodes = false;
    private int countAssigned = 0;
    private int countSourceNodes = 0;
    private int countTargetNodes = 0;
    private List<JsonNode> listSourceNodesNotAssigned = null;
    private boolean debug = false;
    private boolean dieIfSourceKeyNotExists = false;
    private boolean dieIfTargetKeyNotExists = false;
    private boolean dieIfSourceLoopPathNotExists = false;
    private boolean dieIfTargetLoopPathNotExists = false;

    public void info(String message) {
        if (this.logger != null) {
            this.logger.info((Object)message);
        } else {
            System.out.println("INFO: " + message);
        }
    }

    public void debug(String message) {
        if (this.debug) {
            if (this.logger != null) {
                this.logger.debug((Object)message);
            } else {
                System.out.println("DEBUG: " + message);
            }
        }
    }

    public void error(String message, Throwable t) {
        if (this.debug) {
            if (this.logger != null) {
                this.logger.error((Object)message, t);
            } else if (message != null) {
                System.err.println("ERROR: " + message);
            } else if (t != null) {
                System.err.println("ERROR: " + t.getMessage());
            }
        }
    }

    public JsonNode setSourceNode(JsonNode node) throws Exception {
        this.sourceRootNode = node;
        this.sourceDoc = new JsonDocument(node);
        return this.sourceRootNode;
    }

    public JsonNode setSourceNode(String node) throws Exception {
        this.sourceDoc = new JsonDocument(node);
        this.sourceRootNode = this.sourceDoc.getRootNode();
        return this.sourceRootNode;
    }

    public JsonNode setTargetNode(JsonNode node) throws Exception {
        this.targetRootNode = node;
        this.targetDoc = new JsonDocument(node);
        return this.targetRootNode;
    }

    public JsonNode setTargetNode(String node) throws Exception {
        this.targetDoc = new JsonDocument(node);
        this.targetRootNode = this.targetDoc.getRootNode();
        return this.targetRootNode;
    }

    public JsonNode getTargetNode() {
        return this.targetRootNode;
    }

    public void setSourceLoopPath(String path) {
        this.sourceLoopPath = path;
    }

    public void setTargetLoopPath(String path) {
        this.targetLoopPath = path;
    }

    public String getSourceIdentifier() {
        return this.sourceIdentifier;
    }

    public void setSourceIdentifier(String sourceIdentifier) {
        this.sourceIdentifier = sourceIdentifier;
    }

    public String getTargetIdentifier() {
        return this.targetIdentifier;
    }

    public void setTargetIdentifier(String targetIdentifier) {
        this.targetIdentifier = targetIdentifier;
    }

    public String getTargetMountAttribute() {
        return this.targetMountAttribute;
    }

    public void setTargetMountAttribute(String targetMountAttribute, boolean targetMountNodeIsArray, boolean cloneSourceNodes) {
        this.targetMountAttribute = targetMountAttribute;
        this.targetMountNodeIsArray = targetMountNodeIsArray;
        this.cloneSourceNodes = cloneSourceNodes;
    }

    public int getCountAssigned() {
        return this.countAssigned;
    }

    public int getCountSourceNodes() {
        return this.countSourceNodes;
    }

    public int getCountTargetNodes() {
        return this.countTargetNodes;
    }

    public static boolean isEmpty(String s) {
        if (s == null) {
            return true;
        }
        if (s.trim().isEmpty()) {
            return true;
        }
        return s.trim().equalsIgnoreCase("null");
    }

    public void executeMerge() throws Exception {
        if (this.sourceDoc == null) {
            throw new IllegalStateException("Source node not set!");
        }
        if (this.targetDoc == null) {
            throw new IllegalStateException("Target node not set!");
        }
        if (Merge.isEmpty(this.sourceLoopPath)) {
            throw new IllegalStateException("sourceLoopPath cannot be null or empty.");
        }
        if (Merge.isEmpty(this.targetLoopPath)) {
            throw new IllegalStateException("targetLoopPath cannot be null or empty.");
        }
        if (Merge.isEmpty(this.sourceIdentifier)) {
            throw new IllegalStateException("sourceIdentifier cannot be null or empty.");
        }
        if (Merge.isEmpty(this.targetIdentifier)) {
            throw new IllegalStateException("targetIdentifier cannot be null or empty.");
        }
        if (Merge.isEmpty(this.targetMountAttribute)) {
            throw new IllegalStateException("targetMountAttribute cannot be null or empty.");
        }
        this.listSourceNodesNotAssigned = new ArrayList<JsonNode>();
        JsonNode sourceSearchResult = this.sourceDoc.getNode(this.sourceLoopPath);
        if (this.isDebug()) {
            this.debug("Source search result: " + sourceSearchResult);
        }
        if (this.dieIfSourceLoopPathNotExists && sourceSearchResult == null) {
            throw new Exception("Source loop path does not exist. source-document:\n" + this.sourceDoc + "\nsourceLoopPath: " + this.sourceLoopPath);
        }
        List<JsonNode> sourceListNodes = this.sourceDoc.getArrayValuesAsList(sourceSearchResult, true);
        if (this.isDebug()) {
            StringBuilder message = new StringBuilder();
            message.append("List of source nodes:\n");
            for (JsonNode node : sourceListNodes) {
                message.append(node.toString());
                message.append("\n----------------------------------\n");
            }
        }
        this.countSourceNodes = sourceListNodes.size();
        JsonNode targetSearchResult = this.targetDoc.getNode(this.targetLoopPath);
        if (this.isDebug()) {
            this.debug("Target search result: " + targetSearchResult);
        }
        if (this.dieIfTargetLoopPathNotExists && targetSearchResult == null) {
            throw new Exception("Target loop path does not exist. target-document:\n" + this.targetDoc + "\ntargetLoopPath: " + this.targetLoopPath);
        }
        if (this.isDebug()) {
            StringBuilder message = new StringBuilder();
            message.append("List of target nodes:\n");
            for (JsonNode node : targetSearchResult) {
                message.append(node.toString());
                message.append("\n----------------------------------\n");
            }
        }
        List<JsonNode> targetListNodes = this.targetDoc.getArrayValuesAsList(targetSearchResult, false);
        this.countTargetNodes = targetListNodes.size();
        for (JsonNode sourceNode : sourceListNodes) {
            if (sourceNode.isNull()) {
                throw new Exception("Found null as source node in the search result: " + sourceSearchResult);
            }
            if (!(sourceNode instanceof ObjectNode)) {
                throw new Exception("Found in source nodes a none-ObjectNode: " + sourceNode + " in the search result: " + sourceSearchResult);
            }
            boolean foundTarget = false;
            for (JsonNode targetNode : targetListNodes) {
                if (!this.match(sourceNode, targetNode)) continue;
                if (this.targetMountNodeIsArray) {
                    ArrayNode targetArray = ((ObjectNode)targetNode).withArray(this.targetMountAttribute);
                    if (!this.contains(targetArray, sourceNode)) {
                        if (this.cloneSourceNodes) {
                            targetArray.add(sourceNode.deepCopy());
                        } else {
                            targetArray.add(sourceNode);
                        }
                        ++this.countAssigned;
                    } else if (this.isDebug()) {
                        this.debug("Prevent duplicated source node: " + sourceNode + " in array of target node: " + targetNode);
                    }
                } else if (".".equals(this.targetMountAttribute)) {
                    Iterator<Map.Entry<String, JsonNode>> it = ((ObjectNode)sourceNode).fields();
                    while (it.hasNext()) {
                        Map.Entry<String, JsonNode> sourceValueEntry = it.next();
                        String sourceKey = sourceValueEntry.getKey();
                        JsonNode sourceValue = sourceValueEntry.getValue();
                        if (this.cloneSourceNodes) {
                            ((ObjectNode)targetNode).set(sourceKey, sourceValue.deepCopy());
                            continue;
                        }
                        ((ObjectNode)targetNode).set(sourceKey, sourceValue);
                    }
                    ++this.countAssigned;
                } else {
                    JsonNode child = ((ObjectNode)targetNode).path(this.targetMountAttribute);
                    if (child.isNull() || child.isMissingNode()) {
                        if (this.cloneSourceNodes) {
                            ((ObjectNode)targetNode).set(this.targetMountAttribute, sourceNode.deepCopy());
                        } else {
                            ((ObjectNode)targetNode).set(this.targetMountAttribute, sourceNode);
                        }
                        ++this.countAssigned;
                    }
                }
                foundTarget = true;
            }
            if (foundTarget || this.listSourceNodesNotAssigned.contains(sourceNode)) continue;
            this.listSourceNodesNotAssigned.add(sourceNode);
        }
    }

    public List<JsonNode> getListSourceNodesNotAssigned() {
        return this.listSourceNodesNotAssigned;
    }

    private boolean contains(ArrayNode arrayNode, JsonNode node) {
        Iterator iterator = arrayNode.iterator();
        while (iterator.hasNext()) {
            JsonNode element = (JsonNode)iterator.next();
            if (!element.equals((Object)node)) continue;
            return true;
        }
        return false;
    }

    private boolean match(JsonNode node1, JsonNode node2) throws Exception {
        if (this.isDebug()) {
            this.debug("Check key matching for source node:\n" + node1 + "\nand target node:\n" + node2);
        }
        if (node1 == null || node2 == null) {
            if (this.isDebug()) {
                this.debug("\tSource node or target node are null -> matching FAIL");
            }
            return false;
        }
        if (node1.equals((Object)node2)) {
            if (this.isDebug()) {
                this.debug("\tSource node and target node are equal (prevent self assignment) -> matching FAIL");
            }
            return false;
        }
        JsonNode key1 = this.sourceDoc.getNode(node1, this.sourceIdentifier);
        if (key1 == null && this.dieIfSourceKeyNotExists) {
            throw new Exception("Source node: " + node1.toString() + " does not have the expected key attribute: " + this.sourceIdentifier);
        }
        JsonNode key2 = this.targetDoc.getNode(node2, this.targetIdentifier);
        if (key2 == null && this.dieIfTargetKeyNotExists) {
            throw new Exception("Target node: " + node2.toString() + " does not have the expected key attribute: " + this.targetIdentifier);
        }
        if (key2 instanceof ArrayNode) {
            boolean found = this.contains((ArrayNode)key2, key1);
            if (found) {
                if (this.isDebug()) {
                    this.debug("\tSource key: " + key1 + " exists in target key array: " + key2 + " -> matching OK");
                }
            } else if (this.isDebug()) {
                this.debug("\tSource key: " + key1 + " does not exists in target key array: " + key2 + " -> matching FAIL");
            }
            return found;
        }
        boolean found = false;
        if (key1 != null && key2 != null) {
            if (key1 instanceof ValueNode && key2 instanceof ValueNode) {
                String key1Str = key1.asText().trim();
                String key2Str = key2.asText().trim();
                found = key1Str.equals(key2Str);
            } else if (key1.equals((Object)key2)) {
                found = true;
            }
            if (found) {
                if (this.isDebug()) {
                    this.debug("\tSource key: " + key1 + " and target key: " + key2 + " are equal -> matching OK");
                }
                return true;
            }
            if (this.isDebug()) {
                this.debug("\tSource key: " + key1 + " and target key: " + key2 + " are NOT equal -> matching FAIL");
            }
            return false;
        }
        if (this.isDebug()) {
            this.debug("\tSource key: " + key1 + " or target key: " + key2 + " are null -> matching FAIL");
        }
        return false;
    }

    public boolean isDebug() {
        if (this.logger != null) {
            return this.logger.isDebugEnabled();
        }
        return this.debug;
    }

    public void setDebug(boolean debug) {
        if (this.logger != null) {
            if (debug) {
                this.logger.setLevel(Level.DEBUG);
            } else {
                this.logger.setLevel(Level.INFO);
            }
        }
        this.debug = debug;
    }

    public boolean isDieIfSourceKeyNotExists() {
        return this.dieIfSourceKeyNotExists;
    }

    public void setDieIfSourceKeyNotExists(boolean dieIfSourceKeyNotExists) {
        this.dieIfSourceKeyNotExists = dieIfSourceKeyNotExists;
    }

    public boolean isDieIfTargetKeyNotExists() {
        return this.dieIfTargetKeyNotExists;
    }

    public void setDieIfTargetKeyNotExists(boolean dieIfTargetKeyNotExists) {
        this.dieIfTargetKeyNotExists = dieIfTargetKeyNotExists;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isDieIfSourceLoopPathNotExists() {
        return this.dieIfSourceLoopPathNotExists;
    }

    public void setDieIfSourceLoopPathNotExists(boolean dieIfSourceLoopPathNotExists) {
        this.dieIfSourceLoopPathNotExists = dieIfSourceLoopPathNotExists;
    }

    public boolean isDieIfTargetLoopPathNotExists() {
        return this.dieIfTargetLoopPathNotExists;
    }

    public void setDieIfTargetLoopPathNotExists(boolean dieIfTargetLoopPathNotExists) {
        this.dieIfTargetLoopPathNotExists = dieIfTargetLoopPathNotExists;
    }
}

