/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json;

import com.fasterxml.jackson.databind.JsonNode;
import de.jlo.talendcomp.json.GenericDateUtil;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.time.FastDateFormat;

public final class TypeUtil {
    private static final Map<String, DecimalFormat> numberformatMap = new HashMap<String, DecimalFormat>();
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final String DEFAULT_LOCALE = "en_UK";

    public static DecimalFormat getNumberFormat(String localeStr) {
        DecimalFormat nf = numberformatMap.get(localeStr);
        if (nf == null) {
            Locale locale = new Locale(localeStr);
            nf = (DecimalFormat)NumberFormat.getInstance(locale);
            numberformatMap.put(localeStr, nf);
        }
        return nf;
    }

    public static Date convertToDate(String dateString, String pattern) throws Exception {
        if (dateString == null || dateString.isEmpty()) {
            return null;
        }
        if (pattern == null) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        try {
            FastDateFormat sdf = FastDateFormat.getInstance((String)pattern);
            Date date = null;
            try {
                date = sdf.parse(dateString);
            }
            catch (ParseException pe) {
                date = GenericDateUtil.parseDate(dateString);
            }
            return date;
        }
        catch (Throwable t) {
            throw new Exception("Failed to convert string to date:" + t.getMessage(), t);
        }
    }

    public static Timestamp convertToTimestamp(String dateString, String pattern) throws Exception {
        Date date = TypeUtil.convertToDate(dateString, pattern);
        if (date != null) {
            return new Timestamp(date.getTime());
        }
        return null;
    }

    public static Boolean convertToBoolean(String value) throws Exception {
        if (value == null) {
            return null;
        }
        if ("true".equals(value = value.toLowerCase())) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if ("1".equals(value)) {
            return Boolean.TRUE;
        }
        if ("0".equals(value)) {
            return Boolean.FALSE;
        }
        if ("yes".equals(value)) {
            return Boolean.TRUE;
        }
        if ("y".equals(value)) {
            return Boolean.TRUE;
        }
        if ("s\u00ed".equals(value)) {
            return Boolean.TRUE;
        }
        if ("\u0434\u0430".equals(value)) {
            return Boolean.TRUE;
        }
        if ("no".equals(value)) {
            return Boolean.FALSE;
        }
        if ("\u043d\u0435\u0442".equals(value)) {
            return Boolean.FALSE;
        }
        if ("n".equals(value)) {
            return Boolean.FALSE;
        }
        if ("ja".equals(value)) {
            return Boolean.TRUE;
        }
        if ("j".equals(value)) {
            return Boolean.TRUE;
        }
        if ("nein".equals(value)) {
            return Boolean.FALSE;
        }
        if ("oui".equals(value)) {
            return Boolean.TRUE;
        }
        if ("non".equals(value)) {
            return Boolean.FALSE;
        }
        if ("ok".equals(value)) {
            return Boolean.TRUE;
        }
        if ("x".equals(value)) {
            return Boolean.TRUE;
        }
        if (value != null) {
            throw new Exception("Value: " + value + " cannot be parsed to a boolean");
        }
        return null;
    }

    public static Boolean convertToBoolean(JsonNode node) throws Exception {
        if (node.isBoolean()) {
            return node.asBoolean();
        }
        if (node.isTextual()) {
            return TypeUtil.convertToBoolean(node.asText());
        }
        if (node.isNumber()) {
            return TypeUtil.convertToBoolean(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isMissingNode()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to Boolean");
    }

    public static Double convertToDouble(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        DecimalFormat decfrm = TypeUtil.getNumberFormat(DEFAULT_LOCALE);
        decfrm.setParseBigDecimal(false);
        return decfrm.parse(value).doubleValue();
    }

    public static Double convertToDouble(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return node.asDouble();
        }
        if (node.isTextual()) {
            return TypeUtil.convertToDouble(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isMissingNode()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to Double");
    }

    public static Integer convertToInteger(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        DecimalFormat decfrm = TypeUtil.getNumberFormat(DEFAULT_LOCALE);
        decfrm.setParseBigDecimal(false);
        return decfrm.parse(value).intValue();
    }

    public static Integer convertToInteger(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return node.asInt();
        }
        if (node.isTextual()) {
            return TypeUtil.convertToInteger(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isMissingNode()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to Integer");
    }

    public static Short convertToShort(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Short.parseShort(value);
    }

    public static Short convertToShort(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return (short)node.asInt();
        }
        if (node.isTextual()) {
            return TypeUtil.convertToShort(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isMissingNode()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to Short");
    }

    public static Character convertToChar(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Character.valueOf(value.charAt(0));
    }

    public static String convertToString(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        value = value.replace("\\n", "\n").replace("\\\"", "\"");
        return value;
    }

    public static Float convertToFloat(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Float.valueOf(Float.parseFloat(value));
    }

    public static Float convertToFloat(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return Float.valueOf((float)node.asDouble());
        }
        if (node.isTextual()) {
            return TypeUtil.convertToFloat(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isMissingNode()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to Float");
    }

    public static Long convertToLong(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return Long.parseLong(value);
    }

    public static Long convertToLong(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return node.asLong();
        }
        if (node.isTextual()) {
            return TypeUtil.convertToLong(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        if (node.isMissingNode()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to Long");
    }

    public static BigDecimal convertToBigDecimal(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            DecimalFormat decfrm = TypeUtil.getNumberFormat(DEFAULT_LOCALE);
            decfrm.setParseBigDecimal(true);
            ParsePosition pp = new ParsePosition(0);
            return (BigDecimal)decfrm.parse(value, pp);
        }
        catch (RuntimeException e) {
            throw new Exception("convertToBigDecimal:" + value + " failed:" + e.getMessage(), e);
        }
    }

    public static BigDecimal convertToBigDecimal(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return new BigDecimal(node.asText());
        }
        if (node.isTextual()) {
            return TypeUtil.convertToBigDecimal(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to BigDecimal");
    }

    public static BigInteger convertToBigInteger(String value) throws Exception {
        if (value == null || value.isEmpty()) {
            return null;
        }
        try {
            return new BigInteger(value);
        }
        catch (RuntimeException e) {
            throw new Exception("convertToBigDecimal:" + value + " failed:" + e.getMessage(), e);
        }
    }

    public static BigInteger convertToBigInteger(JsonNode node) throws Exception {
        if (node.isNumber()) {
            return node.bigIntegerValue();
        }
        if (node.isTextual()) {
            return TypeUtil.convertToBigInteger(node.asText());
        }
        if (node.isNull()) {
            return null;
        }
        throw new Exception("Node: " + node + " cannot be converted to BigInteger");
    }

    public static double roundScale(double value, int scale) {
        double d = Math.pow(10.0, scale);
        return (double)Math.round(value * d) / d;
    }
}

