/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json;

import de.jlo.talendcomp.json.ArrayToken;
import de.jlo.talendcomp.json.AttributeToken;
import java.util.ArrayList;
import java.util.List;

public abstract class PathToken {
    private PathToken previous = null;
    private PathToken next = null;

    public static List<PathToken> parse(String directJsonPath) throws Exception {
        ArrayList<PathToken> result = new ArrayList<PathToken>();
        StringBuilder text = new StringBuilder(0);
        boolean inArray = false;
        int last_c = 32;
        PathToken lastToken = null;
        int n = directJsonPath.length();
        for (int i = 0; i < n; ++i) {
            try {
                PathToken token;
                char c = directJsonPath.charAt(i);
                if (c == '$') {
                    last_c = c;
                    continue;
                }
                if (c == '[') {
                    if (last_c != 93 && text.length() > 0) {
                        token = new AttributeToken(text.toString());
                        result.add(token);
                        text.setLength(0);
                        if (lastToken != null) {
                            lastToken.next = token;
                            token.previous = lastToken;
                        }
                        lastToken = token;
                    }
                    inArray = true;
                } else if (inArray) {
                    if (c == ']') {
                        token = new ArrayToken(text.toString());
                        result.add(token);
                        text.setLength(0);
                        if (lastToken != null) {
                            lastToken.next = token;
                            token.previous = lastToken;
                        }
                        lastToken = token;
                        inArray = false;
                    } else {
                        text.append(c);
                    }
                } else {
                    if (c == ']') {
                        throw new Exception("Closing bracket found without opening before");
                    }
                    if (c == '.') {
                        if (last_c != 93 && last_c != 36) {
                            token = new AttributeToken(text.toString());
                            result.add(token);
                            text.setLength(0);
                            if (lastToken != null) {
                                lastToken.next = token;
                                token.previous = lastToken;
                            }
                            lastToken = token;
                        } else if (i == n - 1) {
                            throw new Exception("Dot-delimiter to a next attribute found but we are at the end");
                        }
                    } else {
                        text.append(c);
                    }
                }
                last_c = c;
                continue;
            }
            catch (Exception e) {
                throw new Exception("Parsing failed at pos: " + i, e);
            }
        }
        if (text.length() > 0) {
            AttributeToken token = new AttributeToken(text.toString());
            result.add(token);
            text.setLength(0);
            if (lastToken != null) {
                lastToken.next = token;
                token.previous = lastToken;
            }
            lastToken = token;
        }
        return result;
    }

    public String getPath() {
        StringBuilder path = new StringBuilder();
        this.buildPath(path);
        return path.toString();
    }

    private void buildPath(StringBuilder path) {
        if (this.previous != null) {
            this.previous.buildPath(path);
        }
        if (this instanceof AttributeToken) {
            String name = this.toString();
            if (path.length() > 0) {
                path.append(".");
            }
            path.append(name);
        } else if (this instanceof ArrayToken) {
            path.append(this.toString());
        }
    }

    public PathToken getPrevious() {
        return this.previous;
    }

    public PathToken getNext() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean isNextTokenArray() {
        return this.next instanceof ArrayToken;
    }
}

