/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json.ops;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;

public class JSONValue {
    private List<String> keyPath;
    private String attributeName = null;
    private Object value;
    private boolean isArrayValue = false;
    private int level = 0;

    public String getKeyPath(String delimiter) {
        if (delimiter == null) {
            delimiter = ".";
        }
        if (this.keyPath != null) {
            StringBuilder sb = new StringBuilder();
            boolean firstLoop = true;
            for (String key : this.keyPath) {
                if (firstLoop) {
                    firstLoop = false;
                } else if (!key.startsWith("[")) {
                    sb.append(delimiter);
                }
                sb.append(key);
            }
            return sb.toString();
        }
        return null;
    }

    public void setKeyPath(List<String> keyPath) {
        this.keyPath = keyPath;
        this.level = keyPath.size() - 1;
        this.isArrayValue = keyPath.get(keyPath.size() - 1).endsWith("]");
        for (int i = this.level; i >= 0; --i) {
            String name = keyPath.get(i);
            if (name.startsWith("[")) continue;
            this.attributeName = name;
            break;
        }
    }

    public String getJsonPath() {
        return this.getKeyPath(".");
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueString() {
        if (this.value != null) {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            if (this.value instanceof JsonNode) {
                if (((JsonNode)this.value).isTextual()) {
                    return ((JsonNode)this.value).textValue();
                }
                return ((JsonNode)this.value).toString();
            }
            return this.value.toString();
        }
        return null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String toString() {
        return this.getKeyPath(".") + ":" + this.getValueString() + " | attributeName=" + this.attributeName + " level=" + this.level + " isArrayValue=" + this.isArrayValue;
    }

    public boolean equals(Object o) {
        if (o instanceof JSONValue) {
            JSONValue v = (JSONValue)o;
            if (this.keyPath.equals(v.keyPath) && this.value.equals(v.value)) {
                return true;
            }
        }
        return false;
    }

    public boolean isArrayValue() {
        return this.isArrayValue;
    }

    public int getLevel() {
        return this.level;
    }

    public String getAttributeName() {
        return this.attributeName;
    }
}

