/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json.ops;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.jlo.talendcomp.json.JsonDocument;
import de.jlo.talendcomp.json.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Diff {
    private boolean takeEmptyLikeNull = false;
    private boolean ignoreArrayIndex = false;
    private JsonNode referenceNode = null;
    private JsonNode testNode = null;
    private String refJsonPath = null;
    private String testJsonPath = null;
    private List<Difference> result = null;
    private int countDifferences = 0;
    private String rootArraySortAttribute = null;

    public void executeDiff() throws Exception {
        this.result = this.findDifference(this.referenceNode, this.refJsonPath, this.testNode, this.testJsonPath);
    }

    public List<Difference> findDifference(String reference, String test) throws Exception {
        return this.findDifference(reference, null, test, null);
    }

    public List<Difference> findDifference(String reference, String refJsonPath, String test, String testJsonPath) {
        JsonDocument refDoc = new JsonDocument(reference);
        JsonNode refNode = null;
        refNode = refJsonPath != null && !refJsonPath.trim().isEmpty() ? refDoc.getNode(refJsonPath) : refDoc.getRootNode();
        JsonDocument testDoc = new JsonDocument(test);
        JsonNode testNode = null;
        testNode = testJsonPath != null && !testJsonPath.trim().isEmpty() ? testDoc.getNode(testJsonPath) : testDoc.getRootNode();
        return this.findDifference(null, refNode, testNode, null);
    }

    public List<Difference> findDifference(JsonNode reference, JsonNode test) throws Exception {
        return this.findDifference(null, reference, test, null);
    }

    public List<Difference> findDifference(JsonNode reference, String refJsonPath, JsonNode test, String testJsonPath) throws Exception {
        JsonDocument refDoc = new JsonDocument(reference);
        JsonNode refNode = null;
        refNode = refJsonPath != null && !refJsonPath.trim().isEmpty() ? refDoc.getNode(refJsonPath) : refDoc.getRootNode();
        JsonDocument testDoc = new JsonDocument(test);
        JsonNode testNode = null;
        testNode = testJsonPath != null && !testJsonPath.trim().isEmpty() ? testDoc.getNode(testJsonPath) : testDoc.getRootNode();
        return this.findDifference(null, refNode, testNode, null);
    }

    private List<Difference> findDifference(String parentPath, JsonNode reference, JsonNode test, List<Difference> listDiffs) {
        if (parentPath == null) {
            parentPath = "$";
        }
        if (listDiffs == null) {
            listDiffs = new ArrayList<Difference>();
        }
        if (reference instanceof ObjectNode) {
            ObjectNode rn = (ObjectNode)reference;
            if (test instanceof ObjectNode) {
                Difference diff;
                Difference diff2;
                String newParentPath;
                Map.Entry<String, JsonNode> entry;
                ObjectNode tn = (ObjectNode)test;
                Iterator<Map.Entry<String, JsonNode>> fields = rn.fields();
                while (fields.hasNext()) {
                    entry = fields.next();
                    newParentPath = parentPath + "." + entry.getKey();
                    if (this.containsDiff(listDiffs, newParentPath)) continue;
                    if (tn.has(entry.getKey())) {
                        JsonNode tnValue = tn.get(entry.getKey());
                        if (!Util.isNull(entry.getValue(), this.takeEmptyLikeNull) && !Util.isNull(tnValue, this.takeEmptyLikeNull)) {
                            this.findDifference(newParentPath, entry.getValue(), tnValue, listDiffs);
                            continue;
                        }
                        if (Util.isNull(entry.getValue(), this.takeEmptyLikeNull) && !Util.isNull(tnValue, this.takeEmptyLikeNull)) {
                            diff2 = new Difference();
                            diff2.setJsonPath(newParentPath);
                            diff2.setRefValue((JsonNode)NullNode.getInstance());
                            diff2.setTestValue(tnValue);
                            listDiffs.add(diff2);
                            continue;
                        }
                        if (Util.isNull(entry.getValue(), this.takeEmptyLikeNull) || !Util.isNull(tnValue, this.takeEmptyLikeNull)) continue;
                        diff2 = new Difference();
                        diff2.setJsonPath(newParentPath);
                        diff2.setRefValue(entry.getValue());
                        diff2.setTestValue((JsonNode)NullNode.getInstance());
                        listDiffs.add(diff2);
                        continue;
                    }
                    if (this.takeEmptyLikeNull) {
                        if (Util.isNull(tn.get(entry.getKey()), this.takeEmptyLikeNull) && Util.isNull(entry.getValue(), this.takeEmptyLikeNull)) continue;
                        diff = new Difference();
                        diff.setJsonPath(newParentPath);
                        diff.setRefValue(entry.getValue());
                        listDiffs.add(diff);
                        continue;
                    }
                    diff = new Difference();
                    diff.setJsonPath(newParentPath);
                    diff.setRefValue(entry.getValue());
                    listDiffs.add(diff);
                }
                fields = tn.fields();
                while (fields.hasNext()) {
                    entry = fields.next();
                    newParentPath = parentPath + "." + entry.getKey();
                    if (this.containsDiff(listDiffs, newParentPath)) continue;
                    if (rn.has(entry.getKey())) {
                        JsonNode rnValue = rn.get(entry.getKey());
                        if (!Util.isNull(entry.getValue(), this.takeEmptyLikeNull) && !Util.isNull(rnValue, this.takeEmptyLikeNull)) {
                            this.findDifference(newParentPath, rnValue, entry.getValue(), listDiffs);
                            continue;
                        }
                        if (!Util.isNull(rnValue, this.takeEmptyLikeNull) && Util.isNull(entry.getValue(), this.takeEmptyLikeNull)) {
                            diff2 = new Difference();
                            diff2.setJsonPath(newParentPath);
                            diff2.setRefValue(rnValue);
                            diff2.setTestValue((JsonNode)NullNode.getInstance());
                            listDiffs.add(diff2);
                            continue;
                        }
                        if (!Util.isNull(rnValue, this.takeEmptyLikeNull) || Util.isNull(entry.getValue(), this.takeEmptyLikeNull)) continue;
                        diff2 = new Difference();
                        diff2.setJsonPath(newParentPath);
                        diff2.setRefValue((JsonNode)NullNode.getInstance());
                        diff2.setTestValue(entry.getValue());
                        listDiffs.add(diff2);
                        continue;
                    }
                    if (this.takeEmptyLikeNull) {
                        if (Util.isNull(rn.get(entry.getKey()), this.takeEmptyLikeNull) && Util.isNull(entry.getValue(), this.takeEmptyLikeNull)) continue;
                        diff = new Difference();
                        diff.setJsonPath(newParentPath);
                        diff.setRefValue((JsonNode)NullNode.getInstance());
                        diff.setTestValue(entry.getValue());
                        listDiffs.add(diff);
                        continue;
                    }
                    diff = new Difference();
                    diff.setJsonPath(newParentPath);
                    diff.setRefValue((JsonNode)NullNode.getInstance());
                    diff.setTestValue(entry.getValue());
                    listDiffs.add(diff);
                }
            } else if (!this.containsDiff(listDiffs, parentPath)) {
                if (this.takeEmptyLikeNull) {
                    if (!Util.isNull(reference, this.takeEmptyLikeNull) || !Util.isNull(test, this.takeEmptyLikeNull)) {
                        Difference diff = new Difference();
                        diff.setJsonPath(parentPath);
                        diff.setTypeMismatch(true);
                        diff.setRefValue(reference);
                        diff.setTestValue(test);
                        listDiffs.add(diff);
                    }
                } else {
                    Difference diff = new Difference();
                    diff.setJsonPath(parentPath);
                    diff.setTypeMismatch(true);
                    diff.setRefValue(reference);
                    diff.setTestValue(test);
                    listDiffs.add(diff);
                }
            }
        } else if (reference instanceof ArrayNode) {
            ArrayNode rn = (ArrayNode)reference;
            List<JsonNode> refNodeList = this.arrayToList(rn);
            if (test instanceof ArrayNode) {
                ArrayNode tn = (ArrayNode)test;
                List<JsonNode> testNodeList = this.arrayToList(tn);
                if (refNodeList.size() >= testNodeList.size()) {
                    for (int i = 0; i < refNodeList.size(); ++i) {
                        String newParentPath = parentPath + "[" + i + "]";
                        if (this.containsDiff(listDiffs, newParentPath)) continue;
                        JsonNode rvn = refNodeList.get(i);
                        if (i < testNodeList.size()) {
                            JsonNode tvn = testNodeList.get(i);
                            if (this.ignoreArrayIndex && tvn instanceof ValueNode) {
                                if (this.containsNode(refNodeList, tvn)) continue;
                                this.findDifference(newParentPath, rvn, tvn, listDiffs);
                                continue;
                            }
                            this.findDifference(newParentPath, rvn, tvn, listDiffs);
                            continue;
                        }
                        Difference diff = new Difference();
                        diff.setJsonPath(newParentPath);
                        diff.setRefValue(rvn);
                        diff.setTestValue((JsonNode)NullNode.getInstance());
                        listDiffs.add(diff);
                    }
                } else {
                    for (int i = 0; i < testNodeList.size(); ++i) {
                        String newParentPath = parentPath + "[" + i + "]";
                        if (this.containsDiff(listDiffs, newParentPath)) continue;
                        JsonNode tvn = testNodeList.get(i);
                        if (i < refNodeList.size()) {
                            JsonNode rvn = testNodeList.get(i);
                            if (this.ignoreArrayIndex && rvn instanceof ValueNode) {
                                if (this.containsNode(testNodeList, rvn)) continue;
                                this.findDifference(newParentPath, rvn, tvn, listDiffs);
                                continue;
                            }
                            this.findDifference(newParentPath, rvn, tvn, listDiffs);
                            continue;
                        }
                        Difference diff = new Difference();
                        diff.setJsonPath(newParentPath);
                        diff.setRefValue((JsonNode)NullNode.getInstance());
                        diff.setTestValue(tvn);
                        listDiffs.add(diff);
                    }
                }
            } else if (!(this.containsDiff(listDiffs, parentPath) || Util.isNull(test, this.takeEmptyLikeNull) && Util.isNull((JsonNode)rn, this.takeEmptyLikeNull))) {
                Difference diff = new Difference();
                diff.setJsonPath(parentPath);
                diff.setTypeMismatch(true);
                diff.setRefValue(reference);
                diff.setTestValue(test);
                listDiffs.add(diff);
            }
        } else if (reference instanceof ValueNode) {
            ValueNode rv = (ValueNode)reference;
            if (!this.containsDiff(listDiffs, parentPath)) {
                if (test instanceof ValueNode) {
                    ValueNode tv = (ValueNode)test;
                    if (!this.equals((JsonNode)tv, (JsonNode)rv)) {
                        Difference diff = new Difference();
                        diff.setJsonPath(parentPath);
                        diff.setRefValue((JsonNode)rv);
                        diff.setTestValue((JsonNode)tv);
                        listDiffs.add(diff);
                    }
                } else {
                    Difference diff = new Difference();
                    diff.setJsonPath(parentPath);
                    diff.setTypeMismatch(true);
                    diff.setRefValue(reference);
                    diff.setTestValue(test);
                    listDiffs.add(diff);
                }
            }
        }
        this.result = listDiffs;
        return listDiffs;
    }

    private boolean containsDiff(List<Difference> listDiff, Object test) {
        if (test instanceof String) {
            for (Difference diff : listDiff) {
                if (!((String)test).equals(diff.jsonPath)) continue;
                return true;
            }
            return false;
        }
        if (test instanceof Difference) {
            for (Difference diff : listDiff) {
                if (diff.jsonPath == null || !diff.jsonPath.equals(((Difference)test).jsonPath)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean equals(JsonNode n1, JsonNode n2) {
        if (!Util.isNull(n1, this.takeEmptyLikeNull) && !Util.isNull(n2, this.takeEmptyLikeNull)) {
            return n1.toString().equals(n2.toString());
        }
        return false;
    }

    private boolean containsNode(List<JsonNode> arrayNode, JsonNode node) {
        for (JsonNode element : arrayNode) {
            if (!this.equals(element, node)) continue;
            return true;
        }
        return false;
    }

    public boolean isTakeEmptyLikeNull() {
        return this.takeEmptyLikeNull;
    }

    public void setTakeEmptyLikeNull(boolean takeEmptyLikeNull) {
        this.takeEmptyLikeNull = takeEmptyLikeNull;
    }

    public boolean isIgnoreArrayIndex() {
        return this.ignoreArrayIndex;
    }

    public void setIgnoreArrayIndex(boolean ignoreArrayIndex) {
        this.ignoreArrayIndex = ignoreArrayIndex;
    }

    public JsonNode getReferenceNode() {
        return this.referenceNode;
    }

    public void setReferenceNode(JsonNode referenceNode) {
        this.referenceNode = referenceNode;
    }

    public void setReferenceNode(JsonNode reference, String jsonPath) throws Exception {
        this.referenceNode = new JsonDocument(reference).getNode(jsonPath);
    }

    public void setReferenceNode(String reference) {
        this.referenceNode = new JsonDocument(reference).getRootNode();
    }

    public void setReferenceNode(String reference, String jsonPath) {
        this.referenceNode = new JsonDocument(reference).getNode(jsonPath);
    }

    public JsonNode getTestNode() {
        return this.testNode;
    }

    public void setTestNode(JsonNode testNode) {
        this.testNode = testNode;
    }

    public void setTestNode(String test) {
        this.testNode = new JsonDocument(test).getRootNode();
    }

    public void setTestNode(JsonNode test, String jsonPath) throws Exception {
        this.testNode = new JsonDocument(test).getNode(jsonPath);
    }

    public void setTestNode(String test, String jsonPath) throws Exception {
        this.testNode = new JsonDocument(test).getNode(jsonPath);
    }

    public String getRefJsonPath() {
        return this.refJsonPath;
    }

    public void setRefJsonPath(String refJsonPath) {
        this.refJsonPath = refJsonPath;
    }

    public String getTestJsonPath() {
        return this.testJsonPath;
    }

    public void setTestJsonPath(String testJsonPath) {
        this.testJsonPath = testJsonPath;
    }

    public List<Difference> getResult() {
        return this.result;
    }

    public int getCountDifferences() {
        return this.countDifferences;
    }

    public void setSortKeyAttribute(String keypath) {
        if (keypath != null && !keypath.trim().isEmpty()) {
            this.rootArraySortAttribute = keypath;
        }
    }

    private List<JsonNode> arrayToList(ArrayNode arrayNode) {
        ArrayList<JsonNode> list = new ArrayList<JsonNode>();
        Iterator iterator = arrayNode.iterator();
        while (iterator.hasNext()) {
            JsonNode node = (JsonNode)iterator.next();
            list.add(node);
        }
        if (this.rootArraySortAttribute != null) {
            Collections.sort(list, new Comparator<JsonNode>(){

                @Override
                public int compare(JsonNode n1, JsonNode n2) {
                    JsonNode vn1 = n1.get(Diff.this.rootArraySortAttribute);
                    JsonNode vn2 = n2.get(Diff.this.rootArraySortAttribute);
                    if (vn1 instanceof TextNode && vn2 instanceof TextNode) {
                        return vn1.asText().compareTo(vn2.asText());
                    }
                    if (vn1 instanceof NumericNode && vn2 instanceof NumericNode) {
                        return Double.valueOf(vn1.doubleValue()).compareTo(vn2.doubleValue());
                    }
                    return 0;
                }
            });
        }
        return list;
    }

    public static class Difference {
        private String jsonPath = null;
        private JsonNode refValue = null;
        private JsonNode testValue = null;
        private boolean typeMismatch = false;

        public String getJsonPath() {
            return this.jsonPath;
        }

        public void setJsonPath(String jsonPath) {
            this.jsonPath = jsonPath;
        }

        public JsonNode getRefValue() {
            return this.refValue;
        }

        public void setRefValue(JsonNode value) {
            this.refValue = value;
        }

        public JsonNode getTestValue() {
            return this.testValue;
        }

        public void setTestValue(JsonNode value) {
            this.testValue = value;
        }

        public boolean isTypeMismatch() {
            return this.typeMismatch;
        }

        public void setTypeMismatch(boolean typeMismatch) {
            this.typeMismatch = typeMismatch;
        }

        public String toString() {
            return this.jsonPath + ": ref=" + this.refValue + ", test=" + this.testValue;
        }

        public boolean equals(Object object) {
            if (object instanceof Difference) {
                return this.jsonPath.equals(((Difference)object).jsonPath);
            }
            if (object instanceof String) {
                return this.jsonPath.equals(object);
            }
            return false;
        }

        public int hashCode() {
            return this.jsonPath.hashCode();
        }
    }
}

