/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;

public class Util {
    public static String buildListAsString(Collection<? extends Object> keys, boolean sql) {
        StringBuilder sb = new StringBuilder();
        boolean firstLoop = true;
        for (Object object : keys) {
            if (object instanceof String) {
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    sb.append(",");
                }
                if (sql) {
                    sb.append("'");
                }
                if (sql) {
                    sb.append(((String)object).trim().replace("'", "''"));
                } else {
                    sb.append(((String)object).trim());
                }
                if (!sql) continue;
                sb.append("'");
                continue;
            }
            if (object == null) continue;
            if (firstLoop) {
                firstLoop = false;
            } else {
                sb.append(",");
            }
            sb.append(String.valueOf(object));
        }
        return sb.toString();
    }

    public static String buildSQLInClause(Set<? extends Object> keys, String noKeysReplacement) {
        StringBuilder sb = new StringBuilder();
        boolean firstLoop = true;
        for (Object object : keys) {
            if (object instanceof String) {
                if (firstLoop) {
                    firstLoop = false;
                    sb.append(" in (");
                } else {
                    sb.append(",");
                }
                sb.append("'");
                sb.append(((String)object).trim().replace("'", "''"));
                sb.append("'");
                continue;
            }
            if (object == null) continue;
            if (firstLoop) {
                firstLoop = false;
                sb.append(" in (");
            } else {
                sb.append(",");
            }
            sb.append(String.valueOf(object));
        }
        if (!firstLoop) {
            sb.append(") ");
        } else if (noKeysReplacement != null) {
            sb.append(noKeysReplacement);
        } else {
            sb.append(" is not null and 1=0 ");
        }
        return sb.toString();
    }

    public static Locale createLocale(String locale) {
        int p = locale.indexOf(95);
        String language = locale;
        String country = "";
        if (p > 0) {
            language = locale.substring(0, p);
            country = locale.substring(p);
        }
        return new Locale(language, country);
    }

    public static boolean isNull(JsonNode node, boolean takeEmptyLikeNull) {
        if (node == null) {
            return true;
        }
        if (node.isNull()) {
            return true;
        }
        if (node instanceof ValueNode) {
            return false;
        }
        return takeEmptyLikeNull && node.size() == 0;
    }

    public static String toString(String[] array) {
        if (array == null) {
            return null;
        }
        StringBuilder r = new StringBuilder();
        r.append("[");
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                r.append(",");
            }
            r.append(array[i]);
        }
        r.append("]");
        return r.toString();
    }
}

