/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.MissingNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.ParseContext;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.JacksonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import de.jlo.talendcomp.json.ArrayToken;
import de.jlo.talendcomp.json.AttributeToken;
import de.jlo.talendcomp.json.GenericDateUtil;
import de.jlo.talendcomp.json.PathToken;
import de.jlo.talendcomp.json.TypeUtil;
import de.jlo.talendcomp.json.Util;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class JsonDocument {
    public static final String NULL_STRING = "null";
    public static final Integer NULL_INTEGER = Integer.MAX_VALUE;
    public static final Long NULL_LONG = Long.MAX_VALUE;
    public static final Double NULL_DOUBLE = Double.MAX_VALUE;
    public static final Float NULL_FLOAT = Float.valueOf(Float.MAX_VALUE);
    public static final Short NULL_SHORT = Short.MAX_VALUE;
    public static final BigDecimal NULL_BIGDECIMAL = new BigDecimal(Long.MAX_VALUE);
    public static final BigInteger NULL_BIGINTEGER = new BigInteger(String.valueOf(Long.MAX_VALUE));
    public static final Date NULL_DATE = new Date(Long.MAX_VALUE);
    private JsonNode rootNode = null;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private final Map<String, SimpleDateFormat> dateFormatMap = new HashMap<String, SimpleDateFormat>();
    private DocumentContext rootContext = null;
    private static final Configuration JACKSON_JSON_NODE_CONFIGURATION = Configuration.builder().mappingProvider((MappingProvider)new JacksonMappingProvider()).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider()).build();
    private static final ThreadLocal<ParseContext> tl = new ThreadLocal();
    private ParseContext parseContext = JsonPath.using((Configuration)JACKSON_JSON_NODE_CONFIGURATION);
    private static ParseContext staticParseContext = JsonPath.using((Configuration)JACKSON_JSON_NODE_CONFIGURATION);
    private final Map<String, JsonPath> compiledPathMap = new HashMap<String, JsonPath>();
    private String currentPath = "";
    private Locale defaultLocale = Locale.getDefault();
    private static final Map<String, JsonNode> schemaMap = new HashMap<String, JsonNode>();
    private static final JsonSchemaFactory schemaFactory = JsonSchemaFactory.getInstance();
    private Set<ValidationMessage> lastValidationReport = new HashSet<ValidationMessage>();

    public JsonDocument(boolean isArray) {
        this.rootContext = isArray ? this.parseContext.parse("[]") : this.parseContext.parse("{}");
        tl.remove();
        this.rootNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        JsonNode testNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        if (this.rootNode != testNode) {
            throw new IllegalStateException("Cloned objects detected! Use the latest Jayway library 2.2.1+");
        }
    }

    public JsonDocument(String jsonContent) {
        if (jsonContent == null || jsonContent.trim().isEmpty()) {
            throw new IllegalArgumentException("Json input content cannot be empty or null");
        }
        this.rootContext = this.parseContext.parse(jsonContent);
        this.rootNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        JsonNode testNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        if (this.rootNode != testNode) {
            throw new IllegalStateException("Cloned objects detected! Use the latest Jayway library 2.2.1+");
        }
    }

    public JsonDocument(File jsonFile) throws Exception {
        if (jsonFile != null) {
            if (!jsonFile.exists()) {
                throw new Exception("JSON input file: " + jsonFile.getAbsolutePath() + " does not exists or is not readable!");
            }
        } else {
            throw new IllegalArgumentException("Json input input file cannot be null!");
        }
        FileInputStream in = new FileInputStream(jsonFile);
        this.rootContext = this.parseContext.parse((InputStream)in);
        this.rootNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        JsonNode testNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        if (this.rootNode != testNode) {
            throw new IllegalStateException("Clones objects detected! Use the latest Jayway library 2.2.1+");
        }
    }

    public JsonDocument(JsonNode jsonNode) throws Exception {
        if (jsonNode == null || jsonNode.isNull()) {
            throw new IllegalArgumentException("jsonNode cannor be null or a NullNode");
        }
        this.rootContext = this.parseContext.parse((Object)jsonNode);
        this.rootNode = jsonNode;
        JsonNode testNode = (JsonNode)this.rootContext.read("$", new Predicate[0]);
        if (this.rootNode != testNode) {
            throw new IllegalStateException("Clones objects detected! Use the latest Jayway library 2.2.1+");
        }
    }

    public DocumentContext getDocumentContext() {
        return this.rootContext;
    }

    public boolean isArray() {
        return this.rootNode.isArray();
    }

    public int getCountRootObjects() {
        return this.getCountObjects(this.rootNode);
    }

    public boolean isEmpty() {
        if (this.rootNode instanceof ArrayNode || this.rootNode instanceof ObjectNode) {
            return this.rootNode.size() == 0;
        }
        if (this.rootNode != null) {
            return this.rootNode.isNull();
        }
        return false;
    }

    public int getCountObjects(JsonNode node) {
        if (node instanceof ArrayNode) {
            return node.size();
        }
        if (node instanceof ObjectNode) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public ObjectNode createEmptyNode() {
        return objectMapper.createObjectNode();
    }

    public ObjectNode createEmptyObjectNode() {
        return objectMapper.createObjectNode();
    }

    public ArrayNode createEmptyArrayNode() {
        return objectMapper.createArrayNode();
    }

    public ObjectNode createObjectNode(String name) {
        ObjectNode child = ((ObjectNode)this.rootNode).objectNode();
        if (this.isArray()) {
            throw new IllegalStateException("Root is an array, use addObjectNode instead!");
        }
        ((ObjectNode)this.rootNode).set(name, (JsonNode)child);
        return child;
    }

    public ObjectNode addObjectNode(String name) {
        ObjectNode child = ((ArrayNode)this.rootNode).objectNode();
        if (!this.isArray()) {
            throw new IllegalStateException("Root is an array, use addObjectNode instead!");
        }
        ((ArrayNode)this.rootNode).add((JsonNode)child);
        return child;
    }

    public ObjectNode addObjectNode(JsonNode parent, String name) {
        if (parent instanceof ArrayNode) {
            ObjectNode child = ((ArrayNode)parent).objectNode();
            ((ArrayNode)parent).add((JsonNode)child);
            return child;
        }
        throw new IllegalArgumentException("parent must be an ArrayNode!");
    }

    public ArrayNode addArrayNode(JsonNode parent, String name) {
        if (parent instanceof ArrayNode) {
            ArrayNode child = ((ArrayNode)parent).arrayNode();
            ((ArrayNode)parent).add((JsonNode)child);
            return child;
        }
        throw new IllegalArgumentException("parent must be an ArrayNode!");
    }

    public ArrayNode createArrayNode(String name) {
        if (this.isArray()) {
            ArrayNode child = ((ArrayNode)this.rootNode).arrayNode();
            ((ArrayNode)this.rootNode).add((JsonNode)child);
            return child;
        }
        ArrayNode child = ((ObjectNode)this.rootNode).arrayNode();
        ((ObjectNode)this.rootNode).set(name, (JsonNode)child);
        return child;
    }

    public String toString() {
        return this.rootNode.toString();
    }

    public JsonPath getCompiledJsonPath(String jsonPathStr) {
        JsonPath compiledPath = this.compiledPathMap.get(jsonPathStr);
        if (compiledPath == null) {
            compiledPath = JsonPath.compile((String)jsonPathStr, (Predicate[])new Predicate[0]);
            this.compiledPathMap.put(jsonPathStr, compiledPath);
        }
        return compiledPath;
    }

    public JsonNode getNode(String jsonPath) {
        try {
            JsonPath compiledPath = this.getCompiledJsonPath(jsonPath);
            JsonNode node = (JsonNode)this.rootContext.read(compiledPath);
            if (node.isMissingNode() || node.isNull()) {
                return null;
            }
            return node;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public JsonNode getNodeIncludeMissing(String jsonPath) {
        try {
            JsonPath compiledPath = this.getCompiledJsonPath(jsonPath);
            JsonNode node = (JsonNode)this.rootContext.read(compiledPath);
            if (node.isNull()) {
                return null;
            }
            return node;
        }
        catch (PathNotFoundException e) {
            return MissingNode.getInstance();
        }
    }

    public JsonNode getNode(String jsonPath, boolean create) throws Exception {
        return this.getNode(this.rootNode, jsonPath, create);
    }

    public JsonNode getNode(JsonNode parentNode, String jsonPath) {
        if (jsonPath == null || jsonPath.trim().isEmpty()) {
            throw new IllegalArgumentException("jsonPath cannot be null or empty");
        }
        if (parentNode == null) {
            throw new IllegalArgumentException("parentNode cannot be null");
        }
        if (parentNode == this.rootNode && jsonPath.startsWith("$")) {
            return this.getNode(jsonPath);
        }
        if (jsonPath.equals(".")) {
            return parentNode;
        }
        ParseContext parseContext = JsonPath.using((Configuration)JACKSON_JSON_NODE_CONFIGURATION);
        DocumentContext context = parseContext.parse((Object)parentNode);
        JsonPath compiledPath = this.getCompiledJsonPath(jsonPath);
        JsonNode node = null;
        try {
            node = (JsonNode)context.read(compiledPath);
            if (node.isMissingNode() || node.isNull()) {
                return null;
            }
            return node;
        }
        catch (PathNotFoundException e) {
            return null;
        }
    }

    public JsonNode getNodeIncludeMissing(JsonNode parentNode, String jsonPath) {
        if (jsonPath == null || jsonPath.trim().isEmpty()) {
            throw new IllegalArgumentException("jsonPath cannot be null or empty");
        }
        if (parentNode == null) {
            throw new IllegalArgumentException("parentNode cannot be null");
        }
        if (parentNode == this.rootNode || jsonPath.startsWith("$")) {
            return this.getNodeIncludeMissing(jsonPath);
        }
        if (jsonPath.equals(".")) {
            return parentNode;
        }
        ParseContext parseContext = JsonPath.using((Configuration)JACKSON_JSON_NODE_CONFIGURATION);
        DocumentContext context = parseContext.parse((Object)parentNode);
        JsonPath compiledPath = this.getCompiledJsonPath(jsonPath);
        JsonNode node = null;
        try {
            node = (JsonNode)context.read(compiledPath);
            if (node.isNull()) {
                return null;
            }
            return node;
        }
        catch (PathNotFoundException e) {
            return MissingNode.getInstance();
        }
    }

    public JsonNode getNode(JsonNode parentNode, String jsonPath, boolean create) throws Exception {
        if (jsonPath == null || jsonPath.trim().isEmpty()) {
            throw new IllegalArgumentException("jsonPath cannot be null or empty");
        }
        if (parentNode == null) {
            throw new IllegalArgumentException("parentNode cannot be null");
        }
        if (jsonPath.equals("$")) {
            return this.rootNode;
        }
        if (jsonPath.equals(".")) {
            return parentNode;
        }
        if (!create) {
            if (parentNode == this.rootNode || jsonPath.startsWith("$")) {
                return this.getNode(jsonPath);
            }
            return this.getNode(parentNode, jsonPath);
        }
        Object childNode = null;
        if (jsonPath == null || jsonPath.trim().isEmpty() || jsonPath.trim().equals(".")) {
            return parentNode;
        }
        List<PathToken> listTokens = PathToken.parse(jsonPath);
        for (PathToken t : listTokens) {
            childNode = null;
            if (parentNode instanceof ObjectNode) {
                if (t instanceof AttributeToken) {
                    String name = ((AttributeToken)t).getName();
                    childNode = ((ObjectNode)parentNode).get(name);
                    if (childNode instanceof NullNode) {
                        ((ObjectNode)parentNode).remove(name);
                        childNode = null;
                    }
                    if (childNode == null) {
                        childNode = t.isNextTokenArray() ? ((ObjectNode)parentNode).withArray(name) : ((ObjectNode)parentNode).with(name);
                    }
                } else if (t instanceof ArrayToken) {
                    throw new Exception("The jsonpath expects an array node but found an object node at: " + t.getPath() + " parentNode: " + parentNode);
                }
            } else if (parentNode instanceof ArrayNode) {
                if (t instanceof ArrayToken) {
                    childNode = ((ArrayNode)parentNode).get(((ArrayToken)t).getIndex());
                    if (childNode == null || childNode.isNull()) {
                        childNode = t.hasNext() ? (t.isNextTokenArray() ? ((ArrayNode)parentNode).addArray() : ((ArrayNode)parentNode).addObject()) : parentNode;
                    }
                } else if (t instanceof AttributeToken) {
                    throw new Exception("The jsonpath expects an object node but found an array node at: " + t.getPath() + " parentNode: " + parentNode);
                }
            } else if (parentNode instanceof ValueNode && !parentNode.isNull()) {
                throw new Exception("The jsonpath expects an object or array node but found an value node at: " + t.getPath() + " parentNode: " + parentNode);
            }
            if (childNode == null) break;
            parentNode = childNode;
        }
        return childNode;
    }

    public DocumentContext getRootContext() {
        return this.rootContext;
    }

    public JsonNode getRootNode() {
        return this.rootNode;
    }

    public String formatDate(Date value, String pattern) {
        SimpleDateFormat sdf;
        if (value == null) {
            return null;
        }
        if (pattern == null || pattern.trim().isEmpty()) {
            pattern = DEFAULT_DATE_PATTERN;
        }
        if ((sdf = this.dateFormatMap.get(pattern)) == null) {
            sdf = new SimpleDateFormat(pattern);
            this.dateFormatMap.put(pattern, sdf);
        }
        return sdf.format(value);
    }

    public Date parseDate(String value, String pattern) throws ParseException {
        if (value == null) {
            return null;
        }
        return GenericDateUtil.parseDate(value, this.defaultLocale, pattern);
    }

    public JsonNode setJsonObject(ObjectNode node, String fieldName, String json) throws Exception {
        return this.setJsonObject(node, fieldName, json, false);
    }

    public JsonNode setJsonObject(ObjectNode node, String fieldName, String json, boolean omitAttrIfNullValue) throws Exception {
        if (omitAttrIfNullValue && json == null) {
            return node;
        }
        JsonNode newnode = JsonDocument.buildNode(json);
        node.set(fieldName, newnode);
        return node;
    }

    public JsonNode setJsonObject(ObjectNode node, String fieldName, JsonNode json) throws Exception {
        return this.setJsonObject(node, fieldName, json, false);
    }

    public JsonNode setJsonObject(ObjectNode node, String fieldName, JsonNode json, boolean omitAttrIfNullValue) throws Exception {
        if (omitAttrIfNullValue && json == null) {
            return node;
        }
        node.set(fieldName, json);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, String value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, String value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Boolean value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Boolean value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Integer value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Integer value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Long value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Long value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, BigDecimal value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, BigDecimal value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, BigInteger value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, BigInteger value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Double value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Double value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Float value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Float value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Short value) {
        return this.setValue(node, fieldName, value, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Short value, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, value);
        return node;
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Date value, String pattern) {
        return this.setValue(node, fieldName, value, pattern, false);
    }

    public ObjectNode setValue(ObjectNode node, String fieldName, Date value, String pattern, boolean omitAttrIfNullValue) {
        if (omitAttrIfNullValue && value == null) {
            return node;
        }
        node.put(fieldName, this.formatDate(value, pattern));
        return node;
    }

    public static JsonNode buildNode(Object value) throws Exception {
        if (value instanceof String) {
            String jsonString = (String)value;
            if (jsonString == null || jsonString.trim().isEmpty()) {
                return null;
            }
            return objectMapper.readTree(jsonString);
        }
        if (value instanceof JsonNode) {
            return (JsonNode)value;
        }
        return null;
    }

    public String getJsonString(boolean prettyPrint, boolean suppressEmpty) throws JsonProcessingException {
        if (suppressEmpty) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        } else {
            objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
        if (prettyPrint) {
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.rootNode);
        }
        return objectMapper.writeValueAsString((Object)this.rootNode);
    }

    public String getJsonString(JsonNode node, boolean prettyPrint, boolean suppressEmpty) throws JsonProcessingException {
        if (suppressEmpty) {
            objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
        } else {
            objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        }
        if (node != null) {
            if (prettyPrint) {
                return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)node);
            }
            return objectMapper.writeValueAsString((Object)node);
        }
        return "{}";
    }

    public void writeToFile(String filePath, boolean prettyPrint, boolean suppressEmpty) throws Exception {
        this.writeToFile(this.rootNode, filePath, prettyPrint, suppressEmpty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(JsonNode node, String filePath, boolean prettyPrint, boolean suppressEmpty) throws Exception {
        if (filePath == null || filePath.trim().isEmpty()) {
            throw new IllegalArgumentException("Output file path cannot be null or empty!");
        }
        File file = new File(filePath);
        File dir = file.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!dir.exists()) {
            throw new Exception("Cannot create output dir: " + dir.getAbsolutePath());
        }
        try (BufferedWriter br = null;){
            br = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            br.write(this.getJsonString(node, prettyPrint, suppressEmpty));
            br.flush();
        }
    }

    public JsonNode getValueAsObject(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Object dummy) throws Exception {
        if (node != null) {
            JsonNode valueNode = null;
            if (fieldName == null || ".".equals(fieldName) || node.isValueNode()) {
                valueNode = node;
            } else {
                valueNode = fieldName.contains(".") || fieldName.contains("[") || fieldName.contains("$") ? this.getNodeIncludeMissing(node, fieldName) : node.path(fieldName);
                if (!isNullable && valueNode != null && valueNode.isNull()) {
                    throw new Exception(this.currentPath + ": Attribute: <" + fieldName + ">: value is null but configured as not-nullable!");
                }
                if (!allowMissing && valueNode != null && valueNode.isMissingNode()) {
                    throw new Exception(this.currentPath + ": Attribute: <" + fieldName + "> is missing but mandatory!");
                }
            }
            return valueNode;
        }
        if (!isNullable) {
            throw new Exception(this.currentPath + ": Parent node does not exists.");
        }
        return null;
    }

    private JsonNode getValueNode(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing) throws Exception {
        if (node != null) {
            JsonNode valueNode = null;
            if (fieldName == null || ".".equals(fieldName) || node.isValueNode()) {
                valueNode = node;
                if (valueNode != null && valueNode.isNull()) {
                    if (!isNullable) {
                        String message = this.currentPath + ": ";
                        if (fieldName != null && !".".equals(fieldName)) {
                            message = message + "Attribute: " + fieldName + ": ";
                        }
                        message = valueNode.isValueNode() ? message + "ValueNode is null" : (valueNode.isArray() ? message + "ArrayNode is null" : message + "ObjectNode is null");
                        message = message + " but configured as not-nullable!";
                        throw new Exception(message);
                    }
                    valueNode = null;
                }
            } else {
                valueNode = fieldName.contains(".") || fieldName.contains("[") || fieldName.contains("$") ? this.getNodeIncludeMissing(node, fieldName) : node.path(fieldName);
                if (valueNode != null && valueNode.isNull()) {
                    if (!isNullable) {
                        throw new Exception(this.currentPath + ": Attribute: " + fieldName + ": value is null but configured as not-nullable!");
                    }
                    valueNode = null;
                }
                if (!allowMissing && valueNode != null && valueNode.isMissingNode()) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing but mandatory! Node: " + node);
                }
            }
            return valueNode;
        }
        if (!isNullable) {
            throw new Exception(this.currentPath + ": Parent node does not exists.");
        }
        return null;
    }

    public String getArrayValuesAsChain(ArrayNode arrayNode) {
        StringBuilder sb = new StringBuilder();
        if (arrayNode != null) {
            boolean firstLoop = true;
            Iterator iterator = arrayNode.iterator();
            while (iterator.hasNext()) {
                String value;
                JsonNode valueNode = (JsonNode)iterator.next();
                if (!valueNode.isValueNode() || (value = valueNode.asText()) == null || value.isEmpty()) continue;
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    sb.append(",");
                }
                sb.append(value);
            }
        }
        return sb.toString();
    }

    private void collectNodes(JsonNode node, List<JsonNode> result, boolean unique) {
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator iterator = arrayNode.iterator();
            while (iterator.hasNext()) {
                JsonNode childNode = (JsonNode)iterator.next();
                if (childNode instanceof ArrayNode) {
                    this.collectNodes(childNode, result, unique);
                    continue;
                }
                if (unique && result.contains(childNode)) continue;
                result.add(childNode);
            }
        } else if (node instanceof ObjectNode) {
            if (!unique || !result.contains(node)) {
                result.add(node);
            }
        } else if (!(!(node instanceof ValueNode) || unique && result.contains(node))) {
            result.add(node);
        }
    }

    public List<JsonNode> getArrayValuesAsList(JsonNode node, boolean unique, boolean deep) {
        if (deep) {
            return this.getArrayValuesAsList(node, unique);
        }
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            Iterator iterator = arrayNode.iterator();
            while (iterator.hasNext()) {
                JsonNode childNode = (JsonNode)iterator.next();
                if (unique && result.contains(childNode)) continue;
                result.add(childNode);
            }
        } else if (node instanceof ObjectNode) {
            if (!unique || !result.contains(node)) {
                result.add(node);
            }
        } else if (!(!(node instanceof ValueNode) || unique && result.contains(node))) {
            result.add(node);
        }
        return result;
    }

    public List<JsonNode> getArrayValuesAsList(JsonNode node) {
        return this.getArrayValuesAsList(node, false);
    }

    public List<JsonNode> getArrayValuesAsList(JsonNode node, boolean unique) {
        ArrayList<JsonNode> result = new ArrayList<JsonNode>();
        this.collectNodes(node, result, unique);
        return result;
    }

    private JsonNode getNodeFromArray(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing) throws Exception {
        if (node instanceof ArrayNode) {
            ArrayNode arrayNode = (ArrayNode)node;
            if (arrayIndex < arrayNode.size()) {
                JsonNode child = arrayNode.get(arrayIndex);
                if (child.isNull() && isNullable) {
                    throw new Exception("ArrayNode: " + node + " contains at index: " + arrayIndex + " a null node but is configured as not nullable.");
                }
                return child;
            }
            if (allowMissing) {
                return null;
            }
            throw new Exception("ArrayNode: " + node + " has less elements than expected array index: " + arrayIndex);
        }
        return node;
    }

    public String getValueAsString(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, String missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsString(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public String getValueAsString(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, String missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            if (valueNode.isValueNode()) {
                return valueNode.asText();
            }
            return valueNode.toString();
        }
        return null;
    }

    public Boolean getValueAsBoolean(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Boolean missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsBoolean(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public Boolean getValueAsBoolean(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Boolean missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToBoolean(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public Integer getValueAsInteger(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Integer missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsInteger(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public Integer getValueAsInteger(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Integer missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToInteger(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public Long getValueAsLong(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Long missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsLong(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public Long getValueAsLong(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Long missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToLong(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public Double getValueAsDouble(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Double missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsDouble(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public Double getValueAsDouble(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Double missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToDouble(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public Float getValueAsFloat(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Float missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsFloat(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public Float getValueAsFloat(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Float missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToFloat(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public Short getValueAsShort(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Short missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsShort(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public Short getValueAsShort(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Short missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToShort(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public BigDecimal getValueAsBigDecimal(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, BigDecimal missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsBigDecimal(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public BigDecimal getValueAsBigDecimal(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, BigDecimal missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToBigDecimal(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public BigDecimal getValueAsBigDecimal(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, String missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsBigDecimal(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public BigDecimal getValueAsBigDecimal(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, String missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (missingNodeValue == null || missingNodeValue.trim().isEmpty()) {
                    if (isNullable) {
                        throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null or empty!");
                    }
                    return null;
                }
                return TypeUtil.convertToBigDecimal(missingNodeValue);
            }
            try {
                return TypeUtil.convertToBigDecimal(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public BigInteger getValueAsBigInteger(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, BigInteger missingNodeValue) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsBigInteger(oneNode, ".", isNullable, allowMissing, missingNodeValue);
    }

    public BigInteger getValueAsBigInteger(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, BigInteger missingNodeValue) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return TypeUtil.convertToBigInteger(valueNode);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public Date getValueAsDate(JsonNode node, int arrayIndex, boolean isNullable, boolean allowMissing, Date missingNodeValue, String pattern) throws Exception {
        JsonNode oneNode = this.getNodeFromArray(node, arrayIndex, isNullable, allowMissing);
        return this.getValueAsDate(oneNode, ".", isNullable, allowMissing, missingNodeValue, pattern);
    }

    public Date getValueAsDate(JsonNode node, String fieldName, boolean isNullable, boolean allowMissing, Date missingNodeValue, String pattern) throws Exception {
        JsonNode valueNode = this.getValueNode(node, fieldName, isNullable, allowMissing);
        if (valueNode != null) {
            if (valueNode.isMissingNode()) {
                if (!isNullable && missingNodeValue == null) {
                    throw new Exception(this.currentPath + ": Attribute: " + fieldName + " is missing and configured as not-nullable but the replacement value is also null!");
                }
                return missingNodeValue;
            }
            try {
                return this.parseDate(valueNode.asText(), pattern);
            }
            catch (Exception e) {
                throw new Exception("Convert attribute: " + fieldName + " failed.", e);
            }
        }
        return null;
    }

    public static String escape(String value) {
        if (value == null) {
            return null;
        }
        if (value.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int n = value.length();
        block9: for (int i = 0; i < n; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        if (currentPath == null) {
            currentPath = "Unknown path";
        }
        this.currentPath = currentPath;
    }

    public static int countNotNullAttributes(JsonNode node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        if (node.size() == 0) {
            return 0;
        }
        int count = 0;
        Iterator it = node.elements();
        while (it.hasNext()) {
            JsonNode valueNode = (JsonNode)it.next();
            if (valueNode.isMissingNode() || valueNode.isNull()) continue;
            ++count;
        }
        return count;
    }

    public JsonNode getConditionalUnwrappedRootNode(Boolean unwrap, boolean die) throws Exception {
        return this.getConditionalUnwrappedNode(this.rootNode, unwrap, die);
    }

    public JsonNode getConditionalUnwrappedNode(JsonNode node, Boolean unwrap, boolean die) throws Exception {
        if (unwrap != null && unwrap.booleanValue()) {
            if (node instanceof ArrayNode) {
                if (node.size() > 1) {
                    if (die) {
                        throw new Exception("Cannot remove root array because it contains more than one nodes (" + node.size() + ")");
                    }
                    return ((ArrayNode)node).get(0);
                }
                if (node.size() == 1) {
                    return ((ArrayNode)node).get(0);
                }
                return null;
            }
            return node;
        }
        return node;
    }

    public void setDefaultLocale(String localeStr) {
        if (localeStr != null && !localeStr.trim().isEmpty()) {
            this.defaultLocale = Util.createLocale(localeStr);
        }
    }

    public List<JsonNode> getAttributeNodes(ObjectNode objectNode) {
        ArrayList<JsonNode> listASttributes = new ArrayList<JsonNode>();
        Iterator<String> it = objectNode.fieldNames();
        while (it.hasNext()) {
            ObjectNode node = objectMapper.createObjectNode();
            String attrName = it.next();
            node.set(attrName, objectNode.get(attrName));
            listASttributes.add((JsonNode)node);
        }
        return listASttributes;
    }

    public static JsonNode parse(String jsonContent) throws Exception {
        if (jsonContent != null && !jsonContent.trim().isEmpty()) {
            DocumentContext docContext = staticParseContext.parse(jsonContent);
            JsonNode node = (JsonNode)docContext.json();
            return node;
        }
        throw new IllegalArgumentException("Json input content cannot be empty or null");
    }

    public static void setJsonSchema(String schemaId, Object schemaContent) throws Exception {
        if (schemaId == null || schemaId.trim().isEmpty()) {
            throw new IllegalArgumentException("schemaId cannot be null or empty");
        }
        if (schemaContent != null && schemaId != null && !schemaId.trim().isEmpty()) {
            JsonNode schemaNode = null;
            if (schemaContent instanceof String) {
                schemaNode = JsonDocument.parse((String)schemaContent);
            } else if (schemaContent instanceof JsonNode) {
                schemaNode = (JsonNode)schemaContent;
            } else if (schemaContent instanceof JsonDocument) {
                schemaNode = ((JsonDocument)schemaContent).getRootNode();
            } else {
                throw new IllegalArgumentException("Schema content must be provided as String or JsonNode. Currently got object type: " + schemaContent.getClass().getName());
            }
            schemaMap.put(schemaId, schemaNode);
        }
    }

    public String validate(String schemaId) throws Exception {
        this.lastValidationReport.clear();
        JsonNode schemaNode = schemaMap.get(schemaId);
        if (schemaNode != null) {
            JsonSchema v = schemaFactory.getSchema(schemaNode);
            this.lastValidationReport = v.validate(this.rootNode);
            return JsonDocument.buildValidationReportText(this.lastValidationReport);
        }
        throw new Exception("No json schema defined for the component: " + schemaId);
    }

    public Set<ValidationMessage> getLastValidationReport() {
        return this.lastValidationReport;
    }

    public static String buildValidationReportText(Set<ValidationMessage> report) {
        if (report.isEmpty()) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        text.append("JSON schema validation found " + report.size() + " problems");
        text.append("\n");
        for (ValidationMessage m : report) {
            text.append(m.getMessage());
            text.append("\n");
        }
        return text.toString();
    }
}

