/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import de.jlo.talendcomp.json.JsonDocument;

public class JsonComparator {
    private ObjectMapper objectMapper = new ObjectMapper();

    public JsonComparator getInstance() {
        return new JsonComparator();
    }

    public ArrayNode intersect(ArrayNode array1, ArrayNode array2) {
        ArrayNode result = this.objectMapper.createArrayNode();
        int n1 = array1.size();
        for (int i1 = 0; i1 < n1; ++i1) {
            JsonNode node1 = array1.get(i1);
            int n2 = array2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JsonNode node2 = array2.get(i2);
                if (!node1.equals((Object)node2)) continue;
                result.add(node2);
            }
        }
        return result;
    }

    public boolean contains(ArrayNode array, JsonNode value) {
        int n = array.size();
        for (int i = 0; i < n; ++i) {
            JsonNode node = array.get(i);
            if (!node.equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(ArrayNode array, JsonNode value, String jsonPath) throws Exception {
        if (jsonPath == null || jsonPath.trim().isEmpty()) {
            return this.contains(array, value);
        }
        JsonDocument doc = new JsonDocument((JsonNode)array);
        int n = array.size();
        for (int i = 0; i < n; ++i) {
            JsonNode child2;
            JsonNode nodeInArray = array.get(i);
            JsonNode child1 = doc.getNode(nodeInArray, jsonPath);
            if (!child1.equals((Object)(child2 = doc.getNode(value, jsonPath)))) continue;
            return true;
        }
        return false;
    }

    public ArrayNode difference(ArrayNode array1, ArrayNode array2) {
        ArrayNode result = this.objectMapper.createArrayNode();
        int n1 = array1.size();
        for (int i1 = 0; i1 < n1; ++i1) {
            JsonNode node1 = array1.get(i1);
            boolean found = false;
            int n2 = array2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JsonNode node2 = array2.get(i2);
                if (!node1.equals((Object)node2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(node1);
        }
        ArrayNode x = array1;
        array1 = array2;
        array2 = x;
        int n12 = array1.size();
        for (int i1 = 0; i1 < n12; ++i1) {
            JsonNode node1 = array1.get(i1);
            boolean found = false;
            int n2 = array2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                JsonNode node2 = array2.get(i2);
                if (!node1.equals((Object)node2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(node1);
        }
        return result;
    }
}

