/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.json;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class GenericDateUtil {
    private static ThreadLocal<DateParser> threadLocal = new ThreadLocal();
    public static final long ZERO_TIME = -62170160400000L;
    private static TimeZone utcTimeZone = null;

    public static Date parseDuration(String source) throws ParseException {
        return GenericDateUtil.parseDuration(source, null);
    }

    public static Date parseDuration(String source, String ... suggestedPattern) throws ParseException {
        return GenericDateUtil.getDateParser().parseDuration(source, suggestedPattern);
    }

    public static Long parseDuration(Double source) {
        return GenericDateUtil.getDateParser().getDuration(source);
    }

    public static Date parseDate(String source) throws ParseException {
        return GenericDateUtil.parseDate(source, (String[])null);
    }

    public static Date parseDate(String source, String ... suggestedPattern) throws ParseException {
        return GenericDateUtil.getDateParser().parseDate(source, null, suggestedPattern);
    }

    public static Date parseDate(String source, Locale locale, String ... suggestedPattern) throws ParseException {
        return GenericDateUtil.getDateParser().parseDate(source, locale, suggestedPattern);
    }

    public static DateParser getDateParser() {
        DateParser p = threadLocal.get();
        if (p == null) {
            p = new DateParser();
            threadLocal.set(p);
        }
        return p;
    }

    private static TimeZone getUTCTimeZone() {
        if (utcTimeZone == null) {
            utcTimeZone = TimeZone.getTimeZone("UTC");
        }
        return utcTimeZone;
    }

    public static boolean isZeroDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance(GenericDateUtil.getUTCTimeZone());
            cal.setTime(date);
            cal.setLenient(false);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            cal.set(11, 0);
            int year = cal.get(1);
            int month = cal.get(2);
            int day = cal.get(5);
            int era = cal.get(0);
            return year == 2 && month == 10 && era == 0 && (day == 29 || day == 30);
        }
        return false;
    }

    public static class DateParser {
        private List<String> datePatternList = new ArrayList<String>();
        private List<String> timePatternList = null;
        private static final int SECONDS_PER_MINUTE = 60;
        private static final int MINUTES_PER_HOUR = 60;
        private static final int HOURS_PER_DAY = 24;
        private static final int SECONDS_PER_DAY = 86400;
        private static final long DAY_MILLISECONDS = 86400000L;
        private boolean lenient = true;

        DateParser() {
            this.datePatternList.add("yyyy-MM-dd");
            this.datePatternList.add("dd.MM.yyyy");
            this.datePatternList.add("d.MM.yyyy");
            this.datePatternList.add("d.M.yy");
            this.datePatternList.add("dd.MM.yy");
            this.datePatternList.add("dd.MMM.yyyy");
            this.datePatternList.add("MM/dd/yyyy");
            this.datePatternList.add("MM/dd/yy");
            this.datePatternList.add("M/d/yy");
            this.datePatternList.add("dd/MM/yyyy");
            this.datePatternList.add("dd/MM/yy");
            this.datePatternList.add("dd/MMM/yyyy");
            this.datePatternList.add("dd. MMMM yyyy");
            this.datePatternList.add("dd. MMM. yyyy");
            this.datePatternList.add("dd. MMM yyyy");
            this.datePatternList.add("MMMM dd'th' yyyy");
            this.datePatternList.add("MMM dd'th' yyyy");
            this.datePatternList.add("MMM dd, yyyy");
            this.datePatternList.add("dd'th' MMMM yyyy");
            this.datePatternList.add("dd'th' MMM yyyy");
            this.datePatternList.add("'KW' w/yyyy");
            this.datePatternList.add("'w/c' w.yyyy");
            this.datePatternList.add("'CW' w.yyyy");
            this.datePatternList.add("MMMM yyyy");
            this.datePatternList.add("dd-MM-yyyy");
            this.datePatternList.add("dd-MM-yy");
            this.datePatternList.add("dd-MMM-yyyy");
            this.datePatternList.add("d-M-yy");
            this.datePatternList.add("yyyyMMdd");
            this.datePatternList.add("yyyyMM");
            this.datePatternList.add("yyyy");
            this.timePatternList = new ArrayList<String>();
            this.timePatternList.add(" mm''ss'\"'");
            this.timePatternList.add(" mm''ss'\u201c'");
            this.timePatternList.add(" mm''ss'\u201d'");
            this.timePatternList.add(" mm'\u2018'ss'\u201c'");
            this.timePatternList.add(" mm'\u2019'ss'\u201d'");
            this.timePatternList.add(" mm'\u2032'ss'\u2033'");
            this.timePatternList.add(" HH'h'mm'm'ss's'");
            this.timePatternList.add(" HH'h'mm'm'");
            this.timePatternList.add(" mm'm'ss's'");
            this.timePatternList.add("'T'HH:mm:ss.SSSZ");
            this.timePatternList.add("'T'HH:mm:ss.SSS");
            this.timePatternList.add(" hh:mm:ss aaa");
            this.timePatternList.add(" HH:mm:ss.SSS");
            this.timePatternList.add(" HH:mm:ss");
            this.timePatternList.add(" mm:ss");
            this.timePatternList.add(" HHmmss");
            this.timePatternList.add(" mmss");
        }

        private Date parseDate(String text, Locale locale, String ... userPattern) throws ParseException {
            if (text != null && !text.trim().isEmpty()) {
                Date dateValue = null;
                if (userPattern != null) {
                    for (int i = userPattern.length - 1; i >= 0; --i) {
                        if (this.datePatternList.contains(userPattern[i])) {
                            this.datePatternList.remove(userPattern[i]);
                        }
                        this.datePatternList.add(0, userPattern[i]);
                    }
                }
                if (locale == null) {
                    locale = Locale.ENGLISH;
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd", locale);
                sdf.setLenient(this.lenient);
                for (String pattern : this.datePatternList) {
                    if (pattern == null) continue;
                    sdf.applyPattern(pattern.trim());
                    try {
                        dateValue = sdf.parse(text);
                        if (text.length() - pattern.length() >= 6) {
                            for (String timepattern : this.timePatternList) {
                                String dateTimePattern = pattern + timepattern;
                                sdf.applyPattern(dateTimePattern);
                                try {
                                    dateValue = sdf.parse(text);
                                    pattern = dateTimePattern;
                                    break;
                                }
                                catch (ParseException parseException) {
                                }
                            }
                        }
                        return dateValue;
                    }
                    catch (ParseException e) {
                    }
                }
                throw new ParseException("The value: " + text + " could not be parsed to a Date.", 0);
            }
            return null;
        }

        private Date parseDuration(String text, String ... userPattern) throws ParseException {
            if (text != null && !text.trim().isEmpty()) {
                Date timeValue = null;
                if (userPattern != null) {
                    for (int i = userPattern.length - 1; i >= 0; --i) {
                        if (this.timePatternList.contains(userPattern[i])) {
                            this.timePatternList.remove(userPattern[i]);
                        }
                        this.timePatternList.add(0, userPattern[i]);
                    }
                }
                SimpleDateFormat sdf = new SimpleDateFormat();
                sdf.setTimeZone(GenericDateUtil.getUTCTimeZone());
                for (String pattern : this.timePatternList) {
                    if (pattern == null) continue;
                    sdf.applyPattern(pattern.trim());
                    try {
                        timeValue = sdf.parse(text);
                        return timeValue;
                    }
                    catch (ParseException e) {
                    }
                }
                throw new ParseException("The value: " + text + " could not be parsed to a Date as duration.", 0);
            }
            return null;
        }

        private Long getDuration(Double timeInExcel) {
            if (timeInExcel != null) {
                int wholeDays = (int)Math.floor(timeInExcel);
                int millisecondsInDay = (int)((timeInExcel - (double)wholeDays) * 8.64E7 + 0.5);
                Calendar cal = Calendar.getInstance(GenericDateUtil.getUTCTimeZone());
                cal.setTimeInMillis(0L);
                cal.set(14, millisecondsInDay);
                return cal.getTimeInMillis();
            }
            return null;
        }

        public boolean isLenient() {
            return this.lenient;
        }

        public void setLenient(boolean lenient) {
            this.lenient = lenient;
        }
    }
}

