/*
 * Decompiled with CFR 0.152.
 */
package de.cimt.talendcomp.dbtools.parser;

import de.cimt.talendcomp.dbtools.parser.SQLStatement;
import java.io.Serializable;
import java.util.StringTokenizer;

public class SQLPSParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PARAM_DESC_DELIMITER = "\u0002";
    private SQLStatement sqlPs;
    private int index;
    private String name;
    private int basicType = -1;
    private String value;
    private String valueCode;
    private boolean outParam = false;
    private boolean isNamedParam = false;
    public static final int ORACLE_ROWID = -100;
    public static final int BASICTYPE_CHAR = 0;
    public static final int BASICTYPE_DATE = 1;
    public static final int BASICTYPE_NUMERIC = 2;
    public static final int BASICTYPE_BINARY = 3;
    public static final int BASICTYPE_CLOB = 4;
    public static final int BASICTYPE_BLOB = 6;
    public static final int BASICTYPE_ROWID = -100;
    public static final int BASICTYPE_BOOLEAN = 8;

    public int getBasicType() {
        return this.basicType;
    }

    public int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    public SQLStatement getSqlPs() {
        return this.sqlPs;
    }

    public String getValue() {
        return this.value;
    }

    public void setBasicType(int i) {
        this.basicType = i;
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public void setName(String string) {
        if (string != null && string.length() > 0) {
            string = string.trim();
            int firstSpaceIndex = string.indexOf(" ");
            int lastSpaceIndex = string.lastIndexOf(" ");
            if (firstSpaceIndex != -1) {
                String dataType;
                if (lastSpaceIndex == firstSpaceIndex && string.indexOf("#") == -1) {
                    firstSpaceIndex = 0;
                }
                if ((dataType = string.substring(firstSpaceIndex, lastSpaceIndex)).length() > 0) {
                    if ((dataType = dataType.toLowerCase().trim()).equals("string") || dataType.indexOf("char") != -1 || dataType.equals("rowid")) {
                        this.basicType = 0;
                    } else if (dataType.indexOf("num") != -1 || dataType.indexOf("int") != -1 || dataType.indexOf("long") != -1) {
                        this.basicType = 2;
                    } else if (dataType.indexOf("date") != -1 || dataType.indexOf("time") != -1) {
                        this.basicType = 1;
                    }
                }
                this.name = string.substring(lastSpaceIndex).trim();
            } else {
                this.name = string.trim();
            }
        }
    }

    public void setSqlPs(SQLStatement statement) {
        this.sqlPs = statement;
    }

    public void setValue(String value_loc) {
        this.value = value_loc;
    }

    public boolean isValid() {
        return this.index > 0 && this.value != null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("index=");
        sb.append(this.index);
        if (this.outParam) {
            sb.append(" out");
        } else {
            sb.append(" in");
        }
        if (this.value != null) {
            sb.append(" name=");
            sb.append(this.name);
        }
        if (this.value != null) {
            sb.append(" value=");
            sb.append(this.value);
        }
        return sb.toString();
    }

    public void parseParamStr(String paramStr) {
        StringTokenizer st = new StringTokenizer(paramStr, PARAM_DESC_DELIMITER);
        this.index = Integer.parseInt(st.nextToken());
        this.name = st.nextToken();
        this.value = st.nextToken();
    }

    public String getParamStr() {
        return this.index + PARAM_DESC_DELIMITER + this.name + PARAM_DESC_DELIMITER + this.value;
    }

    public String getValueCode() {
        return this.valueCode;
    }

    public void setValueCode(String valueCode_loc) {
        this.valueCode = valueCode_loc;
    }

    public final boolean isOutParam() {
        return this.outParam;
    }

    public final void setOutParam(boolean outParam) {
        this.outParam = outParam;
    }

    public void setNamedParam(boolean isNamedParam) {
        this.isNamedParam = isNamedParam;
    }

    public boolean isNamedParam() {
        return this.isNamedParam;
    }
}

