/*
 * Decompiled with CFR 0.152.
 */
package org.chaostocosmos.scheduler.quartz;

import java.util.Date;
import java.util.List;
import org.chaostocosmos.scheduler.quartz.JobExecutorConcurrent;
import org.chaostocosmos.scheduler.quartz.JobExecutorNonConcurrent;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;

public class CronScheduler {
    Scheduler scheduler = StdSchedulerFactory.getDefaultScheduler();

    public CronScheduler() throws SchedulerException {
        this.scheduler.start();
        System.out.println("############# Scheduler started " + new Date().toString() + " #############");
    }

    public void addSchedule(Date startDate, Date endDate, boolean overtimeCancelPolicy, boolean isAllowConcurrent, String cronExpr, MISFIRE_POLICY misPolicy, Object obj, String methods, Object ... params) throws SchedulerException {
        Object object;
        Object job;
        System.out.println("START DATE: " + startDate);
        System.out.println("END DATE: " + endDate);
        System.out.println("OVERTIME CANCEL: " + overtimeCancelPolicy);
        System.out.println("CONCURRENT: " + isAllowConcurrent);
        System.out.println("CRON EXPR: " + cronExpr);
        System.out.println("CLASS: " + obj.getClass().toString());
        System.out.println("METHOD: " + methods);
        System.out.println("PARAMS: " + params.getClass().toString());
        System.out.println("#################################################################");
        if (isAllowConcurrent) {
            job = new JobExecutorConcurrent();
            object = job;
        } else {
            object = new JobExecutorNonConcurrent();
        }
        job = object;
        JobDataMap map = new JobDataMap();
        map.put("INVOKE_OBJECT", obj);
        map.put("INVOKE_METHOD", methods);
        map.put("INVOKE_PARAMS", (Object)params);
        map.put("OVERTIME_CANCEL_POLICY", overtimeCancelPolicy);
        JobDetail jobDetail = JobBuilder.newJob(job.getClass()).usingJobData(map).build();
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule((String)cronExpr);
        if (misPolicy == MISFIRE_POLICY.DO_NOTHING) {
            cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
        } else if (misPolicy == MISFIRE_POLICY.FIRE_PROCEED) {
            cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
        } else if (misPolicy == MISFIRE_POLICY.IGNORE) {
            cronScheduleBuilder.withMisfireHandlingInstructionIgnoreMisfires();
        }
        TriggerBuilder triggerBuilder = TriggerBuilder.newTrigger();
        triggerBuilder.withSchedule((ScheduleBuilder)cronScheduleBuilder);
        if (startDate != null) {
            triggerBuilder.startAt(startDate);
        }
        if (endDate != null) {
            triggerBuilder.endAt(endDate);
        }
        Trigger trigger = triggerBuilder.forJob(jobDetail).build();
        this.scheduler.scheduleJob(jobDetail, trigger);
    }

    public void shutdown() throws SchedulerException {
        this.scheduler.shutdown();
    }

    public boolean isActive() throws SchedulerException {
        for (String groupName : this.scheduler.getJobGroupNames()) {
            for (JobKey jobKey : this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)groupName))) {
                List triggers = this.scheduler.getTriggersOfJob(jobKey);
                for (Trigger trigger : triggers) {
                    if (!trigger.mayFireAgain()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void main(String[] args) throws SchedulerException {
        new CronScheduler().addSchedule(new Date(), new Date(new Date().getTime() + 5000L), true, false, "0/2 * * * * ?", MISFIRE_POLICY.IGNORE, new TriggeredExample(), "execute", null);
    }

    public static class TriggeredExample {
        public void execute() {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static enum MISFIRE_POLICY {
        DO_NOTHING,
        FIRE_PROCEED,
        IGNORE;

    }
}

