/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel.ext.impl;

import de.jlo.datamodel.SQLProcedure;
import de.jlo.datamodel.SQLTable;
import de.jlo.datamodel.StringReplacer;
import de.jlo.datamodel.ext.GenericDatabaseExtension;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeradataExtension
extends GenericDatabaseExtension {
    private static final String name = "Teradata Extension";
    private static final Logger logger = LoggerFactory.getLogger(TeradataExtension.class);

    public TeradataExtension() {
        this.addDriverClassName("com.teradata.jdbc.TeraDriver");
        this.addSQLKeyword("timezone_minute");
        this.addSQLKeyword("timezone_hour");
        this.addSQLKeyword("no");
        this.addSQLKeyword("before");
        this.addSQLKeyword("after");
        this.addSQLKeyword("collect");
        this.addSQLKeyword("row_number");
        this.addSQLKeywords("merge", "portion", "extract");
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean hasExplainFeature() {
        return true;
    }

    @Override
    public String getExplainSQL(String currentStatement) {
        StringBuilder sb = new StringBuilder();
        sb.append("diagnostic helpstats on for session;\n");
        sb.append("explain\n");
        sb.append(currentStatement);
        return sb.toString();
    }

    @Override
    public String setupViewSQLCode(Connection conn, SQLTable table) {
        if (table.isView()) {
            if (logger.isDebugEnabled()) {
                logger.debug("setupViewSQLCode view=" + table.getAbsoluteName());
            }
            StringBuilder sb = new StringBuilder();
            sb.append("show view ");
            sb.append(table.getSchema().getName());
            sb.append(".");
            sb.append(table.getName());
            String source = null;
            try {
                Statement stat = conn.createStatement();
                ResultSet rs = stat.executeQuery(sb.toString());
                if (rs.next() && (source = rs.getString(1)) != null && !source.isEmpty()) {
                    table.setSourceCode(StringReplacer.fixLineBreaks(source));
                }
                rs.close();
                stat.close();
            }
            catch (SQLException sqle) {
                logger.error("setupViewSQLCode for table " + table.getAbsoluteName() + " failed: " + sqle.getMessage(), (Throwable)sqle);
            }
            return source;
        }
        return null;
    }

    @Override
    public String setupProcedureSQLCode(Connection conn, SQLProcedure proc) {
        if (logger.isDebugEnabled()) {
            logger.debug("setupProcedureSQLCode procedure=" + proc.getAbsoluteName());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("show procedure ");
        sb.append(proc.getSchema().getName());
        sb.append(".");
        sb.append(proc.getName());
        StringBuilder code = new StringBuilder();
        try {
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery(sb.toString());
            while (rs.next()) {
                code.append(StringReplacer.fixLineBreaks(rs.getString(1)));
                code.append("\n");
            }
            rs.close();
            stat.close();
            if (sb.length() > 0) {
                proc.setCode(code.toString());
            }
        }
        catch (SQLException sqle) {
            logger.error("setupProcedureSQLCode for procedure " + proc.getAbsoluteName() + " failed: " + sqle.getMessage(), (Throwable)sqle);
        }
        return proc.getCode();
    }
}

