/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.talendcomp.tabletransfer;

import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLField;
import de.jlo.datamodel.SQLPSParam;
import de.jlo.datamodel.SQLSchema;
import de.jlo.datamodel.SQLStatement;
import de.jlo.datamodel.SQLTable;
import de.jlo.datamodel.StringReplacer;
import de.jlo.datamodel.generator.SQLCodeGenerator;
import de.jlo.talendcomp.tabletransfer.ColumnValue;
import de.jlo.talendcomp.tabletransfer.DBHelper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TableTransfer {
    private Logger logger = null;
    private Properties properties = new Properties();
    private Connection sourceConnection;
    private Connection targetConnection;
    protected SQLStatement targetInsertStatement;
    private Statement sourceSelectStatement;
    protected PreparedStatement targetPSInsert;
    private SQLDataModel sourceModel;
    private static final Map<String, SQLDataModel> sqlModelCache = new HashMap<String, SQLDataModel>();
    private SQLDataModel targetModel;
    private SQLTable sourceTable;
    private String sourceQuery;
    private SQLTable targetTable;
    private static final int RETURN_CODE_OK = 0;
    private static final int RETURN_CODE_ERROR_INPUT = 1;
    private static final int RETURN_CODE_ERROR_OUPUT = 1;
    private static final int RETURN_CODE_WARN = 5;
    private int returnCode = 0;
    private String errorMessage;
    private Exception errorException;
    private BlockingQueue<Object> tableQueue;
    private BlockingQueue<Object> fileQueue;
    private final Object closeFlag = new String("The End");
    private List<String> listSourceFieldNames;
    private List<String> listSourceFieldTypeNames;
    private Thread readerThread;
    private Thread writerThread;
    private Thread writerBackupThread;
    private volatile int countInsertsAdded = 0;
    private volatile int countInsertsInDB = 0;
    private volatile int countFileRows = 0;
    private volatile int countRead = 0;
    private volatile boolean runningDb = false;
    private volatile boolean runningFile = false;
    private long startTime;
    public static final String SOURCE_FETCHSIZE = "source.fetchSize";
    public static final String SOURCE_TABLE = "source.table";
    public static final String SOURCE_WHERE = "source.whereClause";
    public static final String SOURCE_QUERY = "source.query";
    public static final String TARGET_BATCHSIZE = "target.batchSize";
    public static final String TARGET_TABLE = "target.table";
    public static final String DIE_ON_ERROR = "abortIfErrors";
    private boolean dieOnError = true;
    private boolean initialized = false;
    private List<String> excludeFieldList = new ArrayList<String>();
    private List<ColumnValue> fixedColumnValueList = new ArrayList<ColumnValue>();
    private boolean outputToTable = true;
    private boolean outputToFile = false;
    private File backupFile = null;
    private File backupFileTmp = null;
    private String backupFileCharSet = "UTF-8";
    private String fieldSeparator = ";";
    private String fieldEclosure = "\"";
    private String nullReplacement = "\\N";
    private BufferedWriter backupOutputWriter = null;
    private SimpleDateFormat sdfOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean ignoreReadFieldErrors = true;
    private Pattern patternForBackslash = null;
    private Pattern patternForQuota = null;
    private String replacementForBackslash = null;
    private String replacementForQuota = null;
    private SQLCodeGenerator sourceCodeGenerator = null;
    private SQLCodeGenerator targetCodeGenerator = null;
    private boolean exportBooleanAsNumber = true;
    private Map<String, String> dbJavaTypeMap = new HashMap<String, String>();
    private boolean debug = false;
    private boolean keepDataModels = false;
    private String modelKey = null;
    private Map<Integer, String> outputClassMap = new HashMap<Integer, String>();
    private String valueRangeColumn = null;
    private String timeRangeColumn = null;
    private int valueRangeColumnIndex = -1;
    private int timeRangeColumnIndex = -1;
    private java.util.Date timeRangeStart = null;
    private java.util.Date timeRangeEnd = null;
    private String valueRangeStart = null;
    private String valueRangeEnd = null;
    private boolean doCommit = true;
    private boolean strictFieldMatching = false;
    private boolean trimFields = false;
    private String checkConnectionStatement = "select 1";
    private boolean withinWriteAction = false;

    public void enableLog4J(boolean enable) {
        this.logger = enable ? Logger.getLogger(TableTransfer.class) : null;
    }

    public void addDbJavaTypeMapping(String dbType, String javaType) {
        if (dbType != null && !dbType.trim().isEmpty() && javaType != null && !javaType.trim().isEmpty()) {
            this.dbJavaTypeMap.put(dbType, javaType);
        }
    }

    public void addExcludeField(String name) {
        if (name != null && !name.trim().isEmpty()) {
            this.excludeFieldList.add(name.trim().toLowerCase());
        }
    }

    public void setColumnValue(String name, Object value) {
        if (name != null && !name.trim().isEmpty()) {
            ColumnValue cv = new ColumnValue(name.trim());
            cv.setValue(value);
            this.fixedColumnValueList.add(cv);
        }
    }

    public final int getCurrentCountInserts() {
        return Math.max(this.countInsertsInDB, this.countFileRows);
    }

    public final int getCurrentCountReads() {
        return this.countRead;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    public final boolean isRunning() {
        return this.runningDb || this.runningFile;
    }

    public final void execute() throws Exception {
        if (!this.initialized) {
            throw new Exception("Not initialized!");
        }
        this.countRead = 0;
        this.countInsertsAdded = 0;
        this.countInsertsInDB = 0;
        this.startWriting();
        this.startReading();
    }

    private final void startReading() {
        this.readerThread = new Thread(){

            @Override
            public void run() {
                TableTransfer.this.read();
            }
        };
        this.readerThread.setDaemon(false);
        this.readerThread.start();
    }

    private final void startWriting() throws Exception {
        if (this.outputToTable) {
            this.debug("Start writer thread...");
            this.runningDb = true;
            this.writerThread = new Thread(){

                @Override
                public void run() {
                    TableTransfer.this.writeTable();
                }
            };
            this.writerThread.setDaemon(false);
            this.writerThread.start();
        }
        if (this.outputToFile) {
            this.runningFile = true;
            if (this.isDebugEnabled()) {
                this.debug("Create backup file: " + this.backupFile.getAbsolutePath());
            }
            this.backupFileTmp = new File(this.backupFile.getAbsolutePath() + ".tmp");
            this.backupOutputWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.backupFileTmp), this.backupFileCharSet));
            if (this.isDebugEnabled()) {
                this.debug("Backup file established.");
            }
            this.writerBackupThread = new Thread(){

                @Override
                public void run() {
                    TableTransfer.this.writeFile();
                }
            };
            this.writerBackupThread.setDaemon(false);
            this.writerBackupThread.start();
        }
    }

    public final void stop() {
        if (this.readerThread != null) {
            this.readerThread.interrupt();
        }
        if (this.writerThread != null) {
            this.writerThread.interrupt();
        }
        if (this.writerBackupThread != null) {
            this.writerBackupThread.interrupt();
        }
    }

    public final void disconnect() {
        if (this.isDebugEnabled()) {
            this.debug("Close source connection...");
        }
        if (this.sourceConnection != null) {
            try {
                if (!this.sourceConnection.isClosed()) {
                    this.sourceConnection.close();
                }
            }
            catch (SQLException e) {
                this.error("disconnect from source failed: " + e.getMessage(), e);
            }
        }
        if (this.outputToTable) {
            if (this.isDebugEnabled()) {
                this.debug("Close target connection...");
            }
            if (this.targetConnection != null) {
                try {
                    if (!this.targetConnection.isClosed()) {
                        this.targetConnection.close();
                    }
                }
                catch (SQLException e) {
                    this.error("disconnect from target failed: " + e.getMessage(), e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void read() {
        if (this.isDebugEnabled()) {
            if (this.sourceTable != null) {
                this.debug("Start fetch data from source table: " + this.sourceTable.getAbsoluteName());
            } else {
                this.debug("Start fetch data from the given source query");
            }
        }
        try {
            if (this.isDebugEnabled()) {
                this.debug("Execute source query: " + this.sourceQuery);
                this.debug("Source select statement uses fetch size: " + this.sourceSelectStatement.getFetchSize());
            }
            ResultSet rs = this.sourceSelectStatement.executeQuery(this.sourceQuery);
            rs.setFetchSize(this.getFetchSize());
            if (this.isDebugEnabled()) {
                this.debug("Analyse result set...");
            }
            ResultSetMetaData rsMeta = rs.getMetaData();
            int countColumns = rsMeta.getColumnCount();
            this.listSourceFieldNames = new ArrayList<String>(countColumns);
            this.listSourceFieldTypeNames = new ArrayList<String>(countColumns);
            for (int i = 1; i <= countColumns; ++i) {
                String name = rsMeta.getColumnName(i).toLowerCase();
                if (name.equalsIgnoreCase(this.valueRangeColumn)) {
                    this.valueRangeColumnIndex = i;
                    if (this.isDebugEnabled()) {
                        this.debug("Collect min/max for value-range from column: " + name + " at index: " + this.valueRangeColumnIndex);
                    }
                } else if (name.equalsIgnoreCase(this.timeRangeColumn)) {
                    this.timeRangeColumnIndex = i;
                    if (this.isDebugEnabled()) {
                        this.debug("Collect min/max for time-range from column: " + name + " at index: " + this.timeRangeColumnIndex);
                    }
                }
                String type = rsMeta.getColumnTypeName(i).toUpperCase();
                this.listSourceFieldNames.add(name);
                this.listSourceFieldTypeNames.add(type);
                if (!this.isDebugEnabled()) continue;
                this.debug("Name: " + name + ",  Type: " + type);
            }
            for (ColumnValue cv : this.fixedColumnValueList) {
                this.listSourceFieldNames.add(cv.getColumnName().toLowerCase());
                if (!this.isDebugEnabled()) continue;
                this.debug("Name: " + cv.getColumnName());
            }
            if (this.isDebugEnabled()) {
                this.debug("Start fetching data...");
            }
            this.startTime = System.currentTimeMillis();
            while (rs.next()) {
                Object[] row = this.fillRow(rs, countColumns);
                if (this.valueRangeColumnIndex > 0) {
                    this.checkValueRange(row[this.valueRangeColumnIndex - 1]);
                }
                if (this.timeRangeColumnIndex > 0) {
                    this.checkTimeRange(row[this.timeRangeColumnIndex - 1]);
                }
                if (this.outputToTable) {
                    this.tableQueue.put(row);
                }
                if (this.outputToFile) {
                    if (this.writerBackupThread == null || !this.writerBackupThread.isAlive()) {
                        if (!this.outputToTable) throw new Exception("No output will work. The component is in backup only mode and the backup thread is not started or dead. Stop processing.");
                        this.warn("Backup process died. Switch off backup", null);
                        this.outputToFile = false;
                    } else {
                        this.fileQueue.put(row);
                    }
                }
                ++this.countRead;
                if (!Thread.currentThread().isInterrupted()) continue;
                break;
            }
            rs.close();
            if (this.isDebugEnabled()) {
                if (this.sourceTable != null) {
                    this.debug("Finished fetch data from source table " + this.sourceTable.getAbsoluteName() + " count read:" + this.countRead);
                } else {
                    this.debug("Finished fetch data from source query, count read:" + this.countRead);
                }
            }
        }
        catch (SQLException e) {
            String message = e.getMessage();
            SQLException en = e.getNextException();
            if (en != null) {
                message = "\nNext Exception:" + en.getMessage();
            }
            this.error("Read failed in line number " + this.countRead + " message:" + message, e);
            this.returnCode = 1;
        }
        catch (InterruptedException ie) {
            this.error("Read interrupted (send data sets)", ie);
            this.returnCode = 1;
        }
        catch (Exception ie) {
            this.error("Read failed: " + ie.getMessage(), ie);
            this.returnCode = 1;
        }
        catch (Error ie) {
            this.error("Read failed with Error: " + ie.getMessage(), ie);
            this.returnCode = 1;
        }
        finally {
            try {
                if (this.outputToTable) {
                    if (this.isDebugEnabled()) {
                        this.debug("Stopping write table thread...");
                    }
                    this.tableQueue.put(this.closeFlag);
                }
                if (this.outputToFile) {
                    if (this.isDebugEnabled()) {
                        this.debug("Stopping write file thread...");
                    }
                    this.fileQueue.put(this.closeFlag);
                }
            }
            catch (InterruptedException e) {
                this.error("read interrupted (send close flag)", e);
                this.returnCode = 1;
            }
            try {
                if (!this.sourceConnection.getAutoCommit()) {
                    this.sourceConnection.commit();
                }
                this.sourceSelectStatement.close();
            }
            catch (SQLException e) {}
        }
        if (!this.isDebugEnabled()) return;
        this.debug("End read.");
    }

    private final Object[] fillRow(ResultSet rs, int countDBColumns) throws SQLException {
        String dbType = null;
        String javaType = null;
        Object[] row = new Object[countDBColumns + this.fixedColumnValueList.size()];
        for (int columnIndex = 0; columnIndex < countDBColumns; ++columnIndex) {
            dbType = this.listSourceFieldTypeNames.get(columnIndex);
            javaType = dbType != null ? this.dbJavaTypeMap.get(dbType) : null;
            try {
                if (javaType == null) {
                    if (this.trimFields) {
                        Object v = rs.getObject(columnIndex + 1);
                        if (v instanceof String) {
                            row[columnIndex] = ((String)v).trim();
                            continue;
                        }
                        row[columnIndex] = v;
                        continue;
                    }
                    row[columnIndex] = rs.getObject(columnIndex + 1);
                    continue;
                }
                if ("date".equals(javaType)) {
                    row[columnIndex] = rs.getDate(columnIndex + 1);
                    continue;
                }
                if ("time".equals(javaType)) {
                    row[columnIndex] = rs.getTime(columnIndex + 1);
                    continue;
                }
                if ("timestamp".equals(javaType)) {
                    row[columnIndex] = rs.getTimestamp(columnIndex + 1);
                    continue;
                }
                if ("string".equals(javaType)) {
                    String s = rs.getString(columnIndex + 1);
                    if (this.trimFields && s != null) {
                        row[columnIndex] = s.trim();
                        continue;
                    }
                    row[columnIndex] = s;
                    continue;
                }
                if ("boolean".equals(javaType)) {
                    row[columnIndex] = rs.getBoolean(columnIndex + 1);
                    continue;
                }
                if ("short".equals(javaType)) {
                    row[columnIndex] = rs.getShort(columnIndex + 1);
                    continue;
                }
                if ("byte".equals(javaType)) {
                    row[columnIndex] = rs.getByte(columnIndex + 1);
                    continue;
                }
                if ("integer".equals(javaType)) {
                    row[columnIndex] = rs.getInt(columnIndex + 1);
                    continue;
                }
                if ("long".equals(javaType)) {
                    row[columnIndex] = rs.getLong(columnIndex + 1);
                    continue;
                }
                if ("bigdecimal".equals(javaType)) {
                    row[columnIndex] = rs.getBigDecimal(columnIndex + 1);
                    continue;
                }
                if ("biginteger".equals(javaType)) {
                    row[columnIndex] = new BigInteger(rs.getString(columnIndex + 1));
                    continue;
                }
                if ("double".equals(javaType)) {
                    row[columnIndex] = rs.getDouble(columnIndex + 1);
                    continue;
                }
                if ("float".equals(javaType)) {
                    row[columnIndex] = Float.valueOf(rs.getFloat(columnIndex + 1));
                    continue;
                }
                row[columnIndex] = rs.getObject(columnIndex + 1);
                continue;
            }
            catch (SQLException e) {
                if (!this.ignoreReadFieldErrors) {
                    throw e;
                }
                this.warn("Ignore database error while reading field with index: " + columnIndex + " in row: " + this.countRead + " message: " + e.getMessage(), e);
                row[columnIndex] = null;
            }
        }
        for (ColumnValue cv : this.fixedColumnValueList) {
            row[columnIndex++] = cv.getValue();
        }
        return row;
    }

    public void executeKeepAliveStatementForTargetConnection() throws Exception {
        if (!this.withinWriteAction && this.checkConnectionStatement != null && !this.checkConnectionStatement.trim().isEmpty()) {
            try {
                this.debug("Execute keep alive statement on target connection...");
                Statement checkStat = this.targetConnection.createStatement();
                checkStat.execute(this.checkConnectionStatement);
                checkStat.close();
            }
            catch (Exception e) {
                this.stop();
                throw new Exception("Check target connection with statement: " + this.checkConnectionStatement + " failed: " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void writeTable() {
        if (this.isDebugEnabled()) {
            this.debug("Start writing data into target table " + this.targetTable.getAbsoluteName());
        }
        int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "1"));
        int currentBatchCount = 0;
        try {
            SQLException ne;
            int[] counts;
            BatchUpdateException be;
            boolean autocommitTemp = false;
            try {
                if (this.targetConnection == null) {
                    throw new Exception("Write into table: " + this.targetTable.getAbsoluteName() + " failed because target connection is null");
                }
                if (this.targetConnection.isClosed()) {
                    throw new Exception("Write into table: " + this.targetTable.getAbsoluteName() + " failed because target connection is closed");
                }
                autocommitTemp = this.targetConnection.getAutoCommit();
            }
            catch (Exception e2) {
                this.warn("Failed to detect autocommit state: " + e2.getMessage(), e2);
            }
            boolean autocommit = autocommitTemp;
            boolean endFlagReceived = false;
            block21: while (!endFlagReceived) {
                try {
                    ArrayList<Object> queueObjects = new ArrayList<Object>(batchSize);
                    this.withinWriteAction = false;
                    Object one = this.tableQueue.poll(10000L, TimeUnit.MILLISECONDS);
                    if (one == null) continue;
                    queueObjects.add(one);
                    this.tableQueue.drainTo(queueObjects, batchSize);
                    for (Object e : queueObjects) {
                        if (e == this.closeFlag) {
                            if (this.isDebugEnabled()) {
                                this.debug("Write table thread: Stop flag received.");
                            }
                            endFlagReceived = true;
                            continue block21;
                        }
                        this.withinWriteAction = true;
                        this.prepareInsertStatement((Object[])e);
                        this.targetPSInsert.addBatch();
                        ++this.countInsertsAdded;
                        if (++currentBatchCount == batchSize) {
                            this.debug("Write execute insert batch ends with recno: " + this.countInsertsAdded);
                            this.targetPSInsert.executeBatch();
                            this.countInsertsInDB = this.countInsertsAdded;
                            if (this.doCommit && !autocommit) {
                                this.targetConnection.commit();
                            }
                            currentBatchCount = 0;
                        }
                        if (!Thread.currentThread().isInterrupted()) continue;
                        continue block21;
                    }
                }
                catch (InterruptedException e) {
                    this.error("Write interrupted in line " + this.countInsertsAdded, e);
                    this.returnCode = 1;
                    break;
                }
                catch (SQLException sqle) {
                    if (sqle instanceof BatchUpdateException) {
                        void var9_20;
                        be = (BatchUpdateException)sqle;
                        this.debug("Write execute insert batch ends with recno: " + this.countInsertsAdded);
                        counts = be.getUpdateCounts();
                        boolean bl = false;
                        for (int c : counts) {
                            var9_20 += c;
                        }
                        int n = this.countInsertsAdded - batchSize + var9_20;
                        this.error("Write failed in line number " + n + " message:" + sqle.getMessage(), sqle);
                    } else {
                        this.error("Write failed in line number " + this.countInsertsAdded + " message:" + sqle.getMessage(), sqle);
                    }
                    ne = sqle.getNextException();
                    if (ne != null) {
                        this.error("Next exception:" + ne.getMessage(), ne);
                    }
                    if (this.dieOnError) {
                        this.returnCode = 1;
                        try {
                            if (autocommit) break;
                            this.targetConnection.rollback();
                        }
                        catch (SQLException e) {
                            this.error("Write rollback failed: " + e.getMessage(), e);
                        }
                        break;
                    }
                    if (!this.doCommit) continue;
                    try {
                        if (autocommit) continue;
                        this.targetConnection.commit();
                    }
                    catch (SQLException e) {
                        this.error("Write commit failed: " + e.getMessage(), e);
                    }
                }
                catch (Exception e1) {
                    this.returnCode = 1;
                    this.error("Write failed:" + e1.getMessage(), e1);
                    break;
                }
            }
            if (currentBatchCount > 0 && this.returnCode == 0) {
                try {
                    if (this.isDebugEnabled()) {
                        this.debug("write execute final insert batch");
                    }
                    this.targetPSInsert.executeBatch();
                    this.countInsertsInDB += currentBatchCount;
                    if (this.doCommit && !autocommit) {
                        this.targetConnection.commit();
                    }
                    currentBatchCount = 0;
                }
                catch (SQLException sqle) {
                    this.returnCode = 1;
                    if (sqle instanceof BatchUpdateException) {
                        void var9_23;
                        be = (BatchUpdateException)sqle;
                        counts = be.getUpdateCounts();
                        boolean bl = false;
                        for (int c : counts) {
                            var9_23 += c;
                        }
                        int n = this.countInsertsAdded - batchSize + var9_23;
                        this.error("Write failed in line number " + n + " message:" + sqle.getMessage(), sqle);
                    } else {
                        this.error("Write failed in line number " + this.countInsertsAdded + " message:" + sqle.getMessage(), sqle);
                    }
                    ne = sqle.getNextException();
                    if (ne != null) {
                        this.error("Next exception:" + ne.getMessage(), ne);
                    }
                    try {
                        this.targetConnection.rollback();
                    }
                    catch (SQLException e) {
                        this.error("write rollback failed:" + e.getMessage(), e);
                    }
                }
            }
            if (this.returnCode == 1) {
                this.error("Read has been failed. Stop write in table.", null);
            }
        }
        finally {
            try {
                this.targetPSInsert.close();
            }
            catch (SQLException sQLException) {}
            this.runningDb = false;
            if (this.isDebugEnabled()) {
                this.debug("Finished write data into target table " + this.targetTable.getAbsoluteName() + ", count inserts:" + this.countInsertsInDB);
            }
        }
        if (this.isDebugEnabled()) {
            this.debug("Write table finished.");
        }
    }

    protected final Object getRowValue(String columnName, Object[] row) throws Exception {
        if (this.listSourceFieldNames == null) {
            throw new Exception("List of source fields is not initialized");
        }
        if (this.listSourceFieldNames.isEmpty()) {
            throw new Exception("List of source fields is empty");
        }
        int index = this.listSourceFieldNames.indexOf(columnName.toLowerCase());
        if (index != -1) {
            return row[index];
        }
        if (this.strictFieldMatching) {
            StringBuilder sb = new StringBuilder();
            sb.append("Following target columns does not have a matching column in the source query: ");
            boolean firstLoop = true;
            for (SQLPSParam p : this.targetInsertStatement.getParams()) {
                String targetColumnName = p.getName().toLowerCase();
                if (this.listSourceFieldNames.contains(targetColumnName)) continue;
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    sb.append(",");
                }
                sb.append(targetColumnName);
            }
            firstLoop = true;
            sb.append("\nList of source query columns: ");
            for (String sourceColumn : this.listSourceFieldNames) {
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    sb.append(",");
                }
                sb.append(sourceColumn);
            }
            throw new Exception("Transfer into table: " + this.targetTable.getAbsoluteName() + " in strict mode failed: " + sb.toString());
        }
        return null;
    }

    protected final void prepareInsertStatement(Object[] row) throws Exception {
        for (SQLPSParam p : this.targetInsertStatement.getParams()) {
            Object value = this.getRowValue(p.getName(), row);
            if (value != null) {
                String className = this.outputClassMap.get(p.getIndex());
                if (className == null) {
                    className = value.getClass().getSimpleName();
                    this.outputClassMap.put(p.getIndex(), className);
                    if (this.isDebugEnabled()) {
                        this.debug("Output class mapping: #" + p.getIndex() + " (" + p.getName() + ") use: " + className);
                    }
                }
                if ("BigDecimal".equals(className)) {
                    this.targetPSInsert.setBigDecimal(p.getIndex(), (BigDecimal)value);
                    continue;
                }
                if ("BigInteger".equals(className)) {
                    this.targetPSInsert.setLong(p.getIndex(), ((BigInteger)value).longValue());
                    continue;
                }
                if ("Double".equals(className)) {
                    this.targetPSInsert.setDouble(p.getIndex(), (Double)value);
                    continue;
                }
                if ("Float".equals(className)) {
                    this.targetPSInsert.setFloat(p.getIndex(), ((Float)value).floatValue());
                    continue;
                }
                if ("Long".equals(className)) {
                    this.targetPSInsert.setLong(p.getIndex(), (Long)value);
                    continue;
                }
                if ("Integer".equals(className)) {
                    this.targetPSInsert.setInt(p.getIndex(), (Integer)value);
                    continue;
                }
                if ("Short".equals(className)) {
                    this.targetPSInsert.setShort(p.getIndex(), (Short)value);
                    continue;
                }
                if ("String".equals(className)) {
                    this.targetPSInsert.setString(p.getIndex(), (String)value);
                    continue;
                }
                if ("Date".equals(className)) {
                    this.targetPSInsert.setDate(p.getIndex(), (Date)value);
                    continue;
                }
                if ("Timestamp".equals(className)) {
                    this.targetPSInsert.setTimestamp(p.getIndex(), (Timestamp)value);
                    continue;
                }
                if ("Time".equals(className)) {
                    this.targetPSInsert.setTime(p.getIndex(), (Time)value);
                    continue;
                }
                if ("Boolean".equals(className)) {
                    this.targetPSInsert.setBoolean(p.getIndex(), (Boolean)value);
                    continue;
                }
                if ("String".equals(className)) {
                    this.targetPSInsert.setString(p.getIndex(), (String)value);
                    continue;
                }
                this.targetPSInsert.setObject(p.getIndex(), value);
                continue;
            }
            this.targetPSInsert.setNull(p.getIndex(), this.targetTable.getField(p.getName()).getType());
        }
    }

    public final void executeSQLOnTarget(String sqlStatement) throws Exception {
        this.info("On target: Execute statement: " + sqlStatement);
        if (this.targetConnection == null || this.targetConnection.isClosed()) {
            this.error("Execute statement on target failed because connection is null or closed", null);
            throw new Exception("Write into table: " + this.targetTable.getAbsoluteName() + " failed. Execute statement on target failed because connection is null or closed");
        }
        try {
            Statement stat = this.targetConnection.createStatement();
            stat.execute(sqlStatement);
            stat.close();
            this.info("On target: " + this.targetTable.getAbsoluteName() + ": Execute statement finished successfully.");
        }
        catch (SQLException sqle) {
            String message = "On target: " + this.targetTable.getAbsoluteName() + ": Execute statement failed sql=" + sqlStatement + " message: " + sqle.getMessage();
            throw new Exception(message, sqle);
        }
    }

    public void commitSource() throws SQLException {
        this.sourceConnection.commit();
    }

    public void commitTarget() throws SQLException {
        if (this.targetConnection == null || this.targetConnection.isClosed()) {
            throw new IllegalStateException("writeTable failed because target connection is null or closed");
        }
        this.targetConnection.commit();
    }

    public final void setup() throws Exception {
        this.createSourceSelectStatement();
        if (this.outputToTable) {
            this.createTargetInsertStatement();
        }
        int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "100"));
        int fetchSize = Integer.parseInt(this.properties.getProperty(SOURCE_FETCHSIZE, "100"));
        int queueSize = Math.max(batchSize, fetchSize);
        if (this.outputToTable) {
            this.tableQueue = new ArrayBlockingQueue<Object>(queueSize);
        }
        if (this.outputToFile) {
            this.fileQueue = new ArrayBlockingQueue<Object>(queueSize);
        }
        this.dieOnError = Boolean.parseBoolean(this.properties.getProperty(DIE_ON_ERROR, "true"));
        this.patternForBackslash = Pattern.compile("\\", 16);
        this.patternForQuota = Pattern.compile("\"", 16);
        this.replacementForBackslash = Matcher.quoteReplacement("\\\\");
        this.replacementForQuota = this.replacementForQuota != null ? Matcher.quoteReplacement(this.replacementForQuota) : Matcher.quoteReplacement("\\\"");
        this.initialized = true;
    }

    protected final SQLTable getSourceSQLTable() throws Exception {
        String tableAndSchemaName = this.properties.getProperty(SOURCE_TABLE);
        if (this.sourceTable == null || !this.sourceTable.getAbsoluteName().equalsIgnoreCase(tableAndSchemaName)) {
            SQLSchema schema;
            String schemaName = this.getSchemaName(tableAndSchemaName);
            if (schemaName == null) {
                schemaName = this.sourceConnection.getSchema();
            }
            if (schemaName == null) {
                schemaName = this.getSourceDatabase();
            }
            if ((schema = this.sourceModel.getSchema(schemaName)) == null) {
                throw new Exception("getSourceTable failed: schema " + schemaName + " not available");
            }
            String tableName = this.getTableName(tableAndSchemaName);
            this.sourceTable = schema.getTable(tableName);
            if (this.sourceTable == null) {
                throw new Exception("getSourceTable failed: table " + schemaName + "." + tableName + " not available");
            }
            if (!this.sourceTable.isFieldsLoaded()) {
                this.sourceTable.loadColumns(true);
            }
            for (String exclFieldName : this.excludeFieldList) {
                SQLField field = this.sourceTable.getField(exclFieldName);
                if (field == null) continue;
                this.sourceTable.removeSQLField(field);
            }
        }
        return this.sourceTable;
    }

    protected String getSourceDatabase() throws SQLException {
        String cat = this.sourceConnection.getCatalog();
        if (cat == null || cat.trim().isEmpty()) {
            cat = "public";
        }
        return cat;
    }

    protected String getTargetDatabase() throws SQLException {
        String cat = this.targetConnection.getCatalog();
        if (cat == null || cat.trim().isEmpty()) {
            cat = "public";
        }
        return cat;
    }

    protected final SQLTable getTargetSQLTable() throws Exception {
        String tableAndSchemaName = this.properties.getProperty(TARGET_TABLE);
        if (this.targetTable == null || !this.targetTable.getAbsoluteName().equalsIgnoreCase(tableAndSchemaName)) {
            SQLSchema schema;
            String schemaName = this.getSchemaName(tableAndSchemaName);
            if (schemaName == null) {
                schemaName = this.targetConnection.getSchema();
            }
            if (schemaName == null) {
                schemaName = this.getTargetDatabase();
            }
            if ((schema = this.targetModel.getSchema(schemaName)) == null) {
                throw new Exception("Get information about target table: " + tableAndSchemaName + " failed: schema " + schemaName + " not available");
            }
            String tableName = this.getTableName(tableAndSchemaName);
            if (tableName.startsWith("\"")) {
                tableName = tableName.substring(1, tableName.length() - 1);
            }
            this.targetTable = schema.getTable(tableName);
            if (this.targetTable == null) {
                throw new Exception("Get information about target table: " + schemaName + "." + tableName + " not available");
            }
            for (String exclFieldName : this.excludeFieldList) {
                SQLField field;
                boolean exclude = true;
                for (ColumnValue cv : this.fixedColumnValueList) {
                    if (!cv.getColumnName().equalsIgnoreCase(exclFieldName)) continue;
                    exclude = false;
                    break;
                }
                if (!exclude || (field = this.targetTable.getField(exclFieldName)) == null) continue;
                this.targetTable.removeSQLField(field);
            }
        }
        return this.targetTable;
    }

    protected Statement createSourceSelectStatement() throws Exception {
        this.sourceQuery = this.properties.getProperty(SOURCE_QUERY);
        if (this.sourceQuery == null) {
            SQLTable table = this.getSourceSQLTable();
            if (!table.isFieldsLoaded()) {
                table.loadColumns(true);
            }
            this.sourceQuery = this.getSourceCodeGenerator().buildSelectStatement(table, true) + this.buildSourceWhereSQL();
            this.properties.put(SOURCE_QUERY, this.sourceQuery);
        }
        if (this.isDebugEnabled()) {
            this.debug("createSourceSelectStatement SQL:" + this.sourceQuery);
        }
        this.sourceSelectStatement = this.sourceConnection.createStatement(1003, 1007);
        int fetchSize = this.getFetchSize();
        if (fetchSize > 0) {
            this.debug("set source fetch size: " + fetchSize);
            this.sourceSelectStatement.setFetchSize(fetchSize);
        }
        if (DBHelper.isMySQLConnection(this.sourceConnection)) {
            DBHelper util = (DBHelper)Class.forName("de.jlo.talendcomp.tabletransfer.MySQLHelper").newInstance();
            util.setupSelectStatement(this.sourceSelectStatement);
        }
        return this.sourceSelectStatement;
    }

    protected int getFetchSize() {
        int fetchSize = 100;
        try {
            fetchSize = Integer.parseInt(this.properties.getProperty(SOURCE_FETCHSIZE, "1000"));
        }
        catch (Exception e) {
            this.warn("getFetchSize failed: " + e.getMessage(), e);
        }
        return fetchSize;
    }

    protected PreparedStatement createTargetInsertStatement() throws Exception {
        SQLTable table = this.getTargetSQLTable();
        if (!table.isFieldsLoaded()) {
            table.loadColumns(true);
        }
        this.targetInsertStatement = this.getTargetCodeGenerator().buildPSInsertSQLStatement(table, true);
        if (this.isDebugEnabled()) {
            this.debug("createTargetInsertStatement SQL:" + this.targetInsertStatement.getSQL());
        }
        this.targetPSInsert = this.targetConnection.prepareStatement(this.targetInsertStatement.getSQL());
        return this.targetPSInsert;
    }

    protected final String buildSourceWhereSQL() {
        String where = this.properties.getProperty(SOURCE_WHERE);
        if (where != null && !where.trim().isEmpty()) {
            if ((where = this.replacePlaceholders(where)).startsWith("where")) {
                return " " + where;
            }
            return " where " + where;
        }
        return "";
    }

    protected final String replacePlaceholders(String stringWithPlaceholders) {
        boolean ready = false;
        ArrayList<String> listPlaceHolders = new ArrayList<String>();
        int p0 = -1;
        int p1 = -1;
        while (!ready) {
            p0 = stringWithPlaceholders.indexOf(123, p1 + 1);
            p1 = stringWithPlaceholders.indexOf(125, p0 + 1);
            if (p0 != -1 && p1 != -1) {
                String key = stringWithPlaceholders.substring(p0 + 1, p1);
                listPlaceHolders.add(key);
                continue;
            }
            ready = true;
        }
        StringReplacer sr = new StringReplacer(stringWithPlaceholders);
        for (String key : listPlaceHolders) {
            String value = this.properties.getProperty(key);
            if (value == null) {
                this.warn("replacePlaceholders for string " + stringWithPlaceholders + " failed in key:" + key + " reason: missing value", null);
                this.returnCode = 5;
                value = "";
            }
            sr.replace("{" + key + "}", value.trim());
        }
        return sr.getResultText();
    }

    protected final String getSchemaName(String schemaAndTable) {
        int pos = schemaAndTable.indexOf(46);
        if (pos > 0) {
            return schemaAndTable.substring(0, pos);
        }
        return null;
    }

    protected final String getTableName(String schemaAndTable) {
        int pos = schemaAndTable.indexOf(46);
        if (pos > 0) {
            return schemaAndTable.substring(pos + 1, schemaAndTable.length());
        }
        return schemaAndTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setupDataModels() throws Exception {
        Map<String, SQLDataModel> map;
        if (this.keepDataModels) {
            map = sqlModelCache;
            synchronized (map) {
                this.sourceModel = sqlModelCache.get("source_" + this.modelKey);
                if (this.sourceModel == null) {
                    this.sourceModel = new SQLDataModel(this.sourceConnection);
                    this.sourceModel.loadCatalogs();
                    sqlModelCache.put("source_" + this.modelKey, this.sourceModel);
                } else {
                    this.sourceModel.setConnection(this.sourceConnection);
                }
            }
        } else {
            this.sourceModel = new SQLDataModel(this.sourceConnection);
            this.sourceModel.loadCatalogs();
        }
        if (this.sourceConnection != null && !this.sourceConnection.getAutoCommit()) {
            this.sourceConnection.commit();
        }
        if (this.outputToTable) {
            if (this.keepDataModels) {
                map = sqlModelCache;
                synchronized (map) {
                    this.targetModel = sqlModelCache.get("target_" + this.modelKey);
                    if (this.targetModel == null) {
                        this.targetModel = new SQLDataModel(this.targetConnection);
                        this.targetModel.loadCatalogs();
                        sqlModelCache.put("target_" + this.modelKey, this.targetModel);
                    } else {
                        this.targetModel.setConnection(this.targetConnection);
                    }
                }
            } else {
                this.targetModel = new SQLDataModel(this.targetConnection);
                this.targetModel.loadCatalogs();
            }
            if (!this.targetConnection.getAutoCommit()) {
                this.targetConnection.commit();
            }
        }
    }

    public void loadProperties(String filePath) {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            this.properties.load(fis);
            fis.close();
        }
        catch (IOException e) {
            this.error("LoadProperties from " + filePath + " failed: " + e.getMessage(), e);
            this.returnCode = 1;
        }
    }

    public String getSourceFetchSize() {
        return this.properties.getProperty(SOURCE_FETCHSIZE);
    }

    public void setSourceFetchSize(String fetchSize) {
        this.properties.setProperty(SOURCE_FETCHSIZE, fetchSize);
    }

    public void setSourceFetchSize(Integer fetchSize) {
        if (fetchSize != null) {
            this.setSourceFetchSize(String.valueOf(fetchSize));
        }
    }

    public String getTargetInsertStatement() {
        return this.targetInsertStatement.getSQL();
    }

    public String getSourceQuery() {
        return this.properties.getProperty(SOURCE_QUERY);
    }

    public void setSourceQuery(String sourceQuery) {
        if (sourceQuery != null) {
            sourceQuery = sourceQuery.trim();
        }
        if (sourceQuery.endsWith(";")) {
            sourceQuery = sourceQuery.substring(0, sourceQuery.length() - 1);
        }
        this.properties.setProperty(SOURCE_QUERY, sourceQuery);
    }

    public String getSourceTable() throws SQLException {
        return this.getSourceCodeGenerator().getEncapsulatedName(this.properties.getProperty(SOURCE_TABLE));
    }

    public void setSourceTable(String tableAndSchema) {
        if (tableAndSchema == null || tableAndSchema.trim().isEmpty()) {
            throw new IllegalArgumentException("Source schema.table cannot be null or empty! (Got: " + tableAndSchema + ")");
        }
        if (tableAndSchema.endsWith(".null") || tableAndSchema.endsWith(".")) {
            throw new IllegalArgumentException("Source table cannot be null or empty! (Got: " + tableAndSchema + ")");
        }
        if (tableAndSchema.startsWith("null.") || tableAndSchema.startsWith(".")) {
            throw new IllegalArgumentException("Source schema cannot be null or empty! (Got: " + tableAndSchema + ")");
        }
        this.properties.setProperty(SOURCE_TABLE, tableAndSchema);
        this.properties.remove(SOURCE_QUERY);
    }

    public String getSourceWhereClause() {
        return this.properties.getProperty(SOURCE_WHERE);
    }

    public void setSourceWhereClause(String whereClause) {
        this.properties.setProperty(SOURCE_WHERE, whereClause);
    }

    public String getTargetBatchSize() {
        return this.properties.getProperty(TARGET_BATCHSIZE);
    }

    public void setTargetBatchSize(String batchSize) {
        this.properties.setProperty(TARGET_BATCHSIZE, batchSize);
    }

    public void setTargetBatchSize(Integer batchSize) {
        if (batchSize != null) {
            this.setTargetBatchSize(String.valueOf(batchSize));
        }
    }

    public String getTargetTable() throws SQLException {
        return this.getTargetCodeGenerator().getEncapsulatedName(this.properties.getProperty(TARGET_TABLE));
    }

    public void setTargetTable(String tableAndSchema) {
        if (tableAndSchema == null || tableAndSchema.trim().isEmpty()) {
            throw new IllegalArgumentException("Target schema.table cannot be null or empty! (Got: " + tableAndSchema + ")");
        }
        if (tableAndSchema.endsWith(".null") || tableAndSchema.endsWith(".")) {
            throw new IllegalArgumentException("Target table cannot be null or empty! (Got: " + tableAndSchema + ")");
        }
        if (tableAndSchema.startsWith("null.") || tableAndSchema.startsWith(".")) {
            throw new IllegalArgumentException("Target schema cannot be null or empty! (Got: " + tableAndSchema + ")");
        }
        this.properties.setProperty(TARGET_TABLE, tableAndSchema);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public void setProperty(String key, String value) {
        this.properties.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public boolean isSuccessful() {
        return this.returnCode == 0;
    }

    public final void warn(String message, Exception t) {
        if (this.logger != null) {
            if (t != null) {
                this.logger.warn((Object)message, (Throwable)t);
            } else {
                this.logger.warn((Object)message);
            }
        } else {
            System.err.println("WARN: " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
        if (message != null) {
            this.errorMessage = message;
        }
        if (t != null) {
            this.errorException = t;
        }
    }

    public final boolean isDebugEnabled() {
        if (this.logger != null) {
            return this.logger.isDebugEnabled();
        }
        return this.debug;
    }

    public final void debug(String message) {
        if (this.logger != null && this.logger.isDebugEnabled()) {
            this.logger.debug((Object)message);
        } else if (this.debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    public final void info(String message) {
        if (this.logger != null) {
            this.logger.info((Object)message);
        } else {
            System.out.println("INFO: " + message);
        }
    }

    public final void error(String message, Throwable t) {
        if (this.logger != null) {
            if (t != null) {
                this.logger.error((Object)message, t);
            } else {
                this.logger.error((Object)message);
            }
        } else {
            System.err.println("ERROR: " + message);
            if (t != null) {
                t.printStackTrace();
            }
        }
        if (message != null) {
            this.errorMessage = message;
        }
        if (t instanceof Exception) {
            this.errorException = (Exception)t;
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Exception getErrorException() {
        return this.errorException;
    }

    public Connection getSourceConnection() {
        return this.sourceConnection;
    }

    public Statement getSourceStatement() {
        return this.sourceSelectStatement;
    }

    private boolean isClosed(Connection connection) {
        try {
            return connection.isClosed();
        }
        catch (SQLException e) {
            this.logger.error((Object)("Check if connection is closed failed:" + e.getMessage()), (Throwable)e);
            return true;
        }
    }

    public void setSourceConnection(Connection sourceConnection) {
        if (sourceConnection == null) {
            throw new IllegalArgumentException("Source connection cannot be null!");
        }
        if (sourceConnection == this.targetConnection) {
            throw new IllegalArgumentException("Source connection cannot be the same as used for the target! Establish for source and target different connection instances!");
        }
        if (this.isClosed(sourceConnection)) {
            throw new IllegalArgumentException("Source connection is already closed!");
        }
        this.sourceConnection = sourceConnection;
    }

    public Connection getTargetConnection() {
        return this.targetConnection;
    }

    public void setTargetConnection(Connection targetConnection) throws Exception {
        if (targetConnection == null) {
            throw new IllegalArgumentException("Target connection cannot be null!");
        }
        if (this.sourceConnection == targetConnection) {
            throw new IllegalArgumentException("Target connection cannot be the same as used for the source! Establish for source and target different connection instances!");
        }
        if (targetConnection.isReadOnly()) {
            throw new Exception("Target connection cannot be in read only mode!");
        }
        if (this.isClosed(targetConnection)) {
            throw new IllegalArgumentException("Target connection is already closed!");
        }
        this.targetConnection = targetConnection;
    }

    public static final double roundScale2(Double number) {
        if (number != null) {
            return (double)Math.round(number * 100.0) / 100.0;
        }
        return 0.0;
    }

    public String getBackupFilePath() {
        if (this.backupFile != null) {
            return this.backupFile.getAbsolutePath();
        }
        return null;
    }

    public String setBackupFilePath(String backupFilePath) throws Exception {
        if (backupFilePath != null && !backupFilePath.trim().isEmpty()) {
            File test = new File(backupFilePath);
            if (test.isDirectory()) {
                if (!test.exists()) {
                    test.mkdirs();
                    if (!test.exists()) {
                        throw new Exception("Backup dir: " + test.getAbsolutePath() + " could not be created!");
                    }
                }
                this.backupFile = test = new File(test, this.getTargetTable() + ".csv");
                this.outputToFile = true;
                return this.backupFile.getAbsolutePath();
            }
            File dir = test.getParentFile();
            if (dir == null) {
                throw new Exception("Backup file has to be an absolute path (directory or file)!");
            }
            if (!dir.exists()) {
                dir.mkdirs();
                if (!dir.exists()) {
                    throw new Exception("Backup dir: " + dir.getAbsolutePath() + " could not be created!");
                }
            }
            this.backupFile = test;
            this.outputToFile = true;
            return this.backupFile.getAbsolutePath();
        }
        return null;
    }

    private String convertToString(Object value) {
        if (value instanceof String) {
            String sValue = (String)value;
            if (sValue.isEmpty()) {
                return "";
            }
            Matcher m1 = this.patternForBackslash.matcher(sValue);
            sValue = m1.replaceAll(this.replacementForBackslash);
            Matcher m2 = this.patternForQuota.matcher(sValue);
            sValue = m2.replaceAll(this.replacementForQuota);
            return sValue;
        }
        if (value instanceof java.util.Date) {
            return this.sdfOut.format((java.util.Date)value);
        }
        if (value instanceof Boolean) {
            if (this.exportBooleanAsNumber) {
                return (Boolean)value != false ? "1" : "0";
            }
            return Boolean.toString((Boolean)value);
        }
        if (value instanceof Short) {
            return Short.toString((Short)value);
        }
        if (value instanceof Integer) {
            return Integer.toString((Integer)value);
        }
        if (value instanceof Long) {
            return Long.toString((Long)value);
        }
        if (value instanceof Double) {
            return Double.toString((Double)value);
        }
        if (value instanceof Float) {
            return Float.toString(((Float)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value != null) {
            return value.toString();
        }
        return this.nullReplacement;
    }

    private void writeRowInFile(Object[] row) throws Exception {
        if (row != null) {
            boolean firstLoop = true;
            for (Object value : row) {
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    this.backupOutputWriter.write(this.fieldSeparator);
                }
                if (value != null) {
                    this.backupOutputWriter.write(this.fieldEclosure);
                    this.backupOutputWriter.write(this.convertToString(value));
                    this.backupOutputWriter.write(this.fieldEclosure);
                    continue;
                }
                this.backupOutputWriter.write(this.nullReplacement);
            }
            this.backupOutputWriter.write("\n");
            ++this.countFileRows;
        }
    }

    private void writeFile() {
        try {
            File errorFile;
            this.countFileRows = 0;
            this.debug("Start writing data in file: " + this.backupFile.getAbsolutePath());
            int batchSize = Integer.parseInt(this.properties.getProperty(TARGET_BATCHSIZE, "1"));
            boolean endFlagReceived = false;
            block8: while (!endFlagReceived) {
                try {
                    ArrayList<Object> queueObjects = new ArrayList<Object>(batchSize);
                    Object one = this.fileQueue.poll(10000L, TimeUnit.MILLISECONDS);
                    if (one == null) continue;
                    queueObjects.add(one);
                    this.fileQueue.drainTo(queueObjects, batchSize);
                    for (Object e : queueObjects) {
                        if (e == this.closeFlag) {
                            this.debug("Write file thread: Stop flag received.");
                            endFlagReceived = true;
                            continue block8;
                        }
                        this.writeRowInFile((Object[])e);
                        if (!Thread.currentThread().isInterrupted()) continue;
                        continue block8;
                    }
                }
                catch (Exception e) {
                    this.error("write file failed in line number " + this.countFileRows + " message:" + e.getMessage(), e);
                    if (!this.dieOnError) continue;
                    this.returnCode = 1;
                    break;
                }
            }
            try {
                this.backupOutputWriter.flush();
                this.backupOutputWriter.close();
            }
            catch (Exception e) {
                this.error("Close file failed: " + e.getMessage(), e);
            }
            this.runningFile = false;
            if (this.returnCode == 0) {
                this.debug("Finished write data into file " + this.backupFile.getAbsolutePath() + ", count rows:" + this.countFileRows);
                this.debug("Rename tmp file: " + this.backupFileTmp.getAbsolutePath() + " to target file: " + this.backupFile.getAbsolutePath());
                this.backupFileTmp.renameTo(this.backupFile);
            } else if (this.returnCode == 1) {
                this.debug("Finished write data into file " + this.backupFile.getAbsolutePath() + ", count rows:" + this.countFileRows);
                this.warn("Read has been failed. Rename file as error file.", null);
                errorFile = new File(this.backupFile.getAbsolutePath() + ".error");
                this.backupFileTmp.renameTo(errorFile);
            } else if (this.returnCode == 1) {
                this.debug("Finished write data into file " + this.backupFile.getAbsolutePath() + ", count rows:" + this.countFileRows);
                this.warn("Write to file has been failed. Rename file as error file.", null);
                errorFile = new File(this.backupFile.getAbsolutePath() + ".error");
                this.backupFileTmp.renameTo(errorFile);
            }
        }
        catch (Exception e) {
            try {
                this.backupOutputWriter.flush();
                this.backupOutputWriter.close();
            }
            catch (Exception e1) {
                this.error("Close file failed: " + e.getMessage(), e);
            }
            this.runningFile = false;
            this.error("Write data into file " + this.backupFile.getAbsolutePath() + " count rows:" + this.countFileRows + " failed: " + e.getMessage(), e);
        }
        this.debug("Writing file has been finished.");
    }

    public boolean isOutputToTable() {
        return this.outputToTable;
    }

    public void setOutputToTable(boolean outputToTable) {
        this.outputToTable = outputToTable;
    }

    public void setDebug(boolean debug) {
        if (this.logger != null) {
            if (debug) {
                Logger.getRootLogger().setLevel(Level.DEBUG);
            } else {
                Logger.getRootLogger().setLevel(Level.INFO);
            }
        }
        this.debug = debug;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean isExportBooleanAsNumber() {
        return this.exportBooleanAsNumber;
    }

    public void setExportBooleanAsNumber(Boolean exportBooleanAsNumber) {
        if (exportBooleanAsNumber != null) {
            this.exportBooleanAsNumber = exportBooleanAsNumber;
        }
    }

    public boolean isKeepDataModels() {
        return this.keepDataModels;
    }

    public void setKeepDataModels(boolean keepDataModels, String key) {
        this.keepDataModels = keepDataModels;
        if (keepDataModels && (key == null || key.trim().isEmpty())) {
            throw new IllegalArgumentException("If the model should kept statically the key cannot be null or empty!");
        }
        this.modelKey = key;
    }

    public String getValueRangeColumn() {
        return this.valueRangeColumn;
    }

    public void setValueRangeColumn(String valueRangeColumn) {
        if (valueRangeColumn != null && !valueRangeColumn.trim().isEmpty()) {
            this.valueRangeColumn = valueRangeColumn;
        }
    }

    public String getTimeRangeColumn() {
        return this.timeRangeColumn;
    }

    public void setTimeRangeColumn(String timeRangeColumn) {
        if (timeRangeColumn != null && !timeRangeColumn.trim().isEmpty()) {
            this.timeRangeColumn = timeRangeColumn;
        }
    }

    public java.util.Date getTimeRangeStart() {
        return this.timeRangeStart;
    }

    public java.util.Date getTimeRangeEnd() {
        return this.timeRangeEnd;
    }

    public String getValueRangeStart() {
        return this.valueRangeStart;
    }

    public String getValueRangeEnd() {
        return this.valueRangeEnd;
    }

    private void checkTimeRange(Object value) {
        if (value instanceof Long) {
            this.checkTimeRange((Long)value);
        } else if (value instanceof java.util.Date) {
            this.checkTimeRange((java.util.Date)value);
        }
    }

    private void checkTimeRange(Long timeRangeLong) {
        if (timeRangeLong != null) {
            java.util.Date timeRangeDate = new java.util.Date(timeRangeLong);
            if (this.timeRangeStart == null || this.timeRangeStart.after(timeRangeDate)) {
                this.timeRangeStart = timeRangeDate;
            }
            if (this.timeRangeEnd == null || this.timeRangeEnd.before(timeRangeDate)) {
                this.timeRangeEnd = timeRangeDate;
            }
        }
    }

    private void checkTimeRange(java.util.Date timeRangeDate) {
        if (timeRangeDate != null) {
            if (this.timeRangeStart == null || this.timeRangeStart.after(timeRangeDate)) {
                this.timeRangeStart = timeRangeDate;
            }
            if (this.timeRangeEnd == null || this.timeRangeEnd.before(timeRangeDate)) {
                this.timeRangeEnd = timeRangeDate;
            }
        }
    }

    private void checkValueRange(Object value) {
        if (value instanceof String) {
            this.checkValueRange((String)value);
        } else if (value instanceof Integer) {
            this.checkValueRange((Integer)value);
        } else if (value instanceof Long) {
            this.checkValueRange((Long)value);
        } else if (value instanceof BigDecimal) {
            this.checkValueRange((BigDecimal)value);
        } else if (value instanceof BigInteger) {
            this.checkValueRange((BigInteger)value);
        } else if (value instanceof Short) {
            this.checkValueRange((Short)value);
        } else if (value instanceof Byte) {
            this.checkValueRange((Byte)value);
        } else if (value instanceof Character) {
            this.checkValueRange((Character)value);
        } else if (value instanceof Double) {
            this.checkValueRange((Double)value);
        } else if (value instanceof Float) {
            this.checkValueRange((Float)value);
        }
    }

    private void checkValueRange(String newValue) {
        if (newValue != null && !newValue.trim().isEmpty()) {
            if (this.valueRangeStart == null) {
                this.valueRangeStart = newValue.trim();
            } else if (this.valueRangeStart.compareTo(newValue) > 0) {
                this.valueRangeStart = newValue;
            }
            if (this.valueRangeEnd == null) {
                this.valueRangeEnd = newValue.trim();
            } else if (this.valueRangeEnd.compareTo(newValue) < 0) {
                this.valueRangeEnd = newValue;
            }
        }
    }

    private void checkValueRange(Long newValue) {
        if (newValue != null) {
            long cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = Long.valueOf(this.valueRangeStart);
                if (cv > newValue) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = Long.valueOf(this.valueRangeEnd);
                if (cv < newValue) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(Character newValue) {
        if (newValue != null) {
            char cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = this.valueRangeStart.charAt(0);
                if (cv > newValue.charValue()) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = this.valueRangeEnd.charAt(0);
                if (cv < newValue.charValue()) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(Double newValue) {
        if (newValue != null) {
            double cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = Double.valueOf(this.valueRangeStart);
                if (cv > newValue) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = Double.valueOf(this.valueRangeEnd);
                if (cv < newValue) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(Float newValue) {
        if (newValue != null) {
            float cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = Float.valueOf(this.valueRangeStart).floatValue();
                if (cv > newValue.floatValue()) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = Float.valueOf(this.valueRangeEnd).floatValue();
                if (cv < newValue.floatValue()) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(Integer newValue) {
        if (newValue != null) {
            int cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = Integer.valueOf(this.valueRangeStart);
                if (cv > newValue) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = Integer.valueOf(this.valueRangeEnd);
                if (cv < newValue) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(Short newValue) {
        if (newValue != null) {
            short cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = Short.valueOf(this.valueRangeStart);
                if (cv > newValue) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = Short.valueOf(this.valueRangeEnd);
                if (cv < newValue) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(Byte newValue) {
        if (newValue != null) {
            byte cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = Byte.valueOf(this.valueRangeStart);
                if (cv > newValue) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = Byte.valueOf(this.valueRangeEnd);
                if (cv < newValue) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    private void checkValueRange(BigDecimal newValue) {
        if (newValue != null) {
            BigDecimal cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = new BigDecimal(this.valueRangeStart);
                if (cv.compareTo(newValue) > 0) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = new BigDecimal(this.valueRangeEnd);
                if (cv.compareTo(newValue) < 0) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    public void checkValueRange(BigInteger newValue) {
        if (newValue != null) {
            BigInteger cv;
            if (this.valueRangeStart == null || this.valueRangeStart.isEmpty()) {
                this.valueRangeStart = String.valueOf(newValue);
            } else {
                cv = new BigInteger(this.valueRangeStart);
                if (cv.compareTo(newValue) > 0) {
                    this.valueRangeStart = String.valueOf(newValue);
                }
            }
            if (this.valueRangeEnd == null || this.valueRangeEnd.isEmpty()) {
                this.valueRangeEnd = String.valueOf(newValue);
            } else {
                cv = new BigInteger(this.valueRangeEnd);
                if (cv.compareTo(newValue) < 0) {
                    this.valueRangeEnd = String.valueOf(newValue);
                }
            }
        }
    }

    public boolean isDoCommit() {
        return this.doCommit;
    }

    public void setDoCommit(Boolean doCommit) {
        if (doCommit != null) {
            this.doCommit = doCommit;
        }
    }

    protected void setupKeywords(Connection conn, SQLCodeGenerator codeGen) throws SQLException {
        String stringKeyWords;
        String sqlKeyWords;
        if (conn == null) {
            throw new IllegalArgumentException("Connection cannot be null");
        }
        DatabaseMetaData dbmd = conn.getMetaData();
        codeGen.setEnclosureChar(dbmd.getIdentifierQuoteString());
        String numKeyWords = dbmd.getNumericFunctions();
        if (numKeyWords != null && !numKeyWords.trim().isEmpty()) {
            String[] words;
            for (String w : words = numKeyWords.split(",")) {
                codeGen.addKeyword(w.trim());
            }
        }
        if ((sqlKeyWords = dbmd.getSQLKeywords()) != null && !sqlKeyWords.trim().isEmpty()) {
            String[] words;
            for (String w : words = sqlKeyWords.split(",")) {
                codeGen.addKeyword(w.trim());
            }
        }
        if ((stringKeyWords = dbmd.getStringFunctions()) != null && !stringKeyWords.trim().isEmpty()) {
            String[] words;
            for (String w : words = sqlKeyWords.split(",")) {
                codeGen.addKeyword(w.trim());
            }
        }
    }

    public SQLCodeGenerator getSourceCodeGenerator() throws SQLException {
        if (this.sourceCodeGenerator == null) {
            this.sourceCodeGenerator = new SQLCodeGenerator();
            this.setupKeywords(this.sourceConnection, this.sourceCodeGenerator);
        }
        return this.sourceCodeGenerator;
    }

    public SQLCodeGenerator getTargetCodeGenerator() throws SQLException {
        if (this.targetCodeGenerator == null) {
            this.targetCodeGenerator = new SQLCodeGenerator();
            this.setupKeywords(this.targetConnection, this.targetCodeGenerator);
        }
        return this.targetCodeGenerator;
    }

    public String getNullReplacement() {
        return this.nullReplacement;
    }

    public void setNullReplacement(String nullReplacement) {
        if (nullReplacement == null) {
            nullReplacement = "";
        }
        this.nullReplacement = nullReplacement;
    }

    public String getReplacementForQuota() {
        return this.replacementForQuota;
    }

    public void setReplacementForQuota(String replacementForQuota) {
        this.replacementForQuota = replacementForQuota;
    }

    public String getBackupFileCharSet() {
        return this.backupFileCharSet;
    }

    public void setBackupFileCharSet(String backupFileCharSet) {
        if (backupFileCharSet != null && !backupFileCharSet.trim().isEmpty()) {
            this.backupFileCharSet = backupFileCharSet;
        }
    }

    public boolean isStrictFieldMatching() {
        return this.strictFieldMatching;
    }

    public void setStrictFieldMatching(Boolean strictFieldMatching) {
        if (strictFieldMatching != null) {
            this.strictFieldMatching = strictFieldMatching;
        }
    }

    public boolean isTrimFields() {
        return this.trimFields;
    }

    public void setTrimFields(boolean trimFields) {
        this.trimFields = trimFields;
    }

    public String getCheckConnectionStatement() {
        return this.checkConnectionStatement;
    }

    public void setCheckConnectionStatement(String checkConnectionStatement) {
        this.checkConnectionStatement = checkConnectionStatement;
    }
}

