/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLSchema;
import java.util.ArrayList;
import java.util.List;

public class SQLProcedure
extends SQLObject
implements Comparable<SQLProcedure> {
    private SQLSchema schema;
    private String comment = null;
    private boolean function = false;
    private Parameter returnParam;
    private List<Parameter> returnTable = null;
    private String code;
    private ArrayList<Parameter> listParameters = new ArrayList();

    public SQLProcedure(SQLDataModel model, SQLSchema schema, String name) {
        super(model, name);
        this.schema = schema;
    }

    public String getComment() {
        return this.comment;
    }

    public String getAbsoluteName() {
        return this.schema.getName() + "." + this.getName();
    }

    public void setComment(String remark) {
        this.comment = remark;
    }

    public SQLSchema getSchema() {
        return this.schema;
    }

    public Parameter addParameter(String name, int type, String typeName, int length, int precision, int ioType) {
        Parameter parameter = new Parameter(this);
        parameter.setName(name);
        parameter.setLength(length);
        parameter.setType(type);
        parameter.setTypeName(typeName);
        parameter.setPrecision(precision);
        parameter.setIoType(ioType);
        if (parameter.isSingleReturnValue()) {
            this.setFunction(true);
            this.returnParam = parameter;
        } else if (parameter.isResultsetReturnValue()) {
            this.setFunction(true);
            if (this.returnTable == null) {
                this.returnTable = new ArrayList<Parameter>();
            }
            this.returnTable.add(parameter);
        } else {
            this.listParameters.add(parameter);
        }
        return parameter;
    }

    public Parameter getReturnParameter() {
        return this.returnParam;
    }

    public List<Parameter> getResultsetParameters() {
        return this.returnTable;
    }

    public int getParameterCount() {
        return this.listParameters.size();
    }

    public Parameter getParameterAt(int index) {
        return this.listParameters.get(index);
    }

    public void clearParameters() {
        this.listParameters.clear();
    }

    public boolean isFunction() {
        return this.function;
    }

    private void setFunction(boolean function) {
        this.function = function;
    }

    public String getProcedureCallCode() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append("(");
        boolean firstLoop = true;
        for (Parameter p : this.listParameters) {
            if (p.name == null) continue;
            if (firstLoop) {
                firstLoop = false;
            } else {
                sb.append(",");
            }
            sb.append(p.name);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.getProcedureCallCode().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SQLProcedure) {
            SQLProcedure other = (SQLProcedure)object;
            return this.getProcedureCallCode().equalsIgnoreCase(other.getProcedureCallCode());
        }
        return false;
    }

    @Override
    public int compareTo(SQLProcedure o) {
        if (o.getName().equals(this.getName())) {
            if (this.getParameterCount() > o.getParameterCount()) {
                return 1;
            }
            return -1;
        }
        return this.getName().compareTo(o.getName());
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName());
        boolean firstLoop = true;
        sb.append("(");
        for (Parameter p : this.listParameters) {
            if (p.isSingleReturnValue()) continue;
            if (firstLoop) {
                firstLoop = false;
            } else {
                sb.append(",");
            }
            sb.append(p.typeName);
        }
        sb.append(")");
        return sb.toString();
    }

    public static class Parameter {
        private String name;
        private int type;
        private String typeName;
        private int length;
        private int precision;
        private int ioType;
        private SQLProcedure procedure;

        public Parameter(SQLProcedure procedure) {
            this.procedure = procedure;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public int getIoType() {
            return this.ioType;
        }

        public boolean isSingleReturnValue() {
            return this.ioType == 5;
        }

        public boolean isResultsetReturnValue() {
            return this.ioType == 3;
        }

        public boolean isOutputParameter() {
            return this.ioType == 4 || this.ioType == 2;
        }

        public void setIoType(int ioType) {
            this.ioType = ioType;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }

        public String getName() {
            if (this.name != null) {
                return this.name;
            }
            return "";
        }

        public SQLProcedure getProcedure() {
            return this.procedure;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getPrecision() {
            return this.precision;
        }

        public void setPrecision(int precision) {
            this.precision = precision;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public boolean equals(Object o) {
            if (o instanceof Parameter) {
                return ((Parameter)o).getName().equalsIgnoreCase(this.name);
            }
            return false;
        }

        public int hashCode() {
            int hash = 3;
            hash = 31 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }

        public String toString() {
            if (this.name != null && this.name.length() > 0) {
                return this.name;
            }
            return "return";
        }
    }
}

