/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLField;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLTable;
import java.util.ArrayList;

public class SQLConstraint
extends SQLObject {
    public static final int PRIMARY_KEY = 1;
    public static final int FOREIGN_KEY = 2;
    public static final int UNIQUE_KEY = 4;
    public static final int NOT_NULL = 5;
    private int type = 0;
    private ArrayList<PkColumn> pkColumnList = new ArrayList();
    private ArrayList<FkPkColumnPair> fkColumnPairList = new ArrayList();
    private String referencedTableName = null;
    private SQLTable sqlTable = null;

    public SQLTable getTable() {
        return this.sqlTable;
    }

    public SQLConstraint(SQLDataModel model, SQLTable sqlTable, int type, String name) {
        super(model, name);
        this.sqlTable = sqlTable;
        this.type = type;
    }

    public void setReferencedTableName(String tableName) {
        this.referencedTableName = tableName;
    }

    public SQLTable getReferencedTable() {
        return this.getModel().getSQLTable(this.referencedTableName);
    }

    public void addForeignKeyColumnNamePair(String fkColumnName, String pkColumnName, int index) {
        FkPkColumnPair pair = new FkPkColumnPair();
        pair.setFkColumnName(fkColumnName);
        pair.setPkColumnName(pkColumnName);
        pair.setIndex(index);
        if (!this.fkColumnPairList.contains(pair)) {
            this.fkColumnPairList.add(pair);
        }
    }

    public int getImportedKeyFieldListSize() {
        return this.fkColumnPairList.size();
    }

    public String getImportedKeyFieldNameAt(int index) {
        if (index >= this.fkColumnPairList.size()) {
            throw new IllegalArgumentException("index greater than size=" + this.fkColumnPairList.size());
        }
        return this.fkColumnPairList.get(index).getPkColumnName();
    }

    public void addPrimaryKeyFieldName(String name, int index) {
        SQLField field;
        PkColumn col = new PkColumn();
        col.setPkColumnName(name);
        col.setIndex(index);
        if (!this.pkColumnList.contains(col)) {
            this.pkColumnList.add(col);
        }
        if ((field = this.sqlTable.getField(name)) == null) {
            throw new IllegalStateException("column " + name + " does not exists.");
        }
        field.setPrimaryKey(true);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getFkColumnPairCount() {
        return this.fkColumnPairList.size();
    }

    public int getColumnCount() {
        if (this.type == 1 || this.type == 4) {
            return this.pkColumnList.size();
        }
        return this.fkColumnPairList.size();
    }

    public Object getColumnAt(int index) {
        if (this.type == 1 || this.type == 4) {
            return this.pkColumnList.get(index);
        }
        return this.fkColumnPairList.get(index);
    }

    public boolean equals(Object o) {
        if (o instanceof SQLConstraint) {
            SQLConstraint c = (SQLConstraint)o;
            if (c.getType() != this.type) {
                return false;
            }
            return this.getName().equalsIgnoreCase(c.getName());
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 13 * hash + this.type;
        hash = 13 * hash + (this.getName() != null ? this.getName().toLowerCase().hashCode() : 0);
        return hash;
    }

    public String getDropStatement(boolean withSchemaName) {
        StringBuilder sb = new StringBuilder();
        sb.append("alter table ");
        if (withSchemaName) {
            sb.append(this.sqlTable.getAbsoluteName());
        } else {
            sb.append(this.sqlTable.getName());
        }
        sb.append(" drop constraint ");
        sb.append(this.getName());
        return sb.toString();
    }

    @Override
    public String toString() {
        if (this.type == 1) {
            StringBuilder sb = new StringBuilder();
            sb.append("PK <");
            sb.append(this.getName());
            sb.append("> (");
            for (int i = 0; i < this.pkColumnList.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.pkColumnList.get(i).toString());
            }
            sb.append(')');
            return sb.toString();
        }
        if (this.type == 2) {
            StringBuilder sb = new StringBuilder();
            sb.append("FK <");
            sb.append(this.getName());
            sb.append("> to table ");
            sb.append(this.referencedTableName);
            sb.append(" (");
            for (int i = 0; i < this.fkColumnPairList.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.fkColumnPairList.get(i).toString());
            }
            sb.append(')');
            return sb.toString();
        }
        if (this.type == 4) {
            StringBuilder sb = new StringBuilder();
            sb.append("UN <");
            sb.append(this.getName());
            sb.append("> (");
            for (int i = 0; i < this.pkColumnList.size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.pkColumnList.get(i).toString());
            }
            sb.append(')');
            return sb.toString();
        }
        return "constraint " + this.getName() + " has unknown type=" + this.type;
    }

    public ArrayList<FkPkColumnPair> getFkColumnPairList() {
        return this.fkColumnPairList;
    }

    public ArrayList<PkColumn> getPkColumnList() {
        return this.pkColumnList;
    }

    public static class PkColumn
    implements Comparable<PkColumn> {
        private String pkColumnName;
        private int index = 0;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public void setPkColumnName(String pkColumnName) {
            this.pkColumnName = pkColumnName;
        }

        public boolean equals(Object o) {
            if (o instanceof PkColumn) {
                PkColumn pair = (PkColumn)o;
                return pair.pkColumnName != null && pair.pkColumnName.equalsIgnoreCase(this.pkColumnName);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.pkColumnName != null ? this.pkColumnName.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(PkColumn o) {
            if (o != null) {
                return o.getIndex() - this.index;
            }
            return 0;
        }

        public String toString() {
            return this.pkColumnName + "(" + this.index + ")";
        }
    }

    public static class FkPkColumnPair
    implements Comparable<FkPkColumnPair> {
        private String fkColumnName;
        private String pkColumnName;
        private int index = 0;

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public String getFkColumnName() {
            return this.fkColumnName;
        }

        public void setFkColumnName(String fkColumnName) {
            this.fkColumnName = fkColumnName;
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public void setPkColumnName(String pkColumnName) {
            this.pkColumnName = pkColumnName;
        }

        public boolean equals(Object o) {
            if (o instanceof FkPkColumnPair) {
                FkPkColumnPair pair = (FkPkColumnPair)o;
                return pair.fkColumnName != null && pair.fkColumnName.equalsIgnoreCase(this.fkColumnName) && pair.pkColumnName != null && pair.pkColumnName.equalsIgnoreCase(this.pkColumnName);
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + (this.fkColumnName != null ? this.fkColumnName.hashCode() : 0);
            hash = 47 * hash + (this.pkColumnName != null ? this.pkColumnName.hashCode() : 0);
            return hash;
        }

        @Override
        public int compareTo(FkPkColumnPair o) {
            if (o != null) {
                return o.getIndex() - this.index;
            }
            return 0;
        }

        public String toString() {
            return this.fkColumnName + "->" + this.pkColumnName + "(" + this.index + ")";
        }
    }
}

