/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel.ext.impl;

import de.jlo.datamodel.SQLProcedure;
import de.jlo.datamodel.SQLStatement;
import de.jlo.datamodel.SQLTable;
import de.jlo.datamodel.ext.GenericDatabaseExtension;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class EXASolutionExtension
extends GenericDatabaseExtension {
    private Logger logger = Logger.getLogger(EXASolutionExtension.class);
    private static final String driverClassName = "com.exasol.jdbc.EXADriver";

    public EXASolutionExtension() {
        this.addDriverClassName(driverClassName);
        this.addSQLKeyword("flush statistics");
        this.addSQLKeyword("distribute");
        this.addSQLKeyword("profile");
        this.addSQLDatatype("geometry");
        this.addSQLDatatype("timestamp with local time zone");
        this.addSQLDatatype("interval year to month");
        this.addSQLDatatype("interval day to second");
    }

    @Override
    public String setupViewSQLCode(Connection conn, SQLTable table) {
        StringBuilder sb = new StringBuilder();
        sb.append("select VIEW_TEXT from SYS.EXA_ALL_VIEWS where VIEW_SCHEMA='");
        sb.append(table.getName().toUpperCase());
        sb.append("' and VIEW_NAME='");
        sb.append(table.getSchema().getName().toUpperCase());
        sb.append("'");
        String code = null;
        try {
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery(sb.toString());
            if (rs.next()) {
                code = rs.getString(1);
            }
            rs.close();
            stat.close();
            if (code != null && code.length() > 1) {
                table.setSourceCode(code);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("setupViewSQLCode for view=" + table.getName() + " failed:" + e.getMessage()), (Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public String setupProcedureSQLCode(Connection conn, SQLProcedure proc) {
        StringBuilder sb = new StringBuilder();
        sb.append("select FUNCTION_TEXT from SYS.EXA_ALL_FUNCTIONS where FUNCTION_NAME='");
        sb.append(proc.getName().toUpperCase());
        sb.append("' and FUNCTION_SCHEMA='");
        sb.append(proc.getSchema().getName().toUpperCase());
        sb.append("'");
        String code = null;
        try {
            Statement stat = conn.createStatement();
            ResultSet rs = stat.executeQuery(sb.toString());
            if (rs.next()) {
                code = rs.getString(1);
            }
            rs.close();
            stat.close();
            if (code != null && code.length() > 1) {
                proc.setCode(code);
            }
        }
        catch (SQLException e) {
            this.logger.error((Object)("setupProcedureSQLCode for proc=" + proc.getName() + " failed:" + e.getMessage()), (Throwable)e);
        }
        return sb.toString();
    }

    @Override
    public boolean hasExplainFeature() {
        return true;
    }

    @Override
    public String getExplainSQL(String currentStatement) {
        if (currentStatement != null) {
            currentStatement = currentStatement.trim();
            StringBuilder sb = new StringBuilder();
            sb.append("alter session set profile='on';");
            sb.append(SQLStatement.ignoreResultSetComment + "\n");
            sb.append(currentStatement);
            if (!currentStatement.endsWith(";")) {
                sb.append(";\n");
            }
            sb.append("alter session set profile='off';\n");
            sb.append("flush statistics;\n");
            sb.append("select * from EXA_STATISTICS.EXA_USER_PROFILE_LAST_DAY\n");
            sb.append("where session_id = current_session order by stmt_id desc;");
            return sb.toString();
        }
        return "";
    }
}

