/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.SQLConstraint;
import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLField;
import de.jlo.datamodel.SQLIndex;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class SQLTable
extends SQLObject {
    private final List<SQLField> listColumns = new ArrayList<SQLField>();
    private final List<SQLIndex> listIndexes = new ArrayList<SQLIndex>();
    private final Map<String, SQLField> fieldMap = new HashMap<String, SQLField>();
    private SQLSchema schema;
    private String type;
    private String comment;
    private String sourceCode;
    static final int IS_REFERENCED_FROM_TABLE = -1;
    static final int HAS_REFERENCE_TO_TABLE = 1;
    static final int NO_REFERENCES = 0;
    public static final String TYPE_TABLE = "TABLE";
    public static final String TYPE_VIEW = "VIEW";
    public static final String TYPE_MAT_VIEW = "MATERIALIZED VIEW";
    public static final String TYPE_SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String TYPE_SYSTEM_VIEW = "SYSTEM VIEW";
    public static final String TYPE_GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String TYPE_LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    public static final String TYPE_ALIAS = "ALIAS";
    public static final String TYPE_SYNONYM = "SYNONYM";
    public static final String TYPE_SYSTEM = "SYSTEM";
    private boolean fieldsLoaded = false;
    private boolean constraintsLoaded = false;
    private boolean indexesLoaded = false;
    private Map<String, SQLConstraint> constraintMap = new HashMap<String, SQLConstraint>();
    private transient SQLConstraint primaryKeyConstraint = null;
    private boolean loadingColumns = false;
    private boolean loadingConstraints = false;
    private boolean loadingIndexes = false;
    private boolean inheritated = false;
    private int countPartitions = 0;

    public SQLTable(SQLDataModel model, SQLSchema schema, String name) {
        super(model, name);
        this.schema = schema;
    }

    public void clear() {
        this.clearConstraints();
        this.clearIndexes();
        this.clearFields();
    }

    public Map<String, SQLConstraint> getConstraintMap() {
        return this.constraintMap;
    }

    public void setConstraintMap(HashMap<String, SQLConstraint> constraintMap) {
        this.constraintMap = constraintMap;
    }

    public SQLConstraint getPrimaryKeyConstraint() {
        return this.primaryKeyConstraint;
    }

    public void setPrimaryKeyConstraint(SQLConstraint primaryKeyConstraint) {
        this.primaryKeyConstraint = primaryKeyConstraint;
        this.addConstraint(primaryKeyConstraint);
    }

    public void clearConstraints() {
        this.constraintMap.clear();
        this.primaryKeyConstraint = null;
        this.constraintsLoaded = false;
        for (SQLField f : this.listColumns) {
            f.setPrimaryKey(false);
        }
    }

    public int getCountConstraints() {
        return this.constraintMap.size();
    }

    public List<SQLConstraint> getConstraints() {
        ArrayList<SQLConstraint> list = new ArrayList<SQLConstraint>();
        Iterator<Map.Entry<String, SQLConstraint>> it = this.constraintMap.entrySet().iterator();
        while (it.hasNext()) {
            list.add(it.next().getValue());
        }
        return list;
    }

    public List<SQLIndex> getIndexes() {
        ArrayList<SQLIndex> list = new ArrayList<SQLIndex>();
        for (SQLIndex index : this.listIndexes) {
            list.add(index);
        }
        return list;
    }

    public int getCountIndexes() {
        return this.listIndexes.size();
    }

    public int countConstraints() {
        return this.constraintMap.size();
    }

    public void addConstraint(SQLConstraint constraint) {
        this.constraintMap.put(constraint.getName(), constraint);
    }

    public void removeConstraint(SQLConstraint constraint) {
        this.constraintMap.remove(constraint.getName());
    }

    public SQLConstraint getConstraint(String name) {
        return this.constraintMap.get(name);
    }

    public boolean isConstraintsLoadFinished() {
        return this.constraintsLoaded;
    }

    public boolean isSourceCodeLoaded() {
        return this.sourceCode != null;
    }

    void setConstraintsLoaded() {
        this.constraintsLoaded = true;
    }

    public boolean isFieldsLoaded() {
        return this.fieldsLoaded;
    }

    public void setFieldsLoaded() {
        this.fieldsLoaded = true;
    }

    void setIndexesLoaded() {
        this.indexesLoaded = true;
    }

    public boolean isIndexesLoadFinished() {
        return this.indexesLoaded;
    }

    public String getAbsoluteName() {
        if (!this.schema.getName().isEmpty()) {
            return this.schema.getName() + "." + this.getName();
        }
        return this.getName();
    }

    public void setSchema(SQLSchema schema_loc) {
        this.schema = schema_loc;
    }

    public SQLSchema getSchema() {
        return this.schema;
    }

    public void addIndex(SQLIndex index) {
        if (!this.listIndexes.contains(index)) {
            this.listIndexes.add(index);
        }
    }

    public int countIndexes() {
        return this.listIndexes.size();
    }

    public SQLIndex getIndexAt(int listPos) {
        return this.listIndexes.get(listPos);
    }

    public SQLIndex getIndexByName(String indexName) {
        for (SQLIndex index : this.listIndexes) {
            if (!index.getName().equalsIgnoreCase(indexName)) continue;
            return index;
        }
        return null;
    }

    public void addField(SQLField field) {
        this.listColumns.add(field);
        this.fieldMap.put(field.getName().toLowerCase(), field);
    }

    public void removeSQLField(SQLField field) {
        this.listColumns.remove(field);
        this.fieldMap.remove(field.getName().toLowerCase());
    }

    public void clearFields() {
        this.listColumns.clear();
        this.fieldMap.clear();
        this.fieldsLoaded = false;
    }

    public void clearIndexes() {
        this.listIndexes.clear();
        this.indexesLoaded = false;
    }

    public int getFieldCount() {
        if (this.loadingColumns) {
            return 0;
        }
        if (!this.fieldsLoaded) {
            this.loadColumns();
        }
        return this.listColumns.size();
    }

    public SQLField getFieldAt(int index) {
        if (!this.fieldsLoaded) {
            this.loadColumns();
        }
        if (this.loadingColumns) {
            return null;
        }
        return this.listColumns.get(index);
    }

    public SQLField getField(String name) {
        if (!this.fieldsLoaded) {
            this.loadColumns();
        }
        SQLField field = null;
        for (int i = 0; i < this.listColumns.size() && !name.equalsIgnoreCase((field = this.listColumns.get(i)).getName()); ++i) {
            field = null;
        }
        return field;
    }

    public List<String> getPrimaryKeyFieldNames() {
        if (!this.fieldsLoaded) {
            this.loadColumns();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (SQLField field : this.listColumns) {
            if (!field.isPrimaryKey()) continue;
            names.add(field.getName());
        }
        return names;
    }

    public List<String> getFieldNames() {
        if (!this.fieldsLoaded) {
            this.loadColumns();
        }
        ArrayList<String> names = new ArrayList<String>();
        for (SQLField field : this.listColumns) {
            names.add(field.getName());
        }
        return names;
    }

    public boolean isReferencingByForeignKeys() {
        if (this.isTable() && !this.constraintMap.isEmpty()) {
            for (SQLConstraint constraint : this.constraintMap.values()) {
                if (constraint.getType() != 2) continue;
                return true;
            }
        }
        return false;
    }

    public List<SQLTable> getReferencedTables() {
        ArrayList<SQLTable> referencedTables = new ArrayList<SQLTable>();
        if (this.isTable() && !this.constraintMap.isEmpty()) {
            for (SQLConstraint constraint : this.constraintMap.values()) {
                if (constraint.getType() != 2) continue;
                SQLTable rt = constraint.getReferencedTable();
                referencedTables.add(rt);
            }
        }
        return referencedTables;
    }

    public boolean isReferencedTable(SQLTable table) {
        if (this.isTable() && table.isTable()) {
            if (!this.constraintMap.isEmpty()) {
                for (SQLConstraint constraint : this.constraintMap.values()) {
                    if (constraint.getType() != 2) continue;
                    SQLTable rt = constraint.getReferencedTable();
                    System.out.print("isReferenced: " + this.getName() + " rt:" + rt.getName() + " ? " + table.getName());
                    if (rt.equals(table)) {
                        System.out.println(" = true");
                        return true;
                    }
                    System.out.println(" = false");
                }
            }
        } else if (this.isView() && this.sourceCode != null && this.sourceCode.toLowerCase().indexOf(table.getName().toLowerCase()) > 0) {
            return true;
        }
        return false;
    }

    public boolean hasPrimaryKeyFields() {
        boolean hasPrimaryKeyField = false;
        for (int i = 0; i < this.listColumns.size(); ++i) {
            SQLField field = this.listColumns.get(i);
            if (!field.isPrimaryKey()) continue;
            hasPrimaryKeyField = true;
            break;
        }
        return hasPrimaryKeyField;
    }

    public boolean equals(Object o) {
        boolean isEqual = false;
        if (o instanceof SQLTable) {
            isEqual = ((SQLTable)o).getAbsoluteName().equalsIgnoreCase(this.getAbsoluteName());
        }
        return isEqual;
    }

    public String getType() {
        return this.type;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setType(String string) {
        this.type = string;
    }

    public void loadColumns() {
        this.fieldsLoaded = this.getModel().loadColumns(this);
    }

    public void loadColumns(boolean onlyColumns) {
        this.fieldsLoaded = this.getModel().loadColumns(this, onlyColumns);
    }

    public int hashCode() {
        return this.getAbsoluteName().hashCode();
    }

    public boolean isTable() {
        return TYPE_TABLE.equals(this.type) || TYPE_SYSTEM_TABLE.equals(this.type) || TYPE_GLOBAL_TEMPORARY.equals(this.type) || TYPE_LOCAL_TEMPORARY.equals(this.type) || TYPE_SYSTEM.equals(this.type) || TYPE_SYSTEM_TABLE.equals(this.type) || TYPE_ALIAS.equals(this.type);
    }

    public boolean isView() {
        return TYPE_VIEW.equals(this.type) || TYPE_MAT_VIEW.equals(this.type) || TYPE_SYSTEM_VIEW.equals(this.type);
    }

    public boolean isMaterializedView() {
        return TYPE_MAT_VIEW.equals(this.type);
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public void setSourceCode(String sourceCode) {
        if (sourceCode != null) {
            sourceCode = sourceCode.trim();
        }
        this.sourceCode = sourceCode;
    }

    public boolean isLoadingColumns() {
        return this.loadingColumns;
    }

    public void setLoadingColumns(boolean loadingColumns) {
        this.loadingColumns = loadingColumns;
    }

    public boolean isLoadingConstraints() {
        return this.loadingConstraints;
    }

    public void setLoadingConstraints(boolean loadingConstraints) {
        this.loadingConstraints = loadingConstraints;
    }

    public boolean isLoadingIndexes() {
        return this.loadingIndexes;
    }

    public void setLoadingIndexes(boolean loadingIndexes) {
        this.loadingIndexes = loadingIndexes;
    }

    public boolean isInheritated() {
        return this.inheritated;
    }

    public void setInheritated(boolean inheritated) {
        this.inheritated = inheritated;
    }

    public int getCountPartitions() {
        return this.countPartitions;
    }

    public void setCountPartitions(int countPartitions) {
        this.countPartitions = countPartitions;
    }
}

