/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.SQLCatalog;
import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLProcedure;
import de.jlo.datamodel.SQLSequence;
import de.jlo.datamodel.SQLTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class SQLSchema
extends SQLObject {
    private final Vector<SQLTable> tableList = new Vector();
    private final HashMap<String, SQLTable> tableMap = new HashMap();
    private final ArrayList<SQLProcedure> procedureList = new ArrayList();
    private final ArrayList<SQLSequence> sequenceList = new ArrayList();
    private boolean loadingTables = false;
    private boolean loadingProcedures = false;
    private boolean tablesLoaded = false;
    private boolean procedureLoaded = false;
    private boolean loadingSequences = false;
    private boolean sequencesLoaded = false;
    private SQLCatalog catalog;

    public void setProcedureLoaded() {
        this.procedureLoaded = true;
    }

    public boolean isProceduresLoaded() {
        return this.procedureLoaded;
    }

    public void addSequence(SQLSequence sequence) {
        this.sequenceList.add(sequence);
    }

    public List<SQLSequence> getSequences() {
        if (!this.sequencesLoaded && !this.loadingSequences) {
            this.getModel().loadSequences(this);
        }
        return this.sequenceList;
    }

    public int getSequenceCount() {
        if (!this.sequencesLoaded) {
            this.getModel().loadSequences(this);
        }
        return this.sequenceList.size();
    }

    public void addProcedure(SQLProcedure procedure) {
        this.procedureList.add(procedure);
    }

    public void sortProcedureList() {
        Collections.sort(this.procedureList);
    }

    public List<SQLProcedure> getProcedures(String name) {
        if (!this.procedureLoaded && !this.loadingProcedures) {
            this.loadProcedures();
        }
        ArrayList<SQLProcedure> list = new ArrayList<SQLProcedure>();
        SQLProcedure p = null;
        for (int i = 0; i < this.procedureList.size(); ++i) {
            p = this.procedureList.get(i);
            if (p.getName() == null || !p.getName().equalsIgnoreCase(name)) continue;
            list.add(p);
        }
        return list;
    }

    public List<SQLProcedure> getProcedures() {
        if (!this.procedureLoaded && !this.loadingProcedures) {
            this.loadProcedures();
        }
        ArrayList<SQLProcedure> list = new ArrayList<SQLProcedure>();
        SQLProcedure p = null;
        for (int i = 0; i < this.procedureList.size(); ++i) {
            p = this.procedureList.get(i);
            list.add(p);
        }
        return list;
    }

    public void removeProcedure(SQLProcedure procedure) {
        this.procedureList.remove(procedure);
    }

    public int getProcedureCount() {
        if (!this.procedureLoaded) {
            this.getModel().loadProcedures(this);
        }
        return this.procedureList.size();
    }

    public SQLProcedure getProcedureAt(int index) {
        if (!this.procedureLoaded) {
            this.getModel().loadProcedures(this);
        }
        return this.procedureList.get(index);
    }

    public SQLSequence getSequenceAt(int index) {
        if (!this.sequencesLoaded) {
            this.getModel().loadSequences(this);
        }
        return this.sequenceList.get(index);
    }

    public void clearProcedures() {
        this.procedureList.clear();
        this.procedureLoaded = false;
    }

    public boolean isTablesLoaded() {
        return this.tablesLoaded;
    }

    public void setSequencesLoaded() {
        this.sequencesLoaded = true;
    }

    public boolean isSequencesLoaded() {
        return this.sequencesLoaded;
    }

    public void setTablesLoaded() {
        this.tablesLoaded = true;
    }

    public SQLSchema(SQLDataModel model, String name) {
        super(model, name);
    }

    public void addTable(SQLTable table) {
        this.tableList.addElement(table);
        this.tableMap.put(table.getName().toLowerCase(), table);
    }

    void removeSQLTable(SQLTable table) {
        this.tableList.remove(table);
        this.tableMap.remove(table.getName().toLowerCase());
    }

    public void clearTables() {
        this.tableList.clear();
        this.tableMap.clear();
        this.tablesLoaded = false;
        this.sequencesLoaded = false;
    }

    public int getTableCount() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tableList.size();
    }

    public SQLTable getTableAt(int index) {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tableList.get(index);
    }

    public List<SQLTable> getTables() {
        ArrayList<SQLTable> list = new ArrayList<SQLTable>();
        for (int i = 0; i < this.getTableCount(); ++i) {
            list.add(this.getTableAt(i));
        }
        Collections.sort(list, new Comparator<SQLTable>(){

            @Override
            public int compare(SQLTable o1, SQLTable o2) {
                return o1.getName().toLowerCase().compareToIgnoreCase(o2.getName());
            }
        });
        return list;
    }

    public SQLTable getTable(String name) {
        if (SQLSchema.isValidIdentifier(name)) {
            if (!this.tablesLoaded) {
                this.loadTables();
            }
            return this.tableMap.get(name.toLowerCase());
        }
        return null;
    }

    public boolean loadTables() {
        this.tablesLoaded = this.getModel().loadTables(this);
        return this.tablesLoaded;
    }

    public boolean loadProcedures() {
        return this.getModel().loadProcedures(this);
    }

    public boolean loadSequences() {
        return this.getModel().loadSequences(this);
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SQLSchema) {
            SQLSchema so = (SQLSchema)o;
            return so.getName().equalsIgnoreCase(this.getName());
        }
        return false;
    }

    public boolean isLoadingTables() {
        return this.loadingTables;
    }

    public void setLoadingTables(boolean loadingTables) {
        this.loadingTables = loadingTables;
    }

    public boolean isLoadingProcedures() {
        return this.loadingProcedures;
    }

    public void setLoadingSequences(boolean loading) {
        this.loadingSequences = loading;
    }

    public boolean isLoadingSequences() {
        return this.loadingSequences;
    }

    public void setLoadingProcedures(boolean loadingProcedures) {
        this.loadingProcedures = loadingProcedures;
    }

    public SQLCatalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(SQLCatalog catalog) {
        this.catalog = catalog;
        catalog.addSQLSchema(this);
    }
}

