/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import java.util.HashMap;

public class BasicDataType {
    private int id;
    private String name;
    private static HashMap<Integer, BasicDataType> list = new HashMap();
    public static final BasicDataType CHARACTER = new BasicDataType(0, "Character");
    public static final BasicDataType DATE = new BasicDataType(1, "Date");
    public static final BasicDataType DOUBLE = new BasicDataType(2, "Double");
    public static final BasicDataType BINARY = new BasicDataType(3, "Binary");
    public static final BasicDataType INTEGER = new BasicDataType(5, "Integer");
    public static final BasicDataType LONG = new BasicDataType(6, "Long");
    public static final BasicDataType CLOB = new BasicDataType(4, "CLOB");
    public static final BasicDataType ROWID = new BasicDataType(-100, "RowId");
    public static final BasicDataType SQLEXP = new BasicDataType(7, "SQL expression");
    public static final BasicDataType BOOLEAN = new BasicDataType(8, "Boolean");
    public static final BasicDataType UNKNOWN = new BasicDataType(99999, "Unknown");

    private BasicDataType(int id, String name) {
        this.id = id;
        this.name = name;
        if (list.containsKey(id)) {
            throw new IllegalArgumentException("id=" + id + " already exists");
        }
        list.put(id, this);
    }

    public static boolean isNumberType(int type) {
        return type == BasicDataType.DOUBLE.id || type == BasicDataType.INTEGER.id || type == BasicDataType.LONG.id;
    }

    public static boolean isNumberType(BasicDataType type) {
        return type == DOUBLE || type == INTEGER || type == LONG;
    }

    public static boolean isStringType(int type) {
        return type == BasicDataType.CLOB.id || type == BasicDataType.CHARACTER.id;
    }

    public static boolean isStringType(BasicDataType type) {
        return type == CLOB || type == CHARACTER;
    }

    public static boolean isDateType(int type) {
        return type == BasicDataType.DATE.id;
    }

    public static boolean isDateType(BasicDataType type) {
        return type == DATE;
    }

    public static boolean isBooleanType(int type) {
        return type == BasicDataType.BOOLEAN.id;
    }

    public static boolean isBooleanType(BasicDataType type) {
        return type == BOOLEAN;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public static BasicDataType getBasicDataType(int id) {
        return list.get(id);
    }

    public boolean equals(Object o) {
        if (o instanceof BasicDataType) {
            return this.id == ((BasicDataType)o).getId();
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + this.id;
        return hash;
    }

    public String toString() {
        return this.getName();
    }

    public static int getBasicTypeByTypes(int type) {
        if (type == 12 || type == 1 || type == -9 || type == -15 || type == -8) {
            return CHARACTER.getId();
        }
        if (type == 2 || type == 6 || type == 7 || type == 8 || type == 3) {
            return DOUBLE.getId();
        }
        if (type == 4 || type == -6 || type == 5) {
            return INTEGER.getId();
        }
        if (type == -5) {
            return LONG.getId();
        }
        if (type == 91 || type == 92 || type == 93) {
            return DATE.getId();
        }
        if (type == 2005 || type == 2011 || type == -16 || type == -1) {
            return CLOB.getId();
        }
        if (type == -2 || type == -3 || type == -4 || type == 2004) {
            return BINARY.getId();
        }
        if (type == -100) {
            return ROWID.getId();
        }
        if (type == 16 || type == -7) {
            return BOOLEAN.getId();
        }
        return 0;
    }

    public static BasicDataType getBasicTypeByTypeObjects(int type) {
        if (type == 12 || type == 1 || type == -9 || type == -15 || type == -8) {
            return CHARACTER;
        }
        if (type == 2 || type == 6 || type == 7 || type == 8 || type == 3) {
            return DOUBLE;
        }
        if (type == 4 || type == -6 || type == 5) {
            return INTEGER;
        }
        if (type == -5) {
            return LONG;
        }
        if (type == 91 || type == 92 || type == 93) {
            return DATE;
        }
        if (type == 2005 || type == 2011 || type == -16 || type == -1) {
            return CLOB;
        }
        if (type == -2 || type == -3 || type == -4 || type == 2004) {
            return BINARY;
        }
        if (type == -100) {
            return ROWID;
        }
        if (type == 16 || type == -7) {
            return BOOLEAN;
        }
        return UNKNOWN;
    }

    public static int getBasicTypeByName(String typeName) {
        if ((typeName = typeName.toUpperCase()).equals("CLOB")) {
            return CLOB.getId();
        }
        if (typeName.indexOf("CHAR") != -1 || typeName.equals("TEXT")) {
            return CHARACTER.getId();
        }
        if (typeName.indexOf("NUM") != -1 || typeName.equals("FLOAT") || typeName.equals("REAL") || typeName.equals("DOUBLE") || typeName.equals("DECIMAL")) {
            return DOUBLE.getId();
        }
        if (typeName.equals("INT8") || typeName.equals("BIGINT")) {
            return LONG.getId();
        }
        if (typeName.equals("INTEGER") || typeName.equals("TINYINT") || typeName.equals("INT4") || typeName.equals("INT2") || typeName.equals("SMALLINT")) {
            return INTEGER.getId();
        }
        if (typeName.equals("DATE") || typeName.equals("TIME") || typeName.equals("TIMESTAMP")) {
            return DATE.getId();
        }
        if (typeName.equals("BOOL") || typeName.equals("BOOLEAN") || typeName.equals("BIT")) {
            return BOOLEAN.getId();
        }
        if (typeName.indexOf("BIN") != -1) {
            return BINARY.getId();
        }
        if (typeName.equals("BLOB")) {
            return BINARY.getId();
        }
        if (typeName.equals("ROWID")) {
            return CHARACTER.getId();
        }
        return 0;
    }
}

