/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel.ext;

import de.jlo.datamodel.Field;
import de.jlo.datamodel.SQLProcedure;
import de.jlo.datamodel.SQLSchema;
import de.jlo.datamodel.SQLSequence;
import de.jlo.datamodel.SQLTable;
import de.jlo.datamodel.SQLTrigger;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.List;

public interface DatabaseExtension {
    public void setupConnection(Connection var1);

    public void setupStatement(Statement var1);

    public boolean isApplicable(String var1);

    public boolean hasExplainFeature();

    public String getExplainSQL(String var1);

    public boolean loadTables(Connection var1, SQLSchema var2) throws SQLException;

    public String setupViewSQLCode(Connection var1, SQLTable var2);

    public String setupProcedureSQLCode(Connection var1, SQLProcedure var2);

    public String setupTriggerSQLCode(Connection var1, SQLTrigger var2);

    public String setupSequenceSQLCode(Connection var1, SQLSequence var2);

    public void setupDataType(Field var1);

    public void setupDataType(SQLProcedure.Parameter var1);

    public String getName();

    public List<String> getAdditionalSQLKeywords();

    public List<String> getAdditionalSQLDatatypes();

    public List<String> getAdditionalProcedureKeywords();

    public String getUpdateCommentStatement(String var1, String var2);

    public String getUpdateCommentStatement(String var1, String var2, String var3);

    public boolean hasSQLLimitFeature();

    public boolean isLimitExpressionAWhereCondition();

    public String getLimitExpression(int var1);

    public String getDateToSQLExpression(Date var1);

    public String getDateToSQLExpressionPattern();

    public String getTimestampToSQLExpression(Date var1);

    public String getTimestampToSQLExpressionPattern();

    public String getIdentifierQuoteString();

    public void setIdentifierQuoteString(String var1);

    public boolean hasSequenceFeature();

    public List<SQLSequence> listSequences(Connection var1, SQLSchema var2);

    public String getSequenceNextValSQL(SQLSequence var1);

    public String getSelectCountRows(SQLTable var1);

    public boolean loadProcedures(Connection var1, SQLSchema var2) throws SQLException;

    public void closeConnection(Connection var1);

    public void cancelLastStatement(Connection var1);
}

