/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLTable;
import java.util.ArrayList;
import java.util.List;

public class SQLIndex
extends SQLObject {
    private SQLTable table;
    private int type;
    private boolean unique;
    private int cardinality;
    private String filterCondition;
    private List<IndexField> listIndexedFields = new ArrayList<IndexField>();

    public SQLIndex(SQLDataModel model, String name, SQLTable table) {
        super(model, name);
        this.table = table;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public String getFilterCondition() {
        return this.filterCondition;
    }

    public void setFilterCondition(String filterCondition) {
        this.filterCondition = filterCondition;
    }

    public SQLTable getTable() {
        return this.table;
    }

    public void addIndexField(String name, int ordinalPosition, String sortOrder) {
        IndexField field = new IndexField(name, ordinalPosition, sortOrder);
        int pos = this.listIndexedFields.indexOf(field);
        if (pos != -1) {
            IndexField existingField = this.listIndexedFields.get(pos);
            existingField.updateFrom(field);
        } else {
            this.listIndexedFields.add(field);
        }
    }

    public void clearFields() {
        this.listIndexedFields.clear();
    }

    public int getCountFields() {
        return this.listIndexedFields.size();
    }

    public IndexField getFieldByName(String fieldName) {
        for (IndexField f : this.listIndexedFields) {
            if (!f.name.equalsIgnoreCase(fieldName)) continue;
            return f;
        }
        return null;
    }

    public IndexField getFieldByOrdinalPosition(int ordinalPos) {
        for (IndexField f : this.listIndexedFields) {
            if (f.ordinalPosition != ordinalPos) continue;
            return f;
        }
        return null;
    }

    public IndexField getFieldAt(int listPos) {
        return this.listIndexedFields.get(listPos);
    }

    public boolean equals(Object o) {
        if (o instanceof SQLIndex) {
            return super.equals(o) && this.table.equals(((SQLIndex)o).table);
        }
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + (this.unique ? " (unique)" : "");
    }

    public static class IndexField {
        private String name;
        private int ordinalPosition;
        private String sortOrder;

        public IndexField(String name, int ordinalPosition, String sortOrder) {
            this.name = name;
            this.ordinalPosition = ordinalPosition;
            this.sortOrder = sortOrder;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public String getSortOrder() {
            return this.sortOrder;
        }

        public void updateFrom(IndexField field) {
            if (field != null) {
                this.ordinalPosition = field.ordinalPosition;
                this.sortOrder = field.sortOrder;
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof IndexField) {
                return this.name.equalsIgnoreCase(((IndexField)o).name);
            }
            return false;
        }

        public String toString() {
            return this.name;
        }
    }
}

