/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.DatamodelEvent;
import de.jlo.datamodel.DatamodelListener;
import de.jlo.datamodel.DefaultCatalog;
import de.jlo.datamodel.DefaultSchema;
import de.jlo.datamodel.SQLCatalog;
import de.jlo.datamodel.SQLConstraint;
import de.jlo.datamodel.SQLField;
import de.jlo.datamodel.SQLIndex;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLProcedure;
import de.jlo.datamodel.SQLSchema;
import de.jlo.datamodel.SQLTable;
import de.jlo.datamodel.ext.DatabaseExtension;
import de.jlo.datamodel.ext.DatabaseExtensionFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public final class SQLDataModel
extends SQLObject
implements Comparable<SQLDataModel> {
    private static final Logger logger = Logger.getLogger(SQLDataModel.class);
    private String errorMessage;
    private final List<SQLCatalog> catalogs = new ArrayList<SQLCatalog>();
    private boolean loadingSchemas = false;
    private boolean loadingCatalogs = false;
    private boolean useLowerCaseIdentifiers = false;
    private boolean useUpperCaseIdentifiers = false;
    private boolean userCaseSensitiveIdentifiers = false;
    public final char delimiter = '\u0000';
    private boolean schemasLoaded = false;
    private boolean catalogsLoaded = false;
    private SQLSchema currentSQLSchema = null;
    private ArrayList<DatamodelListener> listener = new ArrayList();
    private DatabaseExtension databaseExtension;
    private Connection connection;

    public void addDatamodelListener(DatamodelListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void removeDatamodelListener(DatamodelListener l) {
        this.listener.remove(l);
    }

    public void removeAllDatamodelListener() {
        this.listener.clear();
    }

    private void fireDatamodelEvent(final String message, final int type) {
        if (!this.listener.isEmpty()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doFireDatemodelEvent(message, type);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SQLDataModel.this.doFireDatemodelEvent(message, type);
                    }
                });
            }
        }
    }

    private void doFireDatemodelEvent(String message, int type) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)message);
        }
        DatamodelEvent e = new DatamodelEvent(this, message, type);
        for (DatamodelListener l : this.listener) {
            l.eventHappend(e);
        }
    }

    public boolean isUseLowerCaeIdentifiers() {
        return this.useLowerCaseIdentifiers;
    }

    public boolean isUseUpperCaseIdentifiers() {
        return this.useUpperCaseIdentifiers;
    }

    public boolean isUserCaseSensitiveIdentifiers() {
        return this.userCaseSensitiveIdentifiers;
    }

    public SQLDataModel(Connection connection) throws Exception {
        super(null, "given-connection");
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null");
        }
        if (connection.isClosed()) {
            throw new IllegalStateException("connection is closed already");
        }
        this.connection = connection;
        String driverClass = null;
        driverClass = connection.getMetaData().getDriverName();
        this.databaseExtension = DatabaseExtensionFactory.getDatabaseExtension(driverClass);
    }

    public void refresh() {
        this.loadCatalogs();
    }

    public boolean isSchemaLoaded() {
        return this.schemasLoaded;
    }

    public boolean isCatalogsLoaded() {
        return this.catalogsLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadCatalogs() {
        Connection conn;
        if (this.loadingCatalogs) {
            return false;
        }
        this.loadingCatalogs = true;
        if (Thread.currentThread().isInterrupted()) {
            this.loadingSchemas = false;
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"loadCatalogs");
        }
        if ((conn = this.connection) == null) {
            return false;
        }
        boolean ok = false;
        try {
            this.fireDatamodelEvent("Loading catalogs", 2);
            DatabaseMetaData dbmd = conn.getMetaData();
            if (dbmd != null) {
                this.useLowerCaseIdentifiers = dbmd.storesLowerCaseIdentifiers();
                this.useUpperCaseIdentifiers = dbmd.storesUpperCaseIdentifiers();
                this.userCaseSensitiveIdentifiers = dbmd.storesMixedCaseIdentifiers();
                this.catalogsLoaded = false;
                ResultSet rsCatalogs = dbmd.getCatalogs();
                this.catalogs.clear();
                while (rsCatalogs.next()) {
                    String catName = rsCatalogs.getString("TABLE_CAT");
                    if (catName == null || catName.isEmpty()) continue;
                    this.addCatalog(new SQLCatalog(this, catName));
                }
                rsCatalogs.close();
                if (this.catalogs.isEmpty()) {
                    this.catalogs.add(new DefaultCatalog(this));
                }
                this.catalogsLoaded = true;
            }
        }
        catch (SQLException sqle) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException rsCatalogs) {
                // empty catch block
            }
            this.errorMessage = "loadCatalogs failed: " + sqle.getMessage();
            logger.error((Object)this.errorMessage);
        }
        finally {
            this.loadingCatalogs = false;
        }
        this.fireDatamodelEvent("Loading catalogs finished (" + this.catalogs.size() + ")", 2);
        for (SQLCatalog catalog : this.catalogs) {
            this.loadSchemas(catalog);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSchemas(SQLCatalog catalog) {
        Connection conn;
        if (this.loadingSchemas) {
            return false;
        }
        catalog.setLoadingSchemas(true);
        this.loadingSchemas = true;
        if (Thread.currentThread().isInterrupted()) {
            this.loadingSchemas = false;
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadSchemas for catalog: " + catalog.getName()));
        }
        if ((conn = this.connection) == null) {
            return false;
        }
        boolean ok = false;
        this.fireDatamodelEvent("Loading schemas for catalog", 2);
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            if (dbmd != null) {
                dbmd = conn.getMetaData();
                catalog.clear();
                ResultSet rsSchemas = dbmd.getSchemas();
                while (rsSchemas.next() && !Thread.currentThread().isInterrupted()) {
                    String name = rsSchemas.getString("TABLE_SCHEM");
                    SQLSchema schema = new SQLSchema(this, name);
                    catalog.addSQLSchema(schema);
                }
                rsSchemas.close();
                if (catalog.getCountSchemas() == 0) {
                    DefaultSchema schema = new DefaultSchema(this);
                    catalog.addSQLSchema(schema);
                }
                ok = true;
                this.schemasLoaded = true;
            }
        }
        catch (Exception e) {
            try {
                conn.rollback();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.errorMessage = "loadSchemas (schemas) for catalog: " + catalog.getName() + " failed: " + e.getMessage();
            logger.error((Object)this.errorMessage);
            this.fireDatamodelEvent("Loading schemas failed.", 2);
            boolean bl = false;
            return bl;
        }
        finally {
            this.loadingSchemas = false;
            catalog.setLoadingSchemas(false);
        }
        this.fireDatamodelEvent("Loading catalogs+schemas finished (" + this.catalogs.size() + ")", 2);
        return ok;
    }

    protected void clearCatalogs() {
        this.catalogs.clear();
    }

    public void addCatalog(SQLCatalog catalog) {
        if (!this.catalogs.contains(catalog)) {
            this.catalogs.add(catalog);
        }
    }

    public SQLTable getSQLTable(String schemaName, String tableName) {
        if (!SQLDataModel.isIdentifierName(tableName)) {
            return null;
        }
        for (SQLCatalog cat : this.catalogs) {
            for (SQLSchema schema : cat.getSchemas()) {
                SQLTable table;
                if (!schema.getName().equalsIgnoreCase(schemaName) || (table = schema.getTable(tableName)) == null) continue;
                return table;
            }
        }
        return null;
    }

    public static boolean isIdentifierName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public SQLSchema getSchema(String schemaName) {
        String currentCatalog = null;
        int pos = schemaName.indexOf(46);
        if (pos > 0) {
            currentCatalog = schemaName.substring(0, pos);
        }
        for (SQLCatalog cat : this.catalogs) {
            if (currentCatalog != null && !currentCatalog.equals(cat.getName())) continue;
            for (SQLSchema schema : cat.getSchemas()) {
                if (!schema.getName().equalsIgnoreCase(schemaName)) continue;
                return schema;
            }
        }
        return null;
    }

    public SQLTable getSQLTable(String schemaDotTableName) {
        int pos = schemaDotTableName.indexOf(46);
        if (pos == -1) {
            if (this.currentSQLSchema == null) {
                throw new IllegalStateException("current schema is null");
            }
            return this.currentSQLSchema.getTable(schemaDotTableName);
        }
        String schemaName = schemaDotTableName.substring(0, pos);
        String tableName = schemaDotTableName.substring(pos + 1);
        return this.getSQLTable(schemaName, tableName);
    }

    public SQLField getSQLField(String schemaDotTableDotFieldName) {
        int pos = schemaDotTableDotFieldName.indexOf(46);
        if (pos == -1) {
            throw new IllegalArgumentException(schemaDotTableDotFieldName + " is not a absolute name");
        }
        String schemaName = schemaDotTableDotFieldName.substring(0, pos);
        SQLSchema schema = this.getSchema(schemaName);
        if (schema != null) {
            int pos1 = schemaDotTableDotFieldName.indexOf(46, pos + 1);
            if (pos1 == -1) {
                throw new IllegalArgumentException(schemaDotTableDotFieldName + " is not a absolute name");
            }
            String tableName = schemaDotTableDotFieldName.substring(pos + 1, pos1);
            SQLTable table = schema.getTable(tableName);
            if (table != null) {
                String fieldName = schemaDotTableDotFieldName.substring(pos1);
                return table.getField(fieldName);
            }
        }
        return null;
    }

    public SQLCatalog getSQLCatalog(String name) {
        for (SQLCatalog c : this.catalogs) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public List<SQLCatalog> getCatalogs() {
        return this.catalogs;
    }

    public SQLField getSQLField(String schemaName, String tableName, String fieldName) {
        SQLTable table;
        SQLSchema schema = this.getSchema(schemaName);
        if (schema != null && (table = schema.getTable(tableName)) != null) {
            return table.getField(fieldName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadTables(SQLSchema schema) {
        if (schema.isLoadingTables()) {
            return false;
        }
        schema.setLoadingTables(true);
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadTables schema=" + schema));
        }
        boolean ok = false;
        Connection conn = this.connection;
        if (conn == null) {
            return false;
        }
        try {
            this.fireDatamodelEvent("Loading tables and views...", 2);
            ok = this.databaseExtension.loadTables(conn, schema);
            schema.setTablesLoaded();
        }
        catch (SQLException sqle) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.errorMessage = "loadTables for schema=" + schema + " failed: " + sqle.getMessage();
            this.fireDatamodelEvent("Loading tables failed.", 2);
            boolean bl = false;
            return bl;
        }
        finally {
            schema.setLoadingTables(false);
        }
        this.fireDatamodelEvent("Loading tables and views finished: " + schema.getTableCount() + " tables.", 2);
        return ok;
    }

    public boolean loadSequences(SQLSchema schema) {
        if (this.databaseExtension.hasSequenceFeature()) {
            Connection conn;
            if (schema.isLoadingTables()) {
                return false;
            }
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadSequences schema=" + schema));
            }
            if ((conn = this.connection) == null) {
                return false;
            }
            this.fireDatamodelEvent("Loading sequences...", 2);
            this.databaseExtension.listSequences(conn, schema);
            this.fireDatamodelEvent("Loading sequences for " + schema + " finished: " + schema.getSequenceCount() + " sequences.", 2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProcedures(SQLSchema schema) {
        if (schema.isLoadingProcedures()) {
            return false;
        }
        schema.setLoadingProcedures(true);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadProcedures schema=" + schema));
        }
        boolean ok = false;
        Connection conn = this.connection;
        if (conn == null) {
            return false;
        }
        try {
            this.fireDatamodelEvent("Load procedures for " + schema, 2);
            this.databaseExtension.loadProcedures(conn, schema);
            this.fireDatamodelEvent("Loading procedure source code", 2);
            for (int i = 0; i < schema.getProcedureCount(); ++i) {
                SQLProcedure p = schema.getProcedureAt(i);
                this.databaseExtension.setupProcedureSQLCode(conn, p);
            }
            ok = true;
            this.fireDatamodelEvent("Load procedures for " + schema + " finished: " + schema.getProcedureCount() + " procedures.", 2);
        }
        catch (SQLException sqle) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.errorMessage = "loadProcedures schema=" + schema + " failed: " + sqle.getMessage();
            this.fireDatamodelEvent("Load procedures failed.", 2);
            boolean bl = false;
            return bl;
        }
        finally {
            schema.setLoadingProcedures(false);
        }
        return ok;
    }

    boolean loadColumns(SQLTable table) {
        return this.loadColumns(table, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadColumns(SQLTable table, boolean ignoreIndices) {
        block26: {
            Connection conn;
            if (table.isLoadingColumns()) {
                return false;
            }
            table.setLoadingColumns(true);
            if (Thread.currentThread().isInterrupted()) {
                table.setLoadingColumns(false);
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadColumns table=" + table));
            }
            if ((conn = this.connection) == null) {
                table.setLoadingColumns(false);
                return false;
            }
            try {
                this.fireDatamodelEvent("Load columns for " + table, 2);
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd == null) break block26;
                SQLField field = null;
                try {
                    table.clearFields();
                    ResultSet rs = dbmd.getColumns(table.getSchema().getCatalog().getKey(), table.getSchema().getKey(), table.getName(), null);
                    if (rs != null) {
                        while (rs.next() && !Thread.currentThread().isInterrupted()) {
                            String tableName = rs.getString("TABLE_NAME");
                            if (!table.getName().equalsIgnoreCase(tableName)) continue;
                            String name = rs.getString("COLUMN_NAME");
                            field = new SQLField(this, table, name);
                            field.setType(rs.getInt("DATA_TYPE"));
                            field.setTypeName(rs.getString("TYPE_NAME"));
                            field.setLength(rs.getInt("COLUMN_SIZE"));
                            field.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                            field.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                            field.setNullValueAllowed(rs.getInt("NULLABLE") == 1);
                            this.databaseExtension.setupDataType(field);
                            table.addField(field);
                        }
                        rs.close();
                    }
                    this.fireDatamodelEvent("Loading columns finished", 2);
                    if (table.isView()) {
                        if (table.isMaterializedView() && !ignoreIndices) {
                            this.loadIndexes(table);
                        }
                        if (!ignoreIndices) {
                            this.databaseExtension.setupViewSQLCode(conn, table);
                        }
                    } else {
                        this.loadConstraints(table);
                        if (!ignoreIndices) {
                            this.loadIndexes(table);
                        }
                    }
                    table.setLoadingColumns(false);
                    table.setFieldsLoaded();
                }
                catch (SQLException sqle) {
                    try {
                        try {
                            if (!conn.getAutoCommit()) {
                                conn.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        logger.error((Object)("loadColumns (get columns) for table=" + table + " failed: " + sqle.getMessage()));
                        this.fireDatamodelEvent("Loading columns for table=" + table + " failed", 2);
                        table.setLoadingColumns(false);
                        boolean bl = false;
                        table.setLoadingColumns(false);
                        table.setFieldsLoaded();
                        table.setLoadingColumns(false);
                        table.setFieldsLoaded();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            table.setLoadingColumns(false);
                            table.setFieldsLoaded();
                            throw throwable;
                        }
                        catch (Exception e) {
                            try {
                                conn.rollback();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            logger.error((Object)("loadColumns failed: " + e.getMessage()), (Throwable)e);
                        }
                        catch (Throwable throwable2) {
                            throw throwable2;
                        }
                    }
                }
            }
            finally {
                table.setLoadingColumns(false);
                table.setFieldsLoaded();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConstraints(SQLTable table) {
        block30: {
            Connection conn;
            if (table.isLoadingConstraints()) {
                return false;
            }
            table.setLoadingConstraints(true);
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadConstraints table=" + table));
            }
            if ((conn = this.connection) == null) {
                return false;
            }
            try {
                ResultSet rs;
                this.fireDatamodelEvent("Load primary key constraints for table " + table, 2);
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd == null) break block30;
                table.clearConstraints();
                try {
                    rs = dbmd.getPrimaryKeys(table.getSchema().getCatalog().getKey(), table.getSchema().getKey(), table.getName());
                    if (rs != null) {
                        while (rs.next() && !Thread.currentThread().isInterrupted()) {
                            String tableName = rs.getString("TABLE_NAME");
                            if (!table.getName().equalsIgnoreCase(tableName)) continue;
                            String name = rs.getString("PK_NAME");
                            SQLConstraint constraint = table.getPrimaryKeyConstraint();
                            if (constraint == null) {
                                constraint = new SQLConstraint(this, table, 1, name);
                                table.setPrimaryKeyConstraint(constraint);
                            }
                            constraint.addPrimaryKeyFieldName(rs.getString("COLUMN_NAME"), rs.getShort("KEY_SEQ"));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("pk constraint changed: " + constraint));
                        }
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    try {
                        if (!conn.getAutoCommit()) {
                            conn.rollback();
                        }
                    }
                    catch (SQLException tableName) {
                        // empty catch block
                    }
                    logger.error((Object)("loadConstraints (pk) for table=" + table + " failed: " + sqle.getMessage()));
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException tableName) {
                        // empty catch block
                    }
                    table.setLoadingConstraints(false);
                    boolean tableName = false;
                    table.setLoadingConstraints(false);
                    return tableName;
                }
                if (Thread.currentThread().isInterrupted()) {
                    boolean sqle = false;
                    return sqle;
                }
                try {
                    this.fireDatamodelEvent("Load foreign key constraints for table " + table, 2);
                    rs = dbmd.getImportedKeys(table.getSchema().getCatalog().getKey(), table.getSchema().getKey(), table.getName());
                    if (rs != null) {
                        while (rs.next() && !Thread.currentThread().isInterrupted()) {
                            String name = rs.getString("FK_NAME");
                            String referencedSchema = rs.getString("PKTABLE_SCHEM");
                            String referencedTable = rs.getString("PKTABLE_NAME");
                            SQLConstraint constraint = table.getConstraint(name);
                            if (constraint == null) {
                                constraint = new SQLConstraint(this, table, 2, name);
                                if (referencedSchema == null || referencedSchema.isEmpty()) {
                                    referencedSchema = table.getSchema().getName();
                                }
                                constraint.setReferencedTableName(referencedSchema + "." + referencedTable);
                                table.addConstraint(constraint);
                            }
                            constraint.addForeignKeyColumnNamePair(rs.getString("FKCOLUMN_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getShort("KEY_SEQ"));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("fk constraint changed: " + constraint));
                        }
                        rs.close();
                        table.setConstraintsLoaded();
                    }
                    if (logger.isDebugEnabled()) {
                        List<SQLConstraint> list = table.getConstraints();
                        for (int i = 0; i < list.size(); ++i) {
                            logger.debug((Object)(" * " + list.get(i)));
                        }
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("loadConstraints (fk) for table=" + table + " failed: " + sqle.getMessage()));
                    table.setLoadingConstraints(false);
                    boolean bl = false;
                    table.setLoadingConstraints(false);
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error((Object)("loadConstraints failed: " + e.getMessage()), (Throwable)e);
                boolean bl = false;
                return bl;
            }
            finally {
                table.setLoadingConstraints(false);
            }
        }
        this.fireDatamodelEvent("Loading constraints finished", 2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadIndexes(SQLTable table) {
        Connection conn;
        if (table.isLoadingIndexes()) {
            return false;
        }
        table.setLoadingIndexes(true);
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadIndexes table=" + table));
        }
        if ((conn = this.connection) == null) {
            return false;
        }
        try {
            this.fireDatamodelEvent("Load indexes for table " + table, 2);
            DatabaseMetaData dbmd = conn.getMetaData();
            if (dbmd != null) {
                table.clearIndexes();
                SQLIndex index = null;
                ResultSet rs = dbmd.getIndexInfo(null, table.getSchema().getName(), table.getName(), false, true);
                if (rs != null) {
                    while (rs.next() && !Thread.currentThread().isInterrupted()) {
                        String indexName;
                        String tableName = rs.getString("TABLE_NAME");
                        if (!table.getName().equalsIgnoreCase(tableName) || (indexName = rs.getString("INDEX_NAME")) == null) continue;
                        boolean unique = false;
                        Object nonUnique = rs.getObject("NON_UNIQUE");
                        if (nonUnique instanceof Boolean) {
                            unique = (Boolean)nonUnique == false;
                        } else if (nonUnique instanceof Integer) {
                            unique = (Integer)nonUnique == 0;
                        } else if (nonUnique instanceof String) {
                            unique = !Boolean.parseBoolean((String)nonUnique);
                        }
                        short type = rs.getShort("TYPE");
                        short ordinalPosition = rs.getShort("ORDINAL_POSITION");
                        String columnName = rs.getString("COLUMN_NAME");
                        String sortOrder = rs.getString("ASC_OR_DESC");
                        int cardinality = rs.getInt("CARDINALITY");
                        String filterCondition = rs.getString("FILTER_CONDITION");
                        index = table.getIndexByName(indexName);
                        if (index == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("add index " + indexName));
                            }
                            index = new SQLIndex(table.getModel(), indexName, table);
                            index.setUnique(unique);
                            index.setType(type);
                            index.setCardinality(cardinality);
                            index.setFilterCondition(filterCondition);
                            table.addIndex(index);
                        }
                        index.addIndexField(columnName, ordinalPosition, sortOrder);
                    }
                    table.setIndexesLoaded();
                    rs.close();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            try {
                if (!conn.getAutoCommit()) {
                    conn.rollback();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            logger.error((Object)("loadIndexes failed: " + e.getMessage()), (Throwable)e);
            this.fireDatamodelEvent("Load indexes for table " + table + " failed.", 2);
            boolean bl = false;
            return bl;
        }
        finally {
            table.setLoadingIndexes(false);
        }
        return false;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }

    public static void removeViews(SQLSchema schema) {
        SQLTable sqlTable = null;
        for (int x = 0; x < schema.getTableCount(); ++x) {
            sqlTable = schema.getTableAt(x);
            if (!sqlTable.getType().equals("VIEW")) continue;
            schema.removeSQLTable(sqlTable);
            --x;
        }
    }

    public List<SQLSchema> getSchemas() {
        ArrayList<SQLSchema> list = new ArrayList<SQLSchema>();
        for (SQLCatalog c : this.catalogs) {
            for (SQLSchema s : c.getSchemas()) {
                if (list.contains(s)) continue;
                list.add(s);
            }
        }
        return list;
    }

    public DatabaseExtension getDatabaseExtension() {
        return this.databaseExtension;
    }

    public void setConnection(Connection connection) {
        if (this.connection == null) {
            throw new IllegalStateException("Use the method setConnection only to renew an existing connection!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null!");
        }
        this.connection = connection;
    }

    public void setCurrentSQLSchema(SQLSchema currentSQLSchema) {
        this.currentSQLSchema = currentSQLSchema;
    }

    @Override
    public int compareTo(SQLDataModel o) {
        return 0;
    }
}

