/*
 * Decompiled with CFR 0.152.
 */
package de.jlo.datamodel;

import de.jlo.datamodel.SQLDataModel;
import de.jlo.datamodel.SQLObject;
import de.jlo.datamodel.SQLSchema;
import java.util.ArrayList;
import java.util.List;

public class SQLCatalog
extends SQLObject {
    private List<SQLSchema> schemas = new ArrayList<SQLSchema>();
    private boolean schemasLoaded = false;
    private boolean loadingSchemas = false;

    public SQLCatalog(SQLDataModel model, String name) {
        super(model, name);
    }

    public List<SQLSchema> getSchemas() {
        return this.schemas;
    }

    public int getCountSchemas() {
        return this.schemas.size();
    }

    public SQLSchema getSchemaAt(int index) {
        return this.schemas.get(index);
    }

    public void addSQLSchema(SQLSchema schema) {
        if (!this.schemas.contains(schema)) {
            this.schemas.add(schema);
            schema.setCatalog(this);
        }
    }

    public void clear() {
        this.schemas.clear();
        this.schemasLoaded = false;
    }

    public SQLSchema getSQLSchema(String name) {
        if (name == null) {
            return null;
        }
        for (SQLSchema s : this.schemas) {
            if (!name.equalsIgnoreCase(s.getName())) continue;
            return s;
        }
        return null;
    }

    public void setLoadingSchemas(boolean loading) {
        this.loadingSchemas = loading;
    }

    public boolean isSchemasLoaded() {
        return this.schemasLoaded;
    }

    public boolean loadSchemas() {
        this.schemasLoaded = this.getModel().loadSchemas(this);
        return this.schemasLoaded;
    }

    public boolean isLoadingSchemas() {
        return this.loadingSchemas;
    }
}

