/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.xml;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import sqlrunner.DBMessageDialog;
import sqlrunner.LongRunningAction;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.base64.Base64;
import sqlrunner.dbext.DatabaseExtension;
import sqlrunner.dbext.DatabaseExtensionFactory;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.resources.ApplicationIcons;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.xml.ExportQueryEditor;
import sqlrunner.xml.Messages;
import sqlrunner.xml.XMLWriter;

public final class ExporterFrame
extends JFrame
implements ActionListener {
    private static final Logger logger = Logger.getLogger(ExporterFrame.class);
    private static final long serialVersionUID = 1L;
    private ExporterFrame self;
    private final List<String> schemas = new ArrayList<String>();
    private final List<String> tables = new ArrayList<String>();
    private LargeListModel listModel = null;
    private JList<ExportDescription> list = null;
    private JScrollPane scrollPaneList = null;
    private JPanel panelSchema = null;
    private JTextField jTextFieldSchema = null;
    private JTextField jTextFieldFetchSize = null;
    private JPanel panelTop = null;
    private JPanel panelTableButtons = null;
    private JPanel panelTables = null;
    private JButton buttonReload = null;
    private JButton buttonRemoveSelected = null;
    private JButton buttonRemoveUnselected = null;
    private JButton buttonEditSQL = null;
    private JPanel panelFile = null;
    private JTextField textFieldTargetDirectory = null;
    private JButton buttonOpenFile = null;
    private JCheckBox checkboxBase64Coding = null;
    private JCheckBox checkBoxFormatXMLOutput = null;
    private JPanel panelButton = null;
    private JButton buttonStart = null;
    private JButton buttonInterrupt = null;
    private JButton buttonClose = null;
    private final StatusBar status = new StatusBar();
    private transient XMLExporter exporter = null;
    private File targetDirectory;
    private ConnectionDescription cd;
    private ExportQueryEditor queryEditor;
    private JPanel jContentPane = null;
    private boolean enableBinary = false;

    public ExporterFrame(ConnectionDescription cd, Window parent) {
        this.self = this;
        this.setTitle(Messages.getString("ExporterFrame.title"));
        try {
            this.initComponents();
            this.pack();
            this.cd = cd;
            WindowHelper.locateWindowAtMiddle(parent, this);
            this.setVisible(true);
            DatabaseExtension ext = DatabaseExtensionFactory.getDatabaseExtension(cd);
            this.jTextFieldSchema.setText(ext.getLoginSchema(cd));
            SimpleMetaReader reader = new SimpleMetaReader(cd, this.jTextFieldSchema.getText());
            reader.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean close() {
        if (this.exporter != null && this.exporter.isRunning()) {
            int answer = JOptionPane.showConfirmDialog(this, Messages.getString("ExporterFrame.interruptQuestion"), Messages.getString("ExporterFrame.close"), 0, 1);
            if (answer == 0) {
                this.exporter.abort();
            } else {
                return false;
            }
        }
        this.dispose();
        return true;
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 201: {
                if (!this.close()) break;
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    private void initComponents() {
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 0;
            gb.fill = 1;
            gb.weightx = 1.0;
            gb.weighty = 1.0;
            this.jContentPane.add((Component)this.getPanelTop(), gb);
            gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 1;
            gb.fill = 0;
            gb.weightx = 0.0;
            gb.weighty = 0.0;
            this.jContentPane.add((Component)this.getPanelButton(), gb);
            gb = new GridBagConstraints();
            gb.gridx = 0;
            gb.gridy = 2;
            gb.fill = 2;
            gb.weightx = 1.0;
            gb.weighty = 0.0;
            gb.anchor = 15;
            this.jContentPane.add((Component)this.status, gb);
        }
        return this.jContentPane;
    }

    private JPanel getPanelFile() {
        if (this.panelFile == null) {
            this.panelFile = new JPanel();
            this.panelFile.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Messages.getString("ExporterFrame.exporttarget")));
            this.panelFile.setPreferredSize(new Dimension(390, 100));
            this.panelFile.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 0;
            JLabel label = new JLabel();
            label.setBackground(Color.black);
            label.setHorizontalAlignment(2);
            label.setText(Messages.getString("ExporterFrame.directory"));
            this.panelFile.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.gridwidth = 2;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.textFieldTargetDirectory = new JTextField();
            this.panelFile.add((Component)this.textFieldTargetDirectory, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 3;
            gbc.gridy = 0;
            this.buttonOpenFile = new JButton();
            this.buttonOpenFile.addActionListener(this);
            this.buttonOpenFile.setIcon(ApplicationIcons.OPEN_GIF);
            this.panelFile.add((Component)this.buttonOpenFile, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.anchor = 17;
            gbc.gridwidth = 2;
            this.checkboxBase64Coding = new JCheckBox();
            this.checkboxBase64Coding.setText(Messages.getString("ExporterFrame.encodeinbase64"));
            this.panelFile.add((Component)this.checkboxBase64Coding, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 2;
            gbc.gridy = 1;
            gbc.gridwidth = 2;
            this.checkBoxFormatXMLOutput = new JCheckBox();
            this.checkBoxFormatXMLOutput.setText(Messages.getString("ExporterFrame.formatxml"));
            this.panelFile.add((Component)this.checkBoxFormatXMLOutput, gbc);
        }
        return this.panelFile;
    }

    private JPanel getPanelButton() {
        if (this.panelButton == null) {
            this.panelButton = new JPanel();
            this.buttonStart = new JButton();
            this.buttonStart.setText(Messages.getString("ExporterFrame.start"));
            this.buttonStart.addActionListener(this);
            this.panelButton.add(this.buttonStart);
            this.buttonInterrupt = new JButton();
            this.buttonInterrupt.setText(Messages.getString("ExporterFrame.cancel"));
            this.buttonInterrupt.addActionListener(this);
            this.buttonInterrupt.setEnabled(false);
            this.panelButton.add(this.buttonInterrupt);
            this.buttonClose = new JButton();
            this.buttonClose.setText(Messages.getString("ExporterFrame.close"));
            this.buttonClose.addActionListener(this);
            this.panelButton.add(this.buttonClose);
        }
        return this.panelButton;
    }

    private JPanel getPanelTop() {
        if (this.panelTop == null) {
            this.panelTop = new JPanel();
            this.panelTop.setLayout(new BorderLayout());
            this.panelTop.add((Component)this.getPanelSchema(), "North");
            this.panelTop.add((Component)this.getPanelTables(), "Center");
            this.panelTop.add((Component)this.getPanelFile(), "South");
        }
        return this.panelTop;
    }

    private JPanel getPanelSchema() {
        if (this.panelSchema == null) {
            this.panelSchema = new JPanel();
            this.panelSchema.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            JLabel label = new JLabel();
            label.setText("Schema");
            this.panelSchema.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.anchor = 10;
            gbc.gridx = 1;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jTextFieldSchema = new JTextField();
            this.panelSchema.add((Component)this.jTextFieldSchema, gbc);
            gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.insets = new Insets(2, 2, 2, 2);
            label = new JLabel();
            label.setText("fetchSize");
            this.panelSchema.add((Component)label, gbc);
            gbc = new GridBagConstraints();
            gbc.anchor = 10;
            gbc.gridx = 1;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jTextFieldFetchSize = new JTextField();
            this.jTextFieldFetchSize.setText("1000");
            this.panelSchema.add((Component)this.jTextFieldFetchSize, gbc);
        }
        return this.panelSchema;
    }

    private JPanel getPanelTables() {
        if (this.panelTables == null) {
            this.panelTables = new JPanel();
            this.panelTables.setPreferredSize(new Dimension(182, 160));
            this.panelTables.setLayout(new BorderLayout());
            this.panelTables.add((Component)this.getScrollPaneList(), "Center");
            this.panelTables.add((Component)this.getPanelTableButtons(), "East");
            this.panelTables.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), Messages.getString("ExporterFrame.tables")));
        }
        return this.panelTables;
    }

    private JPanel getPanelTableButtons() {
        if (this.panelTableButtons == null) {
            this.panelTableButtons = new JPanel();
            this.panelTableButtons.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.buttonReload = new JButton();
            this.buttonReload.setText(Messages.getString("ExporterFrame.loadtables"));
            this.buttonReload.addActionListener(this);
            this.panelTableButtons.add((Component)this.buttonReload, gbc);
            gbc = new GridBagConstraints();
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.gridx = 0;
            gbc.gridy = 1;
            gbc.fill = 2;
            gbc.anchor = 17;
            this.buttonRemoveSelected = new JButton();
            this.buttonRemoveSelected.setText(Messages.getString("ExporterFrame.removeselected"));
            this.buttonRemoveSelected.addActionListener(this);
            this.panelTableButtons.add((Component)this.buttonRemoveSelected, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 2;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.buttonRemoveUnselected = new JButton();
            this.buttonRemoveUnselected.setText(Messages.getString("ExporterFrame.removenotselected"));
            this.buttonRemoveUnselected.addActionListener(this);
            this.panelTableButtons.add((Component)this.buttonRemoveUnselected, gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 3;
            gbc.fill = 2;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.buttonEditSQL = new JButton();
            this.buttonEditSQL.setText(Messages.getString("ExporterFrame.editsql"));
            this.buttonEditSQL.addActionListener(this);
            this.panelTableButtons.add((Component)this.buttonEditSQL, gbc);
        }
        return this.panelTableButtons;
    }

    private JScrollPane getScrollPaneList() {
        if (this.scrollPaneList == null) {
            this.scrollPaneList = new JScrollPane();
            this.scrollPaneList.setViewportView(this.getList());
        }
        return this.scrollPaneList;
    }

    private LargeListModel getListModel() {
        if (this.listModel == null) {
            this.listModel = new LargeListModel();
        }
        return this.listModel;
    }

    private JList<ExportDescription> getList() {
        if (this.list == null) {
            this.list = new JList<ExportDescription>(this.getListModel());
        }
        return this.list;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonOpenFile) {
            File f;
            JFileChooser chooser = new JFileChooser();
            if (this.targetDirectory != null) {
                if (this.targetDirectory.getParentFile() != null) {
                    chooser.setCurrentDirectory(this.targetDirectory.getParentFile());
                }
            } else {
                String directory = Main.getUserProperty("EXPORT_DATAFILE_DIR", System.getProperty("user.home"));
                f = new File(directory);
                if (f.getParentFile() != null) {
                    f = f.getParentFile();
                }
                chooser.setCurrentDirectory(f);
            }
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Messages.getString("ExporterFrame.chooseexporttarget"));
            chooser.setFileSelectionMode(1);
            int returnVal = chooser.showOpenDialog(this);
            if (returnVal == 0) {
                f = chooser.getSelectedFile();
                Main.setUserProperty("EXPORT_DATAFILE_DIR", f.toString());
                this.textFieldTargetDirectory.setText(f.getAbsolutePath());
            }
        } else if (e.getSource() == this.buttonInterrupt) {
            if (this.exporter != null && this.exporter.isAlive()) {
                this.exporter.interrupt();
            }
        } else if (e.getSource() == this.buttonStart) {
            if (this.textFieldTargetDirectory.getText() != null && this.textFieldTargetDirectory.getText().length() > 0) {
                this.exporter = new XMLExporter(this, this.cd, this.textFieldTargetDirectory.getText(), this.checkboxBase64Coding.isSelected());
                this.exporter.start();
            } else {
                JOptionPane.showMessageDialog(this, Messages.getString("ExporterFrame.chooseexporttarget"), Messages.getString("ExporterFrame.startexport"), 1);
            }
        } else if (e.getSource() == this.buttonReload) {
            this.listModel.clear();
            new SimpleMetaReader(this.cd, this.jTextFieldSchema.getText()).start();
        } else if (e.getSource() == this.buttonRemoveSelected) {
            List<ExportDescription> selectedItems = this.list.getSelectedValuesList();
            for (int i = 0; i < selectedItems.size(); ++i) {
                this.listModel.removeElement(selectedItems.get(i));
            }
        } else if (e.getSource() == this.buttonRemoveUnselected) {
            List<ExportDescription> selectedItems = this.list.getSelectedValuesList();
            ExportDescription[] allItems = this.listModel.toArray();
            boolean toDelete = false;
            for (int i = 0; i < allItems.length; ++i) {
                toDelete = true;
                for (int j = 0; j < selectedItems.size(); ++j) {
                    if (selectedItems.get(i) != allItems[i]) continue;
                    toDelete = false;
                }
                if (!toDelete) continue;
                this.listModel.removeElement(allItems[i]);
            }
        } else if (e.getSource() == this.buttonEditSQL) {
            ExportDescription selectedExpDesc = this.list.getSelectedValue();
            if (selectedExpDesc != null) {
                this.queryEditor = new ExportQueryEditor(this);
                this.queryEditor.setText(selectedExpDesc.getSql());
                this.queryEditor.setVisible(true);
                if (this.queryEditor.getReturnCode() == 0) {
                    selectedExpDesc.setSql(this.queryEditor.getText());
                    this.list.repaint();
                }
            }
        } else if (e.getSource() == this.buttonClose) {
            this.close();
        }
    }

    public class LargeListModel
    extends AbstractListModel<ExportDescription> {
        private static final long serialVersionUID = 1L;
        private List<ExportDescription> delegate = new ArrayList<ExportDescription>();

        @Override
        public int getSize() {
            return this.delegate.size();
        }

        @Override
        public ExportDescription getElementAt(int index) {
            return this.delegate.get(index);
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public boolean contains(Object elem) {
            return this.delegate.contains(elem);
        }

        public int indexOf(Object elem) {
            return this.delegate.indexOf(elem);
        }

        public int lastIndexOf(Object elem) {
            return this.delegate.lastIndexOf(elem);
        }

        public void addElements(ArrayList<ExportDescription> objectList) {
            if (objectList != null && !objectList.isEmpty()) {
                int index = this.delegate.size();
                this.delegate.addAll(objectList);
                this.fireIntervalAdded(this, index, this.delegate.size() - 1);
            }
        }

        public boolean removeElement(Object obj) {
            int index = this.indexOf(obj);
            boolean rv = this.delegate.remove(obj);
            if (index >= 0) {
                this.fireIntervalRemoved(this, index, index);
            }
            return rv;
        }

        public String toString() {
            return this.delegate.toString();
        }

        public Object get(int index) {
            return this.delegate.get(index);
        }

        public ExportDescription set(int index, ExportDescription element) {
            ExportDescription rv = this.delegate.remove(index);
            this.delegate.add(index, element);
            this.fireContentsChanged(this, index, index);
            return rv;
        }

        public void add(int index, ExportDescription element) {
            this.delegate.add(index, element);
            this.fireIntervalAdded(this, index, index);
        }

        public ExportDescription remove(int index) {
            ExportDescription rv = this.delegate.get(index);
            this.delegate.remove(index);
            this.fireIntervalRemoved(this, index, index);
            return rv;
        }

        public void clear() {
            int index1 = this.delegate.size() - 1;
            this.delegate.clear();
            if (index1 >= 0) {
                this.fireIntervalRemoved(this, 0, index1);
            }
        }

        public void removeRange(int fromIndex, int toIndex) {
            for (int i = toIndex; i >= fromIndex; --i) {
                this.delegate.remove(i);
            }
            this.fireIntervalRemoved(this, fromIndex, toIndex);
        }

        public ExportDescription[] toArray() {
            ExportDescription[] array = new ExportDescription[this.delegate.size()];
            for (int i = 0; i < this.delegate.size(); ++i) {
                array[i] = this.delegate.get(i);
            }
            return array;
        }
    }

    private class XMLExporter
    extends Thread {
        private Logger exportLogger = null;
        private JFrame frame;
        private boolean refreshNow = false;
        private DatabaseSession exportSession;
        private String targetDirectory;
        private boolean codeStringInBase64 = false;
        private long stopTime = 0L;
        private String logFileName = null;
        private FileAppender fileAppender = null;
        boolean ignoreErrors = false;

        public XMLExporter(JFrame frame, ConnectionDescription cd, String targetDirectory, boolean codeStringInBase64) {
            this.frame = frame;
            int fetchSize = 100;
            try {
                fetchSize = Integer.parseInt(ExporterFrame.this.jTextFieldFetchSize.getText());
            }
            catch (Exception e) {
                fetchSize = 100;
                ExporterFrame.this.jTextFieldFetchSize.setText(String.valueOf(fetchSize));
            }
            ConnectionDescription cdExport = cd.clone();
            cdExport.setDefaultFetchSize(fetchSize);
            cdExport.setAutoCommit(false);
            this.exportSession = new DatabaseSession(cdExport);
            this.targetDirectory = targetDirectory;
            this.codeStringInBase64 = codeStringInBase64;
        }

        private FileAppender createFileAppender(String baseDir) throws IOException {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("createFileAppender fileName=" + baseDir));
            }
            SimpleDateFormat sdfLocal = new SimpleDateFormat("yyyy.MM.dd_HH_mm_ss");
            this.logFileName = baseDir + "/xml-export-" + sdfLocal.format(new Date()) + ".log";
            FileAppender appender = new FileAppender();
            appender.setFile(this.logFileName, false, true, 8000);
            PatternLayout layout = new PatternLayout();
            layout.setConversionPattern("%d %-5p %m%n");
            appender.setLayout((Layout)layout);
            appender.setImmediateFlush(true);
            return appender;
        }

        private void closeFileAppender() {
            if (this.fileAppender != null) {
                this.fileAppender.close();
                if (this.exportLogger != null) {
                    this.exportLogger.removeAppender((Appender)this.fileAppender);
                }
            }
        }

        private void setupLocalLoggerWithFileAppender(String baseDir) throws IOException {
            this.fileAppender = this.createFileAppender(baseDir);
            this.setupLocalLogger(baseDir).addAppender((Appender)this.fileAppender);
        }

        private Logger setupLocalLogger(String baseDir) {
            File f = new File(baseDir);
            this.exportLogger = Logger.getLogger((String)(this.getClass().getName() + "-" + f.getName()));
            return this.exportLogger;
        }

        private void setRefreshNow() {
            this.refreshNow = true;
        }

        private void setIgnoreErrors(boolean ignore) {
            this.ignoreErrors = ignore;
        }

        private boolean isIgnoreErrors() {
            return this.ignoreErrors;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.stopTime = 0L;
                try {
                    this.setupLocalLoggerWithFileAppender(this.targetDirectory);
                    this.exportSession.setLogger(this.exportLogger);
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                ExporterFrame.this.disableEvents(64L);
                LongRunningAction lra = new LongRunningAction(){

                    @Override
                    public String getName() {
                        return "XML Export";
                    }

                    @Override
                    public void cancel() {
                    }

                    @Override
                    public boolean canBeCanceled() {
                        return false;
                    }
                };
                MainFrame.addLongRunningAction(lra);
                try {
                    ExporterFrame.this.buttonInterrupt.setEnabled(true);
                    ExporterFrame.this.buttonStart.setEnabled(false);
                    ExporterFrame.this.buttonReload.setEnabled(false);
                    ExporterFrame.this.buttonRemoveSelected.setEnabled(false);
                    ExporterFrame.this.buttonClose.setEnabled(false);
                    ExporterFrame.this.checkboxBase64Coding.setEnabled(false);
                    ExporterFrame.this.buttonOpenFile.setEnabled(false);
                    ExporterFrame.this.textFieldTargetDirectory.setEnabled(false);
                    ExporterFrame.this.buttonRemoveUnselected.setEnabled(false);
                    ((ExporterFrame)ExporterFrame.this).status.infoLabel.setBackground(Color.red);
                    int refreshTime = 2000;
                    Timer timer = new Timer(2000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            XMLExporter.this.setRefreshNow();
                        }
                    });
                    timer.setRepeats(true);
                    timer.start();
                    for (int t = 0; t < ExporterFrame.this.listModel.size() && !this.isInterrupted(); ++t) {
                        ExportDescription exportDesc = (ExportDescription)ExporterFrame.this.listModel.get(t);
                        String tableName = exportDesc.getTableName();
                        XMLWriter xmlWriter = null;
                        ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText("select " + tableName);
                        String sql = exportDesc.getSql();
                        if (sql == null) {
                            sql = "select * from " + tableName;
                        }
                        ResultSet rs = this.exportSession.executeQuery(sql);
                        if (!this.exportSession.isSuccessful()) {
                            if (this.isIgnoreErrors()) continue;
                            DBMessageDialog md = new DBMessageDialog(this.frame, this.exportSession.getLastErrorMessage(), "execute Query");
                            if (md.getReturnCode() == 2) break;
                            if (md.getReturnCode() == 1) {
                                this.setIgnoreErrors(true);
                            }
                        } else {
                            try {
                                xmlWriter = new XMLWriter(new FileOutputStream(new File(this.targetDirectory, tableName + ".xml")));
                                xmlWriter.setFormatOutput(ExporterFrame.this.checkBoxFormatXMLOutput.isSelected());
                                xmlWriter.writeXMLBegin();
                                xmlWriter.writeTagBegin(tableName.toLowerCase(), null);
                            }
                            catch (IOException ioe) {
                                this.exportLogger.error((Object)("XMLExport failed: " + ioe.toString()));
                                new DBMessageDialog(this.frame, ioe.toString(), "create export file");
                                break;
                            }
                            if (rs != null) {
                                try {
                                    ResultSetMetaData rsmd = rs.getMetaData();
                                    int cols = rsmd.getColumnCount();
                                    Object[] resultRow = new Object[cols];
                                    int[] types = new int[cols];
                                    String[] columnNames = new String[cols];
                                    for (int i = 0; i < cols; ++i) {
                                        columnNames[i] = rsmd.getColumnName(i + 1).toLowerCase();
                                        types[i] = BasicDataType.getBasicTypeByTypes(rsmd.getColumnType(i + 1));
                                    }
                                    int rownum = 0;
                                    while (rs.next()) {
                                        if (this.isInterrupted()) {
                                            ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText(Messages.getString("ExporterFrame.abortexport") + String.valueOf(rownum) + " " + Messages.getString("ExporterFrame.datasetsexported"));
                                            break;
                                        }
                                        xmlWriter.writeTagBegin("row", null);
                                        for (int i = 0; i < cols; ++i) {
                                            resultRow[i] = null;
                                            if (BasicDataType.isDateType(types[i])) {
                                                resultRow[i] = rs.getTimestamp(i + 1);
                                                continue;
                                            }
                                            if (BasicDataType.isNumberType(types[i])) {
                                                resultRow[i] = rs.getString(i + 1);
                                                continue;
                                            }
                                            if (BasicDataType.CLOB.getId() == types[i]) {
                                                if (rs.getObject(i + 1) == null) continue;
                                                Clob clob = rs.getClob(i + 1);
                                                resultRow[i] = clob.getSubString(1L, (int)clob.length());
                                                continue;
                                            }
                                            if (BasicDataType.isStringType(types[i])) {
                                                resultRow[i] = rs.getString(i + 1);
                                                continue;
                                            }
                                            if (BasicDataType.BINARY.getId() != types[i] || rs.getObject(i + 1) == null) continue;
                                            resultRow[i] = rs.getBinaryStream(i + 1);
                                        }
                                        this.processDataSet(xmlWriter, resultRow, columnNames, types);
                                        xmlWriter.writeTagEnd();
                                        ++rownum;
                                        if (!this.refreshNow) continue;
                                        this.refreshNow = false;
                                        ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText(tableName + ": " + String.valueOf(rownum) + " " + Messages.getString("ExporterFrame.datasetsexported"));
                                    }
                                    if (this.isInterrupted()) {
                                        ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText(tableName + ": " + String.valueOf(rownum) + " " + Messages.getString("ExporterFrame.datasetsexportedabort"));
                                    }
                                    ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText(tableName + ": " + String.valueOf(rownum) + " " + Messages.getString("ExporterFrame.datasetsexportready"));
                                }
                                catch (SQLException sqle) {
                                    JOptionPane.showMessageDialog(ExporterFrame.this.self, sqle.getMessage(), Messages.getString("ExporterFrame.readqueryresult"), 0);
                                }
                                catch (IOException ioe) {
                                    JOptionPane.showMessageDialog(ExporterFrame.this.self, ioe.getMessage(), Messages.getString("ExporterFrame.writequery"), 0);
                                }
                                finally {
                                    try {
                                        if (rs != null) {
                                            rs.close();
                                        }
                                    }
                                    catch (SQLException sqle) {
                                        sqle.printStackTrace();
                                    }
                                }
                            } else {
                                ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText(Messages.getString("ExporterFrame.Errornoresultforquery"));
                            }
                        }
                        if (xmlWriter == null) continue;
                        try {
                            xmlWriter.writeTagEnd();
                            xmlWriter.close();
                            continue;
                        }
                        catch (IOException e) {
                            this.exportLogger.error((Object)("write document end tag failed: " + e.getMessage()), (Throwable)e);
                            JOptionPane.showMessageDialog(ExporterFrame.this.self, e.getMessage(), Messages.getString("ExporterFrame.writequery"), 0);
                        }
                    }
                    timer.stop();
                    ((ExporterFrame)ExporterFrame.this).status.infoLabel.setText("DISC");
                    ((ExporterFrame)ExporterFrame.this).status.infoLabel.setToolTipText(Messages.getString("ExporterFrame.notconnected"));
                    ((ExporterFrame)ExporterFrame.this).status.infoLabel.setBackground(new Color(204, 204, 204));
                    ExporterFrame.this.buttonInterrupt.setEnabled(false);
                    ExporterFrame.this.buttonStart.setEnabled(true);
                    ExporterFrame.this.buttonReload.setEnabled(true);
                    ExporterFrame.this.buttonRemoveSelected.setEnabled(true);
                    ExporterFrame.this.buttonClose.setEnabled(true);
                    ExporterFrame.this.checkboxBase64Coding.setEnabled(true);
                    ExporterFrame.this.buttonOpenFile.setEnabled(true);
                    ExporterFrame.this.textFieldTargetDirectory.setEnabled(true);
                    ExporterFrame.this.buttonRemoveUnselected.setEnabled(true);
                    ((ExporterFrame)ExporterFrame.this).status.infoLabel.setBackground(Color.lightGray);
                }
                finally {
                    MainFrame.removeLongRunningAction(lra);
                }
                ExporterFrame.this.enableEvents(64L);
                this.stopTime = System.currentTimeMillis();
            }
            finally {
                this.closeFileAppender();
                if (this.exportSession != null) {
                    this.exportSession.close();
                }
            }
        }

        private void processDataSet(XMLWriter xmlWriter, Object[] resultRow, String[] columnNames, int[] types) throws IOException {
            String[][] attributes = new String[1][2];
            for (int i = 0; i < columnNames.length; ++i) {
                Object content = resultRow[i];
                if (content == null) continue;
                if (BasicDataType.isDateType(types[i])) {
                    xmlWriter.writeTagBegin(columnNames[i], null);
                    if (content instanceof Timestamp) {
                        xmlWriter.writeTextContent(String.valueOf(((Timestamp)content).getTime()));
                    } else if (content instanceof Time) {
                        xmlWriter.writeTextContent(String.valueOf(((Time)content).getTime()));
                    }
                    xmlWriter.writeTagEnd();
                    continue;
                }
                if (BasicDataType.isNumberType(types[i])) {
                    xmlWriter.writeTagBegin(columnNames[i], null);
                    if (content != null) {
                        xmlWriter.writeTextContent(content.toString());
                    }
                    xmlWriter.writeTagEnd();
                    continue;
                }
                if (BasicDataType.CLOB.getId() == types[i]) {
                    attributes[0][0] = "code";
                    attributes[0][1] = "base64";
                    xmlWriter.writeTagBegin(columnNames[i], attributes);
                    if (content != null) {
                        xmlWriter.writeCDATAContent(Base64.toString(Base64.encode(((String)content).getBytes("UTF-16")), true));
                    }
                    xmlWriter.writeTagEnd();
                    continue;
                }
                if (BasicDataType.isStringType(types[i])) {
                    if (this.codeStringInBase64) {
                        attributes[0][0] = "code";
                        attributes[0][1] = "base64";
                        xmlWriter.writeTagBegin(columnNames[i], attributes);
                        if (content != null) {
                            xmlWriter.writeCDATAContent(Base64.toString(Base64.encode(((String)content).getBytes("UTF-16")), true));
                        }
                    } else {
                        xmlWriter.writeTagBegin(columnNames[i], null);
                        if (content != null) {
                            xmlWriter.writeTextContent((String)content);
                        }
                    }
                    xmlWriter.writeTagEnd();
                    continue;
                }
                if (!ExporterFrame.this.enableBinary || BasicDataType.BINARY.getId() != types[i]) continue;
                attributes[0][0] = "code";
                attributes[0][1] = "base64";
                xmlWriter.writeTagBegin(columnNames[i], attributes);
                if (content != null) {
                    byte[] buffer = new byte[24];
                    int length = -1;
                    StringBuffer sb = new StringBuffer();
                    InputStream is = (InputStream)content;
                    while ((length = is.read(buffer)) != -1) {
                        sb.append(Base64.toString(Base64.encode(buffer, length)));
                    }
                    is.close();
                    xmlWriter.writeCDATAContent(sb.toString());
                }
                xmlWriter.writeTagEnd();
            }
        }

        public boolean isRunning() {
            return this.stopTime == 0L;
        }

        public void abort() {
            this.interrupt();
        }
    }

    private static class ExportDescription {
        private String tableName;
        private String sql;
        private String defaultSql;

        private ExportDescription() {
        }

        public String getSql() {
            if (this.sql == null) {
                return this.defaultSql;
            }
            return this.sql;
        }

        public void setSql(String sql_loc) {
            this.sql = sql_loc != null ? (!(sql_loc = sql_loc.trim()).equals(this.defaultSql) && sql_loc.length() > 10 ? sql_loc : null) : null;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName_loc) {
            this.tableName = tableName_loc;
            this.defaultSql = "select * from " + tableName_loc;
        }

        public String toString() {
            if (this.sql != null) {
                return "* " + this.tableName;
            }
            return this.tableName;
        }
    }

    private class SimpleMetaReader
    extends Thread {
        private final Logger logger = Logger.getLogger(SimpleMetaReader.class);
        private String user;
        private DatabaseSession session;

        SimpleMetaReader(ConnectionDescription cd, String schema) {
            this.user = schema;
            this.session = new DatabaseSession();
            this.session.setConnectionDescription(cd);
            this.session.connect();
        }

        @Override
        public void run() {
            ExporterFrame.this.buttonReload.setEnabled(false);
            ((ExporterFrame)ExporterFrame.this).status.infoLabel.setBackground(Color.red);
            Connection conn = this.session.getConnection();
            if (conn != null) {
                try {
                    DatabaseMetaData dbmd;
                    if (!conn.isClosed() && (dbmd = conn.getMetaData()) != null) {
                        String schema = null;
                        ExporterFrame.this.schemas.clear();
                        ((ExporterFrame)ExporterFrame.this).status.messageLabel.setText(Messages.getString("ExporterFrame.loadschemas"));
                        ResultSet rs = dbmd.getSchemas();
                        if (rs != null) {
                            while (rs.next()) {
                                schema = rs.getString("TABLE_SCHEM");
                                ExporterFrame.this.schemas.add(schema);
                            }
                            rs.close();
                        }
                        for (int i = 0; i < ExporterFrame.this.schemas.size() && !this.user.equalsIgnoreCase(schema = (String)ExporterFrame.this.schemas.get(i)); ++i) {
                            schema = null;
                        }
                        if (schema == null) {
                            schema = "";
                        }
                        String table = null;
                        String type = null;
                        ExporterFrame.this.tables.clear();
                        ExportDescription exportDesc = null;
                        ArrayList<ExportDescription> list = new ArrayList<ExportDescription>();
                        ResultSet rs1 = dbmd.getTables(null, schema, null, null);
                        if (rs1 != null) {
                            while (rs1.next()) {
                                table = rs1.getString("TABLE_NAME");
                                if (table.indexOf("BIN$") != -1 || "VIEW".equalsIgnoreCase(type = rs1.getString("TABLE_TYPE"))) continue;
                                exportDesc = new ExportDescription();
                                exportDesc.setTableName(table);
                                list.add(exportDesc);
                                if (!this.logger.isDebugEnabled()) continue;
                                this.logger.debug((Object)("add table " + table));
                            }
                            rs1.close();
                        }
                        ExporterFrame.this.listModel.addElements(list);
                    }
                }
                catch (SQLException sqle) {
                    this.logger.error((Object)sqle);
                }
            }
            this.session.close();
            ExporterFrame.this.buttonReload.setEnabled(true);
            ((ExporterFrame)ExporterFrame.this).status.infoLabel.setBackground(Color.lightGray);
        }
    }

    static class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        public JLabel messageLabel = new FixedLabel();
        public JLabel infoLabel = new FixedLabel();
        static final int INFO_ACTION_BREITE = 60;
        static final int HOEHE = 25;

        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
            this.messageLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.messageLabel.setForeground(Color.black);
            this.infoLabel.setPreferredSize(new Dimension(60, 25));
            this.infoLabel.setOpaque(true);
            this.infoLabel.setText("DISC");
            this.infoLabel.setToolTipText(Messages.getString("ExporterFrame.notconnected"));
            this.infoLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.infoLabel.setForeground(Color.black);
            this.add(this.messageLabel);
            this.add(this.infoLabel);
            this.messageLabel.addPropertyChangeListener(new MeldungPropertyChangeListener());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int meldungBreite = this.getWidth() - 60;
            this.messageLabel.setPreferredSize(new Dimension(meldungBreite, 25));
            this.remove(this.messageLabel);
            this.add(this.messageLabel, null, 0);
            this.doLayout();
        }

        private class MeldungPropertyChangeListener
        implements PropertyChangeListener {
            private MeldungPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatusBar.this.messageLabel.setToolTipText(StatusBar.this.messageLabel.getText());
            }
        }

        private static class FixedLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        }
    }
}

