/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.text;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringReplacer {
    private String originalText;
    private StringBuilder sb;
    private int p0;
    private int p1;
    private int searchTextLength;

    public StringReplacer(String originalText) {
        this.originalText = originalText;
        this.sb = new StringBuilder();
    }

    public boolean replace(String searchText, String replaceText) {
        return this.replace(searchText, replaceText, true);
    }

    public boolean replace(String searchText, String replaceText, boolean caseSensitive) {
        this.p0 = 0;
        this.p1 = 0;
        boolean ok = false;
        if (searchText != null && searchText.length() > 0) {
            this.searchTextLength = searchText.length();
            this.sb.setLength(0);
            while (true) {
                this.p1 = caseSensitive ? this.originalText.indexOf(searchText, this.p0) : this.originalText.toLowerCase().indexOf(searchText.toLowerCase(), this.p0);
                if (this.p1 == -1) break;
                this.sb.append(this.originalText.substring(this.p0, this.p1));
                if (replaceText != null) {
                    this.sb.append(replaceText);
                }
                this.p0 = this.p1 + this.searchTextLength;
                ok = true;
            }
            if (ok) {
                this.sb.append(this.originalText.substring(this.p0, this.originalText.length()));
            }
        }
        if (ok) {
            this.originalText = this.sb.toString();
        }
        return ok;
    }

    public String getResultText() {
        return this.originalText;
    }

    public static String extractByRegexGroups(String content, String regex) {
        if (regex != null) {
            if (content != null) {
                content = content.trim();
                StringBuffer sb = new StringBuffer();
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(content);
                while (matcher.find()) {
                    if (matcher.start() >= matcher.end()) continue;
                    int n = matcher.groupCount();
                    for (int i = 1; i <= n; ++i) {
                        sb.append(matcher.group(i));
                    }
                }
                return sb.toString();
            }
            return null;
        }
        return content;
    }

    public static String fixLineBreaks(String text) {
        if (text != null) {
            StringBuffer sb = new StringBuffer();
            int c1 = 32;
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (i < text.length() - 1) {
                    c1 = text.charAt(i + 1);
                }
                if (c == '\r') {
                    if (c1 == 10) continue;
                    sb.append('\n');
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return null;
    }
}

