/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.text;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GenericDateUtil {
    private static ThreadLocal<DateParser> threadLocal = new ThreadLocal();

    public static Date parseDate(String source) throws ParseException {
        return GenericDateUtil.parseDate(source, null);
    }

    public static Date parseDate(String source, String pattern) throws ParseException {
        DateParser p = threadLocal.get();
        if (p == null) {
            p = new DateParser();
            threadLocal.set(p);
        }
        return p.parseDate(source, pattern);
    }

    static class DateParser {
        private List<String> datePatternList = new ArrayList<String>();
        private List<String> timePatternList = null;

        DateParser() {
            this.datePatternList.add("yyyy-MM-dd");
            this.datePatternList.add("dd.MM.yyyy");
            this.datePatternList.add("d.MM.yyyy");
            this.datePatternList.add("d.M.yy");
            this.datePatternList.add("dd.MM.yy");
            this.datePatternList.add("dd.MMM.yyyy");
            this.datePatternList.add("yyyyMMdd");
            this.datePatternList.add("dd/MM/yyyy");
            this.datePatternList.add("dd/MM/yy");
            this.datePatternList.add("dd/MMM/yyyy");
            this.datePatternList.add("d/M/yy");
            this.datePatternList.add("MM/dd/yyyy");
            this.datePatternList.add("MM/dd/yy");
            this.datePatternList.add("dd/MMM/yyyy");
            this.datePatternList.add("M/d/yy");
            this.datePatternList.add("dd-MM-yyyy");
            this.datePatternList.add("dd-MM-yy");
            this.datePatternList.add("dd-MMM-yyyy");
            this.datePatternList.add("d-M-yy");
            this.timePatternList = new ArrayList<String>();
            this.timePatternList.add("HHmmss");
            this.timePatternList.add("HH:mm:ss");
            this.timePatternList.add("HH:mm:ss.SSS");
            this.timePatternList.add("'T'HH:mm:ss.SSSZ");
        }

        public Date parseDate(String text, String userPattern) throws ParseException {
            if (text != null) {
                SimpleDateFormat sdf = new SimpleDateFormat();
                Date dateValue = null;
                if (userPattern != null && !userPattern.isEmpty() && !this.datePatternList.contains(userPattern)) {
                    this.datePatternList.add(0, userPattern);
                }
                for (String pattern : this.datePatternList) {
                    sdf.applyPattern(pattern);
                    try {
                        dateValue = sdf.parse(text);
                        int pos = this.datePatternList.indexOf(pattern);
                        if (pos > 0) {
                            this.datePatternList.remove(pos);
                            this.datePatternList.add(0, pattern);
                        }
                        return dateValue;
                    }
                    catch (Exception e) {
                    }
                }
                throw new ParseException("The value: " + text + " could not parsed to a Date.", 0);
            }
            return null;
        }
    }
}

