/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.history;

import dbtools.SQLStatement;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.SQLFileFilter;
import sqlrunner.history.DetailDialog;
import sqlrunner.history.Messages;
import sqlrunner.swinghelper.WindowHelper;

public class HistoryFrame
extends JFrame
implements ActionListener,
ListSelectionListener {
    private static final Logger logger = Logger.getLogger(HistoryFrame.class);
    private static final long serialVersionUID = 1L;
    private final JPanel jPanel1 = new JPanel();
    private final JPanel jPanel2 = new JPanel();
    private final JButton buttonTakeOver = new JButton();
    private final JButton buttonDel = new JButton();
    private final JButton buttonDetails = new JButton();
    private final JCheckBox checkBoxFreese = new JCheckBox();
    private final JButton buttonClear = new JButton();
    private final JButton buttonClose = new JButton();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final DefaultListModel<SQLStatement> model = new DefaultListModel();
    private final JList<SQLStatement> statementList = new JList<SQLStatement>(this.model);
    private SQLStatement currentSqlStat;
    private DetailDialog details;
    private final JButton buttonScript = new JButton();
    private String sqlMessageDelimiter;
    private final JCheckBox checkBoxNoDouble = new JCheckBox();
    private final JCheckBox checkBoxEnableComment = new JCheckBox();
    private final JCheckBox checkBoxRunImmediate = new JCheckBox();
    private MainFrame mainFrame;
    private boolean freezed;

    public HistoryFrame() {
        super(Messages.getString("HistoryView.0"));
        try {
            this.initComponents();
            this.pack();
            this.sqlMessageDelimiter = Main.getDefaultProperty("HISTORY_VIEW_DELIMITER_MESSAGES", "*#*");
            this.readList();
        }
        catch (Exception e) {
            logger.error((Object)("HistoryView (init) failed: " + e.getMessage()), (Throwable)e);
        }
    }

    private void initComponents() throws Exception {
        this.getRootPane().setDefaultButton(this.buttonTakeOver);
        this.jPanel1.setLayout(new BorderLayout());
        this.jPanel2.setLayout(new GridBagLayout());
        this.statementList.setBackground(SystemColor.info);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jScrollPane1, "Center");
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.buttonTakeOver.setText(Messages.getString("HistoryView.3"));
        this.buttonTakeOver.addActionListener(this);
        this.buttonTakeOver.setEnabled(false);
        this.jPanel2.add((Component)this.buttonTakeOver, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.buttonDel.setText(Messages.getString("HistoryView.4"));
        this.buttonDel.addActionListener(this);
        this.buttonDel.setEnabled(false);
        this.jPanel2.add((Component)this.buttonDel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.buttonDetails.setText(Messages.getString("HistoryView.6"));
        this.buttonDetails.setEnabled(false);
        this.buttonDetails.addActionListener(this);
        this.jPanel2.add((Component)this.buttonDetails, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.checkBoxRunImmediate.setText(Messages.getString("HistoryView.21"));
        this.checkBoxRunImmediate.setBorder(null);
        this.checkBoxRunImmediate.setSelected(Main.getUserProperty("HISTORY_RUN_IMMIDATELY", "false").equals("true"));
        this.jPanel2.add((Component)this.checkBoxRunImmediate, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.buttonClear.setText(Messages.getString("HistoryView.5"));
        this.buttonClear.addActionListener(this);
        this.jPanel2.add((Component)this.buttonClear, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.checkBoxFreese.setBorder(null);
        this.checkBoxFreese.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HistoryFrame.this.freezed = HistoryFrame.this.checkBoxFreese.isSelected();
            }
        });
        this.checkBoxFreese.setText(Messages.getString("HistoryView.8"));
        this.checkBoxFreese.setSelected(Main.getUserProperty("HISTORY_FREESE", "false").equals("true"));
        this.jPanel2.add((Component)this.checkBoxFreese, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.buttonScript.addActionListener(this);
        this.buttonScript.setText(Messages.getString("HistoryView.12"));
        this.jPanel2.add((Component)this.buttonScript, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.checkBoxEnableComment.setText(Messages.getString("HistoryView.17"));
        this.checkBoxEnableComment.setSelected(Main.getUserProperty("HISTORY_SCRIPT_WITH_COMMENTS", "true").equals("true"));
        this.jPanel2.add((Component)this.checkBoxEnableComment, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.checkBoxNoDouble.setText(Messages.getString("HistoryView.13"));
        this.checkBoxNoDouble.setSelected(Main.getUserProperty("HISTORY_NO_DOUBLE", "true").equals("true"));
        this.jPanel2.add((Component)this.checkBoxNoDouble, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y;
        gbc.gridx = 2;
        gbc.fill = 2;
        gbc.insets = new Insets(1, 1, 1, 1);
        this.buttonClose.setText(Messages.getString("HistoryView.7"));
        this.buttonClose.addActionListener(this);
        this.jPanel2.add((Component)this.buttonClose, gbc);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jScrollPane1.setViewportView(this.statementList);
        this.statementList.addListSelectionListener(this);
        this.statementList.addMouseListener(new ListMouseListener());
        this.statementList.setFont(Main.textFont);
        this.statementList.setCellRenderer(new SQLListCellRenderer());
        this.statementList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    if (HistoryFrame.this.buttonTakeOver.isEnabled()) {
                        HistoryFrame.this.buttonTakeOver_actionPerformed();
                    }
                } else if (e.getKeyCode() == 127 && HistoryFrame.this.buttonDel.isEnabled()) {
                    HistoryFrame.this.buttonDel_actionPerformed();
                }
            }
        });
    }

    public boolean isFreezed() {
        return this.freezed;
    }

    public void refresh() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doRefresh();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HistoryFrame.this.doRefresh();
                }
            });
        }
    }

    private void doRefresh() {
        this.statementList.repaint();
        if (this.details != null) {
            this.details.refresh();
        }
    }

    public void setMainFrame(MainFrame mainFrame_loc) {
        this.mainFrame = mainFrame_loc;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            WindowHelper.checkAndCorrectWindowBounds(this);
            if (this.statementList.getModel().getSize() > 0 && this.statementList.getSelectedIndex() == -1) {
                this.statementList.setSelectedIndex(0);
            }
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        super.setVisible(visible);
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        switch (e.getID()) {
            case 201: {
                this.cancel();
                break;
            }
            case 205: {
                this.statementList.requestFocus();
            }
        }
        super.processWindowEvent(e);
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 27: {
                this.cancel();
                break;
            }
            case 68: {
                this.buttonDetails_actionPerformed();
                break;
            }
            case 127: {
                this.buttonDel_actionPerformed();
            }
        }
    }

    private void cancel() {
        this.setVisible(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.buttonTakeOver) {
            this.buttonTakeOver_actionPerformed();
        } else if (e.getSource() == this.buttonDel) {
            this.buttonDel_actionPerformed();
        } else if (e.getSource() == this.buttonClose) {
            this.cancel();
        } else if (e.getSource() == this.buttonClear) {
            this.clearAll();
        } else if (e.getSource() == this.buttonDetails) {
            this.buttonDetails_actionPerformed();
        } else if (e.getSource() == this.buttonScript) {
            JFileChooser chooser = new JFileChooser();
            String lastFile = Main.getUserProperty("HISTORY_BACKUP_FILE");
            if (lastFile != null) {
                chooser.setSelectedFile(new File(lastFile));
            } else {
                chooser.setCurrentDirectory(new File(System.getProperty("user.home")));
            }
            chooser.setDialogType(1);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogTitle(Messages.getString("HistoryView.27"));
            chooser.addChoosableFileFilter(new SQLFileFilter());
            int returnVal = chooser.showSaveDialog(this);
            BufferedWriter bw = null;
            if (returnVal == 0) {
                File f = chooser.getSelectedFile();
                if (chooser.getFileFilter() instanceof SQLFileFilter && !f.getName().toLowerCase().endsWith(".sql")) {
                    f = new File(f.getAbsolutePath() + ".sql");
                }
                Main.setUserProperty("HISTORY_BACKUP_FILE", f.getAbsolutePath());
                try {
                    bw = new BufferedWriter(new FileWriter(f));
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this, ioe.getMessage(), Messages.getString("HistoryView.31"), 0);
                }
            }
            if (bw != null) {
                ListSaver saver = new ListSaver(bw, this);
                saver.start();
            }
        }
    }

    private void buttonTakeOver_actionPerformed() {
        if (this.mainFrame != null) {
            this.currentSqlStat = this.readSQLStatementFromList();
            if (this.currentSqlStat == null) {
                JOptionPane.showMessageDialog(this, Messages.getString("HistoryView.32"), Messages.getString("HistoryView.33"), 2);
            } else {
                if (this.checkBoxRunImmediate.isSelected()) {
                    if (this.mainFrame.isConnected()) {
                        this.mainFrame.getDatabase().executeStatement(this.currentSqlStat);
                    } else {
                        JOptionPane.showMessageDialog(this, Messages.getString("HistoryView.34"), Messages.getString("HistoryView.35"), 0);
                    }
                } else {
                    int[] selectedIndexes = this.statementList.getSelectedIndices();
                    for (int i = selectedIndexes.length - 1; i >= 0; --i) {
                        SQLStatement s = this.statementList.getModel().getElementAt(selectedIndexes[i]);
                        this.mainFrame.insertOrReplaceText(s.getSQL() + ";\n");
                    }
                    this.mainFrame.setTextSaveEnabled(false);
                }
                this.mainFrame.toFront();
            }
        }
    }

    private void buttonDel_actionPerformed() {
        int[] selectedIndexes = this.statementList.getSelectedIndices();
        for (int i = selectedIndexes.length - 1; i >= 0; --i) {
            this.model.removeElementAt(selectedIndexes[i]);
        }
    }

    private void buttonDetails_actionPerformed() {
        if (this.details == null) {
            this.details = new DetailDialog(this);
        }
        this.details.setVisible(true);
        this.details.setStatement(this.currentSqlStat);
        WindowHelper.locateWindowAtLeftSideWithin(this, this.details, 0);
        this.requestFocus();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        SQLStatement statTemp = this.readSQLStatementFromList();
        if (statTemp != null) {
            this.currentSqlStat = statTemp;
            if (this.details != null) {
                this.details.setStatement(this.currentSqlStat);
            }
        }
    }

    private SQLStatement readSQLStatementFromList() {
        SQLStatement s = this.statementList.getSelectedValue();
        if (s != null) {
            this.buttonTakeOver.setEnabled(true);
            this.buttonDel.setEnabled(true);
            this.buttonDetails.setEnabled(true);
        }
        return s;
    }

    public void addSQLStatement(SQLStatement sqlStat) {
        this.addSQLStatement(sqlStat, false);
    }

    public void addSQLStatement(final SQLStatement sqlStat, final boolean isScript) {
        if (!this.checkBoxFreese.isSelected()) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.doAddSQLStatement(sqlStat, isScript);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        HistoryFrame.this.doAddSQLStatement(sqlStat, isScript);
                    }
                });
            }
        }
    }

    private void doAddSQLStatement(SQLStatement sqlStat, boolean isScript) {
        if (!sqlStat.isHidden()) {
            if (!isScript || this.checkBoxNoDouble.isSelected()) {
                for (int i = 0; i < this.model.size(); ++i) {
                    if (!this.model.elementAt(i).equals(sqlStat)) continue;
                    this.model.removeElementAt(i);
                }
                this.model.insertElementAt(sqlStat, 0);
                this.statementList.getSelectionModel().clearSelection();
                this.statementList.setSelectedValue(sqlStat, true);
            } else {
                this.addBatch(sqlStat, isScript);
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)"doAddSQLStatement: skipped because statement is hidden");
        }
    }

    public void setFreezed(boolean freese) {
        this.checkBoxFreese.setSelected(freese);
    }

    public void clearAll() {
        this.model.removeAllElements();
        this.currentSqlStat = null;
        this.buttonTakeOver.setEnabled(false);
        this.buttonDel.setEnabled(false);
        this.buttonDetails.setEnabled(false);
    }

    public void addBatch(SQLStatement sqlStat, boolean isScript) {
        if (!this.checkBoxFreese.isSelected() && sqlStat.isValid() && !sqlStat.isHidden()) {
            this.model.insertElementAt(sqlStat, 0);
            this.buttonTakeOver.setEnabled(false);
            this.buttonDel.setEnabled(false);
            if (isScript) {
                this.statementList.setSelectedIndex(0);
            }
        }
    }

    private void readList() {
        String line = null;
        StringBuffer textBf = new StringBuffer();
        boolean inSQL = false;
        SQLStatement stat = null;
        String param = null;
        try {
            int p0;
            String text;
            BufferedReader br = new BufferedReader(new FileReader(Main.getSqlHistoryFileName()));
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.trim().length() <= 0) continue;
                if (line.startsWith("-[")) {
                    if (inSQL) {
                        stat = new SQLStatement();
                        text = textBf.toString();
                        p0 = text.indexOf(this.sqlMessageDelimiter);
                        stat.setSQL(text.substring(0, p0).trim());
                        stat.setMessage(text.substring(p0 + this.sqlMessageDelimiter.length(), text.length()));
                        stat.parseSummaryStr(param);
                        this.model.addElement(stat);
                        inSQL = false;
                    }
                    param = line.substring("-[".length(), line.length() - 1);
                    inSQL = true;
                    textBf.setLength(0);
                    continue;
                }
                textBf.append(line);
                textBf.append('\n');
            }
            br.close();
            if (textBf.length() > 2) {
                stat = new SQLStatement();
                text = textBf.toString();
                p0 = text.indexOf(this.sqlMessageDelimiter);
                if (p0 > 0) {
                    stat.setSQL(text.substring(0, p0).trim());
                    stat.setMessage(text.substring(p0 + this.sqlMessageDelimiter.length(), text.length()));
                    stat.parseSummaryStr(param);
                    this.model.addElement(stat);
                } else {
                    logger.error((Object)("WARNING: malformed SQLHistory entry: " + text));
                }
            }
        }
        catch (IOException ioe) {
            logger.error((Object)("HistoryView.readList:" + ioe.toString()));
        }
    }

    public void saveList() {
        try {
            File iniFile = new File(Main.getSqlHistoryFileName());
            int MAX_LIST_LINE_NUMBER = 1000;
            int countStatements = 0;
            BufferedWriter bw = new BufferedWriter(new FileWriter(iniFile));
            for (int i = 0; i < this.model.size(); ++i) {
                SQLStatement stat = this.model.getElementAt(i);
                if (stat.getSQL() != null) {
                    bw.write(stat.getSummaryStr());
                    bw.newLine();
                    bw.write(stat.getSQL());
                    bw.newLine();
                    bw.write(this.sqlMessageDelimiter);
                    bw.newLine();
                    bw.write(stat.getMessage());
                    bw.newLine();
                }
                if (++countStatements <= 1000) continue;
                logger.info((Object)Messages.getString("HistoryView.44"));
                break;
            }
            bw.flush();
            bw.close();
        }
        catch (Exception ioe) {
            logger.error((Object)("HistoryView.saveList: " + ioe.toString()));
        }
    }

    public boolean isNoDoublesAllowed() {
        return this.checkBoxNoDouble.isSelected();
    }

    public boolean isFreesed() {
        return this.checkBoxFreese.isSelected();
    }

    public boolean isCommentsInHistoryScriptEnabled() {
        return this.checkBoxEnableComment.isSelected();
    }

    public boolean isRunImmidatlyEnabled() {
        return this.checkBoxRunImmediate.isSelected();
    }

    class ListMouseListener
    extends MouseAdapter {
        ListMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (!me.isControlDown() && me.getClickCount() == 2) {
                this.fireDoubleClickPerformed(me);
            }
        }

        protected void fireDoubleClickPerformed(MouseEvent me) {
            HistoryFrame.this.buttonTakeOver_actionPerformed();
        }
    }

    class ListSaver
    extends Thread {
        private final Logger logger = Logger.getLogger(ListSaver.class);
        BufferedWriter bw;
        JFrame window;

        ListSaver(BufferedWriter bw, JFrame window) {
            this.window = window;
            this.bw = bw;
        }

        @Override
        public void run() {
            HistoryFrame.this.buttonScript.setEnabled(false);
            HistoryFrame.this.checkBoxEnableComment.setEnabled(false);
            try {
                this.bw.write("/* BEGIN generated script from History-View */\n");
                this.bw.newLine();
                for (int i = HistoryFrame.this.model.size() - 1; i >= 0; --i) {
                    SQLStatement stat = (SQLStatement)HistoryFrame.this.model.getElementAt(i);
                    this.bw.write(stat.getSQL());
                    this.bw.write(";");
                    if (HistoryFrame.this.checkBoxEnableComment.isSelected()) {
                        this.bw.newLine();
                        this.bw.write("/*");
                        this.bw.newLine();
                        this.bw.write(stat.getSummary());
                        this.bw.newLine();
                        if (stat.getCurrentUrl() != null) {
                            this.bw.write("URL=");
                            this.bw.write(stat.getCurrentUrl());
                            this.bw.newLine();
                            this.bw.write("USER=");
                            this.bw.write(stat.getCurrentUser());
                            this.bw.newLine();
                        }
                        this.bw.write("*/");
                        this.bw.newLine();
                        continue;
                    }
                    this.bw.newLine();
                }
                this.bw.write("/* END generated script from History-View */\n");
                this.bw.flush();
                this.bw.close();
            }
            catch (IOException ioe) {
                this.logger.error((Object)("ListSaver failed: " + ioe.getMessage()), (Throwable)ioe);
                JOptionPane.showMessageDialog(this.window, ioe.getMessage(), Messages.getString("HistoryView.51"), 0);
            }
            HistoryFrame.this.buttonScript.setEnabled(true);
            HistoryFrame.this.checkBoxEnableComment.setEnabled(true);
        }
    }

    static class SQLListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = 1L;
        private final Color lightRed = new Color(255, 190, 190);
        private final Color lightGreen = new Color(190, 255, 190);
        private final Color yellow = Color.YELLOW;

        SQLListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SQLStatement s = (SQLStatement)value;
            this.setText(s.toString());
            if (isSelected) {
                this.setFont(new Font("Dialog", 1, list.getFont().getSize()));
                this.setBorder(BorderFactory.createLineBorder(Color.black));
            } else {
                this.setFont(new Font("Dialog", 0, list.getFont().getSize()));
                this.setBorder(null);
            }
            if (!s.isStarted()) {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            } else if (s.isRunning()) {
                this.setBackground(this.yellow);
                this.setForeground(list.getForeground());
            } else if (s.isSuccessful()) {
                this.setBackground(this.lightGreen);
                this.setForeground(list.getForeground());
            } else {
                this.setBackground(this.lightRed);
                this.setForeground(list.getForeground());
            }
            this.setComponentOrientation(list.getComponentOrientation());
            return this;
        }
    }
}

