/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.generator;

import dbtools.SQLPSParam;
import dbtools.SQLStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import sqlrunner.datamodel.ModelComparator;
import sqlrunner.datamodel.SQLConstraint;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLFieldNotNullConstraint;
import sqlrunner.datamodel.SQLIndex;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.DatabaseExtension;
import sqlrunner.dbext.DatabaseExtensionFactory;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.text.StringReplacer;

public class SQLCodeGenerator {
    private List<String> keywordList = new ArrayList<String>();
    private String ec = "\"";
    private static SQLCodeGenerator instance;

    public void setEnclosureChar(String c) {
        this.ec = c;
    }

    public static SQLCodeGenerator getInstance() {
        if (instance == null) {
            instance = new SQLCodeGenerator();
        }
        return instance;
    }

    public SQLCodeGenerator() {
        this.keywordList.add("type");
        this.keywordList.add("user");
        this.keywordList.add("password");
        this.keywordList.add("table");
        this.keywordList.add("view");
        this.keywordList.add("date");
        this.keywordList.add("key");
        this.keywordList.add("value");
        this.keywordList.add("database");
        this.keywordList.add("table");
        this.keywordList.add("schema");
    }

    public void addKeyword(String word) {
        if (!this.keywordList.contains(word)) {
            this.keywordList.add(word);
        }
    }

    public boolean containsKeyword(String identifier) {
        if (identifier != null) {
            String[] names;
            for (String name : names = identifier.split("\\.")) {
                for (String w : this.keywordList) {
                    if (!w.equalsIgnoreCase(name)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getEncapsulatedName(String name) {
        if (this.containsKeyword(name) || name.indexOf(45) != -1 || name.indexOf(32) != -1 || name.indexOf("$") != -1) {
            StringBuilder sb = new StringBuilder();
            StringTokenizer st = new StringTokenizer(name, ".");
            String s = null;
            boolean firstLoop = true;
            while (st.hasMoreTokens()) {
                if (firstLoop) {
                    firstLoop = false;
                } else {
                    sb.append(".");
                }
                s = st.nextToken();
                if ((this.containsKeyword(s) || s.contains("-") || s.contains(" ") || s.contains("$")) && !s.contains(this.ec)) {
                    s = this.ec + s + this.ec;
                }
                sb.append(s);
            }
            return sb.toString();
        }
        return name;
    }

    public String buildSelectStatement(SQLTable table, boolean withSchemaName) {
        return this.buildSelectStatement(table, withSchemaName, false);
    }

    public String buildSelectStatement(SQLTable table, boolean withSchemaName, boolean coalesce) {
        if (table != null) {
            this.setupEnclosureChar(table);
            StringBuilder sb = new StringBuilder();
            if (table.getFieldCount() > 0) {
                sb.append("select\n");
                boolean firstLoop = true;
                for (int i = 0; i < table.getFieldCount(); ++i) {
                    if (firstLoop) {
                        firstLoop = false;
                    } else {
                        sb.append(",\n");
                    }
                    SQLField field = table.getFieldAt(i);
                    if (coalesce) {
                        if (field.getBasicType() == BasicDataType.CHARACTER.getId()) {
                            sb.append("coalesce(");
                            sb.append(this.getEncapsulatedName(field.getName()));
                            sb.append(", '') as ");
                            sb.append(this.getEncapsulatedName(field.getName()));
                            continue;
                        }
                        if (BasicDataType.isNumberType(field.getBasicType())) {
                            sb.append("coalesce(");
                            sb.append(this.getEncapsulatedName(field.getName()));
                            sb.append(", 0) as ");
                            sb.append(this.getEncapsulatedName(field.getName()));
                            continue;
                        }
                        sb.append(this.getEncapsulatedName(field.getName()));
                        continue;
                    }
                    sb.append(this.getEncapsulatedName(field.getName()));
                }
                sb.append("\nfrom ");
                if (withSchemaName) {
                    sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
                } else {
                    sb.append(this.getEncapsulatedName(table.getName()));
                }
                return sb.toString();
            }
            return null;
        }
        return null;
    }

    public String buildInsertStatement(SQLTable table, boolean withSchemaName) {
        if (table != null) {
            this.setupEnclosureChar(table);
            StringBuilder sb = new StringBuilder();
            if (table.getFieldCount() > 0) {
                sb.append("insert into ");
                if (withSchemaName) {
                    sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
                } else {
                    sb.append(this.getEncapsulatedName(table.getName()));
                }
                sb.append("\n (");
                boolean firstLoop = true;
                for (int i = 0; i < table.getFieldCount(); ++i) {
                    if (firstLoop) {
                        firstLoop = false;
                    } else {
                        sb.append(",\n  ");
                    }
                    SQLField field = table.getFieldAt(i);
                    sb.append(this.getEncapsulatedName(field.getName()));
                }
                sb.append(")\nvalues\n (\n )");
                return sb.toString();
            }
            return null;
        }
        return null;
    }

    public String buildCreateStatement(SQLIndex index, boolean fullName) {
        return this.buildCreateStatement(index, fullName, null);
    }

    public String buildCreateStatement(SQLProcedure proc, boolean fullName, String alternativeSchemaName) {
        String code = proc.getCode();
        if (code != null && !code.isEmpty()) {
            if (fullName) {
                StringReplacer sr = new StringReplacer(code);
                String schemaName = null;
                schemaName = alternativeSchemaName != null ? alternativeSchemaName : proc.getSchema().getName();
                if (code.indexOf(schemaName + "." + proc.getName()) == -1) {
                    sr.replace(proc.getName(), schemaName + "." + proc.getName());
                }
                return sr.getResultText();
            }
            return code;
        }
        if (proc.isFunction()) {
            return "-- create or replace function " + proc.getName() + " (no source available)";
        }
        return "-- create or replace procedure " + proc.getName() + " (no source available)";
    }

    public String buildCreateStatement(SQLIndex index, boolean fullName, String alternativeSchemaName) {
        if (index != null) {
            this.setupEnclosureChar(index);
            StringBuilder sb = new StringBuilder();
            sb.append("create ");
            if (index.isUnique()) {
                sb.append("unique ");
            }
            sb.append("index ");
            sb.append(index.getName());
            sb.append(" on ");
            if (fullName) {
                if (alternativeSchemaName != null) {
                    sb.append(alternativeSchemaName);
                    sb.append('.');
                    sb.append(index.getTable().getName());
                } else {
                    sb.append(index.getTable().getAbsoluteName());
                }
            } else {
                sb.append(index.getTable().getName());
            }
            sb.append("(");
            int n = index.getCountFields();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(index.getFieldByOrdinalPosition(i + 1).getName());
            }
            sb.append(")");
            return sb.toString();
        }
        return null;
    }

    public String buildDropStatement(SQLIndex index, boolean fullName, String alternativeSchemaName) {
        if (index != null) {
            this.setupEnclosureChar(index);
            StringBuilder sb = new StringBuilder();
            sb.append("drop index ");
            if (fullName) {
                if (alternativeSchemaName != null) {
                    sb.append(alternativeSchemaName);
                    sb.append(".");
                    sb.append(index.getName());
                } else {
                    sb.append(index.getTable().getSchema().getName());
                    sb.append(".");
                    sb.append(index.getName());
                }
            } else {
                sb.append(index.getName());
            }
            return sb.toString();
        }
        return null;
    }

    public String buildCreateStatement(SQLTable table, boolean fullName) {
        return this.buildCreateStatement(table, fullName, null, false, false, false);
    }

    public String buildCreateStatement(SQLTable table, boolean fullName, boolean viewAsTable) {
        return this.buildCreateStatement(table, fullName, null, false, false, viewAsTable);
    }

    private void setupEnclosureChar(SQLObject so) {
        if (so != null) {
            DatabaseExtension ext = SQLCodeGenerator.getDatabaseExtension(so);
            if (ext != null) {
                this.ec = ext.getIdentifierQuoteString();
            }
        } else {
            this.ec = "\"";
        }
    }

    private static DatabaseExtension getDatabaseExtension(SQLObject so) {
        SQLDataModel model = so.getModel();
        if (model != null) {
            return model.getDatabaseExtension();
        }
        return null;
    }

    public String buildCreateStatement(SQLTable table, boolean fullName, String alternativeSchemaName, boolean withDefault, boolean notnull, boolean viewAsTable) {
        if (table != null) {
            String source;
            this.setupEnclosureChar(table);
            String tableName = null;
            tableName = fullName ? (alternativeSchemaName != null ? alternativeSchemaName + '.' + this.getEncapsulatedName(table.getName()) : this.getEncapsulatedName(table.getAbsoluteName())) : this.getEncapsulatedName(table.getName());
            if (table.isTable() || viewAsTable) {
                if (!table.isFieldsLoaded()) {
                    table.loadColumns();
                }
                StringBuilder sb = new StringBuilder();
                if (table.getFieldCount() > 0) {
                    if (table.getComment() != null && !table.getComment().trim().isEmpty()) {
                        sb.append("/*\n");
                        sb.append(table.getComment());
                        sb.append("\n*/\n");
                    }
                    sb.append("-- drop table ");
                    sb.append(tableName);
                    sb.append(";\n");
                    sb.append("create table ");
                    sb.append(tableName);
                    sb.append(" (\n");
                    SQLField field = null;
                    boolean firstLoop = true;
                    for (int i = 0; i < table.getFieldCount(); ++i) {
                        if (firstLoop) {
                            firstLoop = false;
                        } else {
                            String comment = field.getComment();
                            if (comment != null && !comment.trim().isEmpty()) {
                                sb.append(", -- ");
                                sb.append(comment.replace('\n', ' '));
                                sb.append("\n");
                            } else {
                                sb.append(",\n");
                            }
                        }
                        field = table.getFieldAt(i);
                        sb.append("   ");
                        sb.append(this.buildFieldDeclaration(field));
                        if (!field.isNullValueAllowed()) {
                            sb.append(" not null");
                        }
                        sb.append(field.getDefaultValueSQL());
                    }
                    firstLoop = true;
                    SQLConstraint pkConstraint = table.getPrimaryKeyConstraint();
                    if (pkConstraint != null) {
                        sb.append(",\n   ");
                        sb.append(this.buildConstraintSQLCode(pkConstraint, fullName, alternativeSchemaName));
                    }
                    for (SQLConstraint constraint : table.getConstraints()) {
                        if (constraint.getType() == 1) continue;
                        sb.append(",\n   ");
                        sb.append(this.buildConstraintSQLCode(constraint, fullName, alternativeSchemaName));
                    }
                    sb.append(");\n");
                    DatabaseExtension ext = DatabaseExtensionFactory.getDatabaseExtension(table);
                    String tableCommentStat = ext.getUpdateCommentStatement(tableName, table.getComment());
                    if (tableCommentStat != null && !tableCommentStat.trim().isEmpty()) {
                        sb.append("\n");
                        sb.append(tableCommentStat);
                        sb.append(";\n");
                    }
                    for (int i = 0; i < table.getFieldCount(); ++i) {
                        field = table.getFieldAt(i);
                        String columnComment = ext.getUpdateCommentStatement(tableName, field.getName(), field.getComment());
                        if (columnComment == null || columnComment.trim().isEmpty()) continue;
                        sb.append(columnComment);
                        sb.append(";\n");
                    }
                    boolean firstIndex = true;
                    if (table.countIndexes() > 0) {
                        for (SQLIndex index : table.getIndexes()) {
                            if (table.getConstraint(index.getName()) != null) continue;
                            if (firstIndex) {
                                firstIndex = false;
                                sb.append("\n");
                            }
                            sb.append(this.buildCreateStatement(index, fullName));
                            sb.append(";\n");
                        }
                    }
                    return sb.toString();
                }
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (table.getComment() != null && !table.getComment().trim().isEmpty()) {
                sb.append("/*\n");
                sb.append(table.getComment());
                sb.append("\n*/\n");
            }
            if ((source = table.getSourceCode()) != null) {
                sb.append("-- drop view ");
                sb.append(tableName);
                sb.append(";\n");
                if (fullName) {
                    StringReplacer sr = new StringReplacer(table.getSourceCode());
                    if (alternativeSchemaName != null) {
                        if (source.indexOf(alternativeSchemaName + "." + table.getName()) == -1) {
                            sr.replace(table.getName(), alternativeSchemaName + "." + table.getName());
                        }
                    } else if (source.indexOf(table.getAbsoluteName()) == -1) {
                        sr.replace(table.getName(), table.getAbsoluteName());
                    }
                    return sr.getResultText();
                }
                sb.append(table.getSourceCode());
            } else {
                sb.append("-- create view ");
                if (fullName) {
                    if (alternativeSchemaName != null) {
                        sb.append(alternativeSchemaName);
                        sb.append('.');
                        sb.append(this.getEncapsulatedName(table.getName()));
                    } else {
                        sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
                    }
                } else {
                    sb.append(this.getEncapsulatedName(table.getName()));
                }
                sb.append("\n-- source code not available");
            }
            return sb.toString();
        }
        return null;
    }

    public String buildFieldDeclaration(SQLField field) {
        this.setupEnclosureChar(field);
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getEncapsulatedName(field.getName()));
        sb.append(' ');
        sb.append(this.getFieldType(field));
        return sb.toString();
    }

    public String getFieldType(SQLField field) {
        if (field.getTypeSQLCode() != null) {
            return field.getTypeSQLCode();
        }
        StringBuilder sb = new StringBuilder(32);
        if (BasicDataType.isNumberType(field.getBasicType())) {
            sb.append(field.getTypeName());
            if (field.getLength() > 0) {
                sb.append('(');
                sb.append(String.valueOf(field.getLength()));
                sb.append(',');
                sb.append(String.valueOf(field.getDecimalDigits()));
                sb.append(')');
            }
        } else if (field.getBasicType() == BasicDataType.CHARACTER.getId()) {
            sb.append(field.getTypeName());
            if (!(field.getLength() <= 0 || field.getTypeName().equalsIgnoreCase("CLOB") || field.getTypeName().equalsIgnoreCase("TEXT") || field.getTypeName().equalsIgnoreCase("BLOB"))) {
                sb.append('(');
                sb.append(String.valueOf(field.getLength()));
                sb.append(')');
            }
        } else if (field.getBasicType() == BasicDataType.BOOLEAN.getId()) {
            sb.append("boolean");
        } else {
            sb.append(field.getTypeName());
        }
        return sb.toString();
    }

    public String buildPSInsertStatement(SQLTable table, boolean fullName) {
        int i;
        this.setupEnclosureChar(table);
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append("\n (");
        SQLField field = null;
        for (i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (i > 0) {
                sb.append(",\n  ");
            }
            sb.append(this.getEncapsulatedName(field.getName()));
        }
        sb.append(")\nvalues\n (");
        for (i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (i > 0) {
                sb.append(",\n  ");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    public SQLStatement buildPSInsertSQLStatement(SQLTable table, boolean fullName) {
        this.setupEnclosureChar(table);
        SQLStatement sqlPs = new SQLStatement();
        sqlPs.setPrepared(true);
        int paramIndex = 0;
        StringBuilder sb = new StringBuilder();
        sb.append("insert into ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append(" (");
        SQLField field = null;
        for (int i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.getEncapsulatedName(field.getName()));
        }
        sb.append(")\n values(");
        SQLPSParam psParam = null;
        for (int i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (i > 0) {
                sb.append(',');
            }
            sb.append("?");
            psParam = new SQLPSParam();
            psParam.setName(field.getName());
            psParam.setIndex(++paramIndex);
            psParam.setBasicType(field.getBasicType());
            sqlPs.addParam(psParam);
        }
        sb.append(")");
        sqlPs.setSQL(sb.toString());
        return sqlPs;
    }

    public String buildCountAllStatement(SQLTable table, boolean fullName) {
        this.setupEnclosureChar(table);
        StringBuilder sb = new StringBuilder();
        sb.append("select count(*) from ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        return sb.toString();
    }

    public String buildPSCountStatement(SQLTable table, boolean fullName) {
        this.setupEnclosureChar(table);
        StringBuilder sb = new StringBuilder();
        sb.append("select\n count(*)\nfrom ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append("\nwhere\n ");
        SQLField field = null;
        boolean firstLoop = true;
        for (int i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (!field.isPrimaryKey()) continue;
            if (!firstLoop) {
                sb.append("\n and ");
            } else {
                firstLoop = false;
            }
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
        }
        return sb.toString();
    }

    public SQLStatement buildPSCountSQLStatement(SQLTable table, boolean fullName) {
        this.setupEnclosureChar(table);
        StringBuilder sb = new StringBuilder();
        SQLStatement sqlPs = new SQLStatement();
        sqlPs.setPrepared(true);
        sb.append("select\n count(*) \nfrom ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append(" where\n ");
        SQLField field = null;
        boolean firstLoop = true;
        int paramIndex = 0;
        boolean hasPrimaryKeys = false;
        SQLPSParam psParam = null;
        for (int i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (!field.isPrimaryKey()) continue;
            if (!firstLoop) {
                sb.append("\n and ");
            } else {
                firstLoop = false;
            }
            ++paramIndex;
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
            psParam = new SQLPSParam();
            psParam.setName(field.getName());
            psParam.setIndex(paramIndex);
            psParam.setBasicType(field.getBasicType());
            sqlPs.addParam(psParam);
            hasPrimaryKeys = true;
        }
        sqlPs.setSqlCodeValid(hasPrimaryKeys);
        sqlPs.setSQL(sb.toString());
        return sqlPs;
    }

    public String buildPSUpdateStatement(SQLTable table, boolean fullName) {
        int i;
        this.setupEnclosureChar(table);
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append("\nset ");
        SQLField field = null;
        boolean firstLoop = true;
        for (i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (field.isPrimaryKey()) continue;
            if (!firstLoop) {
                sb.append(",\n    ");
            } else {
                firstLoop = false;
            }
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
        }
        firstLoop = true;
        for (i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (!field.isPrimaryKey()) continue;
            if (firstLoop) {
                sb.append("\nwhere\n ");
                firstLoop = false;
            } else {
                sb.append("\n and ");
            }
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
        }
        return sb.toString();
    }

    public String buildPSDeleteStatement(SQLTable table, boolean fullName) {
        this.setupEnclosureChar(table);
        StringBuilder sb = new StringBuilder();
        sb.append("delete from ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        SQLField field = null;
        boolean firstLoop = true;
        firstLoop = true;
        for (int i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (!field.isPrimaryKey()) continue;
            if (firstLoop) {
                sb.append("\nwhere\n ");
                firstLoop = false;
            } else {
                sb.append("\n and ");
            }
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
        }
        return sb.toString();
    }

    public SQLStatement buildPSUpdateSQLStatement(SQLTable table, boolean fullName) {
        int i;
        this.setupEnclosureChar(table);
        SQLStatement sqlPs = new SQLStatement();
        sqlPs.setPrepared(true);
        SQLPSParam psParam = null;
        StringBuilder sb = new StringBuilder();
        sb.append("update ");
        if (fullName) {
            sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append("\nset ");
        SQLField field = null;
        boolean firstLoop = true;
        int paramIndex = 0;
        boolean hasSetField = false;
        boolean hasPrimaryKey = false;
        for (i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (field.isPrimaryKey()) continue;
            if (firstLoop) {
                firstLoop = false;
            } else {
                sb.append(",\n    ");
            }
            ++paramIndex;
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
            psParam = new SQLPSParam();
            psParam.setName(field.getName());
            psParam.setIndex(paramIndex);
            psParam.setBasicType(field.getBasicType());
            sqlPs.addParam(psParam);
            hasSetField = true;
        }
        firstLoop = true;
        for (i = 0; i < table.getFieldCount(); ++i) {
            field = table.getFieldAt(i);
            if (!field.isPrimaryKey()) continue;
            if (firstLoop) {
                sb.append("\nwhere ");
                firstLoop = false;
            } else {
                sb.append(" and \n      ");
            }
            ++paramIndex;
            sb.append(this.getEncapsulatedName(field.getName()));
            sb.append("=?");
            psParam = new SQLPSParam();
            psParam.setName(field.getName());
            psParam.setIndex(paramIndex);
            psParam.setBasicType(field.getBasicType());
            sqlPs.addParam(psParam);
            hasPrimaryKey = true;
        }
        sqlPs.setSqlCodeValid(hasSetField && hasPrimaryKey);
        sqlPs.setSQL(sb.toString());
        return sqlPs;
    }

    public String buildCreateTableStatements(SQLSchema schema, boolean fullName) {
        if (schema != null) {
            String ctString;
            this.setupEnclosureChar(schema);
            List<SQLTable> listSortedTables = SQLCodeGenerator.getTablesSortedByReference(schema);
            StringBuilder text = new StringBuilder();
            for (SQLTable sqlTable : listSortedTables) {
                if (!sqlTable.isTable() || (ctString = this.buildCreateStatement(sqlTable, fullName)) == null) continue;
                text.append(ctString);
                if (!ctString.trim().endsWith(";")) {
                    text.append(";");
                }
                text.append("\n\n");
            }
            for (SQLTable sqlTable : listSortedTables) {
                if (!sqlTable.isView()) continue;
                ctString = this.buildCreateStatement(sqlTable, fullName);
                if (!ctString.trim().endsWith(";")) {
                    text.append(";");
                }
                text.append("\n\n");
            }
            return text.toString();
        }
        return null;
    }

    public String buildDropTableStatements(SQLSchema schema, boolean withSchemaName) {
        if (schema != null) {
            String dtString;
            int x;
            this.setupEnclosureChar(schema);
            List<SQLTable> listSortedTables = SQLCodeGenerator.getTablesSortedByReference(schema);
            StringBuilder text = new StringBuilder();
            SQLTable sqlTable = null;
            for (x = listSortedTables.size() - 1; x >= 0; --x) {
                sqlTable = listSortedTables.get(x);
                if (!sqlTable.isView() || (dtString = this.buildDropStatement(sqlTable, withSchemaName)) == null) continue;
                text.append(dtString);
                text.append(";\n");
            }
            text.append("\n");
            for (x = listSortedTables.size() - 1; x >= 0; --x) {
                sqlTable = listSortedTables.get(x);
                if (!sqlTable.isTable() || (dtString = this.buildDropStatement(sqlTable, withSchemaName)) == null) continue;
                text.append(dtString);
                text.append(";\n");
            }
            return text.toString();
        }
        return null;
    }

    public String buildDropStatement(SQLTable table, boolean withSchemaName) {
        return this.buildDropStatement(table, withSchemaName, null);
    }

    public String buildDropStatement(SQLTable table, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(table);
        if (table.isTable()) {
            if (withSchemaName) {
                if (alternativeSchemaName != null) {
                    return "drop table " + this.getEncapsulatedName(alternativeSchemaName + "." + table.getName());
                }
                return "drop table " + this.getEncapsulatedName(table.getAbsoluteName());
            }
            return "drop table " + this.getEncapsulatedName(table.getName());
        }
        if (table.isView()) {
            if (withSchemaName) {
                if (alternativeSchemaName != null) {
                    return "drop view " + this.getEncapsulatedName(alternativeSchemaName + "." + table.getName());
                }
                return "drop view " + this.getEncapsulatedName(table.getAbsoluteName());
            }
            return "drop view " + this.getEncapsulatedName(table.getName());
        }
        return null;
    }

    public String buildDropStatement(SQLField field, boolean withSchemaName) {
        return this.buildDropStatement(field, withSchemaName, null);
    }

    public String buildDropStatement(SQLField field, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(field);
        SQLTable table = field.getSQLTable();
        if (table.isTable()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("alter table ");
            if (withSchemaName) {
                if (alternativeSchemaName != null) {
                    sb.append(this.getEncapsulatedName(alternativeSchemaName));
                    sb.append(".");
                    sb.append(this.getEncapsulatedName(table.getName()));
                } else {
                    sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
                }
            } else {
                sb.append(this.getEncapsulatedName(table.getName()));
            }
            sb.append(" drop column ");
            sb.append(this.getEncapsulatedName(field.getName()));
            return sb.toString();
        }
        return "";
    }

    public String buildCreateStatement(SQLField field, boolean withSchemaName) {
        return this.buildCreateStatement(field, withSchemaName, null);
    }

    public String buildCreateStatement(SQLField field, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(field);
        SQLTable table = field.getSQLTable();
        if (table.isTable()) {
            StringBuilder sb = new StringBuilder(64);
            sb.append("alter table ");
            if (withSchemaName) {
                if (alternativeSchemaName != null) {
                    sb.append(this.getEncapsulatedName(alternativeSchemaName));
                    sb.append(".");
                    sb.append(this.getEncapsulatedName(table.getName()));
                } else {
                    sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
                }
            } else {
                sb.append(this.getEncapsulatedName(table.getName()));
            }
            sb.append(" add ");
            sb.append(this.buildFieldDeclaration(field));
            if (!field.isNullValueAllowed()) {
                sb.append(" not null");
            }
            return sb.toString();
        }
        return "";
    }

    public String buildAddToTableStatement(SQLConstraint constraint, boolean withSchemaName) {
        return this.buildAddToTableStatement(constraint, withSchemaName, null);
    }

    public String buildAddToTableStatement(SQLConstraint constraint, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(constraint);
        StringBuilder sb = new StringBuilder(64);
        sb.append("alter table ");
        SQLTable table = constraint.getTable();
        if (withSchemaName) {
            if (alternativeSchemaName != null) {
                sb.append(this.getEncapsulatedName(alternativeSchemaName));
                sb.append(".");
                sb.append(this.getEncapsulatedName(table.getName()));
            } else {
                sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
            }
        } else {
            sb.append(table.getName());
        }
        sb.append(" add ");
        sb.append(this.buildConstraintSQLCode(constraint, withSchemaName, alternativeSchemaName));
        return sb.toString();
    }

    public String buildConstraintSQLCode(SQLConstraint constraint, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(constraint);
        if (constraint.getType() == 1) {
            StringBuilder sb = new StringBuilder();
            if (!constraint.getName().equalsIgnoreCase("primary")) {
                sb.append("constraint ");
                sb.append(this.getEncapsulatedName(constraint.getName()));
                sb.append(" ");
            }
            sb.append("primary key (");
            for (int i = 0; i < constraint.getPkColumnList().size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getEncapsulatedName(constraint.getPkColumnList().get(i).getPkColumnName()));
            }
            sb.append(')');
            return sb.toString();
        }
        if (constraint.getType() == 2) {
            int i;
            StringBuilder sb = new StringBuilder();
            sb.append("constraint ");
            sb.append(this.getEncapsulatedName(constraint.getName()));
            sb.append(" foreign key (");
            for (i = 0; i < constraint.getFkColumnPairList().size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getEncapsulatedName(constraint.getFkColumnPairList().get(i).getFkColumnName()));
            }
            sb.append(") references ");
            if (withSchemaName) {
                if (alternativeSchemaName != null) {
                    sb.append(alternativeSchemaName);
                    sb.append(".");
                    sb.append(this.getEncapsulatedName(constraint.getReferencedTable().getName()));
                } else {
                    sb.append(this.getEncapsulatedName(constraint.getReferencedTable().getAbsoluteName()));
                }
            } else {
                sb.append(this.getEncapsulatedName(constraint.getReferencedTable().getName()));
            }
            sb.append("(");
            for (i = 0; i < constraint.getFkColumnPairList().size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getEncapsulatedName(constraint.getFkColumnPairList().get(i).getPkColumnName()));
            }
            sb.append(")");
            return sb.toString();
        }
        if (constraint.getType() == 4) {
            StringBuilder sb = new StringBuilder();
            sb.append("constraint ");
            sb.append(this.getEncapsulatedName(constraint.getName()));
            sb.append(" unique (");
            for (int i = 0; i < constraint.getPkColumnList().size(); ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(this.getEncapsulatedName(constraint.getPkColumnList().get(i).getPkColumnName()));
            }
            sb.append(')');
            return sb.toString();
        }
        return "";
    }

    public String buildSetNotNullConstraint(SQLField field, boolean withSchemaName) {
        return this.buildSetNotNullConstraint(field, withSchemaName, null);
    }

    public String buildSetNotNullConstraint(SQLField field, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(field);
        StringBuilder sb = new StringBuilder(64);
        sb.append("alter table ");
        SQLTable table = field.getSQLTable();
        if (withSchemaName) {
            if (alternativeSchemaName != null) {
                sb.append(this.getEncapsulatedName(alternativeSchemaName));
                sb.append(".");
                sb.append(this.getEncapsulatedName(table.getName()));
            } else {
                sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
            }
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append(" alter column ");
        sb.append(this.getEncapsulatedName(field.getName()));
        sb.append(" set not null");
        return sb.toString();
    }

    public String buildDropNotNullConstraint(SQLField field, boolean withSchemaName) {
        return this.buildDropNotNullConstraint(field, withSchemaName, null);
    }

    public String buildDropNotNullConstraint(SQLField field, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(field);
        StringBuilder sb = new StringBuilder(64);
        sb.append("alter table ");
        SQLTable table = field.getSQLTable();
        if (withSchemaName) {
            if (alternativeSchemaName != null) {
                sb.append(this.getEncapsulatedName(alternativeSchemaName));
                sb.append(".");
                sb.append(this.getEncapsulatedName(table.getName()));
            } else {
                sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
            }
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append(" alter column ");
        sb.append(this.getEncapsulatedName(field.getName()));
        sb.append(" drop not null");
        return sb.toString();
    }

    public String buildDropStatement(SQLConstraint constraint, boolean withSchemaName) {
        return this.buildDropStatement(constraint, withSchemaName, null);
    }

    public String buildDropStatement(SQLConstraint constraint, boolean withSchemaName, String alternativeSchemaName) {
        this.setupEnclosureChar(constraint);
        StringBuilder sb = new StringBuilder(64);
        sb.append("alter table ");
        SQLTable table = constraint.getTable();
        if (withSchemaName) {
            if (alternativeSchemaName != null) {
                sb.append(this.getEncapsulatedName(alternativeSchemaName));
                sb.append(".");
                sb.append(this.getEncapsulatedName(table.getName()));
            } else {
                sb.append(this.getEncapsulatedName(table.getAbsoluteName()));
            }
        } else {
            sb.append(this.getEncapsulatedName(table.getName()));
        }
        sb.append(" drop constraint ");
        sb.append(this.getEncapsulatedName(constraint.getName()));
        return sb.toString();
    }

    public String buildDeleteStatement(SQLTable table, boolean withSchemaName) {
        this.setupEnclosureChar(table);
        if (table.isTable()) {
            if (withSchemaName) {
                return "delete from " + this.getEncapsulatedName(table.getAbsoluteName());
            }
            return "delete from " + this.getEncapsulatedName(table.getName());
        }
        return null;
    }

    public String buildDeleteTableStatements(SQLSchema schema, boolean withSchemaName) {
        if (schema != null) {
            this.setupEnclosureChar(schema);
            List<SQLTable> listSortedTables = SQLCodeGenerator.getTablesSortedByReference(schema);
            StringBuilder text = new StringBuilder();
            SQLTable sqlTable = null;
            for (int x = listSortedTables.size() - 1; x >= 0; --x) {
                sqlTable = listSortedTables.get(x);
                String dtString = this.buildDeleteStatement(sqlTable, withSchemaName);
                if (dtString == null) continue;
                text.append(dtString);
                text.append(";\n");
            }
            return text.toString();
        }
        return null;
    }

    public String buildPreparedCallStatement(SQLProcedure p, boolean fullName) {
        this.setupEnclosureChar(p);
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (p.isFunction()) {
            sb.append("? = ");
        }
        sb.append("call ");
        if (fullName) {
            sb.append(p.getAbsoluteName());
        } else {
            sb.append(p.getName());
        }
        sb.append("(");
        for (int i = 0; i < p.getParameterCount(); ++i) {
            SQLProcedure.Parameter param = p.getParameterAt(i);
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?/*#");
            sb.append(i + 1);
            sb.append(" ");
            sb.append(param.getTypeName());
            sb.append(" ");
            sb.append(param.getName());
            if (param.getIoType() == 2) {
                sb.append("[io]");
            } else if (param.getIoType() == 3) {
                sb.append("[o]");
            }
            sb.append("*/");
        }
        sb.append(")}");
        return sb.toString();
    }

    public String buildDropStatement(SQLProcedure p, boolean fullName) {
        this.setupEnclosureChar(p);
        StringBuilder sb = new StringBuilder();
        sb.append("drop ");
        if (p.isFunction()) {
            sb.append("function ");
        } else {
            sb.append("procedure ");
        }
        if (fullName) {
            sb.append(p.getAbsoluteName());
        } else {
            sb.append(p.getName());
        }
        return sb.toString();
    }

    public static void completeTableAndColumns(SQLSchema schema) {
        SQLTable sqlTable = null;
        for (int x = 0; x < schema.getTableCount(); ++x) {
            sqlTable = schema.getTableAt(x);
            if (sqlTable.isFieldsLoaded()) continue;
            sqlTable.loadColumns();
        }
    }

    public static List<SQLTable> getTablesSortedByReference(SQLSchema schema) {
        SQLCodeGenerator.completeTableAndColumns(schema);
        ArrayList<SQLTable> schemaTables = new ArrayList<SQLTable>();
        for (int i = 0; i < schema.getTableCount(); ++i) {
            SQLTable table = schema.getTableAt(i);
            schemaTables.add(table);
        }
        return SQLCodeGenerator.sortByForeignKeys(schemaTables);
    }

    public static String convertJavaToSqlCode(String javaCode) {
        StringReplacer sr = new StringReplacer(javaCode);
        sr.replace("\r", "");
        sr.replace("\t", " ");
        sr.replace("\\n", "");
        javaCode = sr.getResultText();
        StringBuilder sb = new StringBuilder(javaCode.length());
        int c1 = 32;
        boolean inString = false;
        boolean inSqlCode = false;
        boolean masked = false;
        for (int i = 0; i < javaCode.length(); ++i) {
            char c = javaCode.charAt(i);
            if (i < javaCode.length() - 1) {
                c1 = javaCode.charAt(i + 1);
            }
            if (inSqlCode) {
                if (inString) {
                    if (c == '\'') {
                        inString = false;
                    }
                } else if (c == '\'') {
                    inString = true;
                }
                if (c == '\"') {
                    if (!masked) {
                        inSqlCode = false;
                        if (inString) {
                            inString = false;
                            continue;
                        }
                        sb.append('\n');
                        continue;
                    }
                    masked = false;
                    sb.append(c);
                    continue;
                }
                if (c == '\\') {
                    if (c1 == 34 || c1 == 92) {
                        masked = true;
                        continue;
                    }
                    masked = false;
                    sb.append(c);
                    continue;
                }
                masked = false;
                sb.append(c);
                continue;
            }
            if (c != '\"') continue;
            inSqlCode = true;
        }
        return sb.toString();
    }

    public static String convertSqlToJavaString(String sql) {
        StringReplacer sr = new StringReplacer(sql);
        sr.replace("\"", "\\\"");
        sql = sr.getResultText().trim();
        StringBuilder sb = new StringBuilder(sql.length());
        sb.append("\"");
        char c = ' ';
        boolean inString = false;
        for (int i = 0; i < sql.length(); ++i) {
            c = sql.charAt(i);
            if (!inString) {
                if (c == '\'') {
                    sb.append(c);
                    inString = true;
                } else if (c == '\n') {
                    if (i < sql.length() - 1) {
                        sb.append("\\n\"\n    + \"");
                    } else {
                        sb.append("\"\n");
                    }
                } else {
                    sb.append(c);
                }
            } else {
                if (c == '\\') {
                    sb.append('\\');
                } else if (c == '\'') {
                    inString = false;
                }
                sb.append(c);
            }
            if (i != sql.length() - 1) continue;
            sb.append("\"");
        }
        return sb.toString();
    }

    public static String convertSqlToJavaStringBuffer(String sql, String stringBufferVarName) {
        StringReplacer sr = new StringReplacer(sql);
        sr.replace("\"", "\\\"");
        sql = sr.getResultText().trim();
        StringBuilder sb = new StringBuilder(sql.length());
        sb.append("StringBuilder ");
        sb.append(stringBufferVarName);
        sb.append(" = new StringBuilder();\n");
        sb.append(stringBufferVarName);
        sb.append(".append(\"");
        char c = ' ';
        boolean inString = false;
        for (int i = 0; i < sql.length(); ++i) {
            c = sql.charAt(i);
            if (!inString) {
                if (c == '\'') {
                    sb.append(c);
                    inString = true;
                } else if (c == '\n') {
                    if (i < sql.length() - 1) {
                        sb.append("\\n\");\n");
                        sb.append(stringBufferVarName);
                        sb.append(".append(\"");
                    } else {
                        sb.append("\");\n");
                    }
                } else {
                    sb.append(c);
                }
            } else {
                if (c == '\\') {
                    sb.append('\\');
                } else if (c == '\'') {
                    inString = false;
                }
                sb.append(c);
            }
            if (i != sql.length() - 1) continue;
            sb.append("\");\n");
        }
        return sb.toString();
    }

    public String buildSchemaUpdateStatements(ModelComparator comparator) {
        List<SQLProcedure> listProceduresToChange;
        List<SQLProcedure> listProceduresToAdd;
        List<SQLProcedure> listProceduresToRemove;
        List<SQLIndex> listIndicesToChange;
        List<SQLIndex> listIndicesToRemove;
        List<SQLIndex> listIndicesToAdd;
        List<SQLConstraint> listConstraintsToChange;
        List<SQLConstraint> listConstraintsToRemove;
        List<SQLConstraint> listConstraintsToAdd;
        List<SQLFieldNotNullConstraint> listNncToRemove;
        List<SQLFieldNotNullConstraint> listNncToAdd;
        List<SQLField> listFieldsToChange;
        List<SQLField> listFieldsToRemove;
        List<SQLField> listFieldsToAdd;
        List<SQLTable> listTablesToRemove;
        String alternativeSchemaName = comparator.getTargetSchema().getName();
        StringBuilder sb = new StringBuilder(1024);
        List<SQLTable> listTablesToAdd = comparator.getTablesToAdd();
        if (listTablesToAdd.size() > 0) {
            sb.append("-- ############ Tables to add ############\n");
            listTablesToAdd = SQLCodeGenerator.sortByForeignKeys(listTablesToAdd);
            for (SQLTable table : listTablesToAdd) {
                String sql = this.buildCreateStatement(table, true, alternativeSchemaName, false, false, false);
                sb.append(sql);
                if (sql.endsWith(";\n") || sql.endsWith(";")) {
                    sb.append("\n");
                    continue;
                }
                sb.append(";\n\n");
            }
        }
        if ((listTablesToRemove = comparator.getTablesToRemove()).size() > 0) {
            sb.append("\n\n-- ########## Tables to remove ############\n");
            listTablesToRemove = SQLCodeGenerator.sortByForeignKeys(listTablesToRemove);
            for (int i = listTablesToRemove.size() - 1; i >= 0; --i) {
                SQLTable table = listTablesToRemove.get(i);
                sb.append(this.buildDropStatement(table, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listFieldsToAdd = comparator.getFieldsToAdd()).size() > 0) {
            sb.append("\n\n-- ############ Columns to add ############\n");
            for (SQLField field : listFieldsToAdd) {
                sb.append(this.buildCreateStatement(field, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listFieldsToRemove = comparator.getFieldsToRemove()).size() > 0) {
            sb.append("\n\n-- ############ Columns to remove ############\n");
            for (int i = listFieldsToRemove.size() - 1; i >= 0; --i) {
                SQLField field = listFieldsToRemove.get(i);
                sb.append(this.buildDropStatement(field, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listFieldsToChange = comparator.getFieldsToChange()).size() > 0) {
            sb.append("\n\n-- ############ Columns to change ############\n");
            for (SQLField field : listFieldsToChange) {
                sb.append(this.buildDropStatement(field, true, alternativeSchemaName));
                sb.append(";\n");
                sb.append(this.buildCreateStatement(field, true, alternativeSchemaName));
                sb.append(";\n\n");
            }
        }
        if ((listNncToAdd = comparator.getNotNullsToAdd()).size() > 0) {
            sb.append("\n\n-- ############ Columns Not Null Constraints to add ############\n");
            for (SQLFieldNotNullConstraint nnc : listNncToAdd) {
                sb.append(this.buildSetNotNullConstraint(nnc.getField(), true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listNncToRemove = comparator.getNotNullsToRemove()).size() > 0) {
            sb.append("\n\n-- ############ Columns Not Null Constraints to remove ############\n");
            for (SQLFieldNotNullConstraint nnc : listNncToRemove) {
                sb.append(this.buildDropNotNullConstraint(nnc.getField(), true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listConstraintsToAdd = comparator.getConstraintsToAdd()).size() > 0) {
            sb.append("\n\n-- ############ Constraints to add ############\n");
            for (SQLConstraint constr : listConstraintsToAdd) {
                sb.append(this.buildAddToTableStatement(constr, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listConstraintsToRemove = comparator.getConstraintsToRemove()).size() > 0) {
            sb.append("\n\n-- ############ Constraints to remove ############\n");
            for (int i = listConstraintsToRemove.size() - 1; i >= 0; --i) {
                SQLConstraint constr = listConstraintsToRemove.get(i);
                sb.append(this.buildDropStatement(constr, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listConstraintsToChange = comparator.getConstraintsToChange()).size() > 0) {
            sb.append("\n\n-- ############ Constraints to change ############\n");
            for (SQLConstraint constr : listConstraintsToChange) {
                sb.append(this.buildDropStatement(constr, true, alternativeSchemaName));
                sb.append(";\n");
                sb.append(this.buildAddToTableStatement(constr, true, alternativeSchemaName));
                sb.append(";\n\n");
            }
        }
        if ((listIndicesToAdd = comparator.getIndicesToAdd()).size() > 0) {
            sb.append("\n\n-- ############ Indices to add ############\n");
            for (SQLIndex index : listIndicesToAdd) {
                sb.append(this.buildCreateStatement(index, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listIndicesToRemove = comparator.getIndicesToRemove()).size() > 0) {
            sb.append("\n\n-- ############ Indices to remove ############\n");
            for (SQLIndex index : listIndicesToRemove) {
                sb.append(this.buildDropStatement(index, true, alternativeSchemaName));
                sb.append(";\n");
            }
        }
        if ((listIndicesToChange = comparator.getIndicesToChange()).size() > 0) {
            sb.append("\n\n-- ############ Indices to change ############\n");
            for (SQLIndex index : listIndicesToChange) {
                sb.append(this.buildDropStatement(index, true, alternativeSchemaName));
                sb.append(";\n");
                sb.append(this.buildCreateStatement(index, true, alternativeSchemaName));
                sb.append(";\n\n");
            }
        }
        if (!(listProceduresToRemove = comparator.getProceduresToRemove()).isEmpty()) {
            sb.append("\n\n-- ############ Procedures to remove ############\n");
            sb.append("\n/\n");
            for (SQLProcedure p : listProceduresToRemove) {
                sb.append(this.buildDropStatement(p, true));
                sb.append(";\n");
                sb.append("\n/\n");
            }
        }
        if (!(listProceduresToAdd = comparator.getProceduresToAdd()).isEmpty()) {
            sb.append("\n\n-- ############ Procedures to add ############\n");
            sb.append("\n/\n");
            for (SQLProcedure p : listProceduresToAdd) {
                sb.append(this.buildCreateStatement(p, true, alternativeSchemaName));
                sb.append(";\n");
                sb.append("\n/\n");
            }
        }
        if (!(listProceduresToChange = comparator.getProceduresToChange()).isEmpty()) {
            sb.append("\n\n-- ############ Procedures to change ############\n");
            sb.append("\n/\n");
            for (SQLProcedure p : listProceduresToChange) {
                sb.append(this.buildDropStatement(p, true));
                sb.append(";\n");
                sb.append(this.buildCreateStatement(p, true, alternativeSchemaName));
                sb.append(";\n");
                sb.append("\n/\n");
            }
        }
        return sb.toString();
    }

    public static List<SQLTable> sortByForeignKeys(List<SQLTable> unsortedTables) {
        ArrayList<SQLTable> sortedList = new ArrayList<SQLTable>();
        for (SQLTable t : unsortedTables) {
            SQLCodeGenerator.sortByForeignKeys(t, sortedList);
        }
        return sortedList;
    }

    private static void sortByForeignKeys(SQLTable table, List<SQLTable> sortedList) {
        List<SQLTable> referencedTables = table.getReferencedTables();
        for (SQLTable rt : referencedTables) {
            if (table.equals(rt)) continue;
            SQLCodeGenerator.sortByForeignKeys(rt, sortedList);
        }
        if (!sortedList.contains(table)) {
            sortedList.add(table);
        }
    }
}

