/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.apache.log4j.Logger;
import sqlrunner.flatfileimport.Importer;
import sqlrunner.flatfileimport.gui.Messages;

public class ImportProgressPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(ImportProgressPanel.class);
    private static final long serialVersionUID = 1L;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JProgressBar jProgressBarLines = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JProgressBar jProgressBarInserted = null;
    private JProgressBar jProgressBarUpdated = null;
    private JProgressBar jProgressBarIgnored = null;
    private JLabel jLabelLines = null;
    private JLabel jLabelInserted = null;
    private JLabel jLabelUpdated = null;
    private JLabel jLabelIgnored = null;
    private JLabel jLabelStartedAt = null;
    private JLabel jLabelCalculatedTimeConsumption = null;
    private JLabel jLabel7 = null;
    private JTextField jTextFieldErrorLogFileName = null;
    private JLabel jLabel8 = null;
    private JLabel jLabel9 = null;
    private JLabel jLabelLinesPerSecond = null;
    private JLabel jLabelFinishedAt = null;
    private transient Importer importer = null;
    private Timer timer = null;
    private static int REFRESH_TIME = 1000;
    private JLabel jLabel6 = null;
    private JTextField jTextFieldCurrentAction = null;
    private JButton jButtonCancel = null;
    private long lastCountLines = 0L;

    public ImportProgressPanel() {
        this.initialize();
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    public Importer getImporter() {
        return this.importer;
    }

    public boolean isMonitorRunning() {
        return this.timer != null && this.timer.isRunning();
    }

    public void startMonitoring() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"startMonitoring()");
        }
        this.reset();
        if (this.importer != null) {
            this.timer = new Timer(REFRESH_TIME, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    long startTime = ImportProgressPanel.this.importer.getStartTime();
                    long currTime = System.currentTimeMillis();
                    long countMaximum = ImportProgressPanel.this.importer.getCountMaxInput();
                    long countLines = ImportProgressPanel.this.importer.getCountCurrInput();
                    long countDiff = countLines - ImportProgressPanel.this.lastCountLines;
                    ImportProgressPanel.this.lastCountLines = countLines;
                    long countInserts = ImportProgressPanel.this.importer.getCountInserts();
                    long countUpdates = ImportProgressPanel.this.importer.getCountUpdates();
                    long countIgnores = ImportProgressPanel.this.importer.getCountIgnored();
                    ImportProgressPanel.this.jTextFieldCurrentAction.setText(ImportProgressPanel.this.importer.getCurrentAction());
                    long expectedTime = ImportProgressPanel.calculateExpectedTimeConsumption(startTime, currTime, countMaximum, countLines);
                    ImportProgressPanel.this.jLabelCalculatedTimeConsumption.setText(ImportProgressPanel.getFormatedTime(expectedTime));
                    ImportProgressPanel.this.setStartTime(startTime);
                    ImportProgressPanel.this.setMaximum((int)countMaximum);
                    long stopTime = ImportProgressPanel.this.importer.getStopTime();
                    if (startTime > 1L && stopTime == 0L) {
                        ImportProgressPanel.this.jButtonCancel.setEnabled(true);
                    } else {
                        ImportProgressPanel.this.jButtonCancel.setEnabled(false);
                    }
                    if (countMaximum > 0L) {
                        ImportProgressPanel.this.jProgressBarLines.setValue((int)countLines);
                        ImportProgressPanel.this.jProgressBarInserted.setValue((int)countInserts);
                        ImportProgressPanel.this.jProgressBarUpdated.setValue((int)countUpdates);
                        ImportProgressPanel.this.jProgressBarIgnored.setValue((int)countIgnores);
                    } else {
                        ImportProgressPanel.this.jProgressBarLines.setValue(0);
                        ImportProgressPanel.this.jProgressBarInserted.setValue(0);
                        ImportProgressPanel.this.jProgressBarUpdated.setValue(0);
                        ImportProgressPanel.this.jProgressBarIgnored.setValue(0);
                    }
                    ImportProgressPanel.this.jLabelLines.setText(String.valueOf(countLines) + " / " + countMaximum);
                    ImportProgressPanel.this.jLabelInserted.setText(String.valueOf(countInserts));
                    ImportProgressPanel.this.jLabelUpdated.setText(String.valueOf(countUpdates));
                    ImportProgressPanel.this.jLabelIgnored.setText(String.valueOf(countIgnores));
                    ImportProgressPanel.this.jLabelLinesPerSecond.setText(String.valueOf(countDiff));
                    ImportProgressPanel.this.setStopTime(stopTime);
                    ImportProgressPanel.this.setLogFileName(ImportProgressPanel.this.importer.getLogFileName());
                    if (stopTime > 0L) {
                        ImportProgressPanel.this.stopMonitoring();
                    }
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    private void setLogFileName(String name) {
        this.jTextFieldErrorLogFileName.setText(name);
    }

    private void stopMonitoring() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"stopMonitoring()");
        }
        if (this.timer == null) {
            throw new IllegalStateException("timer is null");
        }
        this.timer.stop();
    }

    private static long calculateExpectedTimeConsumption(long startTime, long currTime, long maxCountDatasets, long currCountDatasets) {
        if (startTime == 0L || currTime == 0L || maxCountDatasets == 0L || currCountDatasets == 0L) {
            return -1L;
        }
        long timeDiff = (currTime - startTime) / 1000L;
        long quantityLeft = maxCountDatasets - currCountDatasets;
        long expectedTime = quantityLeft * timeDiff / currCountDatasets;
        return expectedTime;
    }

    private static String getFormatedTime(long time) {
        if (time < 0L) {
            return Messages.getString("ImportProgressPanel.calculating");
        }
        StringBuffer sb = new StringBuffer();
        if (time < 60L) {
            sb.append(String.valueOf(time));
            sb.append('s');
        } else if (time < 3600L) {
            sb.append(String.valueOf(time / 60L));
            sb.append("min ");
            sb.append(String.valueOf(time % 60L));
            sb.append('s');
        } else {
            sb.append(time / 3600L);
            sb.append("h ");
            sb.append(time / 60L % 60L);
            sb.append("min");
        }
        return sb.toString();
    }

    private void setMaximum(int lineCount) {
        if (lineCount == 0) {
            lineCount = 100;
        }
        this.jProgressBarLines.setMaximum(lineCount);
        this.jProgressBarInserted.setMaximum(lineCount);
        this.jProgressBarUpdated.setMaximum(lineCount);
        this.jProgressBarIgnored.setMaximum(lineCount);
    }

    private void setStartTime(long startTime) {
        if (startTime > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            this.jLabelStartedAt.setText(sdf.format(new Date(startTime)));
        } else {
            this.jLabelFinishedAt.setText(Messages.getString("ImportProgressPanel.notstarted"));
        }
    }

    private void setStopTime(long stopTime) {
        if (stopTime > 0L) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            this.jLabelFinishedAt.setText(sdf.format(new Date(stopTime)));
        } else {
            this.jLabelFinishedAt.setText(Messages.getString("ImportProgressPanel.notfinished"));
        }
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gb = new GridBagConstraints();
        this.jLabel = new JLabel();
        this.jLabel.setText(Messages.getString("ImportProgressPanel.startedat"));
        gb.gridy = 0;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel, gb);
        this.jLabelStartedAt = new JLabel();
        this.jLabelStartedAt.setText(Messages.getString("ImportProgressPanel.notstarted"));
        gb.gridy = 0;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 2;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 17;
        this.add((Component)this.jLabelStartedAt, gb);
        this.jLabel1 = new JLabel();
        this.jLabel1.setText(Messages.getString("ImportProgressPanel.expectedtime"));
        gb.gridy = 1;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel1, gb);
        this.jLabelCalculatedTimeConsumption = new JLabel();
        this.jLabelCalculatedTimeConsumption.setText(Messages.getString("ImportProgressPanel.willbecalculated"));
        gb.gridy = 1;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 2;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelCalculatedTimeConsumption, gb);
        this.jLabel9 = new JLabel();
        this.jLabel9.setText(Messages.getString("ImportProgressPanel.progressPerSecond"));
        gb.gridy = 2;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel9, gb);
        this.jLabelLinesPerSecond = new JLabel();
        this.jLabel = new JLabel();
        gb.gridy = 2;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelLinesPerSecond, gb);
        this.jLabel6 = new JLabel();
        this.jLabel6.setText(Messages.getString("ImportProgressPanel.runningaction"));
        gb.gridy = 3;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel6, gb);
        gb.gridy = 3;
        gb.gridx = 1;
        gb.gridwidth = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.anchor = 10;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJTextFieldCurrentAction(), gb);
        this.jLabel2 = new JLabel();
        this.jLabel2.setText(Messages.getString("ImportProgressPanel.lines"));
        gb.gridy = 4;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel2, gb);
        gb.gridy = 4;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.anchor = 10;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJProgressBarLines(), gb);
        this.jLabelLines = new JLabel();
        this.jLabelLines.setText("0");
        gb.gridy = 4;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelLines, gb);
        this.jLabel3 = new JLabel();
        this.jLabel3.setText(Messages.getString("ImportProgressPanel.inserted"));
        gb.gridy = 5;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel3, gb);
        gb.gridy = 5;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJProgressBarInserted(), gb);
        this.jLabelInserted = new JLabel();
        this.jLabelInserted.setText("0");
        gb.gridy = 5;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelInserted, gb);
        this.jLabel4 = new JLabel();
        this.jLabel4.setText(Messages.getString("ImportProgressPanel.updated"));
        gb.gridy = 6;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel4, gb);
        gb.gridy = 6;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.anchor = 10;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJProgressBarUpdated(), gb);
        this.jLabelUpdated = new JLabel();
        this.jLabelUpdated.setText("0");
        gb.gridy = 6;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelUpdated, gb);
        this.jLabel5 = new JLabel();
        this.jLabel5.setText(Messages.getString("ImportProgressPanel.ignored"));
        gb.gridy = 7;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel5, gb);
        gb.gridy = 7;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.anchor = 10;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJProgressBarIgnored(), gb);
        this.jLabelIgnored = new JLabel();
        this.jLabelIgnored.setText("0");
        gb.gridy = 7;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelIgnored, gb);
        this.jLabel7 = new JLabel();
        this.jLabel7.setText(Messages.getString("ImportProgressPanel.errorlog"));
        gb.gridy = 8;
        gb.gridx = 0;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 13;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabel7, gb);
        gb.gridy = 8;
        gb.gridx = 1;
        gb.gridwidth = 2;
        gb.weightx = 1.0;
        gb.fill = 2;
        gb.anchor = 10;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJTextFieldErrorLogFileName(), gb);
        this.jLabel8 = new JLabel();
        this.jLabel8.setText(Messages.getString("ImportProgressPanel.finishedat"));
        gb.gridy = 9;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.insets = new Insets(2, 2, 2, 2);
        gb.anchor = 13;
        this.add((Component)this.jLabel8, gb);
        this.jLabelFinishedAt = new JLabel();
        this.jLabelFinishedAt.setText(Messages.getString("ImportProgressPanel.notfinished"));
        gb.gridy = 9;
        gb.gridx = 2;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 2;
        gb.anchor = 17;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.jLabelFinishedAt, gb);
        gb.gridy = 10;
        gb.gridx = 1;
        gb.gridwidth = 1;
        gb.weightx = 0.0;
        gb.fill = 0;
        gb.anchor = 10;
        gb.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJButtonCancel(), gb);
    }

    public void reset() {
        this.jTextFieldCurrentAction.setText(null);
        this.jLabelCalculatedTimeConsumption.setText(null);
        this.jLabelFinishedAt.setText(null);
        this.jLabelIgnored.setText("0");
        this.jLabelInserted.setText("0");
        this.jLabelUpdated.setText("0");
        this.jLabelLines.setText("0");
        this.jLabelLinesPerSecond.setText(null);
        this.jProgressBarIgnored.setValue(0);
        this.jProgressBarInserted.setValue(0);
        this.jProgressBarLines.setValue(0);
        this.jProgressBarUpdated.setValue(0);
        this.jProgressBarIgnored.setMaximum(100);
        this.jProgressBarInserted.setMaximum(100);
        this.jProgressBarLines.setMaximum(100);
        this.jProgressBarUpdated.setMaximum(100);
        this.jTextFieldErrorLogFileName.setText(null);
        this.jButtonCancel.setEnabled(false);
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
    }

    private JProgressBar getJProgressBarLines() {
        if (this.jProgressBarLines == null) {
            this.jProgressBarLines = new JProgressBar();
            this.jProgressBarLines.setStringPainted(true);
        }
        return this.jProgressBarLines;
    }

    private JProgressBar getJProgressBarInserted() {
        if (this.jProgressBarInserted == null) {
            this.jProgressBarInserted = new JProgressBar();
            this.jProgressBarInserted.setStringPainted(true);
        }
        return this.jProgressBarInserted;
    }

    private JProgressBar getJProgressBarUpdated() {
        if (this.jProgressBarUpdated == null) {
            this.jProgressBarUpdated = new JProgressBar();
            this.jProgressBarUpdated.setStringPainted(true);
        }
        return this.jProgressBarUpdated;
    }

    private JProgressBar getJProgressBarIgnored() {
        if (this.jProgressBarIgnored == null) {
            this.jProgressBarIgnored = new JProgressBar();
            this.jProgressBarIgnored.setStringPainted(true);
        }
        return this.jProgressBarIgnored;
    }

    private JTextField getJTextFieldErrorLogFileName() {
        if (this.jTextFieldErrorLogFileName == null) {
            this.jTextFieldErrorLogFileName = new JTextField();
            this.jTextFieldErrorLogFileName.setEditable(false);
            this.jTextFieldErrorLogFileName.setEnabled(true);
        }
        return this.jTextFieldErrorLogFileName;
    }

    private JTextField getJTextFieldCurrentAction() {
        if (this.jTextFieldCurrentAction == null) {
            this.jTextFieldCurrentAction = new JTextField();
            this.jTextFieldCurrentAction.setEditable(false);
        }
        return this.jTextFieldCurrentAction;
    }

    private JButton getJButtonCancel() {
        if (this.jButtonCancel == null) {
            this.jButtonCancel = new JButton();
            this.jButtonCancel.setText("Import Abbrechen");
            this.jButtonCancel.setEnabled(false);
            this.jButtonCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ImportProgressPanel.this.importer.abort();
                }
            });
        }
        return this.jButtonCancel;
    }
}

