/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import sqlrunner.flatfileimport.AbstractFieldTokenizer;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.ParserException;

public class XLSFieldParser
extends AbstractFieldTokenizer {
    private Row row = null;
    private NumberFormat nf = NumberFormat.getInstance(Locale.ENGLISH);
    private final Logger logger = Logger.getLogger(XLSFieldParser.class);

    public XLSFieldParser() {
        this.nf.setGroupingUsed(false);
    }

    @Override
    public int countDelimitedFields() throws ParserException {
        if (this.row != null) {
            return this.row.getLastCellNum();
        }
        return 0;
    }

    @Override
    public boolean parseRawData(List<FieldDescription> fieldDescriptionList) throws ParserException {
        return this.parseRawData(fieldDescriptionList, false);
    }

    @Override
    public boolean parseRawData(List<FieldDescription> fieldDescriptionList, boolean skipConverting) throws ParserException {
        this.setFieldDescriptions(fieldDescriptionList);
        return this.parseRowData(skipConverting);
    }

    @Override
    public boolean parseRawData(Object rowData) throws ParserException {
        this.setRowData(rowData);
        return this.parseRowData(false);
    }

    @Override
    public void setRowData(Object rowData) {
        if (rowData instanceof Row) {
            this.row = (Row)rowData;
        } else {
            if (rowData != null) {
                throw new IllegalArgumentException("rowData must be an instanceof HSSFRow");
            }
            this.row = null;
        }
    }

    private boolean parseRowData(boolean skipConverting) throws ParserException {
        this.clearListData();
        if (this.row != null) {
            boolean valuesAdded = false;
            for (int i = 0; i < this.getCountFieldDescriptions(); ++i) {
                FieldDescription fd = this.getFieldDescriptionAt(i);
                try {
                    if (!this.addDataValue(this.extractData(this.row, fd, skipConverting))) continue;
                    valuesAdded = true;
                    continue;
                }
                catch (Exception e) {
                    if (this.isTestMode()) {
                        String message = e.getClass().getName();
                        if (e.getMessage() != null) {
                            message = " " + e.getMessage();
                        }
                        this.addDataValue("ERROR: " + message);
                        valuesAdded = true;
                        if (!(e instanceof RuntimeException)) continue;
                        this.logger.error((Object)("parseRowData failed: + " + e.getMessage()), (Throwable)e);
                        continue;
                    }
                    if (fd.isIgnoreDatasetIfInvalid()) {
                        return false;
                    }
                    throw new ParserException(e);
                }
            }
            return valuesAdded;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getCellValue(Cell cell, FieldDescription fd, boolean skipConverting) throws Exception {
        Date value = null;
        if (cell == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("getCellValue cell:" + cell.toString() + " field:" + fd.toString()));
        }
        if (fd.getBasicTypeId() == BasicDataType.CHARACTER.getId()) {
            String s = "";
            if (cell.getCellType() == 1) {
                s = cell.getRichStringCellValue().getString();
            } else if (cell.getCellType() == 0) {
                s = this.nf.format(cell.getNumericCellValue());
            } else {
                try {
                    Date d = cell.getDateCellValue();
                    s = d.toString();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (fd.isTrimRequired()) {
                s = s.trim();
            }
            if (fd.getPositionType() == 3 && fd.getLength() > 0 && s != null && s.length() > fd.getLength()) {
                s = s.substring(0, fd.getLength());
            }
            if (s == null) return value;
            if (s.length() <= 0) return value;
            return XLSFieldParser.filter(fd.getFilterPattern(), s);
        }
        if (fd.getBasicTypeId() == BasicDataType.DATE.getId()) {
            if (!skipConverting) return cell.getDateCellValue();
            return cell.getRichStringCellValue().getString();
        }
        if (fd.getBasicTypeId() == BasicDataType.BOOLEAN.getId()) {
            if (skipConverting) {
                return cell.getRichStringCellValue().getString();
            }
            if (cell.getCellType() == 4) {
                return cell.getBooleanCellValue();
            }
            if (cell.getCellType() == 1) {
                return "true".equals(cell.getRichStringCellValue().getString());
            }
            if (cell.getCellType() != 0) return value;
            return cell.getNumericCellValue() > 1.0E-6;
        }
        if (!BasicDataType.isNumberType(fd.getBasicTypeId())) return value;
        if (skipConverting) {
            return cell.getRichStringCellValue().getString();
        }
        if (cell.getCellType() == 0) {
            return cell.getNumericCellValue();
        }
        if (cell.getCellType() == 1 || cell.getCellType() == 3) {
            String s = cell.getRichStringCellValue().getString();
            if (s == null) return 0.0;
            if (s.length() == 0) {
                return 0.0;
            }
            try {
                if (fd.getBasicTypeId() == BasicDataType.DOUBLE.getId()) {
                    return Double.parseDouble(cell.getRichStringCellValue().getString());
                }
                if (fd.getBasicTypeId() == BasicDataType.INTEGER.getId()) {
                    return Integer.parseInt(cell.getRichStringCellValue().getString());
                }
                if (fd.getBasicTypeId() != BasicDataType.LONG.getId()) return value;
                return Long.parseLong(cell.getRichStringCellValue().getString());
            }
            catch (NumberFormatException e) {
                throw new ParserException(e);
            }
        }
        if (cell.getCellType() != 4) throw new Exception("in field " + fd + " cell type cannot be used to convert into number");
        if (!cell.getBooleanCellValue()) return "false";
        return "true";
    }

    private Object extractData(Row row, FieldDescription field, boolean skipConverting) throws Exception {
        Object value = null;
        if (field.getPositionType() == 2 || field.getPositionType() == 3) {
            Cell cell = row.getCell(field.getDelimPos());
            value = this.getCellValue(cell, field, skipConverting);
        }
        if (value == null) {
            if (field.getAlternativeFieldDescription() != null) {
                value = this.extractData(row, field.getAlternativeFieldDescription(), skipConverting);
            }
            if (value == null) {
                value = this.convertStringValue(field, field.getDefaultValue());
            }
        }
        return value;
    }
}

