/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import dbtools.SQLParser;
import dbtools.SQLStatement;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.CSVFieldTokenizer;
import sqlrunner.flatfileimport.CSVFileDatasetProvider;
import sqlrunner.flatfileimport.DatasetProvider;
import sqlrunner.flatfileimport.FieldDescription;
import sqlrunner.flatfileimport.FieldTokenizer;
import sqlrunner.flatfileimport.ImportAttributes;
import sqlrunner.flatfileimport.Importer;
import sqlrunner.flatfileimport.ParserException;
import sqlrunner.flatfileimport.StringInputStream;
import sqlrunner.flatfileimport.XLSFieldParser;
import sqlrunner.flatfileimport.XLSFileDatasetProvider;
import sqlrunner.flatfileimport.XLSXFileDatasetProvider;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.text.StringReplacer;

public class FileImporter
implements Importer {
    private static final Logger staticLogger = Logger.getLogger(FileImporter.class);
    private Logger instanceLogger = staticLogger;
    static final int ROWS_BETWEEN_COMMIT = 1000;
    private long countRowsBetweenCommit = 1000L;
    private String descFilename;
    private File currentDataFile;
    private ArrayList<FieldDescription> fields;
    private DatabaseSession session;
    private Properties additionalProperties = new Properties();
    private int errorCode = -1;
    static String lineSep = System.getProperty("line.separator");
    private String lastErrorMessage;
    private boolean interrupted = false;
    private long startTime;
    private long stopTime;
    private long countLines = 0L;
    private long countInsert = 0L;
    private long countInsertProcessed = 0L;
    private long countUpdate = 0L;
    private long countMaxLines = 0L;
    private String currentAction;
    private boolean running = false;
    private String errorLogFileName = null;
    private boolean testOnly = false;
    private boolean disableDeleteTable = false;
    private String defaultExtension = "csv";
    private ArrayList<String> csvFileExtensions = new ArrayList();
    private ImportAttributes currentAttributs = new ImportAttributes();
    private HashMap<String, Object> lastValues = new HashMap();
    private int batchCounter = 0;

    public FileImporter() {
        this.csvFileExtensions.add("csv");
        this.csvFileExtensions.add("tsv");
        this.csvFileExtensions.add("txt");
    }

    public void addCSVFileExtension(String extension) {
        if (extension == null || extension.isEmpty()) {
            throw new IllegalArgumentException("extension cannot be null or empty");
        }
        this.csvFileExtensions.add(extension.toLowerCase());
    }

    private boolean isCSVFileExt(String ext) {
        if (this.currentAttributs.isHandleFileAlwaysAsCSV()) {
            return true;
        }
        for (String knownExt : this.csvFileExtensions) {
            if (!ext.equalsIgnoreCase(knownExt)) continue;
            return true;
        }
        return false;
    }

    private boolean isXLSFileExt(String ext) {
        if (this.currentAttributs.isHandleFileAlwaysAsCSV()) {
            return false;
        }
        if (ext == null || ext.isEmpty()) {
            throw new IllegalArgumentException("ext cannot be null or empty");
        }
        return ext.equalsIgnoreCase("xls");
    }

    private boolean isXLSXFileExt(String ext) {
        if (this.currentAttributs.isHandleFileAlwaysAsCSV()) {
            return false;
        }
        if (ext == null || ext.isEmpty()) {
            throw new IllegalArgumentException("ext cannot be null or empty");
        }
        return ext.equalsIgnoreCase("xlsx");
    }

    public DatasetProvider createDatasetProvider(File dataFile, boolean testMode, String defaultExt, ImportAttributes opts) throws Exception {
        DatasetProvider provider = null;
        String ext = FileImporter.getFileExtension(dataFile.getName(), defaultExt);
        if (this.isXLSFileExt(ext)) {
            this.getLogger().info((Object)("file " + dataFile + " is a xls spreadsheet. Using " + (opts.getSheetName() != null ? opts.getSheetName() : " first sheet")));
            provider = new XLSFileDatasetProvider();
        } else if (this.isXLSXFileExt(ext)) {
            this.getLogger().info((Object)("file " + dataFile + " is a xlsx spreadsheet. Using " + (opts.getSheetName() != null ? opts.getSheetName() : " first sheet")));
            provider = new XLSXFileDatasetProvider();
        } else if (this.isCSVFileExt(ext) || opts.isHandleFileAlwaysAsCSV()) {
            this.getLogger().info((Object)("file " + dataFile + " is plain text"));
            provider = new CSVFileDatasetProvider();
        } else {
            throw new Exception("Unknown or invalid file extension:" + ext);
        }
        provider.setupDatasetProvider(dataFile, testMode, opts);
        return provider;
    }

    private static String getFileExtension(String fileName, String defaultExt) {
        if (fileName == null || fileName.trim().length() == 0) {
            throw new IllegalArgumentException("fileName cannot be null or empty");
        }
        if (defaultExt == null || defaultExt.trim().length() == 0) {
            throw new IllegalArgumentException("defaultExt cannot be null or empty");
        }
        int pos = fileName.lastIndexOf(46);
        if (pos == -1) {
            return defaultExt;
        }
        String name = fileName.trim().toLowerCase();
        String ext = name.substring(pos + 1);
        if (ext != null && ext.length() > 0) {
            return ext;
        }
        return defaultExt;
    }

    public ImportAttributes getImportAttributes() {
        return this.currentAttributs;
    }

    public boolean isDisableDeleteTable() {
        return this.disableDeleteTable;
    }

    public void setDisableDeleteTable(boolean disableDeleteTable) {
        this.disableDeleteTable = disableDeleteTable;
    }

    public boolean isTestOnly() {
        return this.testOnly;
    }

    public void setTestOnly(boolean testOnly) {
        this.testOnly = testOnly;
    }

    public int getBatchCounter() {
        return this.batchCounter;
    }

    @Override
    public String getCurrentAction() {
        return this.currentAction;
    }

    public void setProperty(String key, String value) {
        this.additionalProperties.setProperty(key, value);
    }

    public String getProperty(String key, String defaultValue) {
        return this.additionalProperties.getProperty(key, defaultValue);
    }

    public void removeProperty(String key) {
        this.additionalProperties.remove(key);
    }

    public void clearProperties() {
        this.additionalProperties.clear();
    }

    protected void resetStatus() {
        this.startTime = 0L;
        this.stopTime = 0L;
        this.errorCode = -1;
        this.stopTime = 0L;
        this.countMaxLines = 0L;
        this.countLines = 0L;
        this.countInsert = 0L;
        this.countUpdate = 0L;
        this.countInsertProcessed = 0L;
        this.batchCounter = 0;
    }

    public boolean connect(ConnectionDescription cd) {
        if (this.running) {
            throw new IllegalStateException("importer is already running");
        }
        this.resetStatus();
        this.currentAction = "connecting";
        this.setErrorCode(0);
        ConnectionDescription localCd = cd.clone();
        localCd.setAutoCommit(false);
        this.session = new DatabaseSession(localCd);
        boolean ok = this.session.loadDriver();
        if (!ok) {
            this.error("load database-driver failed!", 2);
            this.setErrorCode(2);
        }
        if (this.instanceLogger != null) {
            this.session.setLogger(this.instanceLogger);
        }
        return this.session.isConnected();
    }

    public void disconnect() {
        if (this.running) {
            throw new IllegalStateException("importer is already running");
        }
        if (this.session != null && this.session.isConnected()) {
            this.session.close();
            this.session = null;
            if (this.instanceLogger != null) {
                this.instanceLogger.removeAllAppenders();
            }
            this.instanceLogger = null;
        }
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public boolean setImportConfig(String descFilename_loc) {
        this.status("set description-config-file:" + descFilename_loc);
        this.descFilename = descFilename_loc;
        return this.initConfig(new File(this.descFilename));
    }

    public void importData(String filePath) {
        File f = new File(filePath);
        this.importData(f);
    }

    public void importData(File dataFile) {
        if (this.running) {
            throw new IllegalStateException("importer is already running");
        }
        this.currentDataFile = dataFile;
        this.importData();
    }

    public String getDataFileName() {
        return this.currentDataFile.getName();
    }

    public Logger setLogger(Logger localLogger) {
        if (localLogger == null) {
            throw new IllegalArgumentException("localLogger cannot be null");
        }
        if (this.running) {
            throw new IllegalStateException("importer is already running");
        }
        if (this.instanceLogger != null) {
            this.instanceLogger.removeAllAppenders();
        }
        this.instanceLogger = localLogger;
        if (this.session != null) {
            this.session.setLogger(this.instanceLogger);
        }
        return this.instanceLogger;
    }

    public FileAppender createFileAppender(String fileName) throws IOException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM.dd_HH_mm_ss");
        this.errorLogFileName = fileName + "-" + sdf.format(new Date()) + ".import.log";
        FileAppender appender = new FileAppender();
        appender.setFile(this.errorLogFileName, false, true, 8000);
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%d %-5p %m%n");
        appender.setLayout((Layout)layout);
        appender.setImmediateFlush(true);
        return appender;
    }

    public Logger createLogger(String sourceFileName) {
        File f = new File(sourceFileName);
        Logger localLogger = Logger.getLogger((String)(this.getClass().getName() + "-" + f.getName()));
        return localLogger;
    }

    public void setupLocalLoggerWithFileAppender(String sourceFileName) throws IOException {
        this.setupLocalLogger(sourceFileName).addAppender((Appender)this.createFileAppender(sourceFileName));
    }

    public Logger setupLocalLogger(String sourceFileName) {
        this.setLogger(this.createLogger(sourceFileName));
        return this.getLogger();
    }

    public Logger setupLoggerAsStaticClassLogger() {
        this.instanceLogger = staticLogger;
        return this.instanceLogger;
    }

    public Logger getLogger() {
        if (this.instanceLogger == null) {
            this.instanceLogger = staticLogger;
        }
        return this.instanceLogger;
    }

    public void importData() {
        if (this.running) {
            throw new IllegalStateException("importer is already running");
        }
        if (this.instanceLogger == null) {
            throw new IllegalStateException("logger is not configured");
        }
        if (this.testOnly) {
            this.instanceLogger.info((Object)"run in test mode");
        }
        if (this.currentDataFile != null) {
            try {
                this.running = true;
                if (this.runPreProcessSQL() && this.runImport()) {
                    this.runPostProcessSQL();
                }
                this.running = false;
            }
            catch (Exception e) {
                this.getLogger().error((Object)("importData failed: " + e.getMessage()), (Throwable)e);
                this.setErrorCode(2);
                this.running = false;
            }
        } else {
            this.error("data-file expected !", 2);
        }
        this.stopTime = System.currentTimeMillis();
        switch (this.errorCode) {
            case 0: {
                this.status("\nJob ends successful.");
                break;
            }
            case 1: {
                this.status("\nJob ends with warnings !");
                break;
            }
            case 2: {
                this.status("\nJob ends with fatals !");
            }
        }
    }

    private void runPostProcessSQL() {
        if (this.currentAttributs.isPostProcessEnabled()) {
            this.status("run post process SQL");
            this.currentAction = "Replace SQL parameters";
            String sql = this.replaceParameters(this.currentAttributs.getPostProcessSQL());
            this.currentAction = "Parse post process SQL script";
            SQLParser parser = new SQLParser(sql);
            SQLStatement stat = null;
            for (int i = 0; i < parser.getStatementCount(); ++i) {
                this.currentAction = "Execute post process SQL (" + i + ")";
                stat = parser.getStatementAt(i);
                if (this.testOnly) continue;
                this.session.execute(stat.getSQL());
                if (this.session.isSuccessful()) {
                    this.session.commit();
                    continue;
                }
                this.error(this.session.getLastErrorMessage(), 2);
                this.session.rollback();
                break;
            }
            this.currentAction = "Post process SQL proceeded";
            this.status("finished");
        }
    }

    private boolean runPreProcessSQL() {
        boolean ok = true;
        if (this.currentAttributs.isPreProcessEnabled()) {
            this.status("run pre process SQL");
            this.currentAction = "Replace SQL parameters";
            String sql = this.replaceParameters(this.currentAttributs.getPreProcessSQL());
            this.currentAction = "Parse pre process SQL script";
            SQLParser parser = new SQLParser(sql);
            SQLStatement stat = null;
            for (int i = 0; i < parser.getStatementCount(); ++i) {
                this.currentAction = "Execute pre process SQL (" + i + ")";
                stat = parser.getStatementAt(i);
                if (this.testOnly) continue;
                this.session.execute(stat.getSQL());
                if (this.session.isSuccessful()) {
                    this.session.commit();
                    continue;
                }
                ok = false;
                this.error(this.session.getLastErrorMessage(), 2);
                this.session.rollback();
                break;
            }
            this.currentAction = "Pre process SQL proceeded";
            this.status("finished");
        }
        return ok;
    }

    private String replaceParameters(String sql) {
        FieldDescription field = null;
        if (sql != null) {
            StringReplacer sr = new StringReplacer(sql);
            for (int i = 0; i < this.fields.size(); ++i) {
                field = this.fields.get(i);
                sr.replace("{field." + field.getName() + ".defaultValue}", field.getDefaultValue(), false);
                sr.replace("{field." + field.getName() + ".lastValue}", this.getLastValue(field.getName()).toString(), false);
                sr.replace("{field." + field.getName() + ".generatorStartValue}", field.getGeneratorStartValue(), false);
            }
            if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
                Map.Entry<Object, Object> entry2 = null;
                for (Map.Entry<Object, Object> entry2 : this.additionalProperties.entrySet()) {
                    sr.replace("{prop." + ((String)entry2.getKey()).toLowerCase() + ".value}", (String)entry2.getValue(), false);
                }
            }
            return sr.getResultText();
        }
        return null;
    }

    public File getConfigFile() {
        File f = new File(this.descFilename);
        if (f.exists()) {
            return f;
        }
        return null;
    }

    public boolean initConfig(File descFile) {
        this.currentAction = "Load config file";
        if (descFile == null) {
            throw new IllegalArgumentException("descFile cannot be null");
        }
        if (!descFile.exists()) {
            this.error("initConfig failed: descFile=" + descFile.getAbsolutePath() + " doesn't exist!", 2);
            return false;
        }
        this.status("read description-properties from file " + descFile.getAbsolutePath());
        this.fields = new ArrayList();
        boolean ok = this.initConfig(this.loadProperties(descFile));
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(File propertiesFile) {
        FileInputStream fin = null;
        Properties importProperties = new Properties();
        try {
            fin = new FileInputStream(propertiesFile);
            importProperties.load(fin);
        }
        catch (IOException ioe) {
            this.error(ioe.getMessage(), 2);
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (Exception e) {}
            }
        }
        return importProperties;
    }

    public boolean initConfig(String propertiesAsString) {
        if (propertiesAsString == null) {
            this.error("initConfig propertiesAsString cannot be null", 2);
            return false;
        }
        Properties importProperties = new Properties();
        try {
            StringInputStream in = new StringInputStream(propertiesAsString);
            importProperties.load(in);
            in.close();
        }
        catch (Exception e) {
            this.error("initConfig with String failed:" + e.getMessage(), 2);
            return false;
        }
        return this.initConfig(importProperties);
    }

    private int extractIndexFromKey(String key) {
        int p1;
        int p0;
        int index = -1;
        if (key.startsWith("COLUMN_") && key.endsWith("_NAME") && (p0 = key.indexOf("_")) != -1 && (p1 = key.indexOf("_", p0 + 1)) != -1) {
            try {
                index = Integer.parseInt(key.substring(p0 + 1, p1));
            }
            catch (Exception e) {
                this.getLogger().warn((Object)("invalid key, no valid index found. Exception: " + e.getMessage()), (Throwable)e);
            }
        }
        return index;
    }

    private ArrayList<Integer> collectFieldDescriptionIndexes(Properties properties) {
        ArrayList<Integer> listIndexes = new ArrayList<Integer>();
        int index = 0;
        for (Object key : properties.keySet()) {
            Integer indexObj;
            index = this.extractIndexFromKey((String)key);
            if (index == -1 || listIndexes.contains(indexObj = Integer.valueOf(index))) continue;
            listIndexes.add(indexObj);
        }
        Collections.sort(listIndexes);
        return listIndexes;
    }

    public boolean initConfig(Properties importProperties) {
        this.currentAction = "Setup import configuration";
        this.resetStatus();
        this.interrupted = false;
        this.status("read descriptions from properties...");
        this.fields = new ArrayList();
        if (importProperties == null || importProperties.isEmpty()) {
            this.error("importProperties cannot be null or empty", 2);
            return false;
        }
        boolean ok = true;
        try {
            this.currentAttributs = new ImportAttributes();
            this.currentAttributs.setupFrom(importProperties);
            if (this.currentAttributs.getBatchSize() > 1) {
                this.getLogger().info((Object)("Use batch size of " + this.currentAttributs.getBatchSize()));
            }
            ArrayList<Integer> listIndexes = this.collectFieldDescriptionIndexes(importProperties);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("initConfig found " + listIndexes.size() + " columns"));
            }
            int index = 0;
            for (Integer propertySearchIndex : listIndexes) {
                this.fields.add(new FieldDescription(index++, propertySearchIndex, importProperties));
            }
            for (int d = 0; d < this.fields.size(); ++d) {
                FieldDescription fd = this.fields.get(d);
                if (fd.getAlternativeFieldDescriptionName() != null) {
                    fd.setAlternativeFieldDescription(this.getFieldDescription(fd.getAlternativeFieldDescriptionName()));
                }
                if (!fd.validate()) {
                    ok = false;
                    this.error("check FieldDescription:" + fd.toString() + ":" + fd.getErrorMessage(), 1);
                    continue;
                }
                if (!BasicDataType.isNumberType(fd.getBasicTypeId()) || fd.getFieldFormat() != null) continue;
                this.error("field " + fd + " has numeric type without defined number locale. This can result in wrong parsing if value is a fraction number", 1);
            }
        }
        catch (Exception ex) {
            this.error(ex.getMessage(), 2);
            ok = false;
        }
        return ok;
    }

    public List<FieldDescription> getFieldDescriptions() {
        return this.fields;
    }

    private void resetAutoValueGenerators() {
        this.status("reset auto value generators");
        FieldDescription fd = null;
        for (int i = 0; i < this.fields.size(); ++i) {
            fd = this.fields.get(i);
            fd.resetAutValueGenerator();
        }
    }

    public FieldDescription getFieldDescription(String name) {
        FieldDescription fd = null;
        for (int i = 0; i < this.fields.size(); ++i) {
            fd = this.fields.get(i);
            if (fd.getName() == null || !fd.getName().equalsIgnoreCase(name)) continue;
            return fd;
        }
        return null;
    }

    public FieldDescription getFieldDescription(int index) {
        if (this.fields != null) {
            return this.fields.get(index);
        }
        return null;
    }

    public int getCountFieldDescriptions() {
        if (this.fields != null) {
            return this.fields.size();
        }
        return 0;
    }

    private PreparedStatement createTestStatement() {
        PreparedStatement ps;
        StringBuffer sqlBf = new StringBuffer();
        boolean isFirstLoop = true;
        for (int f = 0; f < this.fields.size(); ++f) {
            FieldDescription fieldTemp = this.fields.get(f);
            if (!fieldTemp.isPartOfPrimaryKey()) continue;
            if (isFirstLoop) {
                isFirstLoop = false;
                sqlBf.append("select count(");
                sqlBf.append(SQLCodeGenerator.getInstance().getEncapsulatedName(fieldTemp.getName()));
                sqlBf.append(") from ");
                sqlBf.append(SQLCodeGenerator.getInstance().getEncapsulatedName(this.currentAttributs.getTableName()));
                sqlBf.append(" where ");
            } else {
                sqlBf.append(" and ");
            }
            sqlBf.append(SQLCodeGenerator.getInstance().getEncapsulatedName(fieldTemp.getName()));
            sqlBf.append("=?");
        }
        if (this.isDebugEnabled()) {
            this.debug("test statement SQL:" + sqlBf.toString());
        }
        if (isFirstLoop) {
            this.status("createTestStatement for table " + this.currentAttributs.getTableName() + " has in Description NO primary keys defined !");
            return null;
        }
        try {
            ps = this.session.createPreparedStatement(sqlBf.toString());
        }
        catch (SQLException sqle) {
            this.error("createTestStatement for table " + this.currentAttributs.getTableName() + " failed!\n" + sqle.getMessage(), 2);
            ps = null;
        }
        return ps;
    }

    private PreparedStatement createInsertStatement() {
        PreparedStatement ps;
        FieldDescription fieldTemp;
        int f;
        StringBuffer sqlBf = new StringBuffer();
        sqlBf.append("insert into " + this.currentAttributs.getTableName() + " (");
        boolean isFirstLoop = true;
        for (f = 0; f < this.fields.size(); ++f) {
            fieldTemp = this.fields.get(f);
            if (!fieldTemp.isEnabled()) continue;
            if (isFirstLoop) {
                isFirstLoop = false;
            } else {
                sqlBf.append(',');
            }
            sqlBf.append(fieldTemp.getName());
        }
        sqlBf.append(") values (");
        isFirstLoop = true;
        for (f = 0; f < this.fields.size(); ++f) {
            fieldTemp = this.fields.get(f);
            if (!fieldTemp.isEnabled()) continue;
            if (isFirstLoop) {
                isFirstLoop = false;
            } else {
                sqlBf.append(',');
            }
            if (fieldTemp.getBasicTypeId() == BasicDataType.SQLEXP.getId()) {
                sqlBf.append(fieldTemp.getDefaultValue());
                continue;
            }
            sqlBf.append('?');
        }
        sqlBf.append(')');
        if (this.isDebugEnabled()) {
            this.debug("insert statement SQL:" + sqlBf.toString());
        }
        try {
            ps = this.session.createPreparedStatement(sqlBf.toString());
        }
        catch (SQLException sqle) {
            this.error("createInsertStatement for table " + this.currentAttributs.getTableName() + " failed!\n" + sqle.getMessage(), 2);
            ps = null;
        }
        return ps;
    }

    private PreparedStatement createUpdateStatement() {
        PreparedStatement ps;
        FieldDescription fieldTemp;
        StringBuffer sqlBf = new StringBuffer();
        sqlBf.append("update ");
        sqlBf.append(this.currentAttributs.getTableName());
        sqlBf.append(" set ");
        boolean isFirstLoop = true;
        for (int f = 0; f < this.fields.size(); ++f) {
            fieldTemp = this.fields.get(f);
            if (!fieldTemp.isEnabled() || fieldTemp.isPartOfPrimaryKey()) continue;
            if (isFirstLoop) {
                isFirstLoop = false;
            } else {
                sqlBf.append(',');
            }
            if (fieldTemp.isAggregateNumberValues() && BasicDataType.isNumberType(fieldTemp.getBasicTypeId())) {
                sqlBf.append(fieldTemp.getName());
                sqlBf.append('=');
                sqlBf.append(fieldTemp.getName());
                sqlBf.append("+?");
                continue;
            }
            if (fieldTemp.getBasicTypeId() == BasicDataType.SQLEXP.getId()) {
                sqlBf.append(fieldTemp.getName());
                sqlBf.append("=");
                sqlBf.append(fieldTemp.getDefaultValue());
                continue;
            }
            sqlBf.append(fieldTemp.getName());
            sqlBf.append("=?");
        }
        sqlBf.append(" where ");
        isFirstLoop = true;
        for (int x = 0; x < this.fields.size(); ++x) {
            fieldTemp = this.fields.get(x);
            if (!fieldTemp.isPartOfPrimaryKey()) continue;
            if (isFirstLoop) {
                isFirstLoop = false;
            } else {
                sqlBf.append(" and ");
            }
            sqlBf.append(fieldTemp.getName());
            if (fieldTemp.getBasicTypeId() == BasicDataType.SQLEXP.getId()) {
                sqlBf.append("=");
                sqlBf.append(fieldTemp.getDefaultValue());
                continue;
            }
            sqlBf.append("=?");
        }
        if (this.isDebugEnabled()) {
            this.debug("update statement SQL:" + sqlBf.toString());
        }
        try {
            ps = this.session.createPreparedStatement(sqlBf.toString());
        }
        catch (SQLException sqle) {
            this.error("createUpdateStatement for table " + this.currentAttributs.getTableName() + " failed!\n" + sqle.getMessage(), 2);
            ps = null;
        }
        return ps;
    }

    private boolean existsDataset(FieldTokenizer parser, PreparedStatement ps, long lineNumber) throws ParserException {
        boolean exist = true;
        int paramIndex = 1;
        try {
            for (int p = 0; p < this.fields.size(); ++p) {
                FieldDescription fieldDescription = this.fields.get(p);
                if (!fieldDescription.isPartOfPrimaryKey() || fieldDescription.getBasicTypeId() == BasicDataType.SQLEXP.getId()) continue;
                Object value = parser.getData(fieldDescription.getIndex());
                this.setParameterValue(fieldDescription, ps, paramIndex, value);
                ++paramIndex;
            }
            ResultSet rs = ps.executeQuery();
            if (rs.next()) {
                int count = rs.getInt(1);
                if (count == 0) {
                    exist = false;
                } else if (count == 1) {
                    exist = true;
                } else {
                    this.error("isDatasetExists: primary key not correct, more than one dataset found data in line " + lineNumber, 2);
                    exist = false;
                }
            }
            rs.close();
        }
        catch (SQLException sqle) {
            this.error("isDatasetExists: in line:" + String.valueOf(lineNumber) + " failed " + sqle.getMessage(), 1);
            exist = false;
        }
        return exist;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setParameterValue(FieldDescription fd, PreparedStatement ps, int paramIndex, Object value) throws SQLException, ParserException {
        if (this.isDebugEnabled()) {
            this.debug("param at " + paramIndex + " value: " + value);
        }
        try {
            if (fd.getBasicTypeId() == BasicDataType.DATE.getId()) {
                if (value != null) {
                    if (value instanceof Timestamp) {
                        ps.setTimestamp(paramIndex, (Timestamp)value);
                    } else {
                        if (!(value instanceof Date)) throw new ParserException("in field " + fd + " date value has not valid class " + value.getClass());
                        ps.setTimestamp(paramIndex, new Timestamp(((Date)value).getTime()));
                    }
                } else {
                    ps.setNull(paramIndex, 93);
                }
            } else if (fd.getBasicTypeId() == BasicDataType.DOUBLE.getId()) {
                if (value != null) {
                    ps.setDouble(paramIndex, ((Number)value).doubleValue());
                } else {
                    ps.setNull(paramIndex, 8);
                }
            } else if (fd.getBasicTypeId() == BasicDataType.INTEGER.getId()) {
                if (value != null) {
                    ps.setInt(paramIndex, ((Number)value).intValue());
                } else {
                    ps.setNull(paramIndex, 4);
                }
            } else if (fd.getBasicTypeId() == BasicDataType.LONG.getId()) {
                if (value != null) {
                    ps.setLong(paramIndex, ((Number)value).longValue());
                } else {
                    ps.setNull(paramIndex, -5);
                }
            } else if (fd.getBasicTypeId() == BasicDataType.BOOLEAN.getId()) {
                if (value != null) {
                    ps.setBoolean(paramIndex, (Boolean)value);
                } else {
                    ps.setNull(paramIndex, 16);
                }
            } else {
                if (fd.getBasicTypeId() == BasicDataType.SQLEXP.getId()) {
                    throw new ParserException("FieldDescription with basic type SQL expr cannot be used in this method");
                }
                if (value != null) {
                    ps.setString(paramIndex, (String)value);
                } else {
                    ps.setNull(paramIndex, 12);
                }
            }
            if (value == null) return;
            this.putLastValue(fd.getName(), value);
            return;
        }
        catch (ClassCastException cce) {
            throw new ParserException(cce);
        }
    }

    private int insertRow(FieldTokenizer parser, PreparedStatement ps, long lineNumber) {
        int count = 0;
        int paramIndex = 1;
        if (this.isDebugEnabled()) {
            this.debug("insertRow: for table " + this.currentAttributs.getTableName() + " line number:" + lineNumber);
        }
        try {
            for (int f = 0; f < this.fields.size(); ++f) {
                FieldDescription fieldDescription = this.fields.get(f);
                if (!fieldDescription.isEnabled() || fieldDescription.getBasicTypeId() == BasicDataType.SQLEXP.getId()) continue;
                Object value = parser.getData(fieldDescription.getIndex());
                this.setParameterValue(fieldDescription, ps, paramIndex, value);
                ++paramIndex;
            }
            if (this.testOnly) {
                count = 1;
            } else if (this.currentAttributs.getBatchSize() > 1) {
                ps.addBatch();
                ++this.batchCounter;
                if (this.batchCounter == this.currentAttributs.getBatchSize()) {
                    int[] counters;
                    for (int i : counters = ps.executeBatch()) {
                        count += i >= 0 ? i : 1;
                    }
                    this.batchCounter = 0;
                    this.session.commit();
                }
            } else {
                count = ps.executeUpdate();
            }
        }
        catch (SQLException sqle) {
            count = -1;
            this.error("insertRow: in line:" + String.valueOf(lineNumber) + " failed:" + sqle.getMessage(), 1);
        }
        catch (ParserException pe) {
            count = -1;
            this.error("insertRow: in line:" + String.valueOf(lineNumber) + " failed:" + pe.getMessage(), 1);
        }
        if (count >= 0 && !this.testOnly && this.isDebugEnabled()) {
            this.debug("insertRow: row successful inserted.");
        }
        return count;
    }

    private int updateRow(FieldTokenizer parser, PreparedStatement ps, long lineNumber) {
        if (this.isDebugEnabled()) {
            this.debug("updateRow(ps=" + ps + ", counter=" + lineNumber + ")");
        }
        int count = 0;
        int paramIndex = 1;
        try {
            Object value;
            FieldDescription fieldTemp;
            for (int f = 0; f < this.fields.size(); ++f) {
                fieldTemp = this.fields.get(f);
                if (!fieldTemp.isEnabled() || fieldTemp.isPartOfPrimaryKey() || fieldTemp.getBasicTypeId() == BasicDataType.SQLEXP.getId()) continue;
                value = parser.getData(fieldTemp.getIndex());
                this.setParameterValue(fieldTemp, ps, paramIndex, value);
                ++paramIndex;
            }
            for (int p = 0; p < this.fields.size(); ++p) {
                fieldTemp = this.fields.get(p);
                if (!fieldTemp.isPartOfPrimaryKey() || fieldTemp.getBasicTypeId() == BasicDataType.SQLEXP.getId()) continue;
                value = parser.getData(fieldTemp.getIndex());
                this.setParameterValue(fieldTemp, ps, paramIndex, value);
                ++paramIndex;
            }
            count = this.testOnly ? 1 : ps.executeUpdate();
        }
        catch (SQLException sqle) {
            count = -1;
            this.error("updateRow: in line:" + String.valueOf(lineNumber) + " failed:" + sqle.getMessage(), 1);
        }
        catch (ParserException pe) {
            count = -1;
            this.error("updateRow: in line:" + String.valueOf(lineNumber) + " failed:" + pe.getMessage(), 1);
        }
        if (count == 1) {
            if (this.isDebugEnabled()) {
                this.debug("update successful.");
            }
        } else if (count == 0) {
            this.error("updateRow: dataset NOT updated ! in line:\n" + lineNumber, 1);
        } else if (count > 1) {
            this.error("updateRow: in line:" + String.valueOf(lineNumber) + " more than ONE (" + count + ") datasets updated !\n", 2);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runImport() {
        this.errorCode = 0;
        this.resetAutoValueGenerators();
        this.startTime = System.currentTimeMillis();
        this.status("run import for table " + this.currentAttributs.getTableName());
        if (this.currentAttributs.getBatchSize() > 0) {
            this.status("Ignore commit size and commit after each batch execute");
        }
        if (this.getFieldDescriptions() == null || this.getFieldDescriptions().isEmpty()) {
            this.error("runImport failed: list of fielddescriptions is null or empty", 2);
            return false;
        }
        if (this.currentAttributs.isInsertEnabled()) {
            this.status("* inserts enabled");
        }
        if (this.currentAttributs.isUpdateEnabled()) {
            this.status("* update enabled");
        }
        try {
            PreparedStatement psInsert;
            PreparedStatement psTest = null;
            if (psTest == null && this.currentAttributs.isUpdateEnabled()) {
                psTest = this.createTestStatement();
            }
            PreparedStatement psUpdate = null;
            if (psTest != null && this.currentAttributs.isUpdateEnabled()) {
                psUpdate = this.createUpdateStatement();
            }
            if ((psInsert = null) == null && this.currentAttributs.isInsertEnabled()) {
                psInsert = this.createInsertStatement();
            }
            if (this.currentAttributs.isDeleteBeforeImport() && !this.isTestOnly() && !this.isDisableDeleteTable()) {
                this.currentAction = "Delete table data";
                this.status("delete former table data...");
                this.session.executeUpdate("delete from " + this.currentAttributs.getTableName());
                if (!this.session.isSuccessful()) {
                    this.error("delete table data failed: " + this.session.getLastErrorMessage(), 2);
                }
            }
            if (this.errorCode != 2) {
                DatasetProvider datasetProvider = null;
                try {
                    block46: {
                        this.currentAction = "Start import data";
                        this.status("import file " + this.currentDataFile.getAbsolutePath());
                        if (this.currentAttributs.isHandleFileAlwaysAsCSV()) {
                            this.status("Ignore file extension and handle file as CSV!");
                        }
                        datasetProvider = this.createDatasetProvider(this.currentDataFile, false, this.defaultExtension, this.currentAttributs);
                        this.countMaxLines = datasetProvider.retrieveDatasetCount();
                        if (this.currentAttributs.isSkipFirstRow()) {
                            --this.countMaxLines;
                        }
                        int countDifference = 0;
                        boolean firstLoop = true;
                        FieldTokenizer parser = datasetProvider.createParser();
                        parser.setFieldDescriptions(this.getFieldDescriptions());
                        if (parser instanceof CSVFieldTokenizer) {
                            ((CSVFieldTokenizer)parser).setDelimiter(this.currentAttributs.getDelimiter());
                            ((CSVFieldTokenizer)parser).setEnclosure(this.currentAttributs.getEnclosure());
                        }
                        Object dataset = null;
                        long currentRowsToSkip = this.currentAttributs.getCountSkipRows();
                        if (currentRowsToSkip > 0L) {
                            this.status("first " + currentRowsToSkip + " will be skipped");
                            this.countMaxLines -= currentRowsToSkip;
                        }
                        this.status("count lines to import=" + this.countMaxLines);
                        while (true) {
                            dataset = datasetProvider.getNextDataset();
                            if (this.interrupted || Thread.currentThread().isInterrupted()) {
                                this.status("Import interrupted");
                                break block46;
                            }
                            if (this.currentAttributs.getCountSkipRows() > 0L && currentRowsToSkip > 0L) {
                                this.currentAction = "Skip datasets";
                                --currentRowsToSkip;
                                continue;
                            }
                            if (this.currentAttributs.isSkipFirstRow() && firstLoop) {
                                firstLoop = false;
                                continue;
                            }
                            if (dataset == null) break block46;
                            ++countDifference;
                            try {
                                this.currentAction = "Read and import data";
                                if (parser.parseRawData(dataset)) {
                                    if (!this.currentAttributs.isUpdateEnabled() || psTest == null) {
                                        int count;
                                        if (this.currentAttributs.isInsertEnabled() && (count = this.insertRow(parser, psInsert, this.countLines)) >= 0) {
                                            this.countInsertProcessed += (long)count;
                                            ++this.countInsert;
                                        }
                                    } else {
                                        int count;
                                        this.currentAttributs.setBatchSize(0);
                                        if (this.existsDataset(parser, psTest, this.countLines)) {
                                            int count2;
                                            if (this.currentAttributs.isUpdateEnabled() && (count2 = this.updateRow(parser, psUpdate, this.countLines)) >= 0) {
                                                ++this.countUpdate;
                                            }
                                        } else if (this.currentAttributs.isInsertEnabled() && (count = this.insertRow(parser, psInsert, this.countLines)) >= 0) {
                                            this.countInsertProcessed += (long)count;
                                            ++this.countInsert;
                                        }
                                    }
                                }
                            }
                            catch (ParserException ex) {
                                this.error("parse value in linenumber=" + this.countLines + " failed: " + ex.getMessage(), 1);
                            }
                            ++this.countLines;
                            if (this.currentAttributs.getBatchSize() == 0 && (long)countDifference == this.countRowsBetweenCommit) {
                                countDifference = 0;
                                this.session.commit();
                            }
                            if (this.errorCode == 2) break;
                        }
                        this.status(" ERRORS occurse whilst import - reading aborted !");
                    }
                    if (this.batchCounter > 0) {
                        int[] counters;
                        for (int i : counters = psInsert.executeBatch()) {
                            this.countInsertProcessed += (long)(i >= 0 ? i : 1);
                        }
                    }
                    this.session.commit();
                    if (this.interrupted) {
                        this.status("INTERRUPT IMPORT");
                    }
                    this.status("READY: " + String.valueOf(this.countLines) + " datasets proceeded:");
                    this.status("  - inserted: " + String.valueOf(this.countInsert) + " / insert processed: " + String.valueOf(this.countInsertProcessed) + " updated: " + String.valueOf(this.countUpdate) + " ignored: " + String.valueOf(this.countLines - this.countInsert - this.countUpdate));
                }
                catch (FileNotFoundException fne) {
                    this.error("writeData: open file " + this.currentDataFile + "\n" + fne.getMessage(), 2);
                }
                catch (Exception e) {
                    this.error("writeData: read file " + this.currentDataFile + "\n" + e.getMessage(), 2);
                }
                finally {
                    if (datasetProvider != null) {
                        this.status("close file");
                        datasetProvider.closeDatasetProvider();
                    }
                }
            }
            if (psTest != null) {
                psTest.close();
            }
            if (psUpdate != null) {
                psUpdate.close();
            }
            if (psInsert != null) {
                psInsert.close();
            }
            if (!this.session.isSuccessful()) {
                this.error(this.session.getLastErrorMessage(), 1);
            }
        }
        catch (SQLException sqle) {
            this.error(sqle.getMessage(), 2);
        }
        this.currentAction = "import data finished";
        return this.errorCode != 2 && !this.interrupted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long retrieveDatasetCount(File file) {
        long count = 0L;
        DatasetProvider dsp = null;
        try {
            dsp = this.createDatasetProvider(file, false, this.defaultExtension, this.currentAttributs);
            count = dsp.retrieveDatasetCount();
        }
        catch (Exception e) {
            this.getLogger().error((Object)("retrieveDatasetCount file=" + file + " failed: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (dsp != null) {
                dsp.closeDatasetProvider();
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long retrieveDatasetCount(File file, ImportAttributes opts) {
        long count = 0L;
        DatasetProvider dsp = null;
        try {
            dsp = this.createDatasetProvider(file, false, this.defaultExtension, opts);
            count = dsp.retrieveDatasetCount();
        }
        catch (Exception e) {
            this.getLogger().error((Object)("retrieveDatasetCount file=" + file + " failed: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (dsp != null) {
                dsp.closeDatasetProvider();
            }
        }
        return count;
    }

    protected boolean isDebugEnabled() {
        if (this.instanceLogger != null) {
            return this.instanceLogger.isDebugEnabled();
        }
        return staticLogger.isDebugEnabled();
    }

    protected void debug(String message) {
        if (this.instanceLogger != null) {
            this.instanceLogger.debug((Object)message);
        } else {
            staticLogger.debug((Object)message);
        }
    }

    protected void status(String message) {
        if (this.instanceLogger != null) {
            this.instanceLogger.info((Object)message);
        } else {
            staticLogger.info((Object)message);
        }
    }

    public void reset() {
        this.setErrorCode(0);
        this.startTime = 0L;
        this.stopTime = 0L;
        this.countLines = 0L;
        this.countInsert = 0L;
        this.countInsertProcessed = 0L;
        this.countUpdate = 0L;
        this.batchCounter = 0;
        this.lastErrorMessage = null;
        this.fields = new ArrayList();
        this.lastValues.clear();
        this.errorLogFileName = null;
        if (this.session != null) {
            this.session.close();
        }
    }

    protected void error(String message, int errorcode) {
        this.error(message, this.errorCode, null);
    }

    protected void error(String message, int errorcode, Throwable t) {
        Logger logger;
        Logger logger2 = logger = this.instanceLogger != null ? this.instanceLogger : staticLogger;
        if (errorcode == 2) {
            if (t != null) {
                SQLException ne;
                logger.error((Object)message, t);
                if (t instanceof SQLException && (ne = ((SQLException)t).getNextException()) != null && ne != t) {
                    logger.error((Object)"next exception:", t);
                }
            } else {
                logger.error((Object)message);
            }
        } else if (t != null) {
            SQLException ne;
            logger.warn((Object)message, t);
            if (t instanceof SQLException && (ne = ((SQLException)t).getNextException()) != null && ne != t) {
                logger.warn((Object)"next exception:", t);
            }
        } else {
            logger.warn((Object)message);
        }
        this.lastErrorMessage = message;
        this.setErrorCode(errorcode);
    }

    @Override
    public String getLogFileName() {
        if (this.errorCode > 0) {
            return this.errorLogFileName;
        }
        return null;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public boolean isSuccessful() {
        return this.errorCode == 0;
    }

    protected void setErrorCode(int code) {
        if (this.errorCode < code) {
            this.errorCode = code;
        }
    }

    @Override
    public long getCountMaxInput() {
        return this.countMaxLines;
    }

    @Override
    public long getCountUpdates() {
        return this.countUpdate;
    }

    @Override
    public void abort() {
        this.interrupt();
    }

    @Override
    public long getCountCurrInput() {
        return this.countLines;
    }

    @Override
    public long getCountIgnored() {
        return this.countLines - this.countInsert - this.countUpdate;
    }

    @Override
    public long getCountInserts() {
        return this.countInsert;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public int getStatusCode() {
        return this.errorCode;
    }

    @Override
    public long getStopTime() {
        return this.stopTime;
    }

    @Override
    public boolean isRunning() {
        return this.startTime > 0L && this.stopTime == 0L;
    }

    @Override
    public boolean isStopped() {
        return this.stopTime > 0L;
    }

    public String getDefaultExtension() {
        return this.defaultExtension;
    }

    public void setDefaultExtension(String ext) {
        if (ext != null && ext.trim().length() > 0) {
            if ((ext = ext.trim()).endsWith(".")) {
                throw new IllegalArgumentException("ext cannot end with a dot");
            }
            int pos = ext.lastIndexOf(".");
            this.defaultExtension = pos != -1 ? ext.substring(pos + 1) : ext;
        }
    }

    public boolean isXLSFile(File f) {
        return this.isXLSFileExt(FileImporter.getFileExtension(f.getName(), this.defaultExtension));
    }

    public boolean isXLSXFile(File f) {
        return this.isXLSXFileExt(FileImporter.getFileExtension(f.getName(), this.defaultExtension));
    }

    public boolean isExcelFile(File f) {
        return this.isXLSFile(f) || this.isXLSXFile(f);
    }

    public boolean isDataFile(File f) {
        return this.isCSVFile(f) || this.isExcelFile(f);
    }

    public boolean isCSVFile(File f) {
        return this.isCSVFileExt(FileImporter.getFileExtension(f.getName(), this.defaultExtension));
    }

    public FieldTokenizer createFieldTokenizer(String fileName) {
        if (fileName != null) {
            if (this.isXLSFileExt(FileImporter.getFileExtension(fileName, this.defaultExtension)) || this.isXLSXFileExt(FileImporter.getFileExtension(fileName, this.defaultExtension))) {
                return new XLSFieldParser();
            }
            return new CSVFieldTokenizer();
        }
        return null;
    }

    public long getCountRowsBetweenCommit() {
        return this.countRowsBetweenCommit;
    }

    public void setCountRowsBetweenCommit(long countRowsBetweenCommit) {
        this.countRowsBetweenCommit = countRowsBetweenCommit;
    }

    private void putLastValue(String columnName, Object value) {
        if (columnName == null) {
            throw new IllegalArgumentException("columnName cannot be null");
        }
        if (value != null) {
            this.lastValues.put(columnName.toLowerCase(), value);
        }
    }

    @Override
    public Object getLastValue(String columnName) {
        Object lastValue = this.lastValues.get(columnName.toLowerCase());
        if (lastValue != null) {
            return lastValue;
        }
        return "";
    }
}

