/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.flatfileimport;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import sqlrunner.datamodel.SQLField;
import sqlrunner.flatfileimport.BasicDataType;
import sqlrunner.flatfileimport.generator.AutoValueGenerator;
import sqlrunner.flatfileimport.generator.NumberValueGenerator;
import sqlrunner.flatfileimport.gui.Messages;

public class FieldDescription
implements Comparable<FieldDescription> {
    private String name;
    private int basicType = -1;
    private String format = "";
    private static final String DATE_FORMAT_TEMPLATE = "dd.MM.yyyy";
    private int index = 0;
    private int delimPos = -1;
    private int absPos = -1;
    private int length = 0;
    private String defaultValue = "";
    private String alternativeFieldDescriptionName = null;
    private String generatorStartValue = null;
    private boolean isPrimaryKey = false;
    private boolean aggregateNumberValues = false;
    private boolean enabled = true;
    private boolean nullEnabled = true;
    private boolean ignoreDatasetIfInvalid = false;
    private boolean trimRequired = false;
    public static final int ABSOLUTE_POSITION = 0;
    public static final int RELATIVE_POSITION = 1;
    public static final int DELIMITER_POSITION = 2;
    public static final int DELIMITER_POSITION_WITH_LENGTH = 3;
    public static final int AUTO_GENERATED = 4;
    public static final int FIX_VALUE = 5;
    private int positionType = -1;
    private boolean valid;
    private String errorMessage;
    public static final String sep = System.getProperty("line.separator");
    private AutoValueGenerator autoValueGenerator = null;
    private String filterRegex;
    private Pattern filterPattern = null;
    private String regexCompilerMessage;
    private FieldDescription alternativeValueFieldDescription = null;
    private Locale locale = Locale.getDefault();
    private NumberFormat nf = null;

    public FieldDescription() {
    }

    public FieldDescription(String name, int basicType, String format, int index, int positionType, int delimPos, int absPos, int length, boolean isPrimaryKey, boolean enabled, String defaultValue, boolean aggregate, boolean nullEnabled, String generatorStartValue) {
        if (name != null && name.trim().length() == 0) {
            name = null;
        }
        this.name = name;
        this.basicType = basicType;
        this.format = format;
        this.index = index;
        this.delimPos = delimPos;
        this.absPos = absPos;
        this.length = length;
        this.isPrimaryKey = isPrimaryKey;
        this.enabled = enabled;
        if (defaultValue != null) {
            this.defaultValue = defaultValue;
        }
        if (positionType != -1) {
            this.positionType = positionType;
        } else {
            this.computePositionType();
        }
        if (basicType == BasicDataType.DATE.getId() && (format == null || format.trim().length() < 2)) {
            this.format = DATE_FORMAT_TEMPLATE;
        }
        if (isPrimaryKey && !enabled) {
            this.enabled = true;
        }
        this.aggregateNumberValues = aggregate;
        this.nullEnabled = nullEnabled;
        this.generatorStartValue = generatorStartValue;
        this.setupNumberFormat();
    }

    public FieldDescription(SQLField field) {
        this.name = field.getName();
        this.basicType = field.getBasicType();
        this.format = this.basicType == BasicDataType.DATE.getId() ? DATE_FORMAT_TEMPLATE : "";
        this.index = field.getOrdinalPosition();
        this.delimPos = field.getOrdinalPosition() - 1;
        this.absPos = -1;
        this.length = field.getLength();
        this.isPrimaryKey = field.isPrimaryKey();
        this.enabled = true;
        this.positionType = 2;
        this.aggregateNumberValues = false;
        this.nullEnabled = true;
        this.setupNumberFormat();
    }

    public FieldDescription(int index, int propertySearchNumber, Properties properties) {
        this.index = index;
        this.fillFromProperties(propertySearchNumber, properties);
        if (this.positionType == -1) {
            this.computePositionType();
        }
        if (this.basicType == BasicDataType.DATE.getId() && (this.format == null || this.format.trim().length() < 2)) {
            this.format = DATE_FORMAT_TEMPLATE;
        }
        if (this.isPrimaryKey && !this.enabled) {
            this.enabled = true;
        }
        this.setupNumberFormat();
    }

    private static Locale createLocale(String localeName) {
        if (localeName == null || localeName.length() == 0) {
            localeName = "en_US";
        }
        Locale locale = null;
        int pos = localeName.indexOf(95);
        if (pos > 1) {
            String language = localeName.substring(0, pos);
            String country = localeName.substring(pos + 1);
            locale = new Locale(language, country);
        } else {
            locale = new Locale(localeName);
        }
        return locale;
    }

    private void setupNumberFormat() {
        if (BasicDataType.isNumberType(this.basicType)) {
            if (this.locale == null) {
                this.locale = FieldDescription.createLocale(this.format);
            }
            this.nf = NumberFormat.getInstance(this.locale);
        }
    }

    private void setupDateFormat() {
        if (this.basicType == BasicDataType.DATE.getId() && this.format != null) {
            if (this.locale != null) {
                new SimpleDateFormat(this.format, this.locale);
            } else {
                new SimpleDateFormat(this.format);
            }
        }
    }

    public Locale getNumberFormatLocale() {
        return this.locale;
    }

    public NumberFormat getNumberFormat() {
        return this.nf;
    }

    public FieldDescription getAlternativeFieldDescription() {
        return this.alternativeValueFieldDescription;
    }

    public void setAlternativeFieldDescription(FieldDescription alternativeValueFieldDescription) {
        this.alternativeValueFieldDescription = alternativeValueFieldDescription;
    }

    public String getAlternativeFieldDescriptionName() {
        return this.alternativeFieldDescriptionName;
    }

    public void setAlternativeFieldDescriptionName(String alternativeFieldDescriptionName) {
        this.alternativeFieldDescriptionName = alternativeFieldDescriptionName;
    }

    public boolean isDummy() {
        return this.getName().startsWith("#");
    }

    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        return "#Test-" + this.delimPos;
    }

    public void setName(String name_loc) {
        if (name_loc != null && !name_loc.isEmpty()) {
            this.name = name_loc;
        }
    }

    public int getBasicTypeId() {
        return this.basicType;
    }

    public void setBasicTypeId(int basicType_loc) {
        this.basicType = basicType_loc;
        this.setupNumberFormat();
        this.setupDateFormat();
    }

    public String getFieldFormat() {
        return this.format;
    }

    public void setFormat(String format_loc) {
        this.format = format_loc != null && format_loc.trim().length() == 0 ? null : format_loc;
        this.setupNumberFormat();
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index_loc) {
        this.index = index_loc;
    }

    public int getDelimPos() {
        return this.delimPos;
    }

    public void setDelimPos(int delimPos_loc) {
        this.delimPos = delimPos_loc;
    }

    public int getAbsPos() {
        return this.absPos;
    }

    public void setAbsPos(int absPos_loc) {
        this.absPos = absPos_loc;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length_loc) {
        this.length = length_loc;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled_loc) {
        this.enabled = enabled_loc;
    }

    public int getPositionType() {
        return this.positionType;
    }

    public void setPositionType(int positionType_loc) {
        this.positionType = positionType_loc;
    }

    public boolean validate() {
        this.valid = true;
        if (this.isPrimaryKey && !this.enabled) {
            this.errorMessage = Messages.getString("FieldDescription.4");
            this.valid = false;
        } else if (this.name == null || this.name.length() == 0) {
            this.errorMessage = Messages.getString("FieldDescription.5");
            this.valid = false;
        } else if (this.basicType == BasicDataType.DATE.getId() && (this.format == null || this.format.trim().length() < 2)) {
            this.errorMessage = Messages.getString("FieldDescription.6");
            this.valid = false;
        } else if (this.basicType == -1) {
            this.errorMessage = Messages.getString("FieldDescription.7");
            this.valid = false;
        } else if (this.filterRegex != null && this.filterPattern == null) {
            this.errorMessage = "filterRegex: " + this.regexCompilerMessage;
            this.valid = false;
        } else if (this.positionType == -1) {
            this.errorMessage = Messages.getString("FieldDescription.8");
            this.valid = false;
        } else {
            switch (this.positionType) {
                case 0: {
                    if (this.absPos == -1) {
                        this.errorMessage = Messages.getString("FieldDescription.9");
                        this.valid = false;
                        break;
                    }
                    if (this.length != 0) break;
                    this.errorMessage = Messages.getString("FieldDescription.10");
                    this.valid = false;
                    break;
                }
                case 1: {
                    if (this.length != 0) break;
                    this.errorMessage = Messages.getString("FieldDescription.11");
                    this.valid = false;
                    break;
                }
                case 3: {
                    if (this.delimPos == -1) {
                        this.errorMessage = Messages.getString("FieldDescription.12");
                        this.valid = false;
                        break;
                    }
                    if (this.length != 0) break;
                    this.errorMessage = Messages.getString("FieldDescription.13");
                    this.valid = false;
                    break;
                }
                case 2: {
                    if (this.delimPos != -1) break;
                    this.errorMessage = Messages.getString("FieldDescription.14");
                    this.valid = false;
                }
            }
        }
        return this.valid;
    }

    public boolean isPartOfPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setIsPartOfPrimaryKey(boolean isPartOfPrimaryKey) {
        this.isPrimaryKey = isPartOfPrimaryKey;
    }

    private void computePositionType() {
        if (this.basicType == -1) {
            this.valid = false;
            this.errorMessage = Messages.getString("FieldDescription.15");
        } else if (this.basicType == BasicDataType.DATE.getId()) {
            if (this.format != null) {
                this.valid = true;
            } else {
                this.valid = false;
                this.errorMessage = Messages.getString("FieldDescription.16");
            }
        }
        if (this.absPos != -1) {
            this.positionType = 0;
            if (this.length != 0) {
                this.valid = true;
            } else {
                this.valid = false;
                this.errorMessage = Messages.getString("FieldDescription.17");
            }
        } else if (this.delimPos != -1) {
            this.positionType = this.length != 0 ? 3 : 2;
        } else if (this.length != 0) {
            this.positionType = 1;
            this.valid = true;
        } else {
            this.valid = false;
            this.errorMessage = Messages.getString("FieldDescription.18");
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public int compareTo(FieldDescription object) {
        if (object != null) {
            return this.index - object.getIndex();
        }
        return 0;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    public String getNextAutoGeneratedValue() {
        this.setupGenerator();
        if (this.autoValueGenerator != null) {
            return this.autoValueGenerator.getNext();
        }
        return null;
    }

    private void setupGenerator() {
        if (this.autoValueGenerator == null && BasicDataType.isNumberType(this.basicType)) {
            this.autoValueGenerator = new NumberValueGenerator();
            if (this.generatorStartValue != null && this.generatorStartValue.length() > 0) {
                this.autoValueGenerator.setStartValue(this.generatorStartValue);
            }
        }
    }

    public void resetAutValueGenerator() {
        if (this.autoValueGenerator != null) {
            this.autoValueGenerator.reset();
        }
    }

    public String getPropertiesString() {
        StringBuffer sb = new StringBuffer();
        sb.append("# -----------------------------");
        sb.append(sep);
        Properties props = new Properties();
        this.completeProperties(props);
        Map.Entry<Object, Object> entry2 = null;
        for (Map.Entry<Object, Object> entry2 : props.entrySet()) {
            sb.append(entry2.getKey());
            sb.append('=');
            sb.append(entry2.getValue());
            sb.append(sep);
        }
        return sb.toString();
    }

    public void completeProperties(Properties props) {
        if (this.name != null) {
            props.put("COLUMN_" + String.valueOf(this.index) + "_NAME", this.name);
            props.put("COLUMN_" + String.valueOf(this.index) + "_BASICTYPE", String.valueOf(this.basicType));
            if (this.basicType == BasicDataType.DATE.getId() && this.format != null) {
                props.put("COLUMN_" + String.valueOf(this.index) + "_FORMAT", this.format);
            } else {
                props.remove("COLUMN_" + String.valueOf(this.index) + "_FORMAT");
            }
            if (this.locale != null) {
                props.put("COLUMN_" + String.valueOf(this.index) + "_LOCALE", this.locale.toString());
            } else {
                props.remove("COLUMN_" + String.valueOf(this.index) + "_LOCALE");
            }
            props.put("COLUMN_" + String.valueOf(this.index) + "_POSITIONTYPE", String.valueOf(this.positionType));
            props.put("COLUMN_" + String.valueOf(this.index) + "_DELIMITERCOUNT", String.valueOf(this.delimPos));
            props.put("COLUMN_" + String.valueOf(this.index) + "_ABSPOS", String.valueOf(this.absPos));
            props.put("COLUMN_" + String.valueOf(this.index) + "_LENGTH", String.valueOf(this.length));
            props.put("COLUMN_" + String.valueOf(this.index) + "_PRIMARYKEY", String.valueOf(this.isPrimaryKey));
            props.put("COLUMN_" + String.valueOf(this.index) + "_ENABLED", String.valueOf(this.enabled));
            if (this.defaultValue != null) {
                props.put("COLUMN_" + String.valueOf(this.index) + "_DEFAULT", this.defaultValue);
            } else {
                props.remove("COLUMN_" + String.valueOf(this.index) + "_DEFAULT");
            }
            if (this.alternativeFieldDescriptionName != null) {
                props.put("COLUMN_" + String.valueOf(this.index) + "_ALTERNATIVE_FIELD", this.alternativeFieldDescriptionName);
            } else {
                props.remove("COLUMN_" + String.valueOf(this.index) + "_ALTERNATIVE_FIELD");
            }
            props.put("COLUMN_" + String.valueOf(this.index) + "_AGGREGATE", String.valueOf(this.aggregateNumberValues));
            props.put("COLUMN_" + String.valueOf(this.index) + "_NULL_ENABLED", String.valueOf(this.nullEnabled));
            props.put("COLUMN_" + String.valueOf(this.index) + "_IGNORE_DATASET_IF_INVALID", String.valueOf(this.ignoreDatasetIfInvalid));
            props.put("COLUMN_" + String.valueOf(this.index) + "_TRIM", String.valueOf(this.trimRequired));
            if (this.generatorStartValue != null) {
                props.put("COLUMN_" + String.valueOf(this.index) + "_GENERATORSTARTVALUE", this.generatorStartValue);
            } else {
                props.remove("COLUMN_" + String.valueOf(this.index) + "_GENERATORSTARTVALUE");
            }
            if (this.filterRegex != null) {
                props.put("COLUMN_" + String.valueOf(this.index) + "_REGEX", this.filterRegex);
            } else {
                props.remove("COLUMN_" + String.valueOf(this.index) + "_REGEX");
            }
        }
    }

    public void fillFromProperties(int propertySearchNumber, Properties props) {
        this.name = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_NAME");
        this.basicType = Integer.parseInt(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_BASICTYPE", "0"));
        this.setLocale(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_LOCALE"));
        this.format = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_FORMAT");
        this.positionType = Integer.parseInt(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_POSITIONTYPE", "0"));
        this.delimPos = Integer.parseInt(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_DELIMITERCOUNT", "0"));
        this.absPos = Integer.parseInt(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_ABSPOS", "0"));
        this.length = Integer.parseInt(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_LENGTH", "0"));
        this.isPrimaryKey = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_PRIMARYKEY", "false").equals("true");
        this.enabled = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_ENABLED", "false").equals("true");
        this.defaultValue = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_DEFAULT");
        this.alternativeFieldDescriptionName = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_ALTERNATIVE_FIELD");
        this.aggregateNumberValues = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_AGGREGATE", "false").equals("true");
        this.nullEnabled = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_NULL_ENABLED", "false").equals("true");
        this.ignoreDatasetIfInvalid = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_IGNORE_DATASET_IF_INVALID", "false").equals("true");
        this.trimRequired = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_TRIM", "false").equals("true");
        this.generatorStartValue = props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_GENERATORSTARTVALUE");
        this.setFilterRegex(props.getProperty("COLUMN_" + String.valueOf(propertySearchNumber) + "_REGEX"));
    }

    public String getExtractionDescription() {
        String desc;
        if (this.basicType == BasicDataType.SQLEXP.getId()) {
            desc = "SQL code";
        } else {
            switch (this.positionType) {
                case 0: {
                    desc = Messages.getString("FieldDescription.68") + String.valueOf(this.absPos) + Messages.getString("FieldDescription.69") + String.valueOf(this.length);
                    if (this.alternativeFieldDescriptionName != null) {
                        desc = desc + " altern. " + this.alternativeFieldDescriptionName;
                    }
                    if (this.filterPattern != null) {
                        desc = desc + " (filterRegex)";
                    }
                    if (this.defaultValue == null || this.defaultValue.length() <= 0) break;
                    desc = desc + Messages.getString("FieldDescription.78") + this.defaultValue;
                    break;
                }
                case 1: {
                    desc = Messages.getString("FieldDescription.70") + String.valueOf(this.length);
                    if (this.alternativeFieldDescriptionName != null) {
                        desc = desc + " altern. " + this.alternativeFieldDescriptionName;
                    }
                    if (this.filterPattern != null) {
                        desc = desc + " (filterRegex)";
                    }
                    if (this.defaultValue == null || this.defaultValue.length() <= 0) break;
                    desc = desc + Messages.getString("FieldDescription.78") + this.defaultValue;
                    break;
                }
                case 5: {
                    desc = Messages.getString("FieldDescription.fixvalue") + " = " + this.defaultValue;
                    if (this.alternativeFieldDescriptionName != null) {
                        desc = desc + " altern. " + this.alternativeFieldDescriptionName;
                    }
                    if (this.filterPattern == null) break;
                    desc = desc + " (filterRegex)";
                    break;
                }
                case 4: {
                    if (this.generatorStartValue != null && this.generatorStartValue.trim().length() > 0) {
                        desc = Messages.getString("FieldDescription.80") + this.generatorStartValue;
                        break;
                    }
                    desc = Messages.getString("FieldDescription.81");
                    break;
                }
                case 2: {
                    desc = this.delimPos == 0 ? Messages.getString("FieldDescription.71") : Messages.getString("FieldDescription.72") + this.delimPos + Messages.getString("FieldDescription.73");
                    if (this.alternativeFieldDescriptionName != null) {
                        desc = desc + " altern. " + this.alternativeFieldDescriptionName;
                    }
                    if (this.filterPattern != null) {
                        desc = desc + " (filterRegex)";
                    }
                    if (this.defaultValue == null || this.defaultValue.length() <= 0) break;
                    desc = desc + Messages.getString("FieldDescription.78") + this.defaultValue;
                    break;
                }
                case 3: {
                    desc = this.delimPos == 0 ? Messages.getString("FieldDescription.74") + String.valueOf(this.length) : Messages.getString("FieldDescription.75") + this.delimPos + Messages.getString("FieldDescription.76") + String.valueOf(this.length);
                    if (this.alternativeFieldDescriptionName != null) {
                        desc = desc + " altern. " + this.alternativeFieldDescriptionName;
                    }
                    if (this.filterPattern != null) {
                        desc = desc + " (filterRegex)";
                    }
                    if (this.defaultValue == null || this.defaultValue.length() <= 0) break;
                    desc = desc + Messages.getString("FieldDescription.78") + this.defaultValue;
                    break;
                }
                default: {
                    desc = Messages.getString("FieldDescription.77");
                }
            }
        }
        return desc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FieldDescription) {
            String otherName = ((FieldDescription)obj).getName();
            if (this.name != null && otherName != null && this.name.toLowerCase().trim().equals(otherName.toLowerCase().trim())) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.name;
    }

    public final boolean isAggregateNumberValues() {
        return this.aggregateNumberValues;
    }

    public final void setAggregateNumberValues(boolean aggregateNumberValues) {
        this.aggregateNumberValues = aggregateNumberValues;
    }

    public boolean isNullEnabled() {
        return this.nullEnabled && !this.isPrimaryKey;
    }

    public void setNullEnabled(boolean nullEnabled) {
        this.nullEnabled = nullEnabled;
    }

    public boolean isIgnoreDatasetIfInvalid() {
        return this.ignoreDatasetIfInvalid;
    }

    public void setIgnoreDatasetIfInvalid(boolean ignoreDatasetIfInvalid) {
        this.ignoreDatasetIfInvalid = ignoreDatasetIfInvalid;
    }

    public boolean isTrimRequired() {
        return this.trimRequired;
    }

    public void setTrimRequired(boolean trim) {
        this.trimRequired = trim;
    }

    public String getGeneratorStartValue() {
        return this.generatorStartValue;
    }

    public void setGeneratorStartValue(String generatorStartValue) {
        this.generatorStartValue = generatorStartValue;
    }

    public static String getPositioningTypeName(int positioningType) {
        switch (positioningType) {
            case 0: {
                return Messages.getString("FieldDescription.absolute");
            }
            case 4: {
                return Messages.getString("FieldDescription.generated");
            }
            case 2: {
                return Messages.getString("FieldDescription.afternumberdelimiter");
            }
            case 3: {
                return Messages.getString("FieldDescription.afternumberdelimiterwithlength");
            }
            case 5: {
                return Messages.getString("FieldDescription.fixvalue");
            }
            case 1: {
                return Messages.getString("FieldDescription.following");
            }
        }
        return "unknown positioning type";
    }

    public String getRegex() {
        return this.filterRegex;
    }

    public Pattern getFilterPattern() {
        return this.filterPattern;
    }

    public void setFilterRegex(String regex) {
        if (regex != null && regex.trim().length() > 0) {
            this.filterRegex = regex;
            try {
                this.filterPattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException pse) {
                this.filterPattern = null;
                this.regexCompilerMessage = pse.getMessage();
            }
        } else {
            this.filterRegex = null;
            this.filterPattern = null;
        }
    }

    public void setLocale(String localeString) {
        this.locale = FieldDescription.createLocale(localeString);
        this.setupNumberFormat();
        this.setupDateFormat();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.setupNumberFormat();
        this.setupDateFormat();
    }

    public Locale getLocale() {
        return this.locale;
    }
}

