/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.export;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import sqlrunner.CSVFileFilter;
import sqlrunner.Main;
import sqlrunner.SQLFileFilter;
import sqlrunner.XLSFileFilter;
import sqlrunner.XLSXFileFilter;
import sqlrunner.export.Messages;
import sqlrunner.resources.ApplicationIcons;

public class TargetPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JRadioButton jRadioButtonExportInFile = null;
    private JTextField jTextFieldFileName = null;
    private JButton jButtonChooseFile = null;
    private JCheckBox jCheckBoxSplit = null;
    private JTextField jTextFieldCountDatasets = null;
    private JRadioButton jRadioButtonExportInEditor = null;
    private JCheckBox jCheckBoxLimitDatasetsInEditor = null;
    private JTextField jTextFieldLimitDatasetsInEditor = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private File exportFile = null;
    private boolean showEditorAsTarget = false;
    private SQLFileFilter sqlFileFilter = null;
    private CSVFileFilter csvFileFilter = null;
    private XLSFileFilter xlsFileFilter = null;
    private XLSXFileFilter xlsxFileFilter = null;

    public TargetPanel(boolean showEditorAsTarget) {
        this.showEditorAsTarget = showEditorAsTarget;
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gbc;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(0), Messages.getString("TargetPanel.6"), 0, 0, new Font("Lucida Grande", 0, 13), Color.black));
        int y = 0;
        if (this.showEditorAsTarget) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y++;
            gbc.insets = new Insets(2, 5, 2, 2);
            gbc.anchor = 17;
            gbc.gridwidth = 3;
            this.add((Component)this.getJRadioButtonExportInFile(), gbc);
        }
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.insets = new Insets(2, 20, 2, 2);
        gbc.anchor = 13;
        JLabel jLabel = new JLabel();
        jLabel.setText(Messages.getString("TargetPanel.0"));
        this.add((Component)jLabel, gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 1;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.getJTextFieldFileName(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = y++;
        gbc.insets = new Insets(0, 2, 2, 2);
        this.add((Component)this.getJButtonChooseFile(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = y;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 20, 2, 0);
        gbc.anchor = 17;
        this.add((Component)this.getJCheckBoxSplit(), gbc);
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 2;
        gbc.gridy = y++;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(2, 2, 2, 5);
        gbc.anchor = 17;
        gbc.gridwidth = 2;
        this.add((Component)this.getJTextFieldCountDatasets(), gbc);
        if (this.showEditorAsTarget) {
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y++;
            gbc.insets = new Insets(15, 5, 2, 2);
            gbc.gridwidth = 4;
            gbc.anchor = 17;
            this.add((Component)this.getJRadioButtonExportInEditor(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = y;
            gbc.insets = new Insets(4, 20, 2, 2);
            gbc.anchor = 17;
            gbc.gridwidth = 2;
            this.add((Component)this.getJCheckBoxLimitDatasetsInEditor(), gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 2;
            gbc.gridx = 2;
            gbc.gridy = y;
            gbc.weightx = 1.0;
            gbc.insets = new Insets(4, 2, 2, 5);
            gbc.anchor = 17;
            gbc.gridwidth = 2;
            this.add((Component)this.getJTextFieldLimitDatasetsInEditor(), gbc);
            this.buttonGroup.add(this.getJRadioButtonExportInFile());
            this.buttonGroup.add(this.getJRadioButtonExportInEditor());
        } else {
            this.jTextFieldFileName.setEnabled(true);
            this.jButtonChooseFile.setEnabled(true);
            this.jCheckBoxSplit.setEnabled(true);
            this.jTextFieldCountDatasets.setEnabled(true);
        }
    }

    private JRadioButton getJRadioButtonExportInFile() {
        if (this.jRadioButtonExportInFile == null) {
            this.jRadioButtonExportInFile = new JRadioButton();
            this.jRadioButtonExportInFile.setText(Messages.getString("TargetPanel.1"));
            this.jRadioButtonExportInFile.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (TargetPanel.this.jRadioButtonExportInFile.isSelected()) {
                        if (TargetPanel.this.jRadioButtonExportInEditor != null) {
                            TargetPanel.this.jRadioButtonExportInEditor.setSelected(false);
                            TargetPanel.this.jTextFieldLimitDatasetsInEditor.setEnabled(false);
                            TargetPanel.this.jCheckBoxLimitDatasetsInEditor.setEnabled(false);
                        }
                        TargetPanel.this.jTextFieldFileName.setEnabled(true);
                        TargetPanel.this.jButtonChooseFile.setEnabled(true);
                        TargetPanel.this.jCheckBoxSplit.setEnabled(true);
                        TargetPanel.this.jTextFieldCountDatasets.setEnabled(true);
                    }
                }
            });
        }
        return this.jRadioButtonExportInFile;
    }

    private JTextField getJTextFieldFileName() {
        if (this.jTextFieldFileName == null) {
            this.jTextFieldFileName = new JTextField();
            this.jTextFieldFileName.setEnabled(false);
        }
        return this.jTextFieldFileName;
    }

    private void setupExportFile() {
        if (this.jTextFieldFileName.getText() != null && this.jTextFieldFileName.getText().trim().length() > 0) {
            this.exportFile = new File(this.jTextFieldFileName.getText());
        }
    }

    private JButton getJButtonChooseFile() {
        if (this.jButtonChooseFile == null) {
            this.jButtonChooseFile = new JButton();
            this.jButtonChooseFile.setEnabled(false);
            this.jButtonChooseFile.setIcon(ApplicationIcons.OPEN_GIF);
            this.jButtonChooseFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int returnVal;
                    TargetPanel.this.setupExportFile();
                    JFileChooser chooser = new JFileChooser();
                    if (TargetPanel.this.exportFile != null) {
                        if (TargetPanel.this.exportFile.getParentFile() != null) {
                            chooser.setCurrentDirectory(TargetPanel.this.exportFile.getParentFile());
                        }
                    } else {
                        String directory = Main.getUserProperty("EXPORT_DATAFILE_DIR", System.getProperty("user.home"));
                        chooser.setCurrentDirectory(new File(directory));
                    }
                    chooser.setDialogType(0);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setDialogTitle(Messages.getString("TargetPanel.9"));
                    if (TargetPanel.this.xlsFileFilter != null) {
                        chooser.addChoosableFileFilter(TargetPanel.this.xlsFileFilter);
                    }
                    if (TargetPanel.this.xlsxFileFilter != null) {
                        chooser.addChoosableFileFilter(TargetPanel.this.xlsxFileFilter);
                    }
                    if (TargetPanel.this.csvFileFilter != null) {
                        chooser.addChoosableFileFilter(TargetPanel.this.csvFileFilter);
                    }
                    if (TargetPanel.this.sqlFileFilter != null) {
                        chooser.addChoosableFileFilter(TargetPanel.this.sqlFileFilter);
                    }
                    if ((returnVal = chooser.showSaveDialog(TargetPanel.this.jButtonChooseFile)) == 0) {
                        File f = chooser.getSelectedFile();
                        if (chooser.getFileFilter() instanceof SQLFileFilter && !f.getName().toLowerCase().endsWith(".sql")) {
                            f = new File(f.getAbsolutePath() + ".sql");
                        } else {
                            String fileName = f.getName();
                            int point = fileName.lastIndexOf(".");
                            String extension = null;
                            if (point > 0) {
                                extension = fileName.toLowerCase().substring(point + 1);
                            }
                            if (chooser.getFileFilter() instanceof CSVFileFilter) {
                                if (!f.getName().toLowerCase().endsWith(".csv") && extension == null) {
                                    f = new File(f.getAbsolutePath() + ".csv");
                                }
                            } else if (chooser.getFileFilter() instanceof XLSFileFilter) {
                                if (!f.getName().toLowerCase().endsWith(".xls") && extension == null) {
                                    f = new File(f.getAbsolutePath() + ".xls");
                                }
                            } else if (chooser.getFileFilter() instanceof XLSXFileFilter && !f.getName().toLowerCase().endsWith(".xlsx") && extension == null) {
                                f = new File(f.getAbsolutePath() + ".xlsx");
                            }
                        }
                        Main.setUserProperty("EXPORT_DATAFILE_DIR", f.getParentFile().getAbsolutePath());
                        TargetPanel.this.jTextFieldFileName.setText(f.getAbsolutePath());
                        TargetPanel.this.exportFile = f;
                    }
                }
            });
        }
        return this.jButtonChooseFile;
    }

    private JCheckBox getJCheckBoxSplit() {
        if (this.jCheckBoxSplit == null) {
            this.jCheckBoxSplit = new JCheckBox();
            this.jCheckBoxSplit.setEnabled(false);
            this.jCheckBoxSplit.setText(Messages.getString("TargetPanel.3"));
        }
        return this.jCheckBoxSplit;
    }

    private JTextField getJTextFieldCountDatasets() {
        if (this.jTextFieldCountDatasets == null) {
            this.jTextFieldCountDatasets = new JTextField();
            this.jTextFieldCountDatasets.setEnabled(false);
            this.jTextFieldCountDatasets.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkOption();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkOption();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkOption();
                }

                private void checkOption() {
                    try {
                        int count = Integer.parseInt(TargetPanel.this.jTextFieldCountDatasets.getText());
                        if (count == 0) {
                            TargetPanel.this.jCheckBoxSplit.setSelected(false);
                        } else {
                            TargetPanel.this.jCheckBoxSplit.setSelected(true);
                        }
                    }
                    catch (Exception e) {
                        TargetPanel.this.jCheckBoxSplit.setSelected(false);
                    }
                }
            });
        }
        return this.jTextFieldCountDatasets;
    }

    private JRadioButton getJRadioButtonExportInEditor() {
        if (this.jRadioButtonExportInEditor == null) {
            this.jRadioButtonExportInEditor = new JRadioButton();
            this.jRadioButtonExportInEditor.setText(Messages.getString("TargetPanel.4"));
            this.jRadioButtonExportInEditor.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (TargetPanel.this.jRadioButtonExportInEditor.isSelected()) {
                        TargetPanel.this.jRadioButtonExportInFile.setSelected(false);
                        TargetPanel.this.jTextFieldLimitDatasetsInEditor.setEnabled(true);
                        TargetPanel.this.jTextFieldFileName.setEnabled(false);
                        TargetPanel.this.jButtonChooseFile.setEnabled(false);
                        TargetPanel.this.jCheckBoxSplit.setEnabled(false);
                        TargetPanel.this.jCheckBoxLimitDatasetsInEditor.setEnabled(true);
                        TargetPanel.this.jTextFieldCountDatasets.setEnabled(false);
                    }
                }
            });
        }
        return this.jRadioButtonExportInEditor;
    }

    private JCheckBox getJCheckBoxLimitDatasetsInEditor() {
        if (this.jCheckBoxLimitDatasetsInEditor == null) {
            this.jCheckBoxLimitDatasetsInEditor = new JCheckBox();
            this.jCheckBoxLimitDatasetsInEditor.setEnabled(false);
            this.jCheckBoxLimitDatasetsInEditor.setText(Messages.getString("TargetPanel.5"));
        }
        return this.jCheckBoxLimitDatasetsInEditor;
    }

    private JTextField getJTextFieldLimitDatasetsInEditor() {
        if (this.jTextFieldLimitDatasetsInEditor == null) {
            this.jTextFieldLimitDatasetsInEditor = new JTextField();
            this.jTextFieldLimitDatasetsInEditor.setEnabled(false);
            this.jTextFieldLimitDatasetsInEditor.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.checkOption();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.checkOption();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.checkOption();
                }

                private void checkOption() {
                    try {
                        int count = Integer.parseInt(TargetPanel.this.jTextFieldLimitDatasetsInEditor.getText());
                        if (count == 0) {
                            TargetPanel.this.jCheckBoxLimitDatasetsInEditor.setSelected(false);
                        } else {
                            TargetPanel.this.jCheckBoxLimitDatasetsInEditor.setSelected(true);
                        }
                    }
                    catch (Exception e) {
                        TargetPanel.this.jCheckBoxLimitDatasetsInEditor.setSelected(false);
                    }
                }
            });
        }
        return this.jTextFieldLimitDatasetsInEditor;
    }

    public boolean isExportInFileSelected() {
        return this.jRadioButtonExportInFile.isSelected();
    }

    public void setExportToFile(boolean toFile) {
        if (toFile) {
            this.jRadioButtonExportInFile.doClick();
        } else {
            if (!this.showEditorAsTarget) {
                throw new IllegalStateException(Messages.getString("TargetPanel.17"));
            }
            this.jRadioButtonExportInEditor.doClick();
        }
    }

    public String getFileName() {
        String fileName = this.jTextFieldFileName.getText();
        if (fileName != null) {
            fileName = fileName.trim();
        }
        return fileName;
    }

    public boolean hasFileName() {
        return this.jTextFieldFileName.getText() != null && this.jTextFieldFileName.getText().trim().length() > 0;
    }

    public void setFocusToFileName() {
        this.jTextFieldFileName.requestFocusInWindow();
    }

    public boolean isCountDatasetsLimited() {
        return this.jCheckBoxLimitDatasetsInEditor.isSelected();
    }

    public long getMaxLimitDatasetInSplittedFiles() {
        try {
            return Long.parseLong(this.jTextFieldCountDatasets.getText());
        }
        catch (Exception e) {
            return 0L;
        }
    }

    public boolean shouldFileSplitted() {
        return this.jCheckBoxSplit.isSelected();
    }

    public void setFileShouldSplitted(boolean split) {
        if (split) {
            if (!this.jCheckBoxSplit.isSelected()) {
                this.jCheckBoxSplit.doClick();
            }
        } else if (this.jCheckBoxSplit.isSelected()) {
            this.jCheckBoxSplit.doClick();
        }
    }

    public void setCountDatasetsLimited(boolean limited) {
        if (limited) {
            if (!this.jCheckBoxLimitDatasetsInEditor.isSelected()) {
                this.jCheckBoxLimitDatasetsInEditor.doClick();
            }
        } else if (this.jCheckBoxLimitDatasetsInEditor.isSelected()) {
            this.jCheckBoxLimitDatasetsInEditor.doClick();
        }
    }

    public void setFile(File file) {
        if (file != null) {
            this.jTextFieldFileName.setText(file.getAbsolutePath());
            this.exportFile = file;
        } else {
            this.jTextFieldFileName.setText(null);
        }
    }

    public File getFile() {
        this.setupExportFile();
        return this.exportFile;
    }

    public boolean isShowEditorAsTarget() {
        return this.showEditorAsTarget;
    }

    public void setShowEditorAsTarget(boolean showEditorAsTarget) {
        this.showEditorAsTarget = showEditorAsTarget;
    }

    public void enableFileTypeSQL(boolean enable) {
        this.sqlFileFilter = enable ? new SQLFileFilter() : null;
    }

    public void enableFileTypeCSV(boolean enable) {
        this.csvFileFilter = enable ? new CSVFileFilter() : null;
    }

    public void enableFileTypeXLS(boolean enable) {
        if (enable) {
            this.xlsFileFilter = new XLSFileFilter();
            this.xlsxFileFilter = new XLSXFileFilter();
        } else {
            this.xlsFileFilter = null;
            this.xlsxFileFilter = null;
        }
    }
}

