/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.dbext.extensions;

import dbtools.DatabaseSession;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.GenericDatabaseExtension;
import sqlrunner.text.StringReplacer;

public class TeradataExtension
extends GenericDatabaseExtension {
    private static final String name = "Teradata Extension";
    private static final Logger logger = Logger.getLogger(TeradataExtension.class);

    public TeradataExtension() {
        this.addDriverClassName("com.teradata.jdbc.TeraDriver");
        this.addSQLKeyword("timezone_minute");
        this.addSQLKeyword("timezone_hour");
        this.addSQLKeyword("no");
        this.addSQLKeyword("before");
        this.addSQLKeyword("after");
        this.addSQLKeyword("collect");
        this.addSQLKeyword("row_number");
        this.addSQLKeywords("merge", "portion", "extract");
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public boolean hasExplainFeature() {
        return true;
    }

    @Override
    public String getExplainSQL(String currentStatement) {
        StringBuilder sb = new StringBuilder();
        sb.append("diagnostic helpstats on for session;\n");
        sb.append("explain\n");
        sb.append(currentStatement);
        return sb.toString();
    }

    @Override
    public String setupViewSQLCode(DatabaseSession session, SQLTable table) {
        if (table.isView()) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("setupViewSQLCode view=" + table.getAbsoluteName()));
            }
            StringBuilder sb = new StringBuilder();
            sb.append("show view ");
            sb.append(table.getSchema().getName());
            sb.append(".");
            sb.append(table.getName());
            String source = null;
            try {
                ResultSet rs = session.executeQuery(sb.toString());
                if (session.isSuccessful() && rs.next() && (source = rs.getString(1)) != null && !source.isEmpty()) {
                    table.setSourceCode(StringReplacer.fixLineBreaks(source));
                }
            }
            catch (SQLException sqle) {
                logger.error((Object)("setupViewSQLCode for table " + table.getAbsoluteName() + " failed: " + sqle.getMessage()), (Throwable)sqle);
            }
            return source;
        }
        return null;
    }

    @Override
    public String setupProcedureSQLCode(DatabaseSession session, SQLProcedure proc) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setupProcedureSQLCode procedure=" + proc.getAbsoluteName()));
        }
        StringBuilder sb = new StringBuilder();
        sb.append("show procedure ");
        sb.append(proc.getSchema().getName());
        sb.append(".");
        sb.append(proc.getName());
        try {
            ResultSet rs = session.executeQuery(sb.toString());
            if (session.isSuccessful()) {
                StringBuilder code = new StringBuilder();
                while (rs.next()) {
                    code.append(StringReplacer.fixLineBreaks(rs.getString(1)));
                    code.append("\n");
                }
                rs.close();
                if (sb.length() > 0) {
                    proc.setCode(code.toString());
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("setupProcedureSQLCode for procedure " + proc.getAbsoluteName() + " failed: " + sqle.getMessage()), (Throwable)sqle);
        }
        return proc.getCode();
    }
}

