/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.dbext;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import sqlrunner.datamodel.Field;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSequence;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.DatabaseExtension;
import sqlrunner.flatfileimport.BasicDataType;

public class GenericDatabaseExtension
implements DatabaseExtension {
    private List<String> listkeywords = new ArrayList<String>();
    private List<String> listdatatypes = new ArrayList<String>();
    private List<String> listprockeywords = new ArrayList<String>();
    private List<String> listDriverClasses = new ArrayList<String>();
    private SimpleDateFormat sdfDate = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat sdfTimestamp = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.sss");
    private String quote = "\"";

    public void addDriverClassName(String driverClass) {
        this.listDriverClasses.add(driverClass);
    }

    @Override
    public boolean isApplicable(ConnectionDescription cd) {
        return this.isApplicable(cd.getDriverClassName());
    }

    @Override
    public boolean isApplicable(String driverClass) {
        for (String dc : this.listDriverClasses) {
            if (!dc.equalsIgnoreCase(driverClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasExplainFeature() {
        return false;
    }

    @Override
    public String getExplainSQL(String currentStatement) {
        return null;
    }

    @Override
    public String setupViewSQLCode(DatabaseSession session, SQLTable table) {
        return null;
    }

    @Override
    public String setupProcedureSQLCode(DatabaseSession session, SQLProcedure proc) {
        return null;
    }

    @Override
    public List<SQLSequence> getSequences(DatabaseSession session) {
        return new ArrayList<SQLSequence>();
    }

    @Override
    public void setupDataType(Field field) {
        if ("integer".equalsIgnoreCase(field.getTypeName()) || "int".equalsIgnoreCase(field.getTypeName())) {
            field.setTypeSQLCode("integer");
            field.setBasicType(BasicDataType.INTEGER.getId());
        } else if ("bigint".equalsIgnoreCase(field.getTypeName())) {
            field.setTypeSQLCode("bigint");
            field.setBasicType(BasicDataType.LONG.getId());
        } else if ("smallint".equalsIgnoreCase(field.getTypeName())) {
            field.setTypeSQLCode("smallint");
            field.setBasicType(BasicDataType.INTEGER.getId());
        } else if ("double".equalsIgnoreCase(field.getTypeName())) {
            field.setTypeSQLCode("double");
            field.setBasicType(BasicDataType.DOUBLE.getId());
        } else if ("bool".equalsIgnoreCase(field.getTypeName())) {
            field.setTypeSQLCode("boolean");
            field.setBasicType(BasicDataType.BOOLEAN.getId());
        }
    }

    @Override
    public String getName() {
        return "No Extension";
    }

    @Override
    public void setupDataType(SQLProcedure.Parameter parameter) {
        if ("integer".equalsIgnoreCase(parameter.getTypeName())) {
            parameter.setLength(0);
        } else if ("bool".equalsIgnoreCase(parameter.getTypeName())) {
            parameter.setTypeName("boolean");
            parameter.setLength(0);
        }
    }

    protected void addSQLKeyword(String word) {
        this.listkeywords.add(word);
    }

    protected void addSQLKeywords(String ... words) {
        if (words != null && words.length > 0) {
            for (int i = 0; i < words.length; ++i) {
                this.listkeywords.add(words[i]);
            }
        }
    }

    protected void addSQLDatatype(String word) {
        this.listdatatypes.add(word);
    }

    protected void addProcedureKeyword(String word) {
        this.listprockeywords.add(word);
    }

    @Override
    public List<String> getAdditionalSQLKeywords() {
        return this.listkeywords;
    }

    @Override
    public List<String> getAdditionalSQLDatatypes() {
        return this.listdatatypes;
    }

    @Override
    public List<String> getAdditionalProcedureKeywords() {
        return this.listprockeywords;
    }

    @Override
    public String getUpdateCommentStatement(String tableName, String comment) {
        StringBuilder sb = new StringBuilder();
        if (comment != null && !comment.trim().isEmpty()) {
            sb.append("comment on table ");
            sb.append(tableName);
            sb.append(" is '");
            sb.append(comment);
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    public String getUpdateCommentStatement(String tableName, String fieldName, String comment) {
        StringBuilder sb = new StringBuilder();
        if (comment != null && !comment.trim().isEmpty()) {
            sb.append("comment on column ");
            sb.append(tableName);
            sb.append(".");
            sb.append(fieldName);
            sb.append(" is '");
            sb.append(comment.replace('\n', ' '));
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    public String getLoginSchema(ConnectionDescription cd) {
        return cd.getUser();
    }

    @Override
    public String getLoginSchema(Connection conn) {
        try {
            return conn.getMetaData().getUserName();
        }
        catch (SQLException e) {
            return "";
        }
    }

    @Override
    public boolean hasSQLLimitFeature() {
        return false;
    }

    @Override
    public String getLimitExpression(int max) {
        return "";
    }

    @Override
    public boolean isLimitExpressionAWhereCondition() {
        return false;
    }

    @Override
    public void setupConnection(Connection c) {
    }

    @Override
    public void setupStatement(Statement stat) {
    }

    @Override
    public String getDateToSQLExpression(Date value) {
        String template = this.getDateToSQLExpressionPattern();
        return template.replace("{date}", this.sdfDate.format(value));
    }

    @Override
    public String getDateToSQLExpressionPattern() {
        return "to_date('{date}','DD.MM.YYYY')";
    }

    @Override
    public String getTimestampToSQLExpression(Date value) {
        String template = this.getDateToSQLExpressionPattern();
        return template.replace("{date}", this.sdfTimestamp.format(value));
    }

    @Override
    public String getTimestampToSQLExpressionPattern() {
        return "to_date('{date}','DD.MM.YYYY')";
    }

    @Override
    public String getIdentifierQuoteString() {
        return this.quote;
    }

    @Override
    public void setIdentifierQuoteString(String quote) {
        if (quote != null && !" ".equals(quote)) {
            this.quote = quote;
        }
    }
}

