/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datetool;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.datetool.Messages;
import sqlrunner.swinghelper.WindowHelper;

public final class DateConverter
extends JFrame {
    private static final Logger logger = Logger.getLogger(DateConverter.class);
    private static final long serialVersionUID = 1L;
    private int row;
    private int col;
    private JPanel jContentPane = null;
    private JScrollPane jScrollPane = null;
    private JTextArea textArea = null;
    private JPanel jPanel = null;
    private JLabel labelCounter = null;
    private JCheckBox checkBoxViewAsDate = null;
    private JComboBox<String> cbDateFormat = null;

    public DateConverter() {
        try {
            this.getRootPane().putClientProperty("Window.style", "small");
            this.initialize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.setTitle(Messages.getString("ValueEditor.title"));
        this.pack();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = 1;
            this.jContentPane.add((Component)this.getJPanel(), gbc);
            gbc = new GridBagConstraints();
            gbc.fill = 1;
            gbc.gridy = 0;
            gbc.weightx = 1.0;
            gbc.weighty = 2.0;
            gbc.gridx = 0;
            this.jContentPane.add((Component)this.getJScrollPane(), gbc);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setPreferredSize(new Dimension(390, 50));
            this.jScrollPane.setViewportView(this.getTextArea());
        }
        return this.jScrollPane;
    }

    private JTextArea getTextArea() {
        if (this.textArea == null) {
            this.textArea = new JTextArea();
            this.textArea.setLineWrap(true);
            this.textArea.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 27) {
                        DateConverter.this.dispose();
                    }
                }
            });
            this.textArea.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent de) {
                    DateConverter.this.labelCounter.setText(String.valueOf(DateConverter.this.textArea.getText().length()));
                }

                @Override
                public void changedUpdate(DocumentEvent de) {
                    DateConverter.this.labelCounter.setText(String.valueOf(DateConverter.this.textArea.getText().length()));
                }

                @Override
                public void removeUpdate(DocumentEvent de) {
                    DateConverter.this.labelCounter.setText(String.valueOf(DateConverter.this.textArea.getText().length()));
                }
            });
        }
        return this.textArea;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 13;
            gbc.gridy = 0;
            gbc.gridx = 0;
            gbc.insets = new Insets(2, 2, 2, 2);
            JLabel jLabel = new JLabel();
            jLabel.setText(Messages.getString("ValueEditor.countchars"));
            this.jPanel.add((Component)jLabel, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 0;
            gbc.gridx = 1;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.anchor = 17;
            this.labelCounter = new JLabel();
            this.labelCounter.setText("0");
            this.jPanel.add((Component)this.labelCounter, gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.gridx = 0;
            gbc.anchor = 17;
            gbc.insets = new Insets(2, 2, 2, 2);
            gbc.weightx = 2.0;
            gbc.fill = 2;
            this.jPanel.add(this.getComboBoxDateFormat(), gbc);
            gbc = new GridBagConstraints();
            gbc.gridy = 1;
            gbc.gridx = 1;
            gbc.anchor = 13;
            gbc.insets = new Insets(2, 2, 2, 2);
            this.jPanel.add((Component)this.getCheckBoxViewAsDate(), gbc);
        }
        return this.jPanel;
    }

    private JCheckBox getCheckBoxViewAsDate() {
        if (this.checkBoxViewAsDate == null) {
            this.checkBoxViewAsDate = new JCheckBox();
            this.checkBoxViewAsDate.setText(Messages.getString("ValueEditor.interpretasdate"));
            this.checkBoxViewAsDate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String format = (String)DateConverter.this.cbDateFormat.getSelectedItem();
                    System.out.println("Format:" + format);
                    SimpleDateFormat sdf = new SimpleDateFormat(format);
                    if (!DateConverter.this.checkBoxViewAsDate.isSelected()) {
                        try {
                            Date date = sdf.parse(DateConverter.this.textArea.getText().trim());
                            DateConverter.this.textArea.setText(String.valueOf(date.getTime()));
                        }
                        catch (ParseException pe) {
                            logger.warn((Object)("converting long->Date failed:" + pe.getMessage()));
                        }
                    } else {
                        try {
                            long time = Long.parseLong(DateConverter.this.textArea.getText().trim());
                            Date date = new Date(time);
                            DateConverter.this.textArea.setText(sdf.format(date));
                        }
                        catch (NumberFormatException nfe) {
                            logger.warn((Object)("converting Date->long failed:" + nfe.getMessage()));
                        }
                    }
                    DateConverter.this.labelCounter.setText(String.valueOf(DateConverter.this.textArea.getText().length()));
                }
            });
            this.checkBoxViewAsDate.setToolTipText(Messages.getString("ValueEditor.showeditlongasdate"));
        }
        return this.checkBoxViewAsDate;
    }

    private JComboBox<String> getComboBoxDateFormat() {
        if (this.cbDateFormat == null) {
            this.cbDateFormat = new JComboBox();
            this.cbDateFormat.setEditable(true);
            this.prepareCbDateFormat();
        }
        return this.cbDateFormat;
    }

    private void prepareCbDateFormat() {
        int i = 0;
        while (true) {
            this.cbDateFormat.addItem("yyyy-MM-dd HH:mm:ss.SSS");
            String formatStr = Main.getDefaultProperty("DATE_FORMAT_" + String.valueOf(i));
            if (formatStr == null) break;
            this.cbDateFormat.addItem(formatStr);
            ++i;
        }
    }

    public static byte[] hexStringToByteArray(String s) {
        if ((s = s.replace(" ", "").replace("\n", "").trim()).startsWith("x'") && s.endsWith("'")) {
            s = s.replace("x'", "").replace("'", "");
        }
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public int getColumnIndex() {
        return this.col;
    }

    public int getRowIndex() {
        return this.row;
    }

    @Override
    protected void processKeyEvent(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.dispose();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (!visible) {
            Main.setUserProperty("CELL_EDITOR_WIDTH", String.valueOf(this.getWidth()));
            Main.setUserProperty("CELL_EDITOR_HEIGHT", String.valueOf(this.getHeight()));
        }
        super.setVisible(visible);
    }
}

