/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel.gui;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;

public class HTMLDataTransferable
implements Transferable,
ClipboardOwner {
    private static final DataFlavor HTML_FLAVOR = new DataFlavor("text/html", "HTML");
    private DataFlavor[] df = new DataFlavor[]{new DataFlavor("text/html", "HTML"), DataFlavor.stringFlavor, DataFlavor.plainTextFlavor};
    private String htmlText = null;

    public HTMLDataTransferable(String htmlText) {
        this.htmlText = htmlText;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (HTML_FLAVOR.equals(flavor)) {
            return new ByteArrayInputStream((this.htmlText == null ? "" : this.htmlText).getBytes());
        }
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.htmlText == null ? "" : this.htmlText;
        }
        if (DataFlavor.plainTextFlavor.equals(flavor)) {
            return new StringReader(this.htmlText == null ? "" : this.htmlText);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.df;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        for (DataFlavor f : this.df) {
            if (!f.equals(flavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

