/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import sqlrunner.datamodel.SQLCatalog;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.datamodel.gui.SQLDataTreeTableModel;
import sqlrunner.resources.ApplicationIcons;

public final class DataModelTreeCellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = 1L;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus_loc) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus_loc);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getUserObject() instanceof SQLDataModel) {
            this.setDisabledIcon(ApplicationIcons.DB_GIF);
            this.setIcon(ApplicationIcons.DB_GIF);
        } else if (node.getUserObject() instanceof SQLCatalog) {
            this.setDisabledIcon(ApplicationIcons.CATALOG_GIF);
            this.setIcon(ApplicationIcons.CATALOG_GIF);
        } else if (node.getUserObject() instanceof SQLSchema) {
            this.setDisabledIcon(ApplicationIcons.SCHEMA_PNG);
            this.setIcon(ApplicationIcons.SCHEMA_PNG);
        } else if (node.getUserObject() instanceof SQLDataTreeTableModel.Folder) {
            this.setDisabledIcon(ApplicationIcons.FOLDER_CLOSED_PNG);
            this.setIcon(ApplicationIcons.FOLDER_CLOSED_PNG);
        } else if (node.getUserObject() instanceof SQLProcedure) {
            if (((SQLProcedure)node.getUserObject()).isFunction()) {
                this.setDisabledIcon(ApplicationIcons.FUNCTION_PNG);
                this.setIcon(ApplicationIcons.FUNCTION_PNG);
            } else {
                this.setDisabledIcon(ApplicationIcons.PROCEDURE_PNG);
                this.setIcon(ApplicationIcons.PROCEDURE_PNG);
            }
        } else if (node.getUserObject() instanceof SQLTable) {
            if (((SQLTable)node.getUserObject()).getType().equals("TABLE")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("VIEW")) {
                this.setDisabledIcon(ApplicationIcons.VIEW_PNG);
                this.setIcon(ApplicationIcons.VIEW_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("ALIAS")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("SYNONYM")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("GLOBAL TEMPORARY")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("LOCAL TEMPORARY")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("SYSTEM TABLE")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else if (((SQLTable)node.getUserObject()).getType().equals("SYSTEM")) {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
            } else {
                this.setDisabledIcon(ApplicationIcons.TABLE_PNG);
                this.setIcon(ApplicationIcons.TABLE_PNG);
                this.setText(this.getText() + " [" + ((SQLTable)node.getUserObject()).getType() + "]");
            }
        } else {
            this.setDisabledIcon(null);
            this.setIcon(null);
        }
        this.setOpaque(true);
        if (sel) {
            this.setBackground(Color.lightGray);
        } else {
            this.setBackground(Color.white);
        }
        return this;
    }
}

