/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel.gui;

import dbtools.ConnectionDescription;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.XmlFileFilter;
import sqlrunner.datamodel.DatamodelEvent;
import sqlrunner.datamodel.DatamodelListener;
import sqlrunner.datamodel.SQLCatalog;
import sqlrunner.datamodel.SQLConstraint;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLIndex;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.datamodel.gui.CountPanel;
import sqlrunner.datamodel.gui.DataModelCompareFrame;
import sqlrunner.datamodel.gui.DataModelTreeCellRenderer;
import sqlrunner.datamodel.gui.Messages;
import sqlrunner.datamodel.gui.SQLDataModelTransferHandler;
import sqlrunner.datamodel.gui.SQLDataTreeTableModel;
import sqlrunner.export.QueryExportFrame;
import sqlrunner.flatfileimport.gui.ImportConfiguratorFrame;
import sqlrunner.generator.JavaCreatorFrame;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.swinghelper.WindowHelper;
import sqlrunner.talend.SchemaUtil;

public final class DataModelFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(DataModelFrame.class);
    private static final long serialVersionUID = 1L;
    StatusBar status = new StatusBar();
    private final JSplitPane splitPaneMain = new JSplitPane();
    private final JSplitPane splitPaneInfo = new JSplitPane();
    private final JTextArea commentTextArea = new JTextArea();
    private final JScrollPane jScrollPaneTree = new JScrollPane();
    private final JScrollPane jScrollPaneTable = new JScrollPane();
    private final JTree tree = new JTree();
    private final JTable table = new JTable();
    private final JMenuBar menuBar = new JMenuBar();
    private final JMenu menuModel = new JMenu();
    private final JMenuItem miSchemaCompare = new JMenuItem();
    private final JMenuItem miClose = new JMenuItem();
    private final JMenu menuPreferences = new JMenu();
    private final JCheckBoxMenuItem miFullQualifiedNames = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem miOverwrite = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem miNewMainFrame = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem miStartImmediately = new JCheckBoxMenuItem();
    private SQLDataTreeTableModel treeAndTableModel = new SQLDataTreeTableModel();
    private MainFrame mainFrame;
    private static DataModelFrame dataModelFrame = null;
    private transient SQLDataModel currentDataModel = null;
    private Thread selectCurrentSchemaThread = null;
    private CountPanel countPanel = new CountPanel();
    private JTextField treeFilterTextField = null;
    private Action enterInTreeAction = new AbstractAction("enter-tree"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DataModelFrame.this.sendSelectedTreeElementNameToEditor();
        }
    };
    private Action enterInTableAction = new AbstractAction("enter-table"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DataModelFrame.this.sendSelectedTableElementNameToEditor();
        }
    };
    private Action sendFieldDeclsAction = new AbstractAction("send-field-decls"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DataModelFrame.this.sendSelectedFieldDeclarationsToEditor();
        }
    };
    private Action sendDropFieldAction = new AbstractAction("send-drop-field"){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DataModelFrame.this.sendDropFieldToEditor();
        }
    };
    final Action selectStarAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                String sql = DataModelFrame.this.useFullName() ? "select * from " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName() : "select * from " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName();
                if (DataModelFrame.this.miNewMainFrame.isSelected()) {
                    MainFrame newMainFrame = Main.createInstance(DataModelFrame.this.mainFrame);
                    if (DataModelFrame.this.miStartImmediately.isSelected()) {
                        newMainFrame.start(sql);
                    } else {
                        newMainFrame.setScriptText(sql);
                    }
                } else {
                    if (DataModelFrame.this.miStartImmediately.isSelected()) {
                        DataModelFrame.this.mainFrame.start(sql);
                    } else if (DataModelFrame.this.miOverwrite.isSelected()) {
                        DataModelFrame.this.mainFrame.setScriptText(sql);
                    } else {
                        DataModelFrame.this.mainFrame.insertOrReplaceText("\n" + sql);
                    }
                    DataModelFrame.this.mainFrame.setState(0);
                    DataModelFrame.this.mainFrame.toFront();
                }
            }
        }
    };
    final Action selectAllAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                String sql = SQLCodeGenerator.getInstance().buildSelectStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName());
                if (DataModelFrame.this.miNewMainFrame.isSelected()) {
                    MainFrame newMainFrame = Main.createInstance(DataModelFrame.this.mainFrame);
                    if (DataModelFrame.this.miStartImmediately.isSelected()) {
                        newMainFrame.start(sql);
                    } else {
                        newMainFrame.setScriptText(sql);
                    }
                } else if (DataModelFrame.this.miOverwrite.isSelected()) {
                    if (DataModelFrame.this.miStartImmediately.isSelected()) {
                        DataModelFrame.this.mainFrame.start(sql);
                    } else {
                        DataModelFrame.this.mainFrame.setScriptText(sql);
                    }
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\n" + sql);
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action selectAllCoalesceAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                String sql = SQLCodeGenerator.getInstance().buildSelectStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName(), true);
                if (DataModelFrame.this.miNewMainFrame.isSelected()) {
                    MainFrame newMainFrame = Main.createInstance(DataModelFrame.this.mainFrame);
                    if (DataModelFrame.this.miStartImmediately.isSelected()) {
                        newMainFrame.start(sql);
                    } else {
                        newMainFrame.setScriptText(sql);
                    }
                } else if (DataModelFrame.this.miOverwrite.isSelected()) {
                    if (DataModelFrame.this.miStartImmediately.isSelected()) {
                        DataModelFrame.this.mainFrame.start(sql);
                    } else {
                        DataModelFrame.this.mainFrame.setScriptText(sql);
                    }
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\n" + sql);
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action insertAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildInsertStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\n" + SQLCodeGenerator.getInstance().buildInsertStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action psInsertAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildPSInsertStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildPSInsertStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action psUpdateAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildPSUpdateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildPSUpdateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action psCountAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildPSCountStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildPSCountStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action psDeleteTableAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildPSDeleteStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildPSDeleteStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action createTableAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action createViewAsTableAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName(), true));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName(), true));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action dropTableAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildDropStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDropStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action deleteTableAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildDeleteStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDeleteStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action createAllTablesAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.mainFrame.isConnectedAndReady()) {
                    if (DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema() != null) {
                        new Thread(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                                    }
                                });
                                final String code = SQLCodeGenerator.getInstance().buildCreateTableStatements(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema(), DataModelFrame.this.useFullName());
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (DataModelFrame.this.miOverwrite.isSelected()) {
                                            DataModelFrame.this.mainFrame.setScriptText(code);
                                            DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                                        } else {
                                            DataModelFrame.this.mainFrame.insertOrReplaceText("\n" + code);
                                        }
                                        DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                                        DataModelFrame.this.mainFrame.setState(0);
                                        DataModelFrame.this.mainFrame.toFront();
                                    }
                                });
                            }
                        }.start();
                    }
                } else {
                    JOptionPane.showMessageDialog(DataModelFrame.this, Messages.getString("DataModelFrame.notready"), Messages.getString("DataModelFrame.refreshschemas"), 1);
                }
            }
        }
    };
    final Action refreshDBAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.mainFrame.isConnectedAndReady()) {
                    new Thread(){

                        @Override
                        public void run() {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                                }
                            });
                            DataModelFrame.this.treeAndTableModel.refresh(DataModelFrame.this.treeAndTableModel.getCurrentSQLDataModel(), DataModelFrame.this.treeAndTableModel.getCurrentNode());
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                                }
                            });
                        }
                    }.start();
                } else {
                    JOptionPane.showMessageDialog(DataModelFrame.this, Messages.getString("DataModelFrame.notready"), Messages.getString("DataModelFrame.refreshschemas"), 1);
                }
            }
        }
    };
    final Action refreshSchemaAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.mainFrame.isConnectedAndReady()) {
                    if (DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema() != null) {
                        new Thread(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                                    }
                                });
                                DataModelFrame.this.treeAndTableModel.refresh(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema(), DataModelFrame.this.treeAndTableModel.getCurrentNode(), true);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                });
                            }
                        }.start();
                    }
                } else {
                    JOptionPane.showMessageDialog(DataModelFrame.this, Messages.getString("DataModelFrame.notready"), Messages.getString("DataModelFrame.refreshtables"), 1);
                }
            }
        }
    };
    final Action refreshTableAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.mainFrame.isConnectedAndReady()) {
                    if (DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema() != null) {
                        new Thread(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                                        DataModelFrame.this.status.messageLabel.setText("refresh current table");
                                    }
                                });
                                DataModelFrame.this.treeAndTableModel.refreshCurrentTable();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DataModelFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                                    }
                                });
                            }
                        }.start();
                    }
                } else {
                    JOptionPane.showMessageDialog(DataModelFrame.this, Messages.getString("DataModelFrame.notready"), Messages.getString("DataModelFrame.refreshfields"), 1);
                }
            }
        }
    };
    final Action dropAllAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildDropTableStatements(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDropTableStatements(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action deleteAllAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildDeleteTableStatements(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDeleteTableStatements(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action selectFieldAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null) {
                String sql = DataModelFrame.this.useFullName() ? "select " + DataModelFrame.this.treeAndTableModel.getCurrentSQLField().getName() + " from " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName() : "select " + DataModelFrame.this.treeAndTableModel.getCurrentSQLField().getName() + " from " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName();
                if (DataModelFrame.this.miNewMainFrame.isSelected()) {
                    DataModelFrame.this.mainFrame = Main.createInstance(DataModelFrame.this.mainFrame);
                    DataModelFrame.this.mainFrame.start(sql);
                } else {
                    if (DataModelFrame.this.miOverwrite.isSelected()) {
                        DataModelFrame.this.mainFrame.setScriptText(sql);
                        DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                    } else {
                        DataModelFrame.this.mainFrame.insertOrReplaceText("\n" + sql);
                    }
                    DataModelFrame.this.mainFrame.setState(0);
                    DataModelFrame.this.mainFrame.toFront();
                }
            }
        }
    };
    final Action addFieldAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLField() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    if (DataModelFrame.this.useFullName()) {
                        DataModelFrame.this.mainFrame.setScriptText("alter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName() + " add my_name my_type;");
                    } else {
                        DataModelFrame.this.mainFrame.setScriptText("alter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName() + " add my_name my_type;");
                    }
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else if (DataModelFrame.this.useFullName()) {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\nalter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName() + " add NeuesFeld FeldType ;");
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\nalter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName() + " add NeuesFeld FeldType ;");
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action dropFieldAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    if (DataModelFrame.this.useFullName()) {
                        DataModelFrame.this.mainFrame.setScriptText("alter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName() + " drop column " + DataModelFrame.this.treeAndTableModel.getCurrentSQLField().getName() + ";");
                    } else {
                        DataModelFrame.this.mainFrame.setScriptText("alter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName() + " drop column " + DataModelFrame.this.treeAndTableModel.getCurrentSQLField().getName() + ";");
                    }
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else if (DataModelFrame.this.useFullName()) {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\nalter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName() + " drop column " + DataModelFrame.this.treeAndTableModel.getCurrentSQLField().getName() + ";");
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText("\nalter table " + DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName() + " drop column " + DataModelFrame.this.treeAndTableModel.getCurrentSQLField().getName() + ";");
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action queryExportAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                QueryExportFrame exportDBTableDialog = new QueryExportFrame(DataModelFrame.this.mainFrame);
                WindowHelper.locateWindowAtMiddle(DataModelFrame.this.mainFrame, exportDBTableDialog);
                exportDBTableDialog.setVisible(true);
                exportDBTableDialog.setQueryText(SQLCodeGenerator.getInstance().buildSelectStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLTable(), DataModelFrame.this.useFullName()));
            }
        }
    };
    final Action fileImportAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.mainFrame != null && DataModelFrame.this.treeAndTableModel.getCurrentSQLTable() != null) {
                if (DataModelFrame.this.useFullName()) {
                    ImportConfiguratorFrame frame = new ImportConfiguratorFrame(DataModelFrame.this.mainFrame.getDatabase(), DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getAbsoluteName());
                    WindowHelper.locateWindowAtMiddle(DataModelFrame.this.mainFrame, frame);
                    frame.setVisible(true);
                } else {
                    ImportConfiguratorFrame frame = new ImportConfiguratorFrame(DataModelFrame.this.mainFrame.getDatabase(), DataModelFrame.this.treeAndTableModel.getCurrentSQLTable().getName());
                    WindowHelper.locateWindowAtMiddle(DataModelFrame.this.mainFrame, frame);
                    frame.setVisible(true);
                }
            }
        }
    };
    final Action exportAsTalendSchema = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLTable table;
            if (DataModelFrame.this.mainFrame != null && (table = DataModelFrame.this.treeAndTableModel.getCurrentSQLTable()) != null) {
                File f;
                JFileChooser chooser = new JFileChooser();
                String lastDir = Main.getUserProperty("talend.schema.xml.dir");
                if (lastDir != null) {
                    File f2 = new File(lastDir, table.getName() + ".xml");
                    chooser.setCurrentDirectory(f2.getParentFile());
                    chooser.setSelectedFile(f2);
                } else {
                    String directory = Main.getUserProperty("SCRIPT_DIR", System.getProperty("user.home"));
                    f = new File(directory, table.getName() + ".xml");
                    chooser.setCurrentDirectory(f.getParentFile());
                    chooser.setSelectedFile(f);
                }
                chooser.setDialogType(1);
                chooser.setMultiSelectionEnabled(false);
                chooser.setDialogTitle(Messages.getString("MainFrame.122"));
                chooser.addChoosableFileFilter(new XmlFileFilter());
                int returnVal = chooser.showSaveDialog(DataModelFrame.this);
                if (returnVal == 0) {
                    f = chooser.getSelectedFile();
                    if (!f.getName().toLowerCase().endsWith(".xml")) {
                        f = new File(f.getAbsolutePath() + ".xml");
                    }
                    Main.setUserProperty("talend.schema.xml.dir", f.getParentFile().getAbsolutePath());
                    SchemaUtil util = new SchemaUtil();
                    try {
                        util.writeSchemaFile(f, table);
                    }
                    catch (IOException e1) {
                        logger.error((Object)("writeSchemaFile f=" + f.getAbsolutePath() + " failed: " + e1.getMessage()), (Throwable)e1);
                        JOptionPane.showMessageDialog(DataModelFrame.this, "writeSchemaFile f=" + f.getAbsolutePath() + " failed: " + e1.getMessage());
                    }
                }
            }
        }
    };
    final Action javaCodeGeneratorAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema() != null) {
                JavaCreatorFrame frame = new JavaCreatorFrame(DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema());
                WindowHelper.locateWindowAtMiddle(DataModelFrame.this.mainFrame, frame);
                frame.setVisible(true);
            }
        }
    };
    final Action dropConstraintAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLConstraint() != null && DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(DataModelFrame.this.treeAndTableModel.getCurrentSQLConstraint().getDropStatement(DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(DataModelFrame.this.treeAndTableModel.getCurrentSQLConstraint().getDropStatement(DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action callProcedureAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure() != null && DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildPreparedCallStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildPreparedCallStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action dropProcedureAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure() != null && DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildDropStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDropStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action createIndexAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLIndex() != null && DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLIndex(), DataModelFrame.this.useFullName()));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLIndex(), DataModelFrame.this.useFullName()));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action createProcedureAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure() != null && DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure(), DataModelFrame.this.useFullName(), null));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildCreateStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLProcedure(), DataModelFrame.this.useFullName(), null));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action dropIndexAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (DataModelFrame.this.treeAndTableModel.getCurrentSQLIndex() != null && DataModelFrame.this.mainFrame != null) {
                if (DataModelFrame.this.miOverwrite.isSelected()) {
                    DataModelFrame.this.mainFrame.setScriptText(SQLCodeGenerator.getInstance().buildDropStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLIndex(), DataModelFrame.this.useFullName(), null));
                    DataModelFrame.this.mainFrame.setTextSaveEnabled(false);
                } else {
                    DataModelFrame.this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDropStatement(DataModelFrame.this.treeAndTableModel.getCurrentSQLIndex(), DataModelFrame.this.useFullName(), null));
                }
                DataModelFrame.this.mainFrame.setState(0);
                DataModelFrame.this.mainFrame.toFront();
            }
        }
    };
    final Action closeAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            DataModelFrame.this.setVisible(false);
        }
    };
    final Action compareSchemaAction = new AbstractAction(){
        private static final long serialVersionUID = 1L;

        @Override
        public void actionPerformed(ActionEvent e) {
            SQLSchema s1 = DataModelFrame.this.treeAndTableModel.getCurrentSQLSchema();
            SQLSchema s2 = DataModelFrame.this.treeAndTableModel.getNextSelectedSQLSchema();
            if (s1 != null && s2 != null && s1 != s2) {
                DataModelCompareFrame cf = new DataModelCompareFrame();
                cf.setSchema1(s1);
                cf.setSchema2(s2);
                cf.setVisible(true);
                WindowHelper.locateWindowAtLeftSideWithin(DataModelFrame.this, cf, 0);
                cf.pack();
            } else {
                JOptionPane.showMessageDialog(DataModelFrame.this, Messages.getString("DataModelFrame.select2Schemas"), "Info", 1);
            }
        }
    };

    private DataModelFrame() {
        try {
            this.initComponents();
            this.setAlwaysOnTop(true);
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataModelFrame getDataModelFrame() {
        if (dataModelFrame == null) {
            dataModelFrame = new DataModelFrame();
        }
        return dataModelFrame;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!this.isShowing()) {
            try {
                this.setLocationByPlatform(!WindowHelper.isWindowPositioningEnabled());
            }
            catch (NoSuchMethodError e) {
                // empty catch block
            }
        }
        super.setVisible(visible);
        if (visible) {
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    DataModelFrame.this.treeAndTableModel.buildNodesForDataModels();
                }
            });
            t.start();
        } else if (this.selectCurrentSchemaThread != null) {
            try {
                this.selectCurrentSchemaThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initComponents() throws Exception {
        this.setTitle(Messages.getString("DataModelFrame.title"));
        this.setJMenuBar(this.menuBar);
        this.menuModel.setText(Messages.getString("DataModelFrame.1"));
        this.menuBar.add(this.menuModel);
        this.miSchemaCompare.setText(Messages.getString("DataModelFrame.schemaCompare"));
        this.miSchemaCompare.addActionListener(this.compareSchemaAction);
        this.miClose.setText(Messages.getString("DataModelFrame.2"));
        this.miClose.addActionListener(this.closeAction);
        this.menuModel.add(this.miSchemaCompare);
        this.menuModel.add(this.miClose);
        this.menuPreferences.setText(Messages.getString("DataModelFrame.3"));
        this.miFullQualifiedNames.setText(Messages.getString("DataModelFrame.4"));
        this.miFullQualifiedNames.setSelected(Main.getUserProperty("FULL_QUALIFIED_NAME", "false").equals("true"));
        this.miOverwrite.setSelected(Main.getUserProperty("DM_FRAME_SCRIPT_OVERWRITE", "true").equals("true"));
        this.miOverwrite.setText(Messages.getString("DataModelFrame.11"));
        this.miNewMainFrame.setText(Messages.getString("DataModelFrame.12"));
        this.miNewMainFrame.setSelected(Main.getUserProperty("DM_FRAME_NEW_FRAME", "false").equals("true"));
        this.miStartImmediately.setText(Messages.getString("DataModelFrame.16"));
        this.miStartImmediately.setSelected(Main.getUserProperty("DM_FRAME_START_IMMEDIATELY", "false").equals("true"));
        this.menuBar.add(this.menuPreferences);
        this.menuPreferences.add(this.miFullQualifiedNames);
        this.menuPreferences.add(this.miOverwrite);
        this.menuPreferences.add(this.miNewMainFrame);
        this.menuPreferences.add(this.miStartImmediately);
        this.splitPaneMain.setOrientation(0);
        this.splitPaneMain.setOneTouchExpandable(true);
        this.jScrollPaneTree.setPreferredSize(new Dimension(300, 300));
        this.splitPaneMain.setDividerLocation(this.jScrollPaneTree.getPreferredSize().height);
        this.jScrollPaneTable.setPreferredSize(new Dimension(300, 200));
        this.getContentPane().add((Component)this.getTreeFilterPanel(), "North");
        this.getContentPane().add((Component)this.splitPaneMain, "Center");
        this.getContentPane().add((Component)this.status, "South");
        this.splitPaneMain.add((Component)this.jScrollPaneTree, "top");
        this.splitPaneMain.add((Component)this.splitPaneInfo, "bottom");
        this.splitPaneInfo.setOrientation(0);
        this.splitPaneInfo.add((Component)this.jScrollPaneTable, "top");
        this.splitPaneInfo.add((Component)this.getInfoTabbedPane(), "bottom");
        this.jScrollPaneTree.setViewportView(this.tree);
        this.jScrollPaneTable.setViewportView(this.table);
        this.table.addMouseListener(new TableMouseListener());
        this.table.setDefaultRenderer(String.class, new FieldTableRenderer());
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DataModelFrame.this.table.hasFocus()) {
                    SQLField field = DataModelFrame.this.treeAndTableModel.getCurrentSQLField();
                    DataModelFrame.this.refreshInfoFor(field);
                }
            }
        });
        this.table.getSelectionModel().addListSelectionListener(this.treeAndTableModel);
        logger.debug((Object)"set table model...");
        this.table.setModel(this.treeAndTableModel);
        this.table.setTransferHandler(new SQLDataModelTransferHandler(this.treeAndTableModel));
        this.table.setDragEnabled(true);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(20);
        this.table.getColumnModel().getColumn(4).setPreferredWidth(25);
        this.updateKeyActionMapForTable();
        logger.debug((Object)"set tree model...");
        this.tree.setModel(this.treeAndTableModel);
        this.tree.setRootVisible(false);
        this.tree.addMouseListener(new TreeMouseListener());
        this.tree.addTreeSelectionListener(this.treeAndTableModel);
        this.tree.addTreeWillExpandListener(this.treeAndTableModel);
        this.tree.setCellRenderer(new DataModelTreeCellRenderer());
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DataModelFrame.this.setupTreeContextMenu();
            }
        });
        this.treeAndTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 1) {
                    String message = e.getLastRow() - e.getFirstRow() + 1 + " columns";
                    DataModelFrame.this.status.messageLabel.setText(message);
                }
            }
        });
        this.updateKeyActionMapForTree();
        this.commentTextArea.setEditable(false);
    }

    private void refreshInfoFor(SQLObject object) {
        if (object instanceof SQLField) {
            SQLField field = (SQLField)object;
            this.commentTextArea.setText(field.getComment());
        } else if (object instanceof SQLTable) {
            SQLTable table = (SQLTable)object;
            this.commentTextArea.setText(table.getComment());
            this.countPanel.setSQLObject(object);
        } else if (object instanceof SQLSchema) {
            this.countPanel.setSQLObject(object);
        } else if (object instanceof SQLProcedure) {
            SQLProcedure table = (SQLProcedure)object;
            this.commentTextArea.setText(table.getComment());
        } else {
            this.commentTextArea.setText(null);
        }
    }

    private JTabbedPane getInfoTabbedPane() {
        JTabbedPane infoTabbedPane = new JTabbedPane();
        infoTabbedPane.add("Count", this.countPanel);
        JScrollPane spComment = new JScrollPane();
        spComment.setViewportView(this.commentTextArea);
        infoTabbedPane.add("comment", spComment);
        infoTabbedPane.setMaximumSize(infoTabbedPane.getPreferredSize());
        return infoTabbedPane;
    }

    private void updateFilterTreeModel() {
        this.treeAndTableModel.setObjectFilter(this.treeFilterTextField.getText());
    }

    private JPanel getTreeFilterPanel() {
        if (this.treeFilterTextField == null) {
            this.treeFilterTextField = new JTextField();
            this.treeFilterTextField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    DataModelFrame.this.updateFilterTreeModel();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    DataModelFrame.this.updateFilterTreeModel();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    DataModelFrame.this.updateFilterTreeModel();
                }
            });
            this.treeFilterTextField.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                    if (e.getKeyChar() == '\n') {
                        DataModelFrame.this.tree.clearSelection();
                        DataModelFrame.this.treeAndTableModel.filterCurrentNodeChildren();
                    }
                }

                @Override
                public void keyReleased(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }
            });
        }
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        JLabel label = new JLabel();
        label.setText(Messages.getString("DataModelFrame.filter"));
        panel.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        panel.add((Component)this.treeFilterTextField, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        JButton button = new JButton("X");
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataModelFrame.this.tree.clearSelection();
                DataModelFrame.this.treeFilterTextField.setText(null);
                DataModelFrame.this.treeAndTableModel.filterCurrentNodeChildren();
            }
        });
        panel.add((Component)button, gbc);
        return panel;
    }

    private void updateKeyActionMapForTree() {
        InputMap inputMap = this.tree.getInputMap();
        ActionMap actionMap = this.tree.getActionMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        inputMap.put(enter, "enter");
        actionMap.put("enter", this.enterInTreeAction);
    }

    private void updateKeyActionMapForTable() {
        InputMap inputMap = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0, false);
        inputMap.put(enter, "enter");
        actionMap.put("enter", this.enterInTableAction);
    }

    @Override
    protected void processWindowEvent(WindowEvent winEvent) {
        switch (winEvent.getID()) {
            case 201: {
                if (this.mainFrame == null) break;
                this.mainFrame.closeDMFrame();
                break;
            }
            case 205: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        int divloc = ((DataModelFrame)DataModelFrame.this).splitPaneInfo.getSize().height - ((DataModelFrame)DataModelFrame.this).countPanel.getMaximumSize().height - 10;
                        DataModelFrame.this.splitPaneInfo.setDividerLocation(divloc);
                    }
                });
            }
            default: {
                super.processWindowEvent(winEvent);
            }
        }
    }

    public boolean isScriptOverwriteSelected() {
        return this.miOverwrite.isSelected();
    }

    public boolean isSelectInNewFrameSelected() {
        return this.miNewMainFrame.isSelected();
    }

    public boolean isStartImmediatelySelected() {
        return this.miStartImmediately.isSelected();
    }

    public int getModelCount() {
        return this.treeAndTableModel.getModelCount();
    }

    public boolean useFullName() {
        if (this.mainFrame != null) {
            return this.miFullQualifiedNames.isSelected() || !this.treeAndTableModel.isCurrentSchema(this.currentDataModel.getLoginSchemaName());
        }
        return false;
    }

    public boolean isFullQualifiedNameSelected() {
        return this.miFullQualifiedNames.isSelected();
    }

    public void setMainFrame(MainFrame newMainFrame) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setMainFrame: " + newMainFrame.getTitle()));
        }
        ConnectionDescription newCd = newMainFrame.getCurrentConnectionDescription();
        ConnectionDescription currCd = this.mainFrame != null ? this.mainFrame.getCurrentConnectionDescription() : null;
        this.mainFrame = newMainFrame;
        this.currentDataModel = newMainFrame.getCurrentDataModel();
        if (newCd != null) {
            DefaultMutableTreeNode dbNode;
            if (!newCd.equals(currCd)) {
                this.selectCurrentSchema();
            } else if (this.currentDataModel != null && (dbNode = this.treeAndTableModel.findAndCreateNode(this.currentDataModel)) != null) {
                TreePath path = new TreePath(dbNode.getPath());
                this.tree.expandPath(path);
            }
        }
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public void addSQLDatamodel(final SQLDataModel model) {
        if (this.treeAndTableModel.addUniqueSQLDataModel(model)) {
            this.treeFilterTextField.setText(null);
            model.addDatamodelListener(new DatamodelListener(){

                @Override
                public void eventHappend(final DatamodelEvent event) {
                    if (SwingUtilities.isEventDispatchThread()) {
                        DataModelFrame.this.status.messageLabel.setText(event.getMessage());
                    } else {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataModelFrame.this.status.messageLabel.setText(event.getMessage());
                            }
                        });
                    }
                }
            });
        }
        final SQLDataTreeTableModel localModel = this.treeAndTableModel;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DefaultMutableTreeNode modelNode = localModel.findTreeNodeByUserObject(model);
                TreePath treePath = new TreePath(modelNode.getPath());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                DataModelFrame.this.tree.expandPath(treePath);
            }
        });
    }

    public void selectCurrentSchema() {
        if (this.currentDataModel != null) {
            this.selectCurrentSchemaThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"selectCurrentSchema interrupted");
                    }
                    SQLSchema currentSchema = DataModelFrame.this.currentDataModel.getCurrentSQLSchema();
                    if (currentSchema != null) {
                        TreePath path;
                        DefaultMutableTreeNode schemaNode;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("selectCurrentSchema currentSchema=" + currentSchema + " currentDataModel=" + DataModelFrame.this.currentDataModel));
                        }
                        if ((schemaNode = DataModelFrame.this.treeAndTableModel.findAndCreateNode(currentSchema)) != null) {
                            path = new TreePath(schemaNode.getPath());
                        } else {
                            DefaultMutableTreeNode dbNode = DataModelFrame.this.treeAndTableModel.findAndCreateNode(DataModelFrame.this.currentDataModel);
                            path = new TreePath(dbNode.getPath());
                        }
                        if (path != null && !DataModelFrame.this.tree.isExpanded(path)) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DataModelFrame.this.tree.setSelectionPath(path);
                                    DataModelFrame.this.tree.expandPath(path);
                                    DataModelFrame.this.tree.scrollPathToVisible(path);
                                }
                            });
                        }
                    }
                }
            };
            this.selectCurrentSchemaThread.start();
        }
    }

    public void removeSQLDataModel(SQLDataModel model) {
        this.treeAndTableModel.removeUniqueSQLDataModel(model);
    }

    private void createTableContextMenu(MouseEvent me) {
        int row = this.table.getSelectedRow();
        if (row != -1) {
            Object o = this.treeAndTableModel.getValueAt(row, 0);
            System.out.println(o);
            if (o instanceof SQLField) {
                JPopupMenu popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.sendToEditor"));
                mi.addActionListener(this.enterInTableAction);
                popup.add(mi);
                JMenuItem mi1 = new JMenuItem(Messages.getString("DataModelFrame.sendFieldDeclToEditor"));
                mi1.addActionListener(this.sendFieldDeclsAction);
                popup.add(mi1);
                JMenuItem mi2 = new JMenuItem(Messages.getString("DataModelFrame.sendDropFieldToEditor"));
                mi2.addActionListener(this.sendDropFieldAction);
                popup.add(mi2);
                int mouseXPos = me.getX();
                int mouseYPos = me.getY();
                popup.show(this.table, mouseXPos, mouseYPos);
            }
        }
    }

    private void setupTreeContextMenu() {
        Object lastSelectedPathComp = this.tree.getLastSelectedPathComponent();
        if (lastSelectedPathComp != null) {
            Object object = ((DefaultMutableTreeNode)lastSelectedPathComp).getUserObject();
            int countChildren = ((DefaultMutableTreeNode)lastSelectedPathComp).getChildCount();
            JPopupMenu popup = null;
            if (object instanceof SQLObject) {
                this.refreshInfoFor((SQLObject)object);
            }
            if (object instanceof SQLTable) {
                popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.sendToEditor"));
                mi.addActionListener(this.enterInTreeAction);
                popup.add(mi);
                mi = new JMenuItem(Messages.getString("DataModelFrame.refresh"));
                mi.addActionListener(this.refreshTableAction);
                popup.add(mi);
                popup.addSeparator();
                mi = new JMenuItem("select * from");
                mi.addActionListener(this.selectStarAction);
                popup.add(mi);
                mi = new JMenuItem(Messages.getString("SQLDataTreeModel.selectAll"));
                mi.addActionListener(this.selectAllAction);
                popup.add(mi);
                mi = new JMenuItem(Messages.getString("SQLDataTreeModel.selectAllCoalesce"));
                mi.addActionListener(this.selectAllCoalesceAction);
                popup.add(mi);
                popup.addSeparator();
                if (((SQLTable)object).getType().equals("TABLE")) {
                    mi = new JMenuItem("insert into <alle Felder>");
                    mi.addActionListener(this.insertAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.0"));
                    mi.addActionListener(this.psInsertAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.116"));
                    mi.addActionListener(this.psUpdateAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.117"));
                    mi.addActionListener(this.psDeleteTableAction);
                    popup.add(mi);
                    mi = new JMenuItem("prepared statement: select count(*)");
                    mi.addActionListener(this.psCountAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.import"));
                    mi.addActionListener(this.fileImportAction);
                    popup.add(mi);
                }
                mi = new JMenuItem(Messages.getString("DataModelFrame.export"));
                mi.addActionListener(this.queryExportAction);
                popup.add(mi);
                popup.addSeparator();
                mi = new JMenuItem(Messages.getString("DataModelFrame.exportTalendSchema"));
                mi.addActionListener(this.exportAsTalendSchema);
                popup.add(mi);
                if (((SQLTable)object).getType().equals("TABLE")) {
                    popup.addSeparator();
                    mi = new JMenuItem(Messages.getString("DataModelFrame.createTable"));
                    mi.addActionListener(this.createTableAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.98"));
                    mi.addActionListener(this.dropTableAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.100"));
                    mi.addActionListener(this.deleteTableAction);
                    popup.add(mi);
                } else if (((SQLTable)object).getType().equals("VIEW")) {
                    mi = new JMenuItem(Messages.getString("DataModelFrame.createView"));
                    mi.addActionListener(this.createTableAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.102"));
                    mi.addActionListener(this.dropTableAction);
                    popup.add(mi);
                    mi = new JMenuItem(Messages.getString("DataModelFrame.createViewAsTable"));
                    mi.addActionListener(this.createViewAsTableAction);
                    popup.add(mi);
                }
            } else if (object instanceof SQLSchema) {
                popup = new JPopupMenu();
                JMenuItem miRefresh = new JMenuItem(Messages.getString("DataModelFrame.refresh"));
                miRefresh.addActionListener(this.refreshSchemaAction);
                popup.add(miRefresh);
                popup.addSeparator();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.106"));
                mi.addActionListener(this.createAllTablesAction);
                popup.add(mi);
                mi = new JMenuItem(Messages.getString("DataModelFrame.108"));
                mi.addActionListener(this.dropAllAction);
                popup.add(mi);
                mi = new JMenuItem(Messages.getString("DataModelFrame.110"));
                mi.addActionListener(this.deleteAllAction);
                popup.add(mi);
                popup.addSeparator();
                mi = new JMenuItem(Messages.getString("DataModelFrame.codegenerator"));
                mi.addActionListener(this.javaCodeGeneratorAction);
                popup.add(mi);
            } else if (object instanceof SQLDataModel) {
                popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.refresh"));
                mi.addActionListener(this.refreshDBAction);
                popup.add(mi);
                this.status.messageLabel.setText(countChildren + " databases");
            } else if (object instanceof SQLCatalog) {
                this.status.messageLabel.setText(countChildren + " schemas");
            } else if (object instanceof SQLConstraint) {
                popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.dropConstraint"));
                mi.addActionListener(this.dropConstraintAction);
                popup.add(mi);
            } else if (object instanceof SQLIndex) {
                popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.createIndex"));
                mi.addActionListener(this.createIndexAction);
                popup.add(mi);
                mi = new JMenuItem(Messages.getString("DataModelFrame.dropIndex"));
                mi.addActionListener(this.dropIndexAction);
                popup.add(mi);
            } else if (object instanceof SQLProcedure) {
                popup = new JPopupMenu();
                JMenuItem mi = new JMenuItem(Messages.getString("DataModelFrame.procedureCallStatement"));
                mi.addActionListener(this.callProcedureAction);
                popup.add(mi);
                JMenuItem miCreate = new JMenuItem(Messages.getString("DataModelFrame.createProcedureStatement"));
                miCreate.addActionListener(this.createProcedureAction);
                popup.add(miCreate);
                JMenuItem miDrop = new JMenuItem(Messages.getString("DataModelFrame.dropProcedureStatement"));
                miDrop.addActionListener(this.dropProcedureAction);
                popup.add(miDrop);
            } else if (object instanceof SQLDataTreeTableModel.TableFolder) {
                this.status.messageLabel.setText(countChildren + " tables");
            } else if (object instanceof SQLDataTreeTableModel.ViewFolder) {
                this.status.messageLabel.setText(countChildren + " views");
            } else if (object instanceof SQLDataTreeTableModel.ProcedureFolder) {
                this.status.messageLabel.setText(countChildren + " procedures");
            }
            this.tree.setComponentPopupMenu(popup);
        }
    }

    private void sendSelectedTableElementNameToEditor() {
        int row = this.table.getSelectedRow();
        if (row != -1 && this.mainFrame != null) {
            Object o = this.treeAndTableModel.getValueAt(row, 0);
            if (o instanceof SQLField) {
                this.mainFrame.insertOrReplaceText(((SQLField)o).getName());
            } else if (o instanceof SQLIndex) {
                this.mainFrame.insertOrReplaceText(((SQLIndex)o).getName());
            }
            this.mainFrame.setState(0);
            this.mainFrame.toFront();
        }
    }

    private void sendSelectedFieldDeclarationsToEditor() {
        int[] rows = this.table.getSelectedRows();
        if (rows != null && this.mainFrame != null) {
            for (int row : rows) {
                Object o = this.treeAndTableModel.getValueAt(row, 0);
                if (!(o instanceof SQLField)) continue;
                this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildFieldDeclaration((SQLField)o));
                this.mainFrame.insertFormattedBreak();
            }
            this.mainFrame.setState(0);
            this.mainFrame.toFront();
        }
    }

    private void sendDropFieldToEditor() {
        int[] rows = this.table.getSelectedRows();
        if (rows != null && this.mainFrame != null) {
            for (int row : rows) {
                Object o = this.treeAndTableModel.getValueAt(row, 0);
                if (!(o instanceof SQLField)) continue;
                this.mainFrame.insertOrReplaceText(SQLCodeGenerator.getInstance().buildDropStatement((SQLField)o, this.useFullName()));
                this.mainFrame.insertFormattedBreak();
            }
            this.mainFrame.setState(0);
            this.mainFrame.toFront();
        }
    }

    private void sendSelectedTreeElementNameToEditor() {
        Object userObject = this.treeAndTableModel.getCurrentUserObject();
        if (this.mainFrame != null) {
            if (this.useFullName()) {
                if (userObject instanceof SQLTable) {
                    this.mainFrame.insertOrReplaceText(((SQLTable)userObject).getAbsoluteName());
                    this.mainFrame.setState(0);
                    this.mainFrame.toFront();
                } else if (userObject instanceof SQLSchema) {
                    this.mainFrame.insertOrReplaceText(((SQLSchema)userObject).getName());
                    this.mainFrame.setState(0);
                    this.mainFrame.toFront();
                } else if (userObject instanceof SQLCatalog) {
                    this.mainFrame.insertOrReplaceText(((SQLCatalog)userObject).getName());
                    this.mainFrame.setState(0);
                    this.mainFrame.toFront();
                } else if (userObject instanceof SQLConstraint) {
                    this.mainFrame.insertOrReplaceText(((SQLConstraint)userObject).getName());
                    this.mainFrame.setState(0);
                    this.mainFrame.toFront();
                } else if (userObject instanceof SQLIndex) {
                    this.mainFrame.insertOrReplaceText(((SQLIndex)userObject).getName());
                    this.mainFrame.setState(0);
                    this.mainFrame.toFront();
                } else if (userObject instanceof SQLProcedure) {
                    this.mainFrame.insertOrReplaceText(((SQLProcedure)userObject).getName());
                    this.mainFrame.setState(0);
                    this.mainFrame.toFront();
                }
            } else if (userObject instanceof SQLTable) {
                this.mainFrame.insertOrReplaceText(((SQLTable)userObject).getName());
                this.mainFrame.setState(0);
                this.mainFrame.toFront();
            } else if (userObject instanceof SQLSchema) {
                this.mainFrame.insertOrReplaceText(((SQLSchema)userObject).getName());
                this.mainFrame.setState(0);
                this.mainFrame.toFront();
            } else if (userObject instanceof SQLCatalog) {
                this.mainFrame.insertOrReplaceText(((SQLCatalog)userObject).getName());
                this.mainFrame.setState(0);
                this.mainFrame.toFront();
            } else if (userObject instanceof SQLConstraint) {
                this.mainFrame.insertOrReplaceText(((SQLConstraint)userObject).getName());
                this.mainFrame.setState(0);
                this.mainFrame.toFront();
            } else if (userObject instanceof SQLProcedure) {
                this.mainFrame.insertOrReplaceText(((SQLProcedure)userObject).getProcedureCallCode());
                this.mainFrame.setState(0);
                this.mainFrame.toFront();
            }
        }
    }

    private static class FieldTableRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public FieldTableRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table_loc, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setFont(table_loc.getFont());
            SQLField field = null;
            SQLProcedure.Parameter parameter = null;
            if (value instanceof SQLField) {
                field = (SQLField)value;
                switch (column) {
                    case 0: {
                        this.setText(field.getName());
                        break;
                    }
                    case 1: {
                        this.setText(field.getTypeName());
                        break;
                    }
                    case 2: {
                        this.setText(String.valueOf(field.getLength()));
                        break;
                    }
                    case 3: {
                        this.setText(String.valueOf(field.getDecimalDigits()));
                        break;
                    }
                    case 4: {
                        this.setText(field.isNullValueAllowed() ? Messages.getString("DataModelFrame.114") : Messages.getString("DataModelFrame.115"));
                    }
                }
            } else if (value instanceof SQLProcedure.Parameter) {
                parameter = (SQLProcedure.Parameter)value;
                switch (column) {
                    case 0: {
                        this.setText(parameter.toString());
                        break;
                    }
                    case 1: {
                        this.setText(parameter.getTypeName());
                        break;
                    }
                    case 2: {
                        this.setText(String.valueOf(parameter.getLength()));
                        break;
                    }
                    case 3: {
                        this.setText(String.valueOf(parameter.getPrecision()));
                        break;
                    }
                    case 4: {
                        this.setText("");
                    }
                }
            } else if (value != null) {
                this.setText(value.toString());
            } else {
                this.setText("");
            }
            if (field != null && field.isPrimaryKey()) {
                if (isSelected) {
                    if (column > 0) {
                        this.setForeground(table_loc.getForeground());
                        this.setBackground(Color.yellow);
                    } else {
                        this.setForeground(table_loc.getSelectionForeground());
                        this.setBackground(table_loc.getSelectionBackground());
                    }
                } else {
                    this.setForeground(table_loc.getForeground());
                    this.setBackground(Color.yellow);
                }
            } else if (isSelected) {
                this.setForeground(table_loc.getSelectionForeground());
                this.setBackground(table_loc.getSelectionBackground());
            } else {
                this.setForeground(table_loc.getForeground());
                this.setBackground(table_loc.getBackground());
            }
            return this;
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private class TableMouseListener
    extends MouseAdapter {
        private TableMouseListener() {
        }

        protected void fireDoubleClickPerformed(MouseEvent me) {
            DataModelFrame.this.sendSelectedTableElementNameToEditor();
        }

        @Override
        public void mouseEntered(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(12));
        }

        @Override
        public void mouseExited(MouseEvent me) {
            Component comp = (Component)me.getSource();
            comp.setCursor(Cursor.getPredefinedCursor(0));
        }

        @Override
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                DataModelFrame.this.createTableContextMenu(me);
            }
        }

        @Override
        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                DataModelFrame.this.createTableContextMenu(me);
            }
        }

        @Override
        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                DataModelFrame.this.createTableContextMenu(me);
            } else if (me.getClickCount() == 2) {
                this.fireDoubleClickPerformed(me);
            }
        }
    }

    public static class StatusBar
    extends JPanel {
        private static final long serialVersionUID = 1L;
        BoxLayout box = new BoxLayout(this, 0);
        public JLabel messageLabel = new FixedLabel();
        public JLabel infoAction = new FixedLabel();
        static final int STATUS_HEIGHT = 25;

        public StatusBar() {
            this.setLayout(this.box);
            this.messageLabel.setBorder(BorderFactory.createLoweredBevelBorder());
            this.messageLabel.setForeground(Color.black);
            this.add(this.messageLabel);
            this.messageLabel.addPropertyChangeListener(new MeldungPropertyChangeListener());
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            int meldungBreite = this.getWidth();
            this.messageLabel.setPreferredSize(new Dimension(meldungBreite, 25));
            this.remove(this.messageLabel);
            this.add(this.messageLabel, null, 0);
            this.doLayout();
        }

        class MeldungPropertyChangeListener
        implements PropertyChangeListener {
            MeldungPropertyChangeListener() {
            }

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                StatusBar.this.messageLabel.setToolTipText(StatusBar.this.messageLabel.getText());
            }
        }

        static class FixedLabel
        extends JLabel {
            private static final long serialVersionUID = 1L;

            public FixedLabel(String text) {
                super(text);
            }

            public FixedLabel() {
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        }
    }
}

