/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.DatamodelEvent;
import sqlrunner.datamodel.DatamodelListener;
import sqlrunner.datamodel.ModelComparator;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.datamodel.gui.Messages;
import sqlrunner.generator.SQLCodeGenerator;
import sqlrunner.resources.ApplicationIcons;

public class DataModelCompareFrame
extends JFrame {
    private static final Logger logger = Logger.getLogger(DataModelCompareFrame.class);
    private static final long serialVersionUID = 1L;
    private JTextField jTextFieldReferenceSchemaName;
    private JTextField jTextFieldTargetSchemaName;
    private JButton jButtonChange12;
    private JTextArea jTextAreaLog;
    private JButton jButtonStartCompare;
    private JButton jButtonCreateSQL;
    private SQLObject schema1;
    private SQLObject schema2;
    private Thread compareThread;
    private ModelComparator comparator;

    public DataModelCompareFrame() {
        this.initGui();
        this.setTitle(Messages.getString("DataModelCompareFrame.title"));
        this.setPreferredSize(new Dimension(400, 600));
    }

    public void setSchema1(SQLObject schema1) {
        this.schema1 = schema1;
        this.jTextFieldReferenceSchemaName.setText(schema1.getModel().getName() + "/" + schema1.getName());
    }

    public void setSchema2(SQLObject schema2) {
        this.schema2 = schema2;
        this.jTextFieldTargetSchemaName.setText(schema2.getModel().getName() + "/" + schema2.getName());
    }

    private void initGui() {
        this.getContentPane().setLayout(new GridBagLayout());
        int y = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        JLabel label = new JLabel();
        label.setText(Messages.getString("DataModelCompareFrame.referenceSchemaLabel"));
        this.getContentPane().add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.getJTextFieldReferenceSchemaName(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 10;
        this.getContentPane().add((Component)this.getJButtonChange12(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        label = new JLabel();
        label.setText(Messages.getString("DataModelCompareFrame.targetSchemaLabel"));
        this.getContentPane().add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.getContentPane().add((Component)this.getJTextFieldTargetSchemaName(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 0, 5);
        gbc.anchor = 10;
        this.getContentPane().add((Component)this.getJButtonStartCompare(), gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        gbc.fill = 2;
        label = new JLabel();
        label.setText(Messages.getString("DataModelCompareFrame.compareLog"));
        this.getContentPane().add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        JScrollPane sp = new JScrollPane();
        sp.setViewportView(this.getJTextAreaLog());
        this.getContentPane().add((Component)sp, gbc);
        gbc = new GridBagConstraints();
        gbc.gridy = y++;
        gbc.gridx = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 17;
        this.getContentPane().add((Component)this.getJButtonCreateSQL(), gbc);
    }

    private JTextField getJTextFieldReferenceSchemaName() {
        if (this.jTextFieldReferenceSchemaName == null) {
            this.jTextFieldReferenceSchemaName = new JTextField();
            this.jTextFieldReferenceSchemaName.setEditable(false);
        }
        return this.jTextFieldReferenceSchemaName;
    }

    private JTextField getJTextFieldTargetSchemaName() {
        if (this.jTextFieldTargetSchemaName == null) {
            this.jTextFieldTargetSchemaName = new JTextField();
            this.jTextFieldTargetSchemaName.setEditable(false);
        }
        return this.jTextFieldTargetSchemaName;
    }

    private JTextArea getJTextAreaLog() {
        if (this.jTextAreaLog == null) {
            this.jTextAreaLog = new JTextArea();
            this.jTextAreaLog.setWrapStyleWord(true);
            this.jTextAreaLog.setLineWrap(true);
            this.jTextAreaLog.setEditable(false);
        }
        return this.jTextAreaLog;
    }

    private JButton getJButtonChange12() {
        if (this.jButtonChange12 == null) {
            this.jButtonChange12 = new JButton();
            this.jButtonChange12.setIcon(ApplicationIcons.UP_DOWN_EXCHANGE_PNG);
            this.jButtonChange12.setToolTipText(Messages.getString("DataModelCompareFrame.exchange12"));
            this.jButtonChange12.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DataModelCompareFrame.this.schema1 != null && DataModelCompareFrame.this.schema2 != null) {
                        SQLObject t = DataModelCompareFrame.this.schema2;
                        DataModelCompareFrame.this.schema2 = DataModelCompareFrame.this.schema1;
                        DataModelCompareFrame.this.schema1 = t;
                        DataModelCompareFrame.this.jTextFieldReferenceSchemaName.setText(DataModelCompareFrame.this.schema1.getModel().getName() + "/" + DataModelCompareFrame.this.schema1.getName());
                        DataModelCompareFrame.this.jTextFieldTargetSchemaName.setText(DataModelCompareFrame.this.schema2.getModel().getName() + "/" + DataModelCompareFrame.this.schema2.getName());
                    }
                }
            });
        }
        return this.jButtonChange12;
    }

    private JButton getJButtonStartCompare() {
        if (this.jButtonStartCompare == null) {
            this.jButtonStartCompare = new JButton();
            this.jButtonStartCompare.setText(Messages.getString("DataModelCompareFrame.startCompare"));
            this.jButtonStartCompare.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataModelCompareFrame.this.startCompare();
                }
            });
        }
        return this.jButtonStartCompare;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible && this.compareThread != null && this.compareThread.isAlive()) {
            this.compareThread.interrupt();
        }
        super.setVisible(visible);
    }

    private void startCompare() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("startCompare " + this.schema1 + " with " + this.schema2));
        }
        if (this.compareThread != null && this.compareThread.isAlive()) {
            this.compareThread.interrupt();
        }
        this.jButtonStartCompare.setEnabled(false);
        this.compareThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataModelCompareFrame.this.setCursor(Cursor.getPredefinedCursor(3));
                        DataModelCompareFrame.this.jTextAreaLog.setText("Start...");
                    }
                });
                DataModelCompareFrame.this.comparator = new ModelComparator();
                DataModelCompareFrame.this.comparator.setDatamodelListener(new DatamodelListener(){

                    @Override
                    public void eventHappend(final DatamodelEvent event) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DataModelCompareFrame.this.jTextAreaLog.append("\n" + event.getMessage());
                            }
                        });
                    }
                });
                try {
                    if (DataModelCompareFrame.this.schema1 instanceof SQLSchema && DataModelCompareFrame.this.schema2 instanceof SQLSchema) {
                        DataModelCompareFrame.this.comparator.compare((SQLSchema)DataModelCompareFrame.this.schema1, (SQLSchema)DataModelCompareFrame.this.schema2);
                    } else if (DataModelCompareFrame.this.schema1 instanceof SQLTable && DataModelCompareFrame.this.schema2 instanceof SQLTable) {
                        DataModelCompareFrame.this.comparator.compare((SQLTable)DataModelCompareFrame.this.schema1, (SQLTable)DataModelCompareFrame.this.schema2);
                    }
                }
                catch (Throwable throwable) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DataModelCompareFrame.this.jButtonStartCompare.setEnabled(true);
                            DataModelCompareFrame.this.jTextAreaLog.append("\nFinished.");
                            DataModelCompareFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                            DataModelCompareFrame.this.jButtonCreateSQL.setEnabled(true);
                        }
                    });
                    throw throwable;
                }
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
        this.compareThread.start();
    }

    private JButton getJButtonCreateSQL() {
        if (this.jButtonCreateSQL == null) {
            this.jButtonCreateSQL = new JButton();
            this.jButtonCreateSQL.setText(Messages.getString("DataModelCompareFrame.createSQL"));
            this.jButtonCreateSQL.setEnabled(false);
            this.jButtonCreateSQL.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DataModelCompareFrame.this.showSQLCode();
                }
            });
        }
        return this.jButtonCreateSQL;
    }

    private void showSQLCode() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"showSQLCode ");
        }
        this.jButtonCreateSQL.setEnabled(false);
        Thread t = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    DataModelCompareFrame.this.jTextAreaLog.setText(SQLCodeGenerator.getInstance().buildSchemaUpdateStatements(DataModelCompareFrame.this.comparator));
                }
                finally {
                    DataModelCompareFrame.this.jButtonCreateSQL.setEnabled(true);
                }
            }
        };
        t.start();
    }
}

