/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;

public class CountPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel labelInfo = new JLabel();
    private JButton button = new JButton();
    private JTextField textFieldCountResult = new JTextField();
    private JLabel labelDate = new JLabel();
    private SQLObject sqlObject = null;
    private boolean countRunning = false;
    private Thread countThread;

    public CountPanel() {
        this.initGui();
        this.setPreferredSize(new Dimension(220, 120));
        this.setMaximumSize(this.getPreferredSize());
    }

    private void initGui() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.labelInfo, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.button.setText("Count");
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CountPanel.this.countRunning) {
                    CountPanel.this.cancelCount();
                } else if (CountPanel.this.sqlObject instanceof SQLTable) {
                    CountPanel.this.startCountForTable();
                } else if (CountPanel.this.sqlObject instanceof SQLSchema) {
                    CountPanel.this.startCountForAllTables();
                }
            }
        });
        this.add((Component)this.button, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.textFieldCountResult.setEditable(false);
        this.add((Component)this.textFieldCountResult, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        JLabel label = new JLabel("Count date:");
        this.add((Component)label, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        gbc.fill = 2;
        gbc.weightx = 1.0;
        this.add((Component)this.labelDate, gbc);
    }

    public void setSQLObject(SQLObject object) {
        this.sqlObject = object;
        if (this.countRunning) {
            this.cancelCount();
        }
        this.refreshView();
    }

    private void refreshView() {
        if (this.sqlObject instanceof SQLTable) {
            this.button.setText("Count");
            this.button.setEnabled(true);
            SQLTable table = (SQLTable)this.sqlObject;
            this.labelInfo.setText(table.getAbsoluteName());
            if (table.getCountDatasets() != null) {
                NumberFormat nf = NumberFormat.getInstance();
                this.textFieldCountResult.setText(nf.format(table.getCountDatasets()));
                if (table.getCountDate() != null) {
                    SimpleDateFormat sdf = new SimpleDateFormat();
                    this.labelDate.setText(sdf.format(table.getCountDate()));
                } else {
                    this.labelDate.setText(null);
                }
            } else {
                this.textFieldCountResult.setText(null);
                this.labelDate.setText(null);
            }
        } else if (this.sqlObject instanceof SQLSchema) {
            this.labelInfo.setText(((SQLSchema)this.sqlObject).getName());
            this.button.setText("Count All");
            this.button.setEnabled(true);
            this.textFieldCountResult.setText(null);
            this.labelDate.setText(null);
        } else {
            this.labelInfo.setText(this.sqlObject.toString());
            this.button.setEnabled(false);
            this.textFieldCountResult.setText(null);
            this.labelDate.setText(null);
        }
    }

    private void cancelCount() {
        if (this.countThread != null) {
            this.countThread.interrupt();
        }
    }

    private void startCountForTable() {
        this.button.setText("Cancel");
        if (this.sqlObject instanceof SQLTable) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.countThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CountPanel.this.countRunning = true;
                    try {
                        SQLTable table = (SQLTable)CountPanel.this.sqlObject;
                        table.refreshCount();
                        CountPanel.this.refreshView();
                    }
                    finally {
                        CountPanel.this.button.setText("Count");
                        CountPanel.this.countRunning = false;
                        CountPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.countThread.start();
        }
    }

    private void startCountForAllTables() {
        this.button.setText("Cancel");
        if (this.sqlObject instanceof SQLSchema) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.countThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    CountPanel.this.countRunning = true;
                    SQLSchema schema = (SQLSchema)CountPanel.this.sqlObject;
                    try {
                        for (SQLTable table : schema.getTables()) {
                            if (!table.isTable()) continue;
                            CountPanel.this.labelInfo.setText(table.getAbsoluteName());
                            table.refreshCount();
                            CountPanel.this.sqlObject = table;
                            CountPanel.this.refreshView();
                        }
                    }
                    finally {
                        CountPanel.this.button.setText("Count");
                        CountPanel.this.countRunning = false;
                        CountPanel.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.countThread.start();
        }
    }
}

