/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel;

import sqlrunner.datamodel.SQLDataModel;

public class SQLObject {
    private String name;
    private transient SQLDataModel model = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SQLObject(SQLDataModel model, String name) {
        if (model == null) {
            if (!(this instanceof SQLDataModel)) throw new IllegalArgumentException("model cannot be null");
            this.model = (SQLDataModel)this;
        } else {
            this.model = model;
        }
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.name = name;
    }

    public String getKey() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public SQLDataModel getModel() {
        return this.model;
    }

    public static boolean isValidIdentifier(String name) {
        boolean valid = true;
        if (name == null) {
            return false;
        }
        if (name.isEmpty()) {
            return false;
        }
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (!(i == 0 ? !(Character.isJavaIdentifierStart(c) || Character.isUpperCase(c)) : !(Character.isUpperCase(c) || Character.isJavaIdentifierPart(c) || c == '-'))) continue;
            return false;
        }
        return valid;
    }
}

