/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import sqlrunner.datamodel.Field;
import sqlrunner.datamodel.SQLDataModel;
import sqlrunner.datamodel.SQLFieldNotNullConstraint;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.flatfileimport.BasicDataType;

public final class SQLField
extends SQLObject
implements Comparable<SQLField>,
Field {
    private int type;
    private String dbTypeName;
    private int basicType;
    private SQLTable ownSQLTable;
    private boolean nullEnabled = true;
    private SQLFieldNotNullConstraint nnc = null;
    private boolean isPrimaryKey = false;
    private String usedInIndex = null;
    private int length = 0;
    private int decimalDigits = 0;
    private int ordinalPosition;
    private String comment;
    private String typeSQLCode;
    private String defaultValue;
    private boolean isSerial = false;
    private Class<?> javaClass;
    public static final int ORACLE_ROWID = -100;
    static final int[] arrayBasicTypes = new int[]{BasicDataType.CHARACTER.getId(), BasicDataType.DATE.getId(), BasicDataType.DOUBLE.getId(), BasicDataType.INTEGER.getId(), BasicDataType.LONG.getId(), BasicDataType.BINARY.getId(), BasicDataType.CLOB.getId(), BasicDataType.BOOLEAN.getId()};
    private static final HashMap<Integer, Integer> customTypeMap = new HashMap();

    public SQLField(SQLDataModel model, SQLTable sqlTable, String name) {
        super(model, name);
        this.ownSQLTable = sqlTable;
    }

    public String getTableName() {
        return this.ownSQLTable.getName();
    }

    public void setPrimaryKey(boolean isPrimaryKey_loc) {
        this.isPrimaryKey = isPrimaryKey_loc;
    }

    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    public void setNullValueAllowed(boolean nullEnabled_loc) {
        this.nullEnabled = nullEnabled_loc;
    }

    public SQLFieldNotNullConstraint getNotNullConstraint() {
        if (this.nullEnabled) {
            return null;
        }
        if (this.nnc == null) {
            this.nnc = new SQLFieldNotNullConstraint(this);
        }
        return this.nnc;
    }

    public boolean isNullValueAllowed() {
        return this.nullEnabled && !this.isPrimaryKey;
    }

    public static void addCustomTypeBasictypePair(int sqlType, int basicType) {
        customTypeMap.put(sqlType, basicType);
    }

    public static Set<Map.Entry<Integer, Integer>> getCustomTypeMap() {
        return customTypeMap.entrySet();
    }

    public void setType(int type) {
        this.type = type;
        this.basicType = BasicDataType.getBasicTypeByTypes(type);
    }

    public int getType() {
        return this.type;
    }

    @Override
    public void setTypeName(String name_loc) {
        this.dbTypeName = name_loc;
    }

    @Override
    public String getTypeName() {
        return this.dbTypeName;
    }

    @Override
    public void setLength(Integer length_loc) {
        if (length_loc != null) {
            this.length = length_loc;
        }
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setDecimalDigits(Integer digits) {
        if (digits != null) {
            this.decimalDigits = digits;
        }
    }

    @Override
    public int getDecimalDigits() {
        return this.decimalDigits;
    }

    public void setOrdinalPosition(int pos) {
        this.ordinalPosition = pos;
    }

    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment != null && !comment.trim().isEmpty() ? comment.trim() : null;
    }

    public String getAbsoluteName() {
        return this.ownSQLTable.getName() + "." + this.getName();
    }

    @Override
    public int compareTo(SQLField field) {
        int compvalue = 0;
        if (field != null && (compvalue = this.ownSQLTable.getName().compareTo(field.getTableName())) == 0) {
            compvalue = this.ordinalPosition > field.getOrdinalPosition() ? 1 : -1;
        }
        return compvalue;
    }

    public boolean equals(Object object) {
        if (object instanceof SQLField) {
            return this.getAbsoluteName().equalsIgnoreCase(((SQLField)object).getAbsoluteName());
        }
        return false;
    }

    public int hashCode() {
        return this.getAbsoluteName().hashCode();
    }

    public SQLTable getSQLTable() {
        return this.ownSQLTable;
    }

    public int getBasicType() {
        return this.basicType;
    }

    @Override
    public void setBasicType(int basicType) {
        this.basicType = basicType;
    }

    public final String getUsedInIndex() {
        return this.usedInIndex;
    }

    public final void setUsedInIndex(String usedInIndex) {
        this.usedInIndex = usedInIndex;
    }

    public static void setCustomSqlTypeMapping(String parameterString) throws Exception {
        StringTokenizer st = new StringTokenizer(parameterString, ",;|");
        while (st.hasMoreTokens()) {
            String pair = st.nextToken();
            try {
                int posEqual = pair.indexOf(61);
                if (posEqual > 0 && posEqual < pair.length() - 1) {
                    int sqlType = Integer.parseInt(pair.substring(0, posEqual));
                    int basicType = Integer.parseInt(pair.substring(posEqual + 1));
                    if (SQLField.isValidBasicType(basicType)) {
                        SQLField.addCustomTypeBasictypePair(sqlType, basicType);
                        continue;
                    }
                    throw new Exception("Unknown basicType " + basicType);
                }
                throw new Exception("invalid pair");
            }
            catch (Exception e) {
                throw new Exception("Using customTypMap pair <" + pair + "> failed: " + e.getMessage(), e);
            }
        }
    }

    private static boolean isValidBasicType(int basicType) {
        for (int type : arrayBasicTypes) {
            if (type != basicType) continue;
            return true;
        }
        return false;
    }

    public static String getBasicTypeName(int id) {
        BasicDataType type = BasicDataType.getBasicDataType(id);
        if (type != null) {
            return type.getName();
        }
        return "Unknown Type";
    }

    @Override
    public String getTypeSQLCode() {
        return this.typeSQLCode;
    }

    @Override
    public void setTypeSQLCode(String typeSQLCode) {
        this.typeSQLCode = typeSQLCode;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getDefaultValueSQL() {
        String sql = "";
        if (this.defaultValue != null && this.basicType == BasicDataType.CHARACTER.getId()) {
            sql = " default '" + this.defaultValue + "'";
        }
        return sql;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isSerial() {
        return this.isSerial;
    }

    public void setSerial(boolean isSerial) {
        this.isSerial = isSerial;
    }

    @Override
    public void setJavaClass(Class<?> clazz) {
        this.javaClass = clazz;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }
}

