/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel;

import dbtools.ConnectionDescription;
import dbtools.DatabaseSession;
import dbtools.DatabaseSessionPool;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.DatamodelEvent;
import sqlrunner.datamodel.DatamodelListener;
import sqlrunner.datamodel.DefaultCatalog;
import sqlrunner.datamodel.DefaultSchema;
import sqlrunner.datamodel.SQLCatalog;
import sqlrunner.datamodel.SQLConstraint;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLIndex;
import sqlrunner.datamodel.SQLObject;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.dbext.DatabaseExtension;
import sqlrunner.dbext.DatabaseExtensionFactory;
import sqlrunner.generator.SQLCodeGenerator;

public final class SQLDataModel
extends SQLObject
implements Comparable<SQLDataModel> {
    private static final Logger logger = Logger.getLogger(SQLDataModel.class);
    private ConnectionDescription cd;
    private String errorMessage;
    private final List<SQLCatalog> catalogs = new ArrayList<SQLCatalog>();
    private boolean loadingSchemas = false;
    private boolean useLowerCaseIdentifiers = false;
    private boolean useUpperCaseIdentifiers = false;
    private boolean userCaseSensitiveIdentifiers = false;
    public final char delimiter = '\u0000';
    private boolean schemasLoaded = false;
    private SQLSchema currentSQLSchema;
    private SQLSchema loginSchema;
    private String loginSchemaName;
    private ArrayList<DatamodelListener> listener = new ArrayList();
    private DatabaseExtension databaseExtension;
    private Connection connection;

    public void addDatamodelListener(DatamodelListener l) {
        if (!this.listener.contains(l)) {
            this.listener.add(l);
        }
    }

    public void removeDatamodelListener(DatamodelListener l) {
        this.listener.remove(l);
    }

    public void removeAllDatamodelListener() {
        this.listener.clear();
    }

    private void fireDatamodelEvent(final String message, final int type) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.doFireDatemodelEvent(message, type);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SQLDataModel.this.doFireDatemodelEvent(message, type);
                }
            });
        }
    }

    private void doFireDatemodelEvent(String message, int type) {
        DatamodelEvent e = new DatamodelEvent(this, message, type);
        for (DatamodelListener l : this.listener) {
            l.eventHappend(e);
        }
    }

    public boolean isUseLowerCaeIdentifiers() {
        return this.useLowerCaseIdentifiers;
    }

    public boolean isUseUpperCaseIdentifiers() {
        return this.useUpperCaseIdentifiers;
    }

    public boolean isUserCaseSensitiveIdentifiers() {
        return this.userCaseSensitiveIdentifiers;
    }

    public SQLDataModel(ConnectionDescription cd) {
        super(null, cd.toString());
        this.cd = cd.clone();
        this.cd.setAutoCommit(true);
        if (DatabaseSessionPool.getConnectionDescription(cd.getUniqueId()) == null) {
            DatabaseSessionPool.addConnectionDescription(cd.getUniqueId(), cd);
        }
        if (!DatabaseSessionPool.isPoolCheckThreadRunning()) {
            DatabaseSessionPool.setMaxIdleTime(5);
            DatabaseSessionPool.setCheckPoolCyclusTime(5);
            DatabaseSessionPool.startCheckPoolThread();
        }
        this.databaseExtension = DatabaseExtensionFactory.getDatabaseExtension(cd);
        this.loginSchemaName = this.databaseExtension.getLoginSchema(cd);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loginSchemaName=" + this.loginSchemaName));
        }
    }

    public SQLDataModel(Connection connection) {
        super(null, "given-connection");
        this.connection = connection;
        String driverClass = null;
        try {
            driverClass = connection.getMetaData().getDriverName();
        }
        catch (SQLException e) {
            logger.error((Object)("Unable to get database metadata: " + e.getMessage()), (Throwable)e);
        }
        this.databaseExtension = DatabaseExtensionFactory.getDatabaseExtension(driverClass);
        this.loginSchemaName = this.databaseExtension.getLoginSchema(connection);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loginSchemaName=" + this.loginSchemaName));
        }
    }

    public void refresh() {
        this.loadSchemas();
    }

    public void reloadSchemasAndTables() {
        this.fireDatamodelEvent("Preloading metadata...", 2);
        this.loadSchemas();
        this.getCurrentSQLSchema();
        if (this.currentSQLSchema != null && !this.currentSQLSchema.isTablesLoaded()) {
            this.loadTables(this.currentSQLSchema);
        }
        this.fireDatamodelEvent("Preloading metadata finished", 2);
    }

    public boolean isSchemaLoaded() {
        return this.schemasLoaded;
    }

    public DatabaseSession getDatabaseSession() {
        return DatabaseSessionPool.getDatabaseSession(this.cd.getUniqueId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSchemas() {
        boolean ok;
        block22: {
            if (this.loadingSchemas) {
                return false;
            }
            this.loadingSchemas = true;
            if (Thread.currentThread().isInterrupted()) {
                this.loadingSchemas = false;
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"loadSchemas");
            }
            DatabaseSession session = null;
            Connection conn = this.connection;
            if (conn == null) {
                session = this.getDatabaseSession();
                if (session == null) {
                    return false;
                }
                session.setLastSQL("loadSchemas");
                conn = session.getConnection();
            }
            if (conn == null) {
                return false;
            }
            ok = false;
            try {
                this.fireDatamodelEvent("Loading schemas", 2);
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd == null) break block22;
                this.useLowerCaseIdentifiers = dbmd.storesLowerCaseIdentifiers();
                this.useUpperCaseIdentifiers = dbmd.storesUpperCaseIdentifiers();
                this.userCaseSensitiveIdentifiers = dbmd.storesMixedCaseIdentifiers();
                this.schemasLoaded = false;
                ResultSet rsCatalogs = dbmd.getCatalogs();
                this.catalogs.clear();
                while (rsCatalogs.next()) {
                    String catName = rsCatalogs.getString("TABLE_CAT");
                    if (catName == null || catName.isEmpty()) continue;
                    this.addCatalog(new SQLCatalog(this, catName));
                }
                rsCatalogs.close();
                if (this.catalogs.isEmpty()) {
                    this.catalogs.add(new DefaultCatalog(this));
                }
                String currentCatalog = conn.getCatalog();
                for (SQLCatalog catalog : this.catalogs) {
                    try {
                        conn.setCatalog(catalog.getKey());
                        dbmd = conn.getMetaData();
                        ResultSet rsSchemas = dbmd.getSchemas();
                        while (rsSchemas.next() && !Thread.currentThread().isInterrupted()) {
                            String name = rsSchemas.getString("TABLE_SCHEM");
                            SQLSchema schema = new SQLSchema(this, name);
                            catalog.addSQLSchema(schema);
                            if (!schema.getName().equalsIgnoreCase(this.loginSchemaName)) continue;
                            this.loginSchema = schema;
                        }
                        rsSchemas.close();
                        if (catalog.getCountSchemas() != 0) continue;
                        DefaultSchema schema = new DefaultSchema(this);
                        catalog.addSQLSchema(schema);
                        if (!((SQLObject)schema).getName().equalsIgnoreCase(this.loginSchemaName)) continue;
                        this.loginSchema = schema;
                    }
                    catch (Exception e) {
                        this.errorMessage = "loadSchemas (schemas) for catalog: " + catalog.getName() + " failed: " + e.getMessage();
                        logger.error((Object)this.errorMessage);
                        this.fireDatamodelEvent("Loading schemas failed.", 2);
                        boolean bl = false;
                        if (session != null) {
                            DatabaseSessionPool.release(session);
                        }
                        this.loadingSchemas = false;
                        return bl;
                    }
                }
                if (currentCatalog != null && !currentCatalog.trim().isEmpty()) {
                    conn.setCatalog(currentCatalog);
                }
                ok = true;
                this.schemasLoaded = true;
            }
            catch (SQLException sqle) {
                this.errorMessage = "loadSchemas (catalogs) failed: " + sqle.getMessage();
                logger.error((Object)this.errorMessage);
                if (session != null) {
                    session.error(this.errorMessage, sqle);
                }
            }
            finally {
                if (session != null) {
                    DatabaseSessionPool.release(session);
                }
                this.loadingSchemas = false;
            }
        }
        this.fireDatamodelEvent("Loading catalogs+schemas finished (" + this.catalogs.size() + ")", 2);
        return ok;
    }

    protected void clearCatalogs() {
        this.catalogs.clear();
    }

    public void addCatalog(SQLCatalog catalog) {
        if (!this.catalogs.contains(catalog)) {
            this.catalogs.add(catalog);
        }
    }

    public SQLTable getSQLTable(String schemaName, String tableName) {
        if (!SQLDataModel.isIdentifierName(tableName)) {
            return null;
        }
        for (SQLCatalog cat : this.catalogs) {
            for (SQLSchema schema : cat.getSchemas()) {
                SQLTable table;
                if (!schema.getName().equalsIgnoreCase(schemaName) || (table = schema.getTable(tableName)) == null) continue;
                return table;
            }
        }
        return null;
    }

    public static boolean isIdentifierName(String name) {
        if (name == null || name.trim().isEmpty()) {
            return false;
        }
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public SQLSchema getSchema(String schemaName) {
        String currentCatalog = null;
        int pos = schemaName.indexOf(46);
        if (pos > 0) {
            currentCatalog = schemaName.substring(0, pos);
        }
        for (SQLCatalog cat : this.catalogs) {
            if (currentCatalog != null && !currentCatalog.equals(cat.getName())) continue;
            for (SQLSchema schema : cat.getSchemas()) {
                if (!schema.getName().equalsIgnoreCase(schemaName)) continue;
                return schema;
            }
        }
        return null;
    }

    public SQLTable getSQLTable(String schemaDotTableName) {
        int pos = schemaDotTableName.indexOf(46);
        if (pos == -1) {
            return this.currentSQLSchema.getTable(schemaDotTableName);
        }
        String schemaName = schemaDotTableName.substring(0, pos);
        String tableName = schemaDotTableName.substring(pos + 1);
        return this.getSQLTable(schemaName, tableName);
    }

    public SQLField getSQLField(String schemaDotTableDotFieldName) {
        int pos = schemaDotTableDotFieldName.indexOf(46);
        if (pos == -1) {
            throw new IllegalArgumentException(schemaDotTableDotFieldName + " is not a absolute name");
        }
        String schemaName = schemaDotTableDotFieldName.substring(0, pos);
        SQLSchema schema = this.getSchema(schemaName);
        if (schema != null) {
            int pos1 = schemaDotTableDotFieldName.indexOf(46, pos + 1);
            if (pos1 == -1) {
                throw new IllegalArgumentException(schemaDotTableDotFieldName + " is not a absolute name");
            }
            String tableName = schemaDotTableDotFieldName.substring(pos + 1, pos1);
            SQLTable table = schema.getTable(tableName);
            if (table != null) {
                String fieldName = schemaDotTableDotFieldName.substring(pos1);
                return table.getField(fieldName);
            }
        }
        return null;
    }

    public SQLCatalog getSQLCatalog(String name) {
        for (SQLCatalog c : this.catalogs) {
            if (!name.equalsIgnoreCase(c.getName())) continue;
            return c;
        }
        return null;
    }

    public List<SQLCatalog> getCatalogs() {
        return this.catalogs;
    }

    public SQLField getSQLField(String schemaName, String tableName, String fieldName) {
        SQLTable table;
        SQLSchema schema = this.getSchema(schemaName);
        if (schema != null && (table = schema.getTable(tableName)) != null) {
            return table.getField(fieldName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadTables(SQLSchema schema) {
        if (schema.isLoadingTables()) {
            return false;
        }
        schema.setLoadingTables(true);
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadTables schema=" + schema));
        }
        boolean ok = false;
        DatabaseSession session = null;
        Connection conn = this.connection;
        if (conn == null) {
            session = this.getDatabaseSession();
            if (session == null) {
                return false;
            }
            conn = session.getConnection();
            session.setLastSQL("loadTables schema=" + schema);
        }
        if (conn == null) {
            return false;
        }
        try {
            this.fireDatamodelEvent("Loading tables and views...", 2);
            DatabaseMetaData dbmd = conn.getMetaData();
            if (dbmd != null) {
                schema.clearTables();
                ResultSet rs = dbmd.getTables(schema.getCatalog().getKey(), schema.getKey(), null, null);
                if (rs != null) {
                    String tableName = null;
                    while (rs.next() && !Thread.currentThread().isInterrupted()) {
                        tableName = rs.getString("TABLE_NAME");
                        SQLTable table = new SQLTable(schema.getModel(), schema, tableName);
                        table.setType(rs.getString("TABLE_TYPE"));
                        table.setComment(rs.getString("REMARKS"));
                        if (!table.isTable() && !table.isView()) continue;
                        schema.addTable(table);
                    }
                    rs.close();
                }
                schema.setTablesLoaded();
                ok = true;
            }
        }
        catch (SQLException sqle) {
            this.errorMessage = "loadTables for schema=" + schema + " failed: " + sqle.getMessage();
            if (session != null) {
                session.error(this.errorMessage, sqle);
            }
            this.fireDatamodelEvent("Loading tables failed.", 2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                DatabaseSessionPool.release(session);
            }
            schema.setLoadingTables(false);
        }
        this.fireDatamodelEvent("Loading tables and views finished", 2);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProcedures(SQLSchema schema) {
        boolean ok;
        block26: {
            if (schema.isLoadingProcedures()) {
                return false;
            }
            schema.setLoadingProcedures(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadProcedures schema=" + schema));
            }
            ok = false;
            DatabaseSession session = null;
            Connection conn = this.connection;
            if (conn == null) {
                session = this.getDatabaseSession();
                if (session == null) {
                    return false;
                }
                conn = session.getConnection();
                session.setLastSQL("loadProcedures schema=" + schema);
            }
            if (conn == null) {
                return false;
            }
            try {
                this.fireDatamodelEvent("Load procedures for " + schema, 2);
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd == null) break block26;
                schema.clearProcedures();
                ResultSet rs = dbmd.getProcedures(schema.getCatalog().getKey(), schema.getKey(), null);
                if (rs != null) {
                    while (rs.next() && !Thread.currentThread().isInterrupted()) {
                        String catalogName = rs.getString("PROCEDURE_CAT");
                        String name = rs.getString("PROCEDURE_NAME");
                        if (catalogName != null && catalogName.length() > 0) {
                            name = catalogName + "." + name;
                        }
                        SQLProcedure procedure = new SQLProcedure(this, schema, name);
                        procedure.setComment(rs.getString("REMARKS"));
                        schema.addProcedure(procedure);
                    }
                    rs.close();
                } else {
                    logger.error((Object)"No result returned by query database metadata for procedures.");
                }
                if (schema.getProcedureCount() > 0 && (rs = dbmd.getProcedureColumns(schema.getCatalog().getKey(), schema.getKey(), null, null)) != null) {
                    int procedureIndex = 0;
                    String prevProcedureName = "noprocedurehere_xx";
                    while (rs.next() && !Thread.currentThread().isInterrupted()) {
                        String catalogName = rs.getString("PROCEDURE_CAT");
                        String name = rs.getString("PROCEDURE_NAME");
                        if (catalogName != null && catalogName.length() > 0) {
                            name = catalogName + "." + name;
                        }
                        int pos = 0;
                        try {
                            pos = rs.getInt("ORDINAL_POSITION");
                        }
                        catch (Exception e) {
                            pos = -1;
                        }
                        if (prevProcedureName.equals(name)) {
                            if (pos == 0) {
                                ++procedureIndex;
                            }
                        } else {
                            procedureIndex = 0;
                        }
                        String columnName = rs.getString("COLUMN_NAME");
                        List<SQLProcedure> list = schema.getProcedures(name);
                        SQLProcedure procedure = list.get(procedureIndex);
                        if (procedure != null) {
                            short dataType = rs.getShort("DATA_TYPE");
                            String dataTypeName = rs.getString("TYPE_NAME");
                            int length = rs.getInt("LENGTH");
                            int precision = rs.getInt("PRECISION");
                            short ioType = rs.getShort("COLUMN_TYPE");
                            SQLProcedure.Parameter p = procedure.addParameter(columnName, dataType, dataTypeName, length, precision, ioType);
                            this.databaseExtension.setupDataType(p);
                        }
                        prevProcedureName = name;
                    }
                    rs.close();
                }
                schema.setProcedureLoaded();
                schema.sortProcedureList();
                this.fireDatamodelEvent("Load procedure source code", 2);
                for (int i = 0; i < schema.getProcedureCount(); ++i) {
                    SQLProcedure p = schema.getProcedureAt(i);
                    if (session == null) continue;
                    this.databaseExtension.setupProcedureSQLCode(session, p);
                }
                ok = true;
                this.fireDatamodelEvent("Loading procedures for " + schema + " finished", 2);
            }
            catch (SQLException sqle) {
                this.errorMessage = "loadProcedures schema=" + schema + " failed: " + sqle.getMessage();
                if (session != null) {
                    session.error(this.errorMessage, sqle);
                }
                this.fireDatamodelEvent("Load procedures failed.", 2);
                boolean bl = false;
                return bl;
            }
            finally {
                if (session != null) {
                    DatabaseSessionPool.release(session);
                }
                schema.setLoadingProcedures(false);
            }
        }
        return ok;
    }

    boolean loadColumns(SQLTable table) {
        return this.loadColumns(table, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean loadColumns(SQLTable table, boolean onlyTables) {
        block22: {
            if (table.isLoadingColumns()) {
                return false;
            }
            table.setLoadingColumns(true);
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadColumns table=" + table));
            }
            DatabaseSession session = null;
            Connection conn = this.connection;
            if (conn == null) {
                session = this.getDatabaseSession();
                if (session == null) {
                    return false;
                }
                conn = session.getConnection();
                session.setLastSQL("loadColumns table=" + table);
            }
            if (conn == null) {
                return false;
            }
            try {
                this.fireDatamodelEvent("Load columns for " + table, 2);
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd == null) break block22;
                SQLField field = null;
                try {
                    table.clearFields();
                    ResultSet rs = dbmd.getColumns(table.getSchema().getCatalog().getKey(), table.getSchema().getKey(), table.getName(), null);
                    if (rs != null) {
                        while (rs.next() && !Thread.currentThread().isInterrupted()) {
                            String name = rs.getString("COLUMN_NAME");
                            field = new SQLField(this, table, name);
                            field.setType(rs.getInt("DATA_TYPE"));
                            field.setTypeName(rs.getString("TYPE_NAME"));
                            field.setLength(rs.getInt("COLUMN_SIZE"));
                            field.setDecimalDigits(rs.getInt("DECIMAL_DIGITS"));
                            field.setOrdinalPosition(rs.getInt("ORDINAL_POSITION"));
                            field.setNullValueAllowed(rs.getInt("NULLABLE") == 1);
                            field.setComment(rs.getString("REMARKS"));
                            this.databaseExtension.setupDataType(field);
                            table.addField(field);
                        }
                        table.setFieldsLoaded();
                        rs.close();
                    }
                    this.fireDatamodelEvent("Loading columns finished", 2);
                    if (!onlyTables && !table.getType().equals("VIEW")) {
                        this.loadConstraints(table);
                        this.loadIndexes(table);
                    } else if (session != null) {
                        this.databaseExtension.setupViewSQLCode(session, table);
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("loadColumns (get columns) for table=" + table + " failed: " + sqle.getMessage()));
                    if (session != null) {
                        session.error(this.errorMessage, sqle);
                    }
                    this.fireDatamodelEvent("Loading columns for table=" + table + " failed", 2);
                    boolean bl = false;
                    if (session != null) {
                        DatabaseSessionPool.release(session);
                    }
                    table.setLoadingColumns(false);
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error((Object)("loadColumns failed: " + e.getMessage()), (Throwable)e);
                if (session != null) {
                    session.error(this.errorMessage);
                }
            }
            finally {
                if (session != null) {
                    DatabaseSessionPool.release(session);
                }
                table.setLoadingColumns(false);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long countDatasets(SQLTable table) {
        Long count = null;
        DatabaseSession session = this.getDatabaseSession();
        if (session != null) {
            this.fireDatamodelEvent("Count datasets for table " + table, 2);
            try {
                ResultSet rs = session.executeQuery(SQLCodeGenerator.getInstance().buildCountAllStatement(table, true));
                if (rs.next()) {
                    count = rs.getLong(1);
                }
                rs.close();
            }
            catch (SQLException sqle) {
                logger.error((Object)("countDatasets for table " + table.getName() + " failed:" + sqle.getMessage()), (Throwable)sqle);
            }
            finally {
                DatabaseSessionPool.release(session);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadConstraints(SQLTable table) {
        block34: {
            if (table.isLoadingConstraints()) {
                return false;
            }
            table.setLoadingConstraints(true);
            if (Thread.currentThread().isInterrupted()) {
                return false;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("loadConstraints table=" + table));
            }
            DatabaseSession session = null;
            Connection conn = this.connection;
            if (conn == null) {
                session = this.getDatabaseSession();
                if (session == null) {
                    return false;
                }
                conn = session.getConnection();
                session.setLastSQL("loadColumns table=" + table);
            }
            if (conn == null) {
                return false;
            }
            try {
                String name2;
                ResultSet rs;
                this.fireDatamodelEvent("Load primary key constraints for table " + table, 2);
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd == null) break block34;
                table.clearConstraints();
                try {
                    rs = dbmd.getPrimaryKeys(table.getSchema().getCatalog().getKey(), table.getSchema().getKey(), table.getName());
                    if (rs != null) {
                        while (rs.next() && !Thread.currentThread().isInterrupted()) {
                            name2 = rs.getString("PK_NAME");
                            SQLConstraint constraint = table.getPrimaryKeyConstraint();
                            if (constraint == null) {
                                constraint = new SQLConstraint(this, table, 1, name2);
                                table.setPrimaryKeyConstraint(constraint);
                            }
                            constraint.addPrimaryKeyFieldName(rs.getString("COLUMN_NAME"), rs.getShort("KEY_SEQ"));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("pk constraint changed: " + constraint));
                        }
                        rs.close();
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("loadConstraints (pk) for table=" + table + " failed: " + sqle.getMessage()));
                    if (session != null) {
                        session.error(this.errorMessage, sqle);
                    }
                    table.setLoadingConstraints(false);
                    boolean name2 = false;
                    if (session != null) {
                        DatabaseSessionPool.release(session);
                    }
                    table.setLoadingConstraints(false);
                    return name2;
                }
                if (Thread.currentThread().isInterrupted()) {
                    boolean sqle = false;
                    return sqle;
                }
                try {
                    if (session != null) {
                        session.setLastSQL("loadConstraints (imported keys) table=" + table);
                    }
                    this.fireDatamodelEvent("Load foreign key constraints for table " + table, 2);
                    rs = dbmd.getImportedKeys(table.getSchema().getCatalog().getKey(), table.getSchema().getKey(), table.getName());
                    if (rs != null) {
                        while (rs.next() && !Thread.currentThread().isInterrupted()) {
                            name2 = rs.getString("FK_NAME");
                            String fkSchema = rs.getString("FKTABLE_SCHEM");
                            String fkTable = rs.getString("PKTABLE_NAME");
                            SQLConstraint constraint = table.getConstraint(name2);
                            if (constraint == null) {
                                constraint = new SQLConstraint(this, table, 2, name2);
                                if (fkSchema == null || fkSchema.isEmpty()) {
                                    fkSchema = table.getSchema().getName();
                                }
                                constraint.setReferencedTableName(fkSchema + "." + fkTable);
                                table.addConstraint(constraint);
                            }
                            constraint.addForeignKeyColumnNamePair(rs.getString("FKCOLUMN_NAME"), rs.getString("PKCOLUMN_NAME"), rs.getShort("KEY_SEQ"));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("fk constraint changed: " + constraint));
                        }
                        rs.close();
                        table.setConstraintsLoaded();
                    }
                    if (logger.isDebugEnabled()) {
                        List<SQLConstraint> list = table.getConstraints();
                        for (int i = 0; i < list.size(); ++i) {
                            logger.debug((Object)(" * " + list.get(i)));
                        }
                    }
                }
                catch (SQLException sqle) {
                    logger.error((Object)("loadConstraints (fk) for table=" + table + " failed: " + sqle.getMessage()));
                    if (session != null) {
                        session.error(this.errorMessage);
                    }
                    table.setLoadingConstraints(false);
                    boolean bl = false;
                    if (session != null) {
                        DatabaseSessionPool.release(session);
                    }
                    table.setLoadingConstraints(false);
                    return bl;
                }
            }
            catch (Exception e) {
                logger.error((Object)("loadConstraints failed: " + e.getMessage()), (Throwable)e);
                if (session != null) {
                    session.error(this.errorMessage);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                if (session != null) {
                    DatabaseSessionPool.release(session);
                }
                table.setLoadingConstraints(false);
            }
        }
        this.fireDatamodelEvent("Loading constraints finished", 2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadIndexes(SQLTable table) {
        if (table.isLoadingIndexes()) {
            return false;
        }
        table.setLoadingIndexes(true);
        if (Thread.currentThread().isInterrupted()) {
            return false;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadIndexes table=" + table));
        }
        DatabaseSession session = null;
        Connection conn = this.connection;
        if (conn == null) {
            session = this.getDatabaseSession();
            if (session == null) {
                return false;
            }
            conn = session.getConnection();
            session.setLastSQL("loadIndexes table=" + table);
        }
        if (conn == null) {
            return false;
        }
        try {
            this.fireDatamodelEvent("Load indexes for table " + table, 2);
            DatabaseMetaData dbmd = conn.getMetaData();
            if (dbmd != null) {
                table.clearIndexes();
                SQLIndex index = null;
                ResultSet rs = dbmd.getIndexInfo(null, table.getSchema().getName(), table.getName(), false, true);
                if (rs != null) {
                    while (rs.next() && !Thread.currentThread().isInterrupted()) {
                        String indexName = rs.getString("INDEX_NAME");
                        if (indexName == null) continue;
                        boolean unique = false;
                        Object nonUnique = rs.getObject("NON_UNIQUE");
                        if (nonUnique instanceof Boolean) {
                            unique = (Boolean)nonUnique == false;
                        } else if (nonUnique instanceof Integer) {
                            unique = (Integer)nonUnique == 0;
                        } else if (nonUnique instanceof String) {
                            unique = !Boolean.parseBoolean((String)nonUnique);
                        }
                        short type = rs.getShort("TYPE");
                        short ordinalPosition = rs.getShort("ORDINAL_POSITION");
                        String columnName = rs.getString("COLUMN_NAME");
                        String sortOrder = rs.getString("ASC_OR_DESC");
                        int cardinality = rs.getInt("CARDINALITY");
                        String filterCondition = rs.getString("FILTER_CONDITION");
                        index = table.getIndexByName(indexName);
                        if (index == null) {
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("add index " + indexName));
                            }
                            index = new SQLIndex(table.getModel(), indexName, table);
                            index.setUnique(unique);
                            index.setType(type);
                            index.setCardinality(cardinality);
                            index.setFilterCondition(filterCondition);
                            table.addIndex(index);
                        }
                        index.addIndexField(columnName, ordinalPosition, sortOrder);
                    }
                    table.setIndexesLoaded();
                    rs.close();
                    boolean bl = true;
                    return bl;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)("loadIndexes failed: " + e.getMessage()), (Throwable)e);
            if (session != null) {
                session.error(this.errorMessage, e);
            }
            this.fireDatamodelEvent("Load indexes for table " + table + " failed.", 2);
            boolean bl = false;
            return bl;
        }
        finally {
            if (session != null) {
                DatabaseSessionPool.release(session);
            }
            table.setLoadingIndexes(false);
        }
        return false;
    }

    public String getLastErrorMessage() {
        return this.errorMessage;
    }

    public static void removeViews(SQLSchema schema) {
        SQLTable sqlTable = null;
        for (int x = 0; x < schema.getTableCount(); ++x) {
            sqlTable = schema.getTableAt(x);
            if (!sqlTable.getType().equals("VIEW")) continue;
            schema.removeSQLTable(sqlTable);
            --x;
        }
    }

    @Override
    public String toString() {
        if (this.cd != null) {
            return this.cd.toString();
        }
        return "not connected";
    }

    @Override
    public int compareTo(SQLDataModel o) {
        if (o.cd != null) {
            return o.cd.compareTo(this.cd);
        }
        return 0;
    }

    public int hashCode() {
        if (this.cd != null) {
            return this.cd.hashCode();
        }
        return super.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SQLDataModel) {
            if (this.cd != null) {
                return this.cd.equals(((SQLDataModel)object).cd);
            }
            return false;
        }
        return false;
    }

    public List<SQLSchema> getSchemas() {
        ArrayList<SQLSchema> list = new ArrayList<SQLSchema>();
        for (SQLCatalog c : this.catalogs) {
            for (SQLSchema s : c.getSchemas()) {
                if (list.contains(s)) continue;
                list.add(s);
            }
        }
        return list;
    }

    public DatabaseExtension getDatabaseExtension() {
        return this.databaseExtension;
    }

    public SQLSchema getCurrentSQLSchema() {
        if (this.currentSQLSchema == null) {
            this.currentSQLSchema = this.getSchema(this.databaseExtension.getLoginSchema(this.cd));
        }
        return this.currentSQLSchema;
    }

    public ConnectionDescription getConnectionDescription() {
        return this.cd.clone();
    }

    public SQLSchema getLoginSchema() {
        return this.loginSchema;
    }

    public String getLoginSchemaName() {
        return this.loginSchemaName;
    }

    public void setConnection(Connection connection) {
        if (this.connection == null) {
            throw new IllegalStateException("Use the method setConnection only to renew an existing connection!");
        }
        if (connection == null) {
            throw new IllegalArgumentException("connection cannot be null!");
        }
        this.connection = connection;
    }
}

