/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.datamodel;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import sqlrunner.datamodel.DatamodelEvent;
import sqlrunner.datamodel.DatamodelListener;
import sqlrunner.datamodel.SQLConstraint;
import sqlrunner.datamodel.SQLField;
import sqlrunner.datamodel.SQLFieldNotNullConstraint;
import sqlrunner.datamodel.SQLIndex;
import sqlrunner.datamodel.SQLProcedure;
import sqlrunner.datamodel.SQLSchema;
import sqlrunner.datamodel.SQLTable;
import sqlrunner.generator.SQLCodeGenerator;

public final class ModelComparator {
    private static final Logger logger = Logger.getLogger(ModelComparator.class);
    private List<SQLTable> tablesToAdd = new ArrayList<SQLTable>();
    private List<SQLField> fieldsToAdd = new ArrayList<SQLField>();
    private List<SQLIndex> indicesToAdd = new ArrayList<SQLIndex>();
    private List<SQLConstraint> constraintsToAdd = new ArrayList<SQLConstraint>();
    private List<SQLFieldNotNullConstraint> notNullsToAdd = new ArrayList<SQLFieldNotNullConstraint>();
    private List<SQLTable> tablesToRemove = new ArrayList<SQLTable>();
    private List<SQLField> fieldsToRemove = new ArrayList<SQLField>();
    private List<SQLIndex> indicesToRemove = new ArrayList<SQLIndex>();
    private List<SQLConstraint> constraintsToRemove = new ArrayList<SQLConstraint>();
    private List<SQLFieldNotNullConstraint> notNullsToRemove = new ArrayList<SQLFieldNotNullConstraint>();
    private List<SQLField> fieldsToChange = new ArrayList<SQLField>();
    private List<SQLConstraint> constraintsToChange = new ArrayList<SQLConstraint>();
    private List<SQLIndex> indicesToChange = new ArrayList<SQLIndex>();
    private List<SQLProcedure> proceduresToAdd = new ArrayList<SQLProcedure>();
    private List<SQLProcedure> proceduresToRemove = new ArrayList<SQLProcedure>();
    private List<SQLProcedure> proceduresToChange = new ArrayList<SQLProcedure>();
    private DatamodelListener dml;
    private SQLSchema targetSchema;

    public void clear() {
        this.tablesToAdd.clear();
        this.fieldsToAdd.clear();
        this.indicesToAdd.clear();
        this.constraintsToAdd.clear();
        this.notNullsToAdd.clear();
        this.tablesToRemove.clear();
        this.fieldsToRemove.clear();
        this.indicesToRemove.clear();
        this.constraintsToRemove.clear();
        this.notNullsToRemove.clear();
        this.fieldsToChange.clear();
        this.constraintsToChange.clear();
        this.indicesToChange.clear();
        this.proceduresToAdd.clear();
        this.proceduresToRemove.clear();
        this.proceduresToChange.clear();
    }

    public void compare(SQLSchema schemaOne, SQLSchema schemaTwo) {
        boolean exists;
        List<SQLProcedure> listProc2;
        int i;
        this.targetSchema = schemaTwo;
        for (i = 0; i < schemaOne.getTableCount(); ++i) {
            SQLTable table2;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            SQLTable table1 = schemaOne.getTableAt(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("check table to add/change " + table1.getAbsoluteName()));
            }
            if ((table2 = schemaTwo.getTable(table1.getName())) != null) {
                this.compare(table1, table2);
                continue;
            }
            this.tablesToAdd.add(table1);
            if (table1.isView()) {
                this.fireEvent("+ View " + table1 + " must be added");
                continue;
            }
            this.fireEvent("+ Table " + table1 + " must be added");
        }
        for (i = 0; i < schemaTwo.getTableCount(); ++i) {
            SQLTable table1;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            SQLTable table2 = schemaTwo.getTableAt(i);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("check table to remove " + table2.getAbsoluteName()));
            }
            if ((table1 = schemaOne.getTable(table2.getName())) != null) continue;
            this.tablesToRemove.add(table2);
            if (table2.isView()) {
                this.fireEvent("- View " + table2 + " must be removed");
                continue;
            }
            this.fireEvent("- Table " + table2 + " must be removed");
        }
        for (i = 0; i < schemaOne.getProcedureCount(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            SQLProcedure proc1 = schemaOne.getProcedureAt(i);
            listProc2 = schemaTwo.getProcedures(proc1.getName());
            if (listProc2.isEmpty()) {
                this.proceduresToAdd.add(proc1);
                this.fireEvent("+ Procedure " + proc1.getName() + " count parameters:" + proc1.getParameterCount() + " must be added");
                continue;
            }
            exists = false;
            for (SQLProcedure p2 : listProc2) {
                if (!proc1.equals(p2)) continue;
                exists = true;
                this.compareProcedures(proc1, p2);
                break;
            }
            if (exists) continue;
            this.proceduresToAdd.add(proc1);
            this.fireEvent("+ Procedure " + proc1.getName() + " count parameters:" + proc1.getParameterCount() + " must be added");
        }
        for (i = 0; i < schemaTwo.getProcedureCount(); ++i) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            SQLProcedure proc2 = schemaOne.getProcedureAt(i);
            listProc2 = schemaOne.getProcedures(proc2.getName());
            if (listProc2.isEmpty()) {
                this.proceduresToRemove.add(proc2);
                this.fireEvent("- Procedure " + proc2.getName() + " count parameters:" + proc2.getParameterCount() + " must be removed");
                continue;
            }
            exists = false;
            for (SQLProcedure p1 : listProc2) {
                if (!proc2.equals(p1)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.proceduresToRemove.add(proc2);
            this.fireEvent("- Procedure " + proc2.getName() + " count parameters:" + proc2.getParameterCount() + " must be removed");
        }
    }

    public void compareProcedures(SQLProcedure procOne, SQLProcedure procTwo) {
        if (procOne.getCode() != null && procTwo.getCode() != null && !procOne.getCode().equalsIgnoreCase(procTwo.getCode())) {
            this.proceduresToChange.add(procOne);
            this.fireEvent("* Procedure " + procOne.getName() + " must be changed");
        }
    }

    public void compare(SQLTable tableOne, SQLTable tableTwo) {
        block25: {
            int i;
            block26: {
                int i2;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("compare " + tableOne.getAbsoluteName() + " with " + tableTwo.getAbsoluteName()));
                }
                if (!tableOne.isTable() || !tableTwo.isTable()) break block26;
                SQLField fieldOne = null;
                SQLField fieldTwo = null;
                for (i2 = 0; i2 < tableOne.getFieldCount(); ++i2) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    fieldOne = tableOne.getFieldAt(i2);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("check column to add/change " + fieldOne.getAbsoluteName()));
                    }
                    if ((fieldTwo = tableTwo.getField(fieldOne.getName())) != null) {
                        this.compare(fieldOne, fieldTwo);
                        continue;
                    }
                    this.fieldsToAdd.add(fieldOne);
                    this.fireEvent("+ Column " + fieldOne.getAbsoluteName() + " must be added");
                }
                for (i2 = 0; i2 < tableTwo.getFieldCount(); ++i2) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    fieldTwo = tableTwo.getFieldAt(i2);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("check column to remove " + fieldTwo.getAbsoluteName()));
                    }
                    if ((fieldOne = tableOne.getField(fieldTwo.getName())) != null) continue;
                    this.fieldsToRemove.add(fieldTwo);
                    this.fireEvent("- Column " + fieldTwo.getAbsoluteName() + " must be removed");
                }
                List<SQLConstraint> listConstraints1 = tableOne.getConstraints();
                for (SQLConstraint c1 : listConstraints1) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    SQLConstraint c2 = tableTwo.getConstraint(c1.getName());
                    if (c2 != null) {
                        this.compare(c1, c2);
                        continue;
                    }
                    this.constraintsToAdd.add(c1);
                    this.fireEvent("+ Constraint on " + c1.getTable().getName() + "->" + c1.getName() + " must be added");
                }
                List<SQLConstraint> listConstraints2 = tableTwo.getConstraints();
                for (SQLConstraint c2 : listConstraints2) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    SQLConstraint c1 = tableOne.getConstraint(c2.getName());
                    if (c1 != null) continue;
                    this.constraintsToRemove.add(c2);
                    this.fireEvent("- Constraint on " + c2.getTable().getName() + "->" + c2.getName() + " must be removed");
                }
                List<SQLIndex> listIndices1 = tableOne.getIndexes();
                for (SQLIndex i1 : listIndices1) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    SQLIndex i22 = tableTwo.getIndexByName(i1.getName());
                    if (i22 != null) {
                        this.compare(i1, i22);
                        continue;
                    }
                    if (this.findConstraint(listConstraints1, i1) != null) continue;
                    this.indicesToAdd.add(i1);
                    this.fireEvent("+ Index on " + i1.getTable().getName() + "->" + i1.getName() + " must be added");
                }
                List<SQLIndex> listIndices2 = tableTwo.getIndexes();
                for (SQLIndex i22 : listIndices2) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    SQLIndex i1 = tableOne.getIndexByName(i22.getName());
                    if (i1 != null || this.findConstraint(listConstraints2, i22) != null) continue;
                    this.indicesToRemove.add(i22);
                    this.fireEvent("- Index on " + i22.getTable().getName() + "->" + i22.getName() + " must be removed");
                }
                break block25;
            }
            if (!tableOne.isView() || !tableTwo.isView()) break block25;
            SQLField fieldOne = null;
            SQLField fieldTwo = null;
            for (i = 0; i < tableOne.getFieldCount(); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                fieldOne = tableOne.getFieldAt(i);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("check column to add/change " + fieldOne.getAbsoluteName()));
                }
                if ((fieldTwo = tableTwo.getField(fieldOne.getName())) != null) {
                    if (this.equals(fieldOne, fieldTwo)) continue;
                    if (this.tablesToAdd.contains(tableOne)) break;
                    this.tablesToAdd.add(tableOne);
                    this.tablesToRemove.add(tableTwo);
                    this.fireEvent("* View " + tableOne + " must changed");
                    break;
                }
                if (this.tablesToAdd.contains(tableOne)) break;
                this.tablesToAdd.add(tableOne);
                this.tablesToRemove.add(tableTwo);
                this.fireEvent("* View " + tableOne + " must changed");
                break;
            }
            for (i = 0; i < tableTwo.getFieldCount(); ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                fieldTwo = tableTwo.getFieldAt(i);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("check superfluous view column " + fieldTwo.getAbsoluteName()));
                }
                if ((fieldOne = tableOne.getField(fieldTwo.getName())) != null) continue;
                if (this.tablesToAdd.contains(tableOne)) break;
                this.tablesToAdd.add(tableOne);
                this.tablesToRemove.add(tableTwo);
                this.fireEvent("* View " + tableOne + " must changed");
                break;
            }
        }
    }

    private SQLConstraint findConstraint(List<SQLConstraint> listConstraints, SQLIndex index) {
        for (SQLConstraint c : listConstraints) {
            if (!c.getName().equalsIgnoreCase(index.getName())) continue;
            return c;
        }
        return null;
    }

    private boolean equals(SQLField field1, SQLField field2) {
        if (!field1.getName().equalsIgnoreCase(field2.getName())) {
            return false;
        }
        if (field1.getBasicType() != field2.getBasicType()) {
            return false;
        }
        if (field1.getLength() != field2.getLength()) {
            return false;
        }
        if (field1.getDecimalDigits() != field2.getDecimalDigits()) {
            return false;
        }
        if (field1.getNotNullConstraint() != null && field2.getNotNullConstraint() == null) {
            return false;
        }
        return field1.getNotNullConstraint() != null || field2.getNotNullConstraint() == null;
    }

    private void compare(SQLField field1, SQLField field2) {
        String fd2;
        String fd1 = SQLCodeGenerator.getInstance().buildFieldDeclaration(field1);
        if (!fd1.equalsIgnoreCase(fd2 = SQLCodeGenerator.getInstance().buildFieldDeclaration(field2))) {
            this.fieldsToChange.add(field1);
            this.fireEvent("* Column " + field1.getAbsoluteName() + " must be changed");
        } else if (!field1.isNullValueAllowed()) {
            if (field2.isNullValueAllowed()) {
                this.notNullsToAdd.add(field1.getNotNullConstraint());
                this.fireEvent("+ Not Null Constraint for " + field1.getAbsoluteName() + " must be added");
            }
        } else if (!field2.isNullValueAllowed() && field1.isNullValueAllowed()) {
            this.notNullsToRemove.add(field2.getNotNullConstraint());
            this.fireEvent("- Not Null Constraint for " + field1.getAbsoluteName() + " must be removed");
        }
    }

    private void compare(SQLConstraint c1, SQLConstraint c2) {
        String cd2;
        String cd1 = SQLCodeGenerator.getInstance().buildAddToTableStatement(c1, false);
        if (!cd1.equalsIgnoreCase(cd2 = SQLCodeGenerator.getInstance().buildAddToTableStatement(c2, false))) {
            this.constraintsToChange.add(c1);
            this.fireEvent("* Constraint " + c1.getTable().getName() + "->" + c1.getName() + " must be changed");
        }
    }

    private void compare(SQLIndex i1, SQLIndex i2) {
        String id2;
        String id1 = SQLCodeGenerator.getInstance().buildCreateStatement(i1, false);
        if (!id1.equalsIgnoreCase(id2 = SQLCodeGenerator.getInstance().buildCreateStatement(i2, false))) {
            this.indicesToChange.add(i1);
            this.fireEvent("* Index " + i1.getTable().getName() + "->" + i1.getName() + " must be changed");
        }
    }

    public void setDatamodelListener(DatamodelListener l) {
        this.dml = l;
    }

    private void fireEvent(String message) {
        DatamodelEvent e = new DatamodelEvent(null, message, 1);
        this.dml.eventHappend(e);
    }

    public List<SQLTable> getTablesToAdd() {
        return this.tablesToAdd;
    }

    public List<SQLField> getFieldsToAdd() {
        return this.fieldsToAdd;
    }

    public List<SQLIndex> getIndicesToAdd() {
        return this.indicesToAdd;
    }

    public List<SQLConstraint> getConstraintsToAdd() {
        return this.constraintsToAdd;
    }

    public List<SQLFieldNotNullConstraint> getNotNullsToAdd() {
        return this.notNullsToAdd;
    }

    public List<SQLTable> getTablesToRemove() {
        return this.tablesToRemove;
    }

    public List<SQLField> getFieldsToRemove() {
        return this.fieldsToRemove;
    }

    public List<SQLIndex> getIndicesToRemove() {
        return this.indicesToRemove;
    }

    public List<SQLConstraint> getConstraintsToRemove() {
        return this.constraintsToRemove;
    }

    public List<SQLFieldNotNullConstraint> getNotNullsToRemove() {
        return this.notNullsToRemove;
    }

    public List<SQLField> getFieldsToChange() {
        return this.fieldsToChange;
    }

    public List<SQLConstraint> getConstraintsToChange() {
        return this.constraintsToChange;
    }

    public List<SQLIndex> getIndicesToChange() {
        return this.indicesToChange;
    }

    public SQLSchema getTargetSchema() {
        return this.targetSchema;
    }

    public List<SQLProcedure> getProceduresToAdd() {
        return this.proceduresToAdd;
    }

    public List<SQLProcedure> getProceduresToRemove() {
        return this.proceduresToRemove;
    }

    public List<SQLProcedure> getProceduresToChange() {
        return this.proceduresToChange;
    }
}

