/*
 * Decompiled with CFR 0.152.
 */
package sqlrunner.config;

import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import sqlrunner.Main;
import sqlrunner.MainFrame;
import sqlrunner.config.ConfigurationPanel;
import sqlrunner.config.Messages;

public class PanelConfigDateFormat
extends JPanel
implements ConfigurationPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox<String> cbDateFormat;
    static String tooltipTextDate = "<HTML><BODY>" + Messages.getString("PanelConfigDateFormat.1") + Messages.getString("PanelConfigDateFormat.2") + Messages.getString("PanelConfigDateFormat.3") + Messages.getString("PanelConfigDateFormat.4") + Messages.getString("PanelConfigDateFormat.5") + Messages.getString("PanelConfigDateFormat.6") + Messages.getString("PanelConfigDateFormat.7") + "</BODY></HTML>";

    public PanelConfigDateFormat() {
        try {
            this.initComponents();
            this.prepareCbDateFormat();
            if (MainFrame.getDateFormatMask() != null) {
                this.setSelectedCbDateFormatItem(MainFrame.getDateFormatMask());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initComponents() throws Exception {
        this.setBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), Messages.getString("PanelConfigDateFormat.bordertitle")));
        this.setLayout(new BorderLayout());
        this.cbDateFormat = new JComboBox();
        this.cbDateFormat.setEditable(true);
        this.cbDateFormat.setToolTipText(tooltipTextDate);
        this.add(this.cbDateFormat, "Center");
    }

    private void prepareCbDateFormat() {
        String formatStr;
        int i = 0;
        while ((formatStr = Main.getDefaultProperty("DATE_FORMAT_" + String.valueOf(i))) != null) {
            this.cbDateFormat.addItem(formatStr);
            ++i;
        }
    }

    private void setSelectedCbDateFormatItem(String dateFormat) {
        for (int i = 0; i < this.cbDateFormat.getItemCount(); ++i) {
            if (!this.cbDateFormat.getItemAt(i).equals(dateFormat)) continue;
            this.cbDateFormat.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public boolean isChanged() {
        return !MainFrame.getDateFormatMask().equals((String)this.cbDateFormat.getSelectedItem());
    }

    @Override
    public boolean performChanges() {
        MainFrame.setDateFormatMask((String)this.cbDateFormat.getSelectedItem());
        Main.setUserProperty("DATE_FORMAT", MainFrame.getDateFormatMask());
        MainFrame mainFrame = Main.getActiveMainFrame();
        if (mainFrame != null) {
            mainFrame.prepareTableRenderer();
            if (mainFrame.getDatabase() != null) {
                mainFrame.getDatabase().createSDF();
            }
        }
        return true;
    }

    @Override
    public void cancel() {
    }
}

